/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.flex.FlexDecoderInfo;

public class ImportFLExDialog
extends ClosableDialog
implements ActionListener,
ChangeListener {
    private JPanel filePanel;
    private JTextField flexFileField;
    private JTextField mediaFileField;
    private JButton selectFlexButton;
    private JButton selectMediaButton;
    private JPanel optionsPanel;
    private JCheckBox includeITCB;
    private JCheckBox includeParagrCB;
    private JCheckBox importParticipantInfoCB;
    private JComboBox unitsCombo;
    private JTextField unitTextField;
    private JRadioButton typesPerElementRB;
    private JRadioButton typesPerTypeRB;
    private JCheckBox typesPerLanguageCB;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private final String[] elements = new String[]{"phrase", "word"};
    private List<String> tempMediaPaths;
    private FlexDecoderInfo decoderInfo = null;
    public static final String INTERLINEAR_TEXT = "ImportFLExDialog.IncludeInterlinearText";
    public static final String PARAGRAPH = "ImportFLExDialog.IncludeParagraph";
    public static final String PARTICIPANT = "ImportFLExDialog.ImportParticipantInfo";
    public static final String SMALLEST_ALIGNABLE_ELEMENT = "ImportFLExDialog.SmallestAlignableElement";
    public static final String TYPES_PER_ELEMENT = "ImportFLExDialog.TypesPerElement";
    public static final String TYPES_PER_TYPE = "ImportFLExDialog.TypesPerType";
    public static final String TYPES_PER_LANG = "ImportFLExDialog.TypesPerLanguage";
    public static final String DURATION = "ImportFLExDialog.DurationPerPhrase";

    public ImportFLExDialog(Frame owner) throws HeadlessException {
        super(owner, true);
        this.initComponents();
        this.postInit();
    }

    public FlexDecoderInfo getDecoderInfo() {
        return this.decoderInfo;
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("ImportDialog.Title.Flex"));
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.filePanel = new JPanel(new GridBagLayout());
        this.filePanel.setBorder(new TitledBorder(""));
        this.flexFileField = new JTextField("", 20);
        this.flexFileField.setEditable(false);
        this.mediaFileField = new JTextField("", 20);
        this.mediaFileField.setEditable(false);
        this.selectFlexButton = new JButton("...");
        this.selectFlexButton.addActionListener(this);
        this.selectMediaButton = new JButton("...");
        this.selectMediaButton.addActionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        this.filePanel.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Flex.File")), gbc);
        gbc.gridy = 1;
        this.filePanel.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Label.Media")), gbc);
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.filePanel.add((Component)this.flexFileField, gbc);
        gbc.gridy = 1;
        this.filePanel.add((Component)this.mediaFileField, gbc);
        gbc.gridy = 0;
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.filePanel.add((Component)this.selectFlexButton, gbc);
        gbc.gridy = 1;
        this.filePanel.add((Component)this.selectMediaButton, gbc);
        this.optionsPanel = new JPanel(new GridBagLayout());
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ImportDialog.Label.Options")));
        this.includeITCB = new JCheckBox(ElanLocale.getString("ImportDialog.Flex.IncludeIT"));
        this.includeITCB.setSelected(true);
        this.includeParagrCB = new JCheckBox(ElanLocale.getString("ImportDialog.Flex.IncludePara"));
        this.includeParagrCB.setSelected(true);
        this.importParticipantInfoCB = new JCheckBox(ElanLocale.getString("ImportDialog.Flex.ImportParticipantInfo"));
        this.typesPerElementRB = new JRadioButton(ElanLocale.getString("ImportDialog.Flex.LinTypeForBasicElement"), true);
        this.typesPerElementRB.addChangeListener(this);
        this.typesPerTypeRB = new JRadioButton(ElanLocale.getString("ImportDialog.Flex.LinTypeForTypes"));
        this.typesPerTypeRB.addChangeListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.typesPerElementRB);
        group.add(this.typesPerTypeRB);
        this.typesPerLanguageCB = new JCheckBox(ElanLocale.getString("ImportDialog.Flex.LinTypeForLang"));
        this.typesPerLanguageCB.setEnabled(false);
        this.unitsCombo = new JComboBox<String>(this.elements);
        this.unitsCombo.setSelectedItem("phrase");
        this.unitTextField = new JTextField("", 8);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.gridy = 0;
        this.optionsPanel.add((Component)this.includeITCB, gbc);
        ++gbc.gridy;
        this.optionsPanel.add((Component)this.includeParagrCB, gbc);
        ++gbc.gridy;
        this.optionsPanel.add((Component)this.importParticipantInfoCB, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(12, 6, 2, 6);
        this.optionsPanel.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Flex.SmallestTimeAlignable")), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        this.optionsPanel.add((Component)this.unitsCombo, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(12, 6, 2, 6);
        this.optionsPanel.add((Component)new JLabel(ElanLocale.getString("ExportTiersDialog.Tab2")), gbc);
        ++gbc.gridy;
        gbc.insets = insets;
        this.optionsPanel.add((Component)this.typesPerElementRB, gbc);
        ++gbc.gridy;
        gbc.insets = insets;
        this.optionsPanel.add((Component)this.typesPerTypeRB, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(2, 26, 2, 6);
        this.optionsPanel.add((Component)this.typesPerLanguageCB, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(12, 6, 2, 6);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.optionsPanel.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Flex.UnitDuration")), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        this.optionsPanel.add((Component)this.unitTextField, gbc);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.filePanel, gbc);
        gbc.gridy = 1;
        this.getContentPane().add((Component)this.optionsPanel, gbc);
        gbc.gridy = 2;
        gbc.anchor = 15;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.loadPreferences();
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void selectFlexFile() {
        FileChooser chooser = new FileChooser(this.getParent());
        chooser.createAndShowFileDialog(ElanLocale.getString("Button.Select"), 0, ElanLocale.getString("Button.Select"), null, FileExtension.FLEX_EXT, false, "LastUsedFlexDir", 0, null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            this.flexFileField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void selectMediaFiles() {
        FileChooser chooser = new FileChooser(this.getParent());
        chooser.createAndShowMultiFileDialog(ElanLocale.getString("Button.Select"), 2);
        Object[] files = chooser.getSelectedFiles();
        if (files != null && files.length > 0) {
            if (this.tempMediaPaths == null) {
                this.tempMediaPaths = new ArrayList<String>(4);
            } else {
                this.tempMediaPaths.clear();
            }
            Object filePaths = "";
            for (Object file : files) {
                this.tempMediaPaths.add(((File)file).getAbsolutePath());
                filePaths = (String)filePaths + file + ", ";
            }
            this.mediaFileField.setText((String)filePaths);
        }
    }

    private boolean checkFields() {
        String path = this.flexFileField.getText();
        if (path == null || path.length() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ImportDialog.Flex.Message.NoFlex"), ElanLocale.getString("Message.Error"), 0);
            return false;
        }
        File f = new File(path);
        if (!f.exists() || f.isDirectory()) {
            Object strMessage = ElanLocale.getString("Menu.Dialog.Message1");
            strMessage = (String)strMessage + path;
            strMessage = (String)strMessage + ElanLocale.getString("Menu.Dialog.Message2");
            String strError = ElanLocale.getString("Message.Error");
            JOptionPane.showMessageDialog(this, strMessage, strError, 0);
            return false;
        }
        path = path.replace('\\', '/');
        long durationVal = -1L;
        try {
            durationVal = Long.parseLong(this.unitTextField.getText());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ImportDialog.Flex.Message.DurElement"), ElanLocale.getString("Message.Error"), 0);
            return false;
        }
        this.decoderInfo = new FlexDecoderInfo(path);
        this.decoderInfo.smallestWithTimeAlignment = (String)this.unitsCombo.getSelectedItem();
        this.decoderInfo.inclITElement = this.includeITCB.isSelected();
        this.decoderInfo.inclParagraphElement = this.includeParagrCB.isSelected();
        this.decoderInfo.importParticipantInfo = this.importParticipantInfoCB.isSelected();
        this.decoderInfo.perPhraseDuration = durationVal;
        if (this.typesPerTypeRB.isSelected()) {
            this.decoderInfo.createLingForNewType = this.typesPerTypeRB.isSelected();
            this.decoderInfo.createLingForNewLang = this.typesPerLanguageCB.isSelected();
        }
        if (this.tempMediaPaths != null && this.tempMediaPaths.size() > 0) {
            ArrayList<MediaDescriptor> descriptors = new ArrayList<MediaDescriptor>(this.tempMediaPaths.size());
            for (String medPath : this.tempMediaPaths) {
                MediaDescriptor descriptor = MediaDescriptorUtil.createMediaDescriptor(medPath);
                if (descriptor == null) continue;
                descriptors.add(descriptor);
            }
            this.decoderInfo.setMediaDescriptors(descriptors);
        }
        this.storePreferences();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectFlexButton) {
            this.selectFlexFile();
        } else if (e.getSource() == this.selectMediaButton) {
            this.selectMediaFiles();
        } else if (e.getSource() == this.okButton) {
            if (this.checkFields()) {
                this.setVisible(false);
            }
        } else if (e.getSource() == this.cancelButton) {
            this.decoderInfo = null;
            this.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.typesPerLanguageCB.setEnabled(this.typesPerTypeRB.isSelected());
    }

    private void storePreferences() {
        Preferences.set(INTERLINEAR_TEXT, this.includeITCB.isSelected(), null);
        Preferences.set(PARAGRAPH, this.includeParagrCB.isSelected(), null);
        Preferences.set(PARTICIPANT, this.importParticipantInfoCB.isSelected(), null);
        Preferences.set(SMALLEST_ALIGNABLE_ELEMENT, this.unitsCombo.getSelectedItem(), null);
        Preferences.set(TYPES_PER_ELEMENT, this.typesPerElementRB.isSelected(), null);
        Preferences.set(TYPES_PER_TYPE, this.typesPerTypeRB.isSelected(), null);
        Preferences.set(TYPES_PER_LANG, this.typesPerLanguageCB.isSelected(), null);
        Preferences.set(DURATION, this.unitTextField.getText(), null);
    }

    private void loadPreferences() {
        String stringPref;
        Boolean boolPref = Preferences.getBool(INTERLINEAR_TEXT, null);
        if (boolPref != null) {
            this.includeITCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool(PARAGRAPH, null)) != null) {
            this.includeParagrCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool(PARTICIPANT, null)) != null) {
            this.importParticipantInfoCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString(SMALLEST_ALIGNABLE_ELEMENT, null)) != null) {
            this.unitsCombo.setSelectedItem(stringPref);
        }
        if ((boolPref = Preferences.getBool(TYPES_PER_ELEMENT, null)) != null) {
            this.typesPerElementRB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool(TYPES_PER_TYPE, null)) != null) {
            this.typesPerTypeRB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool(TYPES_PER_LANG, null)) != null) {
            this.typesPerLanguageCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString(DURATION, null)) != null) {
            this.unitTextField.setText(stringPref.toString());
        }
    }
}

