/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanLocale;

public class IndeterminateProgressMonitor {
    private String message;
    private boolean cancellable;
    private boolean cancelled;
    private boolean modal;
    private boolean decorated;
    private final int MIN_WIDTH = 240;
    private JDialog dialog;
    private JLabel messageLabel;
    private JButton cancelButton;
    private String cancelText;
    private Component parent;
    private JProgressBar progressBar;

    public IndeterminateProgressMonitor(Component parent, boolean modal, String message, boolean cancellable, String cancelText) {
        this.parent = parent;
        this.modal = modal;
        this.message = message;
        this.cancellable = cancellable;
        this.cancelText = cancelText;
        this.cancelled = false;
    }

    public void close() {
        this.cancelled = true;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    public void show() {
        Window owner;
        if (this.cancelled) {
            return;
        }
        Frame frame = null;
        if (this.parent instanceof Frame) {
            frame = (Frame)this.parent;
        } else if (this.parent != null && (owner = SwingUtilities.windowForComponent(this.parent)) instanceof Frame) {
            frame = (Frame)owner;
        }
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.messageLabel = new JLabel();
        if (this.message != null) {
            this.messageLabel.setText(this.message);
        }
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        GridBagConstraints gbc = new GridBagConstraints();
        Insets inset = new Insets(4, 2, 4, 2);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = inset;
        contentPane.add((Component)this.messageLabel, gbc);
        gbc.gridy = 1;
        contentPane.add((Component)this.progressBar, gbc);
        if (this.cancellable) {
            this.cancelButton = new JButton();
            this.cancelButton.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    IndeterminateProgressMonitor.this.cancelled = true;
                    IndeterminateProgressMonitor.this.cancelButton.setEnabled(false);
                }
            });
            if (this.cancelText != null) {
                this.cancelButton.setText(this.cancelText);
            } else {
                this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
            }
            gbc.gridy = 2;
            gbc.anchor = 10;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            contentPane.add((Component)this.cancelButton, gbc);
        }
        this.dialog = new JDialog(frame, this.modal);
        this.dialog.setContentPane(contentPane);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.setUndecorated(!this.decorated);
        this.dialog.getRootPane().setWindowDecorationStyle(2);
        this.dialog.pack();
        if (this.dialog.getWidth() < 240) {
            this.dialog.setSize(240, this.dialog.getHeight());
        }
        this.dialog.setLocationRelativeTo(frame);
        if (this.cancelled) {
            this.dialog.dispose();
        } else {
            this.dialog.setVisible(true);
        }
    }

    public void setMessage(String message) {
        this.message = message;
        if (this.messageLabel != null) {
            this.messageLabel.setText(message);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public void setDecorated(boolean decorated) {
        this.decorated = decorated;
    }
}

