/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.NgramStatsCommand;
import mpi.eudico.client.annotator.export.ExportNgramRawData;
import mpi.eudico.client.annotator.export.ExportNgramStatistics;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.client.annotator.ngramstats.NgramStatsResult;
import mpi.eudico.client.annotator.ngramstats.NgramStatsTableModel;
import mpi.eudico.client.annotator.tier.DisplayableContentTableModel;
import mpi.eudico.client.annotator.tier.SelectableContentTableModel;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.client.annotator.util.SquelchOutput;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.util.EmptyStringComparator;
import mpi.eudico.util.FloatStringComparator;
import mpi.eudico.util.IntComparator;

public class NgramStatisticsDialog
extends ClosableDialog
implements ListSelectionListener,
ActionListener,
ProgressListener {
    private static final long serialVersionUID = 6308995887627969093L;
    private JButton rawButton;
    private JButton saveButton;
    private JButton closeButton;
    private JFrame parent;
    private JLabel titleLabel;
    private String selectedDomain = null;
    private JPanel ngramTablePane;
    private JTable ngramTable;
    private NgramStatsTableModel ngramModel;
    private JPanel tierSelectPanel;
    private JPanel buttonPanel;
    private JPanel titlePanel;
    private JTable tierTable;
    private JButton selectDomainButton;
    private JButton updateStatisticsButton;
    private JTextField ngramSize;
    private JProgressBar progressBar;
    private List<String> fileNames;
    private NgramStatsCommand curCommand;
    private NgramStatsResult curCommandResult;
    private Insets defaultInsets;

    public NgramStatisticsDialog(JFrame parentFrame) {
        super(parentFrame);
        this.parent = parentFrame;
        this.setTitle(ElanLocale.getString("Menu.File.MultiFileNgramStats"));
        this.defaultInsets = new Insets(2, 6, 2, 6);
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    private void initComponents() {
        this.titleLabel = new JLabel(ElanLocale.getString("Menu.File.MultiFileNgramStats"));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titlePanel = new JPanel();
        this.titlePanel.add(this.titleLabel);
        this.initTierSelectionPanel();
        this.initNgramsTable();
        this.initButtonPanel();
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        GridBagConstraints gbc = new GridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = this.defaultInsets;
        this.getContentPane().add((Component)this.titlePanel, gbc);
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.getContentPane().add((Component)this.tierSelectPanel, gbc);
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.getContentPane().add((Component)this.ngramTablePane, gbc);
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)this.progressBar, gbc);
        gbc.gridy = 4;
        gbc.anchor = 11;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.getRootPane().setDefaultButton(this.closeButton);
    }

    private void initButtonPanel() {
        this.rawButton = new JButton(ElanLocale.getString("Statistics.Multi.SaveRawData"));
        this.saveButton = new JButton(ElanLocale.getString("Button.Save"));
        this.closeButton = new JButton(ElanLocale.getString("Button.Close"));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 3, 6, 2));
        this.buttonPanel.add(this.rawButton);
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.closeButton);
        this.rawButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.rawButton.setEnabled(false);
        this.saveButton.setEnabled(false);
    }

    private void initTierSelectionPanel() {
        this.tierSelectPanel = new JPanel(new GridBagLayout());
        this.tierSelectPanel.setPreferredSize(new Dimension(300, 150));
        this.tierSelectPanel.setBorder(new TitledBorder(ElanLocale.getString("Statistics.Multi.TierSelection")));
        this.tierTable = new JTable(new DisplayableContentTableModel(ElanLocale.getString("Statistics.Multi.NoShow")));
        this.tierTable.setSelectionMode(0);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.getTableHeader().setReorderingAllowed(false);
        this.tierTable.setModel(new DisplayableContentTableModel(ElanLocale.getString("Statistics.Multi.NoShow")));
        this.tierTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.Header.Message"));
        JScrollPane tierTableScrollPane = new JScrollPane(this.tierTable);
        tierTableScrollPane.setColumnHeaderView(null);
        this.selectDomainButton = new JButton(ElanLocale.getString("MFE.DomainDefKey"));
        this.updateStatisticsButton = new JButton(ElanLocale.getString("Statistics.Multi.Update"));
        this.updateStatisticsButton.setEnabled(false);
        this.selectDomainButton.addActionListener(this);
        this.updateStatisticsButton.addActionListener(this);
        this.ngramSize = new JTextField();
        this.ngramSize.setText("2");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.gridheight = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.defaultInsets;
        this.tierSelectPanel.add((Component)tierTableScrollPane, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.tierSelectPanel.add((Component)this.selectDomainButton, gbc);
        gbc.gridy = 1;
        this.tierSelectPanel.add((Component)new JLabel(ElanLocale.getString("Statistics.Multi.NgramSize")), gbc);
        gbc.gridy = 2;
        this.tierSelectPanel.add((Component)this.ngramSize, gbc);
        gbc.gridy = 3;
        this.tierSelectPanel.add((Component)this.updateStatisticsButton, gbc);
    }

    private void initNgramsTable() {
        this.ngramTablePane = new JPanel(new GridBagLayout());
        this.ngramTablePane.setPreferredSize(new Dimension(760, 300));
        this.ngramModel = new NgramStatsTableModel(null);
        this.ngramTable = new JTable(this.ngramModel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.insets = this.defaultInsets;
        this.ngramTablePane.add((Component)new JScrollPane(this.ngramTable), gbc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton sender = (JButton)e.getSource();
        if (sender == this.saveButton) {
            if (this.curCommand != null) {
                return;
            }
            this.progressBar.setString("Exporting Statistics...");
            new ExportNgramStatistics((Frame)((JFrame)this.getParent()), true, null, ((NgramStatsTableModel)this.ngramTable.getModel()).getResult());
            this.progressBar.setString("Export Completed.");
            return;
        }
        if (sender == this.rawButton) {
            if (this.curCommand != null) {
                return;
            }
            this.progressBar.setString("Exporting Raw Data...");
            new ExportNgramRawData((Frame)((JFrame)this.getParent()), true, null, ((NgramStatsTableModel)this.ngramTable.getModel()).getResult());
            this.progressBar.setString("Export Completed.");
            return;
        }
        if (sender == this.closeButton) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        if (sender == this.selectDomainButton && this.curCommand == null) {
            this.loadTiersFromDomain();
        }
        if (sender == this.updateStatisticsButton) {
            if (this.curCommand != null) {
                return;
            }
            try {
                int num = Integer.parseInt(this.ngramSize.getText());
                if (num < 1) {
                    throw new NumberFormatException("invalid");
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("Statistics.Multi.NgramSizeWarning"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            String selectedTier = null;
            for (int i = 0; i < this.tierTable.getModel().getRowCount(); ++i) {
                if (!((Boolean)this.tierTable.getValueAt(i, 0)).booleanValue()) continue;
                selectedTier = (String)this.tierTable.getValueAt(i, 1);
                break;
            }
            if (selectedTier == null) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("TranscriptionManager.SelectTierDlg.Empty_Tier"), ElanLocale.getString("Message.Warning"), 2);
            } else {
                this.updateStatisticsButton.setEnabled(false);
                this.selectDomainButton.setEnabled(false);
                this.saveButton.setEnabled(false);
                this.rawButton.setEnabled(false);
                this.ngramTable.setModel(new NgramStatsTableModel(null));
                this.curCommand = new NgramStatsCommand("NgramStats");
                this.curCommand.addProgressListener(this);
                this.curCommandResult = new NgramStatsResult(this.selectedDomain, selectedTier, Integer.parseInt(this.ngramSize.getText()));
                this.curCommand.execute(null, new Object[]{this.fileNames, this.curCommandResult});
            }
        }
    }

    private void loadTiersFromDomain() {
        MFDomainDialog domainDialog = new MFDomainDialog((Dialog)this, true);
        domainDialog.setVisible(true);
        List<String> searchPaths = domainDialog.getSearchPaths();
        List<String> searchDirs = domainDialog.getSearchDirs();
        String val = domainDialog.getDomainName();
        if (searchPaths.size() == 0 && searchDirs.size() == 0) {
            return;
        }
        this.selectedDomain = val;
        this.tierSelectPanel.setBorder(new TitledBorder(ElanLocale.getString("Statistics.Multi.TierSelection") + " (" + ElanLocale.getString("MFE.Domain") + ": " + val + ")"));
        this.fileNames = searchPaths;
        if (searchDirs.size() > 0) {
            for (int i = 0; i < searchDirs.size(); ++i) {
                String name = searchDirs.get(i);
                File f = new File(name);
                if (f.isFile() && f.canRead()) {
                    this.fileNames.add(f.getAbsolutePath());
                    continue;
                }
                if (!f.isDirectory() || !f.canRead()) continue;
                this.addFilesFromDirectory(f, this.fileNames);
            }
        }
        if (this.fileNames.isEmpty()) {
            this.tierTable.getSelectionModel().removeListSelectionListener(this);
            this.tierTable.setModel(new DisplayableContentTableModel(ElanLocale.getString("Statistics.Multi.NoShow")));
            this.updateStatisticsButton.setEnabled(false);
            return;
        }
        List<TierImpl> tiers = null;
        int count = 0;
        while (tiers == null && count < this.fileNames.size()) {
            EAFSkeletonParser parser = new EAFSkeletonParser(this.fileNames.get(count++));
            SquelchOutput s = new SquelchOutput();
            try {
                s.squelchOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                parser.parse();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.restoreOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            tiers = parser.getTiers();
        }
        TreeSet<String> uniqueTierNames = new TreeSet<String>();
        if (tiers != null) {
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl tier = (TierImpl)tiers.get(i);
                if (tier == null) continue;
                uniqueTierNames.add(tier.getName());
            }
        }
        if (uniqueTierNames.isEmpty()) {
            this.tierTable.getSelectionModel().removeListSelectionListener(this);
            this.tierTable.setModel(new DisplayableContentTableModel(ElanLocale.getString("Statistics.Multi.NoShow")));
            this.updateStatisticsButton.setEnabled(false);
        } else {
            this.tierTable.getSelectionModel().removeListSelectionListener(this);
            this.tierTable.setModel(new SelectableContentTableModel(uniqueTierNames));
            this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
            this.tierTable.getColumnModel().getColumn(0).setHeaderValue("");
            this.tierTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("EditTierDialog.Label.TierName"));
            TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>(this.tierTable.getModel());
            EmptyStringComparator emptyComp = new EmptyStringComparator();
            for (int i = 1; i < this.tierTable.getColumnCount(); ++i) {
                rowSorter.setComparator(i, emptyComp);
            }
            this.tierTable.setRowSorter(rowSorter);
            this.tierTable.getSelectionModel().addListSelectionListener(this);
            this.updateStatisticsButton.setEnabled(true);
            this.tierTable.repaint();
        }
    }

    private void addFilesFromDirectory(File dir, List<String> files) {
        if (dir == null && files == null) {
            return;
        }
        File[] allSubs = dir.listFiles();
        for (int i = 0; i < allSubs.length; ++i) {
            if (allSubs[i].isDirectory() && allSubs[i].canRead()) {
                this.addFilesFromDirectory(allSubs[i], files);
                continue;
            }
            if (!allSubs[i].canRead() || !allSubs[i].getName().toLowerCase().endsWith(FileExtension.EAF_EXT[0]) || files.contains(allSubs[i].getAbsolutePath())) continue;
            files.add(allSubs[i].getAbsolutePath());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selectedRow;
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (this.curCommand != null) {
            return;
        }
        if (e.getValueIsAdjusting() && this.fileNames != null && !this.fileNames.isEmpty() && (selectedRow = lsm.getMinSelectionIndex()) >= 0) {
            for (int i = 0; i < this.tierTable.getModel().getRowCount(); ++i) {
                if (!((Boolean)this.tierTable.getValueAt(i, 0)).booleanValue()) continue;
                this.tierTable.setValueAt((Boolean)this.tierTable.getValueAt(i, 0) == false, i, 0);
            }
            this.tierTable.setValueAt((Boolean)this.tierTable.getValueAt(selectedRow, 0) == false, selectedRow, 0);
        }
    }

    @Override
    public void progressCompleted(Object source, String message) {
        this.progressBar.setValue(100);
        this.progressBar.setString(message);
        ProcessReport report = this.curCommand.getProcessReport();
        if (report != null) {
            new ReportDialog((Dialog)this, report).setVisible(true);
        }
        if (!message.equals("ERROR")) {
            NgramStatsTableModel model = new NgramStatsTableModel(this.curCommandResult);
            this.ngramTable.setModel(model);
            TableRowSorter<NgramStatsTableModel> rowSorter = new TableRowSorter<NgramStatsTableModel>(model);
            IntComparator intComp = new IntComparator();
            rowSorter.setComparator(1, intComp);
            int numCols = this.ngramModel.getColumnCount();
            FloatStringComparator fsComp = new FloatStringComparator();
            for (int i = 2; i < numCols; ++i) {
                rowSorter.setComparator(i, fsComp);
            }
            this.ngramTable.setRowSorter(rowSorter);
        }
        this.updateStatisticsButton.setEnabled(true);
        this.selectDomainButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.rawButton.setEnabled(true);
        this.curCommand = null;
        this.curCommandResult = null;
    }

    @Override
    public void progressUpdated(Object source, int percent, String message) {
        if (percent == this.progressBar.getMaximum()) {
            this.progressCompleted(source, message);
        } else {
            this.progressBar.setValue(percent);
            this.progressBar.setString(message);
        }
    }

    @Override
    public void progressInterrupted(Object source, String message) {
    }
}

