/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.ElanSlider;

public class PlaybackToggleDialog
extends ClosableDialog
implements ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    private ElanSlider volumeSlider;
    private ElanSlider rateSlider;

    public PlaybackToggleDialog(Frame owner) {
        super(owner, true);
        this.initComponents();
        this.pack();
        int w = 360;
        int h = 280;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
    }

    private void initComponents() {
        Insets inset;
        this.setTitle(ElanLocale.getString("CommandActions.PlaybackToggle"));
        JPanel content = new JPanel(new GridBagLayout());
        content.setBorder(new EmptyBorder(6, 6, 6, 6));
        JLabel label = new JLabel(ElanLocale.getString("PlaybackToggleDialog.Label"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = inset = new Insets(2, 2, 12, 2);
        content.add((Component)label, gbc);
        this.volumeSlider = new ElanSlider(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Volume"), 0, 100, 100, null);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.insets = inset;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        content.add((Component)this.volumeSlider, gbc);
        this.rateSlider = new ElanSlider(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Rate"), 0, 200, 100, null);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.insets = inset;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        content.add((Component)this.rateSlider, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        content.add((Component)new JPanel(), gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 4;
        content.add((Component)buttonPanel, gbc);
        this.setContentPane(content);
        float rate = 0.5f;
        Float val = Preferences.getFloat("PlaybackRateToggleValue", null);
        if (val != null) {
            rate = val.floatValue();
        }
        this.rateSlider.setValue((int)(100.0f * rate));
        float vol = 0.7f;
        val = Preferences.getFloat("PlaybackVolumeToggleValue", null);
        if (val != null) {
            vol = val.floatValue();
        }
        this.volumeSlider.setValue((int)(100.0f * vol));
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.okButton) {
            float newRate = (float)this.rateSlider.getValue() / 100.0f;
            float newVolume = (float)this.volumeSlider.getValue() / 100.0f;
            Preferences.set("PlaybackRateToggleValue", new Float(newRate), null, false, false);
            Preferences.set("PlaybackVolumeToggleValue", new Float(newVolume), null, true, true);
            this.closeDialog();
        } else {
            this.closeDialog();
        }
    }
}

