/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.AbstractTierSortAndSelectPanel;
import mpi.eudico.client.annotator.gui.TranscriptionTierSortAndSelectPanel;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeFormatter;

public class RegularAnnotationDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private JLabel titleLabel;
    private JPanel titlePanel;
    private AbstractTierSortAndSelectPanel tierSelectionPanel;
    private JPanel timeSpecPanel;
    private JLabel startLabel;
    private JFormattedTextField startHH;
    private JFormattedTextField startMM;
    private JFormattedTextField startSS;
    private JFormattedTextField startMS;
    private JLabel durationLabel;
    private JFormattedTextField durHH;
    private JFormattedTextField durMM;
    private JFormattedTextField durSS;
    private JFormattedTextField durMS;
    boolean durHH_inhib = false;
    boolean durMM_inhib = false;
    boolean durSS_inhib = false;
    boolean durMS_inhib = false;
    private JLabel endLabel;
    private JFormattedTextField endHH;
    private JFormattedTextField endMM;
    private JFormattedTextField endSS;
    private JFormattedTextField endMS;
    boolean endHH_inhib = false;
    boolean endMM_inhib = false;
    boolean endSS_inhib = false;
    boolean endMS_inhib = false;
    private JLabel annotationSizeLabel;
    private JFormattedTextField annSizeHH;
    private JFormattedTextField annSizeMM;
    private JFormattedTextField annSizeSS;
    private JFormattedTextField annSizeMS;
    private long start;
    private long end;
    private long dur;
    private JButton applyButton;
    private JButton closeButton;
    private JPanel buttonPanel;
    private TranscriptionImpl transcription;
    private ElanMediaPlayer player;
    private long mediaDuration;

    public RegularAnnotationDialog(TranscriptionImpl transcription) {
        super((Frame)ELANCommandFactory.getRootFrame(transcription), true);
        this.transcription = transcription;
        this.player = ELANCommandFactory.getViewerManager(transcription).getMasterMediaPlayer();
        if (this.player != null) {
            this.mediaDuration = this.player.getMediaDuration();
            this.initComponents();
            this.postInit();
        }
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RegularAnnotationDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel = new JLabel();
        this.titlePanel = new JPanel();
        this.tierSelectionPanel = new TranscriptionTierSortAndSelectPanel(this.transcription, null, new ArrayList<String>(), true, true, AbstractTierSortAndSelectPanel.Modes.ROOT_TIERS);
        this.initTimeSpecPanel();
        this.applyButton = new JButton();
        this.closeButton = new JButton();
        this.buttonPanel = new JPanel();
        this.updateLocale();
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titlePanel.add(this.titleLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridwidth = 0;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tierSelectionPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.timeSpecPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.applyButton.addActionListener(this);
        this.buttonPanel.add(this.applyButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
    }

    private JPanel initTimeSpecPanel() {
        this.startLabel = new JLabel();
        this.endLabel = new JLabel();
        this.durationLabel = new JLabel();
        this.annotationSizeLabel = new JLabel();
        this.timeSpecPanel = new JPanel();
        this.timeSpecPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        DecimalFormat twoDigits = new DecimalFormat("00");
        twoDigits.setMaximumIntegerDigits(2);
        twoDigits.setMinimumIntegerDigits(2);
        twoDigits.setMaximumFractionDigits(0);
        DecimalFormat threeDigits = new DecimalFormat("000");
        threeDigits.setMaximumIntegerDigits(3);
        threeDigits.setMinimumIntegerDigits(3);
        threeDigits.setMaximumFractionDigits(0);
        String currentTime = TimeFormatter.toString(this.player.getMediaTime());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)this.startLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = insets;
        this.startHH = new JFormattedTextField(twoDigits);
        this.startHH.setColumns(1);
        this.startHH.setValue(Long.valueOf(currentTime.substring(0, 2)));
        this.startHH.addPropertyChangeListener("value", this);
        this.timeSpecPanel.add((Component)this.startHH, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)new JLabel(":"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = insets;
        this.startMM = new JFormattedTextField(twoDigits);
        this.startMM.setColumns(1);
        this.startMM.setValue(Long.valueOf(currentTime.substring(3, 5)));
        this.startMM.addPropertyChangeListener("value", this);
        this.timeSpecPanel.add((Component)this.startMM, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)new JLabel(":"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = insets;
        this.startSS = new JFormattedTextField(twoDigits);
        this.startSS.setColumns(1);
        this.startSS.setValue(Long.valueOf(currentTime.substring(6, 8)));
        this.startSS.addPropertyChangeListener("value", this);
        this.timeSpecPanel.add((Component)this.startSS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)new JLabel("."), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets;
        this.startMS = new JFormattedTextField(threeDigits);
        this.startMS.setColumns(2);
        this.startMS.setValue(Long.valueOf(currentTime.substring(9)));
        this.startMS.addPropertyChangeListener("value", this);
        this.timeSpecPanel.add((Component)this.startMS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)this.durationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = insets;
        this.durHH = new JFormattedTextField(twoDigits);
        this.durHH.setColumns(1);
        this.durHH.setValue(0L);
        this.durHH.addPropertyChangeListener("value", this);
        this.timeSpecPanel.add((Component)this.durHH, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)new JLabel(":"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = insets;
        this.durMM = new JFormattedTextField(twoDigits);
        this.durMM.setColumns(1);
        this.durMM.setValue(0L);
        this.durMM.addPropertyChangeListener("value", this);
        this.timeSpecPanel.add((Component)this.durMM, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)new JLabel(":"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = insets;
        this.durSS = new JFormattedTextField(twoDigits);
        this.durSS.setColumns(1);
        this.durSS.setValue(new Long(0L));
        this.durSS.addPropertyChangeListener("value", this);
        this.timeSpecPanel.add((Component)this.durSS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)new JLabel("."), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = insets;
        this.durMS = new JFormattedTextField(threeDigits);
        this.durMS.setColumns(2);
        this.durMS.setValue(0L);
        this.durMS.addPropertyChangeListener("value", this);
        this.timeSpecPanel.add((Component)this.durMS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)this.endLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = insets;
        this.endHH = new JFormattedTextField(twoDigits);
        this.endHH.setColumns(1);
        this.endHH.setValue(0L);
        this.endHH.addPropertyChangeListener("value", this);
        this.timeSpecPanel.add((Component)this.endHH, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)new JLabel(":"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = insets;
        this.endMM = new JFormattedTextField(twoDigits);
        this.endMM.setColumns(1);
        this.endMM.setValue(0L);
        this.endMM.addPropertyChangeListener("value", this);
        this.timeSpecPanel.add((Component)this.endMM, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)new JLabel(":"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = insets;
        this.endSS = new JFormattedTextField(twoDigits);
        this.endSS.setColumns(1);
        this.endSS.setValue(0L);
        this.endSS.addPropertyChangeListener("value", this);
        this.timeSpecPanel.add((Component)this.endSS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)new JLabel("."), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = insets;
        this.endMS = new JFormattedTextField(threeDigits);
        this.endMS.setColumns(2);
        this.endMS.setValue(0L);
        this.endMS.addPropertyChangeListener("value", this);
        this.timeSpecPanel.add((Component)this.endMS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)this.annotationSizeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = insets;
        this.annSizeHH = new JFormattedTextField(twoDigits);
        this.annSizeHH.setColumns(1);
        this.annSizeHH.setValue(0L);
        this.timeSpecPanel.add((Component)this.annSizeHH, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)new JLabel(":"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = insets;
        this.annSizeMM = new JFormattedTextField(twoDigits);
        this.annSizeMM.setColumns(1);
        this.annSizeMM.setValue(0L);
        this.timeSpecPanel.add((Component)this.annSizeMM, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)new JLabel(":"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = insets;
        this.annSizeSS = new JFormattedTextField(twoDigits);
        this.annSizeSS.setColumns(1);
        this.annSizeSS.setValue(0L);
        this.timeSpecPanel.add((Component)this.annSizeSS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.timeSpecPanel.add((Component)new JLabel("."), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.annSizeMS = new JFormattedTextField(threeDigits);
        this.annSizeMS.setColumns(2);
        this.annSizeMS.setValue(0L);
        this.timeSpecPanel.add((Component)this.annSizeMS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        this.timeSpecPanel.add((Component)new JPanel(), gridBagConstraints);
        return this.timeSpecPanel;
    }

    private void postInit() {
        this.pack();
        int w = 550;
        int h = 400;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("RegularAnnotationDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("RegularAnnotationDialog.Title"));
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("RegularAnnotationDialog.Label.Tier")));
        this.timeSpecPanel.setBorder(new TitledBorder(ElanLocale.getString("RegularAnnotationDialog.Label.Spec")));
        this.startLabel.setText(ElanLocale.getString("RegularAnnotationDialog.Label.Start"));
        this.endLabel.setText(ElanLocale.getString("RegularAnnotationDialog.Label.End"));
        this.durationLabel.setText(ElanLocale.getString("RegularAnnotationDialog.Label.Duration"));
        this.annotationSizeLabel.setText(ElanLocale.getString("RegularAnnotationDialog.Label.Size"));
        this.applyButton.setText(ElanLocale.getString("Button.Apply"));
        this.closeButton.setText(ElanLocale.getString("Button.Cancel"));
    }

    private void closeDialog(WindowEvent evt) {
        if (this.transcription != null) {
            ELANCommandFactory.getViewerManager(this.transcription).disconnectListener(this);
        }
        this.setVisible(false);
        this.dispose();
    }

    private Long getStartTime() {
        long hh = 0L;
        long mm = 0L;
        long ss = 0L;
        long ms = 0L;
        boolean noStart = true;
        if (this.startHH.getValue() != null) {
            hh = (Long)this.startHH.getValue() % 100L * 3600000L;
            noStart = false;
        }
        if (this.startMM.getValue() != null) {
            mm = (Long)this.startMM.getValue() % 100L * 60000L;
            noStart = false;
        }
        if (this.startSS.getValue() != null) {
            ss = (Long)this.startSS.getValue() % 100L * 1000L;
            noStart = false;
        }
        if (this.startMS.getValue() != null) {
            ms = (Long)this.startMS.getValue() % 1000L;
            noStart = false;
        }
        if (noStart) {
            return null;
        }
        return new Long(hh + mm + ss + ms);
    }

    private Long getDuration() {
        long hh = 0L;
        long mm = 0L;
        long ss = 0L;
        long ms = 0L;
        boolean noStart = true;
        if (this.durHH.getValue() != null) {
            hh = (Long)this.durHH.getValue() % 100L * 3600000L;
            noStart = false;
        }
        if (this.durMM.getValue() != null) {
            mm = (Long)this.durMM.getValue() % 100L * 60000L;
            noStart = false;
        }
        if (this.durSS.getValue() != null) {
            ss = (Long)this.durSS.getValue() % 100L * 1000L;
            noStart = false;
        }
        if (this.durMS.getValue() != null) {
            ms = (Long)this.durMS.getValue() % 1000L;
            noStart = false;
        }
        if (noStart) {
            return null;
        }
        return new Long(hh + mm + ss + ms);
    }

    private Long getEndTime() {
        long hh = 0L;
        long mm = 0L;
        long ss = 0L;
        long ms = 0L;
        boolean noStart = true;
        if (this.endHH.getValue() != null) {
            hh = (Long)this.endHH.getValue() % 100L * 3600000L;
            noStart = false;
        }
        if (this.endMM.getValue() != null) {
            mm = (Long)this.endMM.getValue() % 100L * 60000L;
            noStart = false;
        }
        if (this.endSS.getValue() != null) {
            ss = (Long)this.endSS.getValue() % 100L * 1000L;
            noStart = false;
        }
        if (this.endMS.getValue() != null) {
            ms = (Long)this.endMS.getValue() % 1000L;
            noStart = false;
        }
        if (noStart) {
            return null;
        }
        return new Long(hh + mm + ss + ms);
    }

    private Long getAnnotationSize() {
        long hh = 0L;
        long mm = 0L;
        long ss = 0L;
        long ms = 0L;
        boolean noStart = true;
        if (this.annSizeHH.getValue() != null) {
            hh = (Long)this.annSizeHH.getValue() % 100L * 3600000L;
            noStart = false;
        }
        if (this.annSizeMM.getValue() != null) {
            mm = (Long)this.annSizeMM.getValue() % 100L * 60000L;
            noStart = false;
        }
        if (this.annSizeSS.getValue() != null) {
            ss = (Long)this.annSizeSS.getValue() % 100L * 1000L;
            noStart = false;
        }
        if (this.annSizeMS.getValue() != null) {
            ms = (Long)this.annSizeMS.getValue() % 1000L;
            noStart = false;
        }
        if (noStart) {
            return null;
        }
        return new Long(hh + mm + ss + ms);
    }

    private boolean isStartTimeSource(Object source) {
        return source == this.startHH || source == this.startMM || source == this.startSS || source == this.startMS;
    }

    private boolean isDurationSource(Object source) {
        return source == this.durHH || source == this.durMM || source == this.durSS || source == this.durMS;
    }

    private boolean isEndTimeSource(Object source) {
        return source == this.endHH || source == this.endMM || source == this.endSS || source == this.endMS;
    }

    private void setEndTime() {
        this.end = this.dur + this.start;
        try {
            String timeStr = TimeFormatter.toString(this.end);
            long hh = Long.parseLong(timeStr.substring(0, 2));
            long mm = Long.parseLong(timeStr.substring(3, 5));
            long ss = Long.parseLong(timeStr.substring(6, 8));
            long ms = Long.parseLong(timeStr.substring(9));
            Long hhVal = (Long)this.endHH.getValue();
            Long mmVal = (Long)this.endMM.getValue();
            Long ssVal = (Long)this.endSS.getValue();
            Long msVal = (Long)this.endMS.getValue();
            if (null == hhVal || hh != hhVal) {
                this.endHH_inhib = true;
                this.endHH.setValue(hh);
            }
            if (null == mmVal || mm != mmVal) {
                this.endMM_inhib = true;
                this.endMM.setValue(mm);
            }
            if (null == ssVal || ss != ssVal) {
                this.endSS_inhib = true;
                this.endSS.setValue(ss);
            }
            if (null == msVal || ms != msVal) {
                this.endMS_inhib = true;
                this.endMS.setValue(ms);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setDuration() {
        this.dur = this.end - this.start;
        try {
            String timeStr = TimeFormatter.toString(this.dur);
            long hh = Long.parseLong(timeStr.substring(0, 2));
            long mm = Long.parseLong(timeStr.substring(3, 5));
            long ss = Long.parseLong(timeStr.substring(6, 8));
            long ms = Long.parseLong(timeStr.substring(9));
            Long hhVal = (Long)this.durHH.getValue();
            Long mmVal = (Long)this.durMM.getValue();
            Long ssVal = (Long)this.durSS.getValue();
            Long msVal = (Long)this.durMS.getValue();
            if (null == hhVal || hh != hhVal) {
                this.durHH_inhib = true;
                this.durHH.setValue(hh);
            }
            if (null == mmVal || mm != mmVal) {
                this.durMM_inhib = true;
                this.durMM.setValue(mm);
            }
            if (null == ssVal || ss != ssVal) {
                this.durSS_inhib = true;
                this.durSS.setValue(ss);
            }
            if (null == msVal || ms != msVal) {
                this.durMS_inhib = true;
                this.durMS.setValue(ms);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.endHH_inhib) {
            this.endHH_inhib = false;
            return;
        }
        if (this.endMM_inhib) {
            this.endMM_inhib = false;
            return;
        }
        if (this.endSS_inhib) {
            this.endSS_inhib = false;
            return;
        }
        if (this.endMS_inhib) {
            this.endMS_inhib = false;
            return;
        }
        if (this.durHH_inhib) {
            this.durHH_inhib = false;
            return;
        }
        if (this.durMM_inhib) {
            this.durMM_inhib = false;
            return;
        }
        if (this.durSS_inhib) {
            this.durSS_inhib = false;
            return;
        }
        if (this.durMS_inhib) {
            this.durMS_inhib = false;
            return;
        }
        if (this.getStartTime() != null) {
            this.start = this.getStartTime();
        }
        if (this.isStartTimeSource(e.getSource()) && this.getStartTime() != null) {
            if (this.getDuration() != null) {
                this.dur = this.getDuration();
                this.setEndTime();
            }
        } else if (this.isDurationSource(e.getSource()) && this.getDuration() != null) {
            if (this.getStartTime() != null) {
                this.dur = this.getDuration();
                this.setEndTime();
            }
        } else if (this.isEndTimeSource(e.getSource()) && this.getEndTime() != null && this.getStartTime() != null) {
            this.end = this.getEndTime();
            this.setDuration();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.applyButton) {
            try {
                List<String> selectedTiers;
                long end;
                if (null == this.getStartTime() || null == this.getAnnotationSize()) {
                    this.showWarningDialog(ElanLocale.getString("RegularAnnotationDialog.Message.InvalidTime"));
                    return;
                }
                if (this.getAnnotationSize() == 0L) {
                    this.showWarningDialog(ElanLocale.getString("RegularAnnotationDialog.Message.InvalidSize"));
                    this.annSizeSS.requestFocus();
                    return;
                }
                long start = this.getStartTime();
                long annSize = this.getAnnotationSize();
                if (this.getEndTime() != null) {
                    end = this.getEndTime();
                } else if (this.getDuration() != null) {
                    end = start + this.getDuration();
                } else {
                    this.showWarningDialog(ElanLocale.getString("RegularAnnotationDialog.Message.InvalidTime"));
                    return;
                }
                if (start >= end || annSize > end - start || start > this.mediaDuration) {
                    this.showWarningDialog(ElanLocale.getString("RegularAnnotationDialog.Message.InvalidTime"));
                    return;
                }
                if (end > this.mediaDuration) {
                    end = this.mediaDuration;
                }
                if ((selectedTiers = this.tierSelectionPanel.getSelectedTiers()).size() < 1) {
                    this.showWarningDialog(ElanLocale.getString("RegularAnnotationDialog.Message.NoTier"));
                    return;
                }
                Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.RegularAnnotation");
                Object[] args = new Object[]{new Long(start), new Long(end), new Long(annSize), selectedTiers};
                c.execute(this.transcription, args);
                this.closeDialog(null);
            }
            catch (NumberFormatException e) {
                this.showWarningDialog(ElanLocale.getString("RegularAnnotationDialog.Message.InvalidTime"));
            }
        } else if (source == this.closeButton) {
            this.closeDialog(null);
        }
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }
}

