/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FontSizer;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.FontSizePanel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.SimpleReport;

public class ReportDialog
extends ClosableDialog
implements FontSizer {
    private ProcessReport report;
    private JComponent mainComponent;
    private FontSizePanel fontSizePanel;

    public ReportDialog(ProcessReport report) throws HeadlessException {
        this.report = report;
        this.initComponents();
    }

    public ReportDialog(Dialog owner, ProcessReport report) throws HeadlessException {
        super(owner);
        this.report = report;
        this.initComponents();
    }

    public ReportDialog(Frame owner, ProcessReport report) throws HeadlessException {
        super(owner);
        this.report = report;
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("ProcessReport"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel content = new JPanel(new BorderLayout(4, 4));
        if (this.report != null) {
            Dimension dim;
            JScrollPane pane;
            JTextArea area;
            if (this.report.getName() != null && this.report.getName().length() > 0) {
                content.setBorder(new TitledBorder(this.report.getName()));
            } else {
                content.setBorder(new TitledBorder(ElanLocale.getString("ProcessReport")));
            }
            if (this.report instanceof SimpleReport) {
                area = new JTextArea(this.report.getReportAsString());
                area.setLineWrap(false);
                this.mainComponent = area;
                pane = new JScrollPane(area);
                dim = new Dimension(400, 300);
                pane.setPreferredSize(dim);
                pane.setMinimumSize(dim);
                content.add(pane);
            } else {
                area = new JTextArea(this.report.getReportAsString());
                area.setLineWrap(false);
                this.mainComponent = area;
                pane = new JScrollPane(area);
                dim = new Dimension(400, 300);
                pane.setPreferredSize(dim);
                pane.setMinimumSize(dim);
                content.add(pane);
            }
        } else {
            JLabel mes = new JLabel(ElanLocale.getString("ProcessReport.NoReport"));
            mes.setPreferredSize(new Dimension(200, 80));
            content.add(mes);
            this.mainComponent = mes;
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 3, 1, 3);
        JButton saveButton = new JButton(ElanLocale.getString("Button.Save"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportDialog.this.saveReport();
            }
        });
        buttonPanel.add((Component)saveButton, gbc);
        gbc.gridx = 1;
        JButton closeButton = new JButton(ElanLocale.getString("Button.Close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportDialog.this.savePreferences();
                ReportDialog.this.close();
            }
        });
        buttonPanel.add((Component)closeButton, gbc);
        gbc.gridx = 3;
        gbc.anchor = 13;
        this.fontSizePanel = new FontSizePanel(this);
        buttonPanel.add((Component)this.fontSizePanel, gbc);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        buttonPanel.add((Component)new JPanel(), gbc);
        content.add((Component)buttonPanel, "South");
        this.getContentPane().add(content);
        this.pack();
        if (this.getParent() != null) {
            Dimension curSize = this.getSize();
            Dimension parSize = this.getParent().getSize();
            int dx = parSize.width - curSize.width;
            int dy = parSize.height - curSize.height;
            if (dx > 0 || dy > 0) {
                Dimension dim = new Dimension(dx > 0 ? parSize.width : curSize.width, dy > 0 ? parSize.height : curSize.height);
                this.setSize(dim);
            }
            this.setLocationRelativeTo(this.getParent());
        }
        this.loadPreferences();
    }

    private void saveReport() {
        block7: {
            FileChooser chooser = new FileChooser(this);
            ArrayList<String[]> extsList = new ArrayList<String[]>(1);
            extsList.add(FileExtension.TEXT_EXT);
            chooser.createAndShowFileDialog(ElanLocale.getString("ReportDialog.FileChooser.Title"), 1, ElanLocale.getString("Button.OK"), extsList, FileExtension.TEXT_EXT, true, "LastUsedExportDir", 0, null);
            File newSaveFile = chooser.getSelectedFile();
            if (newSaveFile != null) {
                try {
                    FileOutputStream out = new FileOutputStream(newSaveFile);
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                    writer.write(this.report.getReportAsString());
                    writer.close();
                }
                catch (FileNotFoundException ex) {
                    if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                        ClientLogger.LOG.warning("File " + newSaveFile + " not found (" + ex.getMessage() + ")");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                        ClientLogger.LOG.warning("Encoding UTF-8 could not be used (" + e.getMessage() + ")");
                    }
                }
                catch (IOException e) {
                    if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block7;
                    ClientLogger.LOG.warning("Error writing file " + newSaveFile + " (" + e.getMessage() + ")");
                }
            }
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void loadPreferences() {
        Rectangle b;
        Integer prefFontSize = Preferences.getInt("ReportDialog.FontSize", null);
        if (prefFontSize != null) {
            if (this.fontSizePanel != null) {
                this.fontSizePanel.setFontSize(prefFontSize);
            } else {
                this.setFontSize(prefFontSize);
            }
        }
        if ((b = Preferences.getRect("ReportDialog.Bounds", null)) != null) {
            GraphicsDevice[] screens;
            for (GraphicsDevice gd : screens = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                if (!gd.getDefaultConfiguration().getBounds().intersects(b)) continue;
                this.setBounds(b);
                break;
            }
        }
    }

    private void savePreferences() {
        Preferences.set("ReportDialog.FontSize", (Object)this.getFontSize(), null);
        Preferences.set("ReportDialog.Bounds", this.getBounds(), null);
    }

    @Override
    public void setFontSize(int fontSize) {
        if (this.mainComponent != null) {
            Font f = this.mainComponent.getFont();
            this.mainComponent.setFont(f.deriveFont((float)fontSize));
        }
    }

    @Override
    public int getFontSize() {
        if (this.mainComponent != null) {
            return this.mainComponent.getFont().getSize();
        }
        return Constants.DEFAULTFONT.getSize();
    }
}

