/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeFormatter;

public class ShiftAllDialog
extends ClosableDialog
implements ActionListener {
    private TranscriptionImpl transcription;
    private JLabel label;
    private JTextField textField;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;

    public ShiftAllDialog(Transcription transcription) {
        super((Frame)ELANCommandFactory.getRootFrame(transcription), true);
        this.transcription = (TranscriptionImpl)transcription;
        this.initComponents();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.textField = new JTextField();
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.okButton = new JButton();
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets inset = new Insets(2, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = inset;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = inset;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.textField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = inset;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ShiftAllDialog.this.closeDialog();
            }
        });
        this.updateLocale();
        this.pack();
        int w = 260;
        int h = 130;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
        this.textField.grabFocus();
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("ShiftAllDialog.Title"));
        this.label.setText(ElanLocale.getString("ShiftAllDialog.Label"));
        this.okButton.setText(ElanLocale.getString("Button.OK"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        } else if (e.getSource() == this.okButton) {
            String textValue = this.textField.getText().trim();
            long longValue = 0L;
            longValue = TimeFormatter.toMilliSeconds(textValue);
            if (longValue == 0L) {
                this.closeDialog();
                return;
            }
            if (longValue < 0L) {
                if (this.transcription.getTimeOrder().size() > 0) {
                    Iterator<TimeSlot> en = this.transcription.getTimeOrder().iterator();
                    long firstAlignedTime = 0L;
                    while (en.hasNext()) {
                        TimeSlotImpl ts = (TimeSlotImpl)en.next();
                        if (!ts.isTimeAligned()) continue;
                        firstAlignedTime = ts.getTime();
                        break;
                    }
                    if (Math.abs(longValue) > firstAlignedTime) {
                        Object message = ElanLocale.getString("ShiftAllDialog.Warn");
                        message = firstAlignedTime == 0L ? (String)message + " " + firstAlignedTime : (String)message + " -" + firstAlignedTime;
                        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
                        return;
                    }
                } else {
                    this.closeDialog();
                    return;
                }
            }
            this.closeDialog();
            Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.ShiftAll");
            c.execute(this.transcription, new Object[]{new Long(longValue)});
        }
    }
}

