/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class ShowHideMoreTiersDlg
extends ClosableDialog
implements ActionListener,
MouseListener {
    private final String NOT_SPECIFIED = "not specified";
    private final String SHOW_TIERS = ElanLocale.getString("MultiTierControlPanel.Menu.ShowTiers");
    private final String SHOW_TYPES = ElanLocale.getString("MultiTierControlPanel.Menu.ShowLinguisticType");
    private final String SHOW_PART = ElanLocale.getString("MultiTierControlPanel.Menu.ShowParticipant");
    private final String SHOW_ANN = ElanLocale.getString("MultiTierControlPanel.Menu.ShowAnnotator");
    private final String SHOW_LANG = ElanLocale.getString("MultiTierControlPanel.Menu.ShowLanguage");
    private final String SHOW_TIERS_LIPREF = "ShowTiers";
    private final String SHOW_TYPES_LIPREF = "ShowTypes";
    private final String SHOW_PART_LIPREF = "ShowParticipants";
    private final String SHOW_ANN_LIPREF = "ShowAnnotators";
    private final String SHOW_LANG_LIPREF = "ShowLanguages";
    private JPanel checkboxPanel;
    private JButton showAllButton;
    private JButton hideAllButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton sortButton;
    private JButton sortDefaultButton;
    private JTabbedPane showTabPane;
    private Transcription trans;
    private List<String> allTierNames;
    private List<String> allLinTypeNames;
    private List<String> allParticipants;
    private List<String> allAnnotators;
    private List<String> allLanguages;
    private List<String> visibleTypeNames;
    private List<String> visibleTierNames;
    private List<String> visibleParts;
    private List<String> visibleAnns;
    private List<String> visibleLanguages;
    private int currentTabIndex = 0;
    private boolean rootTiersOnly = false;
    private boolean valueChanged = false;
    private List<String> hiddenTiers;

    public ShowHideMoreTiersDlg(Transcription trans, List visibleTiers) {
        this(trans, visibleTiers, null);
    }

    public ShowHideMoreTiersDlg(Transcription trans, List visibleTiers, Component component) {
        this(trans, visibleTiers, component, false);
    }

    public ShowHideMoreTiersDlg(Transcription trans, List visibleTiers, Component component, boolean rootTiersOnly) {
        this(trans, null, visibleTiers, component, rootTiersOnly);
    }

    public ShowHideMoreTiersDlg(Transcription trans, List<String> tierOrder, List visibleTiers, Component component) {
        this(trans, tierOrder, visibleTiers, component, false);
    }

    public ShowHideMoreTiersDlg(Transcription trans, List<String> tierOrder, List visibleTiers, Component component, boolean rootTiersOnly) {
        super(ELANCommandFactory.getRootFrame(trans), ElanLocale.getString("MultiTierControlPanel.Menu.VisibleTiers"), true);
        this.trans = trans;
        this.rootTiersOnly = rootTiersOnly;
        this.initialize(tierOrder, visibleTiers);
        this.initDialog();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocation(component);
    }

    private void initialize(List<String> tierOrder, List visibleTiers) {
        TierImpl tier;
        this.allTierNames = tierOrder == null ? ELANCommandFactory.getViewerManager(this.trans).getTierOrder().getTierOrder() : tierOrder;
        if (this.rootTiersOnly) {
            int i = 0;
            while (i < this.allTierNames.size()) {
                tier = (TierImpl)this.trans.getTierWithId(this.allTierNames.get(i));
                if (tier.hasParentTier()) {
                    this.allTierNames.remove(i);
                    continue;
                }
                ++i;
            }
        }
        this.visibleTierNames = new ArrayList<String>();
        if (visibleTiers != null) {
            tier = null;
            Object obj = null;
            for (int i = 0; i < visibleTiers.size(); ++i) {
                obj = visibleTiers.get(i);
                if (obj instanceof TierImpl) {
                    tier = (TierImpl)visibleTiers.get(i);
                    if (!this.allTierNames.contains(tier.getName()) || this.visibleTierNames.contains(tier.getName())) continue;
                    this.visibleTierNames.add(tier.getName());
                    continue;
                }
                if (!(obj instanceof String) || !this.allTierNames.contains(obj) || this.visibleTierNames.contains(obj)) continue;
                this.visibleTierNames.add(obj);
            }
        }
        this.allLinTypeNames = new ArrayList<String>();
        this.allParticipants = new ArrayList<String>();
        this.allAnnotators = new ArrayList<String>();
        this.allLanguages = new ArrayList<String>();
        this.visibleTypeNames = new ArrayList<String>();
        this.visibleParts = new ArrayList<String>();
        this.visibleAnns = new ArrayList<String>();
        this.visibleLanguages = new ArrayList<String>();
        this.hiddenTiers = new ArrayList<String>();
    }

    private void initDialog() {
        JCheckBox checkbox;
        int i;
        this.showAllButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.ShowAllTiers"));
        this.showAllButton.addActionListener(this);
        this.hideAllButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.HideAllTiers"));
        this.hideAllButton.addActionListener(this);
        this.applyButton = new JButton(ElanLocale.getString("Button.OK"));
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.sortButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.Button.Sort"));
        this.sortButton.addActionListener(this);
        this.sortDefaultButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.Button.Default"));
        this.sortDefaultButton.addActionListener(this);
        this.showTabPane = new JTabbedPane();
        JPanel buttonPanel1 = new JPanel(new GridBagLayout());
        buttonPanel1.add(this.sortButton);
        buttonPanel1.add(this.sortDefaultButton);
        buttonPanel1.add(this.showAllButton);
        buttonPanel1.add(this.hideAllButton);
        GridLayout gl = new GridLayout(1, 2, 6, 2);
        JPanel buttonPanel2 = new JPanel(gl);
        buttonPanel2.add(this.applyButton);
        buttonPanel2.add(this.cancelButton);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setPreferredSize(new Dimension(600, 400));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 11;
        gbc.insets = new Insets(2, 6, 2, 6);
        gbc.gridy = 1;
        gbc.gridx = 0;
        this.getContentPane().add((Component)buttonPanel1, gbc);
        gbc.gridy = 1;
        gbc.gridx = 2;
        gbc.anchor = 13;
        this.getContentPane().add((Component)buttonPanel2, gbc);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        this.getContentPane().add((Component)this.showTabPane, gbc);
        this.getRootPane().setDefaultButton(this.applyButton);
        this.checkboxPanel = new JPanel();
        BoxLayout box = new BoxLayout(this.checkboxPanel, 1);
        this.checkboxPanel.setLayout(box);
        for (i = 0; i < this.allTierNames.size(); ++i) {
            TierImpl tier = (TierImpl)this.trans.getTierWithId(this.allTierNames.get(i));
            checkbox = new JCheckBox(tier.getName());
            this.checkboxPanel.add(checkbox);
            String value = tier.getParticipant();
            if (value.isEmpty()) {
                value = "not specified";
            }
            if (!this.allParticipants.contains(value)) {
                this.allParticipants.add(value);
            }
            if ((value = tier.getAnnotator()).isEmpty()) {
                value = "not specified";
            }
            if (!this.allAnnotators.contains(value)) {
                this.allAnnotators.add(value);
            }
            if ((value = tier.getLangRef()) == null || value.isEmpty()) {
                value = "not specified";
            }
            if (!this.allLanguages.contains(value)) {
                this.allLanguages.add(value);
            }
            if (this.allLinTypeNames.contains(value = tier.getLinguisticType().getLinguisticTypeName())) continue;
            this.allLinTypeNames.add(value);
        }
        this.showTabPane.add(this.SHOW_TIERS, new JScrollPane(this.checkboxPanel));
        this.checkboxPanel = new JPanel();
        box = new BoxLayout(this.checkboxPanel, 1);
        this.checkboxPanel.setLayout(box);
        for (i = 0; i < this.allLinTypeNames.size(); ++i) {
            checkbox = new JCheckBox(this.allLinTypeNames.get(i));
            this.checkboxPanel.add(checkbox);
        }
        this.showTabPane.add(this.SHOW_TYPES, new JScrollPane(this.checkboxPanel));
        this.checkboxPanel = new JPanel();
        box = new BoxLayout(this.checkboxPanel, 1);
        this.checkboxPanel.setLayout(box);
        for (i = 0; i < this.allParticipants.size(); ++i) {
            checkbox = new JCheckBox(this.allParticipants.get(i));
            this.checkboxPanel.add(checkbox);
        }
        this.showTabPane.addTab(this.SHOW_PART, new JScrollPane(this.checkboxPanel));
        this.checkboxPanel = new JPanel();
        box = new BoxLayout(this.checkboxPanel, 1);
        this.checkboxPanel.setLayout(box);
        for (i = 0; i < this.allAnnotators.size(); ++i) {
            checkbox = new JCheckBox(this.allAnnotators.get(i));
            this.checkboxPanel.add(checkbox);
        }
        this.showTabPane.addTab(this.SHOW_ANN, new JScrollPane(this.checkboxPanel));
        this.checkboxPanel = new JPanel();
        box = new BoxLayout(this.checkboxPanel, 1);
        this.checkboxPanel.setLayout(box);
        for (i = 0; i < this.allLanguages.size(); ++i) {
            checkbox = new JCheckBox(this.allLanguages.get(i));
            this.checkboxPanel.add(checkbox);
        }
        this.showTabPane.addTab(this.SHOW_LANG, new JScrollPane(this.checkboxPanel));
        this.showTabPane.addMouseListener(this);
        this.showTiers();
    }

    public JTabbedPane getTabPane() {
        return this.showTabPane;
    }

    private JPanel getCheckboxPanel(int index) {
        return (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
    }

    private void updateTab(int index, List<String> sortedList) {
        JPanel checkboxPanel = this.getCheckboxPanel(index);
        checkboxPanel.removeAll();
        for (String s : sortedList) {
            checkboxPanel.add(new JCheckBox(s));
        }
        this.showTabPane.repaint();
        this.updateTabAtIndex(index);
    }

    private void setLocation(Component component) {
        if (component instanceof MultiTierControlPanel) {
            Point p = new Point(0, 0);
            SwingUtilities.convertPointToScreen(p, component);
            int windowHeight = SwingUtilities.getWindowAncestor(component).getHeight();
            if (this.getHeight() > windowHeight) {
                this.setSize(this.getWidth(), windowHeight);
            }
            p.x += component.getWidth();
            p.y -= this.getHeight() - component.getHeight();
            this.setLocation(p);
        } else {
            this.setLocationRelativeTo(this.getParent());
        }
    }

    public List<String> getVisibleTierNames() {
        return this.visibleTierNames;
    }

    public String getSelectionMode() {
        if (this.visibleTypeNames.size() > 0) {
            return "ShowTypes";
        }
        if (this.visibleParts.size() > 0) {
            return "ShowParticipants";
        }
        if (this.visibleAnns.size() > 0) {
            return this.SHOW_ANN_LIPREF;
        }
        if (this.visibleLanguages.size() > 0) {
            return this.SHOW_LANG_LIPREF;
        }
        return this.SHOW_TIERS_LIPREF;
    }

    private void setHiddenTiers(List<String> hiddenTiers) {
        String value;
        if (hiddenTiers == null) {
            return;
        }
        this.hiddenTiers = hiddenTiers;
        this.visibleAnns.clear();
        this.visibleTypeNames.clear();
        this.visibleParts.clear();
        this.visibleLanguages.clear();
        TierImpl.ValueGetter getter = null;
        List<String> visibleValues = null;
        String selectionMode = this.showTabPane.getTitleAt(this.currentTabIndex);
        if (selectionMode.equals(this.SHOW_ANN)) {
            getter = new TierImpl.AnnotatorGetter();
            visibleValues = this.visibleAnns;
        } else if (selectionMode.equals(this.SHOW_TYPES)) {
            getter = new TierImpl.LinguisticTypeNameGetter();
            visibleValues = this.visibleTypeNames;
        } else if (selectionMode.equals(this.SHOW_PART)) {
            getter = new TierImpl.ParticipantGetter();
            visibleValues = this.visibleParts;
        } else if (selectionMode.equals(this.SHOW_LANG)) {
            getter = new TierImpl.LanguageGetter();
            visibleValues = this.visibleLanguages;
        } else {
            return;
        }
        for (String visibleTierName : this.visibleTierNames) {
            TierImpl t = (TierImpl)this.trans.getTierWithId(visibleTierName);
            value = getter.getSortValue(t);
            if (value.isEmpty()) {
                value = "not specified";
            }
            if (visibleValues.contains(value)) continue;
            visibleValues.add(value);
        }
        this.visibleTierNames.clear();
        for (String tierName : this.allTierNames) {
            TierImpl tier = (TierImpl)this.trans.getTierWithId(tierName);
            value = getter.getSortValue(tier);
            if (value.isEmpty()) {
                value = "not specified";
            }
            if (!visibleValues.contains(value) || hiddenTiers.contains(tierName)) continue;
            this.visibleTierNames.add(tier.getName());
        }
        this.updateTabAtIndex(this.currentTabIndex);
    }

    public void setSelectionMode(String selectionMode, List<String> hiddenTiers) {
        if (selectionMode == null) {
            return;
        }
        this.currentTabIndex = selectionMode.equals("ShowAnnotators") || selectionMode.equals(this.SHOW_ANN) ? this.showTabPane.indexOfTab(this.SHOW_ANN) : (selectionMode.equals("ShowTypes") || selectionMode.equals(this.SHOW_TYPES) ? this.showTabPane.indexOfTab(this.SHOW_TYPES) : (selectionMode.equals("ShowParticipants") || selectionMode.equals(this.SHOW_PART) ? this.showTabPane.indexOfTab(this.SHOW_PART) : (selectionMode.equals("ShowLanguages") || selectionMode.equals(this.SHOW_LANG) ? this.showTabPane.indexOfTab(this.SHOW_LANG) : this.showTabPane.indexOfTab(this.SHOW_TIERS))));
        this.showTabPane.setSelectedIndex(this.currentTabIndex);
        this.setHiddenTiers(hiddenTiers);
    }

    public List<String> getHiddenTiers() {
        if (this.trans == null) {
            return null;
        }
        TierImpl.ValueGetter getter = null;
        List<String> visibleValues = null;
        ArrayList<String> hiddenTiers = new ArrayList<String>();
        if (this.visibleTypeNames.size() > 0) {
            getter = new TierImpl.LinguisticTypeNameGetter();
            visibleValues = this.visibleTierNames;
        } else if (this.visibleParts.size() > 0) {
            getter = new TierImpl.ParticipantGetter();
            visibleValues = this.visibleParts;
        } else if (this.visibleAnns.size() > 0) {
            getter = new TierImpl.AnnotatorGetter();
            visibleValues = this.visibleAnns;
        } else if (this.visibleLanguages.size() > 0) {
            getter = new TierImpl.LanguageGetter();
            visibleValues = this.visibleLanguages;
        } else {
            return null;
        }
        for (String tierName : this.allTierNames) {
            TierImpl tier = (TierImpl)this.trans.getTierWithId(tierName);
            String value = getter.getSortValue(tier);
            if (value.isEmpty()) {
                value = "not specified";
            }
            if (!visibleValues.contains(value) || this.visibleTierNames.contains(tierName)) continue;
            hiddenTiers.add(tierName);
        }
        if (hiddenTiers.size() > 0) {
            return hiddenTiers;
        }
        return null;
    }

    private void showTiers() {
        int index = this.showTabPane.indexOfTab(this.SHOW_TIERS);
        this.setCheckboxes(index, this.visibleTierNames);
    }

    private void setCheckboxes(int index, List<String> select) {
        JPanel checkboxPanel = this.getCheckboxPanel(index);
        for (Component comp : checkboxPanel.getComponents()) {
            if (!(comp instanceof JCheckBox)) continue;
            JCheckBox box = (JCheckBox)comp;
            boolean selected = select.contains(box.getText());
            box.setSelected(selected);
        }
    }

    private void updateTiers() {
        int index = this.showTabPane.indexOfTab(this.SHOW_TIERS);
        JPanel checkboxPanel = this.getCheckboxPanel(index);
        ArrayList<String> oldVisibleTierNames = new ArrayList<String>();
        oldVisibleTierNames.addAll(this.visibleTierNames);
        boolean valueChanged = false;
        this.visibleTierNames.clear();
        Component[] boxes = checkboxPanel.getComponents();
        for (Component comp : boxes) {
            JCheckBox box;
            if (!(comp instanceof JCheckBox) || !(box = (JCheckBox)comp).isSelected()) continue;
            String tierName = box.getText();
            this.visibleTierNames.add(tierName);
            if (oldVisibleTierNames.contains(tierName)) continue;
            if (this.hiddenTiers.contains(tierName)) {
                this.hiddenTiers.remove(tierName);
                continue;
            }
            valueChanged = true;
        }
        if (valueChanged) {
            this.hiddenTiers.clear();
            this.visibleTypeNames.clear();
            this.visibleParts.clear();
            this.visibleAnns.clear();
            this.visibleLanguages.clear();
        } else {
            for (String oldVisibleTierName : oldVisibleTierNames) {
                if (this.visibleTierNames.contains(oldVisibleTierName) || this.hiddenTiers.contains(oldVisibleTierName)) continue;
                this.hiddenTiers.add(oldVisibleTierName);
            }
        }
    }

    private boolean updateTiersFromOtherPane(int index, List<String> visibleValues, TierImpl.ValueGetter getter) {
        JPanel checkboxPanel = this.getCheckboxPanel(index);
        boolean changed = false;
        ArrayList<String> selectedValues = new ArrayList<String>();
        Component[] boxes = checkboxPanel.getComponents();
        for (Component comp : boxes) {
            String value;
            JCheckBox box;
            if (!(comp instanceof JCheckBox) || !(box = (JCheckBox)comp).isSelected() || selectedValues.contains(value = box.getText())) continue;
            selectedValues.add(value);
        }
        if (selectedValues.size() != visibleValues.size()) {
            changed = true;
        } else {
            for (String value : selectedValues) {
                if (visibleValues.contains(value)) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            List[] allLists;
            if (visibleValues.isEmpty()) {
                this.hiddenTiers.clear();
            }
            visibleValues.clear();
            visibleValues.addAll(selectedValues);
            this.visibleTierNames.clear();
            for (String tierName : this.allTierNames) {
                TierImpl tier = (TierImpl)this.trans.getTierWithId(tierName);
                String value = getter.getSortValue(tier);
                if (value.isEmpty()) {
                    value = "not specified";
                }
                if (!visibleValues.contains(value)) continue;
                this.visibleTierNames.add(tierName);
            }
            this.visibleTierNames.removeAll(this.hiddenTiers);
            for (List l : allLists = new List[]{this.visibleTypeNames, this.visibleParts, this.visibleAnns, this.visibleLanguages}) {
                if (l == visibleValues) continue;
                l.clear();
            }
        }
        return changed;
    }

    private void setAllSelected(boolean selected) {
        Component[] boxes;
        int index = this.showTabPane.getSelectedIndex();
        JPanel checkboxPanel = this.getCheckboxPanel(index);
        for (Component comp : boxes = checkboxPanel.getComponents()) {
            if (!(comp instanceof JCheckBox)) continue;
            ((JCheckBox)comp).setSelected(selected);
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isValueChanged() {
        return this.valueChanged;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.showAllButton) {
            this.setAllSelected(true);
        } else if (source == this.hideAllButton) {
            this.setAllSelected(false);
        } else if (source == this.applyButton) {
            this.valueChanged = true;
            this.updateChanges(this.showTabPane.getSelectedIndex());
            this.close();
        } else if (source == this.cancelButton) {
            this.valueChanged = false;
            this.close();
        } else if (source == this.sortButton) {
            int index = this.showTabPane.getSelectedIndex();
            this.updateChanges(index);
            this.sortAlphabetically(index);
        } else if (source == this.sortDefaultButton) {
            int index = this.showTabPane.getSelectedIndex();
            this.updateChanges(index);
            this.sortInDefaultOrder(index);
        }
    }

    private void sortInDefaultOrder(int index) {
        String tabName = this.showTabPane.getTitleAt(index);
        if (tabName.equals(this.SHOW_TYPES)) {
            this.updateTab(index, this.allLinTypeNames);
        } else if (tabName.equals(this.SHOW_TIERS)) {
            this.updateTab(index, this.allTierNames);
        } else if (tabName.equals(this.SHOW_PART)) {
            this.updateTab(index, this.allParticipants);
        } else if (tabName.equals(this.SHOW_ANN)) {
            this.updateTab(index, this.allAnnotators);
        } else if (tabName.equals(this.SHOW_LANG)) {
            this.updateTab(index, this.allLanguages);
        }
    }

    private void sortAlphabetically(int index) {
        String tabName = this.showTabPane.getTitleAt(index);
        Object[] array = null;
        if (tabName.equals(this.SHOW_TYPES)) {
            array = this.allLinTypeNames.toArray(new String[this.allLinTypeNames.size()]);
        } else if (tabName.equals(this.SHOW_TIERS)) {
            array = this.allTierNames.toArray(new String[this.allTierNames.size()]);
        } else if (tabName.equals(this.SHOW_PART)) {
            array = this.allParticipants.toArray(new String[this.allParticipants.size()]);
        } else if (tabName.equals(this.SHOW_ANN)) {
            array = this.allAnnotators.toArray(new String[this.allAnnotators.size()]);
        } else if (tabName.equals(this.SHOW_LANG)) {
            array = this.allLanguages.toArray(new String[this.allLanguages.size()]);
        } else {
            return;
        }
        Arrays.sort(array);
        ArrayList<String> sortedValues = new ArrayList<String>();
        for (Object s : array) {
            sortedValues.add((String)s);
        }
        this.updateTab(index, sortedValues);
    }

    private void updateChanges(int index) {
        String tabName = this.showTabPane.getTitleAt(index);
        if (tabName.equals(this.SHOW_TYPES)) {
            this.updateTiersFromOtherPane(index, this.visibleTypeNames, new TierImpl.LinguisticTypeNameGetter());
        } else if (tabName.equals(this.SHOW_TIERS)) {
            this.updateTiers();
        } else if (tabName.equals(this.SHOW_PART)) {
            this.updateTiersFromOtherPane(index, this.visibleParts, new TierImpl.ParticipantGetter());
        } else if (tabName.equals(this.SHOW_ANN)) {
            this.updateTiersFromOtherPane(index, this.visibleAnns, new TierImpl.AnnotatorGetter());
        } else if (tabName.equals(this.SHOW_LANG)) {
            this.updateTiersFromOtherPane(index, this.visibleLanguages, new TierImpl.LanguageGetter());
        }
    }

    private void updateTabAtIndex(int index) {
        List<String> visible;
        String tabName = this.showTabPane.getTitleAt(index);
        if (tabName.equals(this.SHOW_TYPES)) {
            visible = this.visibleTypeNames;
        } else if (tabName.equals(this.SHOW_TIERS)) {
            visible = this.visibleTierNames;
        } else if (tabName.equals(this.SHOW_PART)) {
            visible = this.visibleParts;
        } else if (tabName.equals(this.SHOW_ANN)) {
            visible = this.visibleAnns;
        } else if (tabName.equals(this.SHOW_LANG)) {
            visible = this.visibleLanguages;
        } else {
            return;
        }
        this.setCheckboxes(index, visible);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.showTabPane) {
            this.updateChanges(this.currentTabIndex);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.showTabPane) {
            this.currentTabIndex = this.showTabPane.getSelectedIndex();
            this.updateTabAtIndex(this.currentTabIndex);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

