/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.MultipleFileStatisticsCommand;
import mpi.eudico.client.annotator.export.ExportStatistics;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.client.annotator.multiplefilesedit.statistics.StatisticsCollectionMF;
import mpi.eudico.client.annotator.tier.DisplayableContentTableModel;
import mpi.eudico.client.annotator.tier.SelectableContentTableModel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.client.util.TableHeaderToolTipAdapter;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.SimpleReport;
import mpi.eudico.util.EmptyStringComparator;
import mpi.eudico.util.FloatStringComparator;
import mpi.eudico.util.IntStringComparator;

public class StatisticsMultipleFilesDialog
extends ClosableDialog
implements ClientLogger,
ListSelectionListener,
ActionListener,
ProgressListener {
    public final int ANN_COL_INDEX = 0;
    public final int TIER_COL_INDEX = 1;
    public final int TYPE_COL_INDEX = 2;
    public final int PART_COL_INDEX = 3;
    public final int ANNOTATOR_COL_INDEX = 4;
    public final int LANGUAGE_COL_INDEX = 5;
    private JButton saveButton;
    private JButton closeButton;
    private JFrame parent;
    private JLabel titleLabel;
    private JTabbedPane tabPane;
    private JPanel fileSelectPanel;
    private JPanel buttonPanel;
    private JPanel titlePanel;
    private JScrollPane tierTableScrollPane;
    private JTable tierTable;
    private JButton selectDomainButton;
    private JButton selectFilesButton;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private JButton updateStatisticsButton;
    private Insets defaultInsets;
    private Insets extraVerticalInset;
    private JProgressBar progressBar;
    private List<TranscriptionImpl> transImplList;
    private List<String> fileNames;
    private static String DEFAULT_TABLE_MESSAGE = ElanLocale.getString("Statistics.Multi.NoShow");
    private static String TIER_SELECTION_TABLE_HEADER = ElanLocale.getString("Frame.GridFrame.ColumnTierName");
    private Map<Integer, String> tabTitles;
    private Map<String, JTable> tabTables;
    private Map<Integer, String[]> tableHeaders;
    private StatisticsCollectionMF curStatsCollection;
    private MultipleFileStatisticsCommand curCommand;

    public StatisticsMultipleFilesDialog(JFrame parentFrame) {
        super(parentFrame);
        this.parent = parentFrame;
        this.transImplList = new ArrayList<TranscriptionImpl>();
        this.defaultInsets = new Insets(2, 6, 2, 6);
        this.extraVerticalInset = new Insets(2, 6, 8, 6);
        this.initComponents();
        this.setTitle(ElanLocale.getString("Statistics.Multi.Title"));
        this.setSize(500, 300);
        this.tierTable.setModel(new DisplayableContentTableModel(DEFAULT_TABLE_MESSAGE));
        this.tierTable.getColumnModel().getColumn(0).setHeaderValue(TIER_SELECTION_TABLE_HEADER);
        this.tierTable.getTableHeader().setReorderingAllowed(false);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    private void initComponents() {
        this.titleLabel = new JLabel(ElanLocale.getString("Statistics.Multi.Title"));
        this.titlePanel = new JPanel();
        this.tabPane = new JTabbedPane();
        this.initStatisticsTab();
        this.saveButton = new JButton(ElanLocale.getString("Button.Save"));
        this.closeButton = new JButton(ElanLocale.getString("Button.Close"));
        this.buttonPanel = new JPanel();
        this.fileSelectPanel = new JPanel(new GridBagLayout());
        this.initTierSelectionPanel();
        this.saveButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.selectDomainButton.addActionListener(this);
        this.selectFilesButton.addActionListener(this);
        this.selectAllButton.addActionListener(this);
        this.selectNoneButton.addActionListener(this);
        this.updateStatisticsButton.addActionListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titlePanel.add(this.titleLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.fileSelectPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tabPane, gridBagConstraints);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.progressBar, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 2));
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.fileSelectPanel.setBorder(new TitledBorder(ElanLocale.getString("Statistics.Multi.TierSelection")));
        this.getRootPane().setDefaultButton(this.closeButton);
    }

    private void initTierSelectionPanel() {
        this.tierTable = new JTable(new DisplayableContentTableModel("Please wait"));
        this.tierTable.setSelectionMode(0);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        this.tierTable.setShowVerticalLines(false);
        this.tierTableScrollPane = new JScrollPane(this.tierTable);
        this.tierTableScrollPane.setPreferredSize(new Dimension(400, 150));
        this.tierTableScrollPane.setColumnHeaderView(null);
        this.selectDomainButton = new JButton(ElanLocale.getString("MFE.DomainDefKey"));
        this.selectFilesButton = new JButton(ElanLocale.getString("Statistics.Multi.Files"));
        this.selectAllButton = new JButton(ElanLocale.getString("Button.SelectAll"));
        this.selectNoneButton = new JButton(ElanLocale.getString("Button.SelectNone"));
        this.updateStatisticsButton = new JButton(ElanLocale.getString("Statistics.Multi.Update"));
        this.updateStatisticsButton.setEnabled(false);
        this.selectAllButton.setEnabled(false);
        this.selectNoneButton.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        gbc.gridheight = 7;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = this.defaultInsets;
        this.fileSelectPanel.add((Component)this.tierTableScrollPane, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.fileSelectPanel.add((Component)this.selectDomainButton, gbc);
        gbc.gridy = 1;
        gbc.insets = this.extraVerticalInset;
        this.fileSelectPanel.add((Component)this.selectFilesButton, gbc);
        gbc.gridy = 2;
        gbc.insets = this.defaultInsets;
        this.fileSelectPanel.add((Component)this.selectAllButton, gbc);
        gbc.gridy = 3;
        gbc.insets = this.extraVerticalInset;
        this.fileSelectPanel.add((Component)this.selectNoneButton, gbc);
        gbc.gridy = 4;
        gbc.insets = this.defaultInsets;
        this.fileSelectPanel.add((Component)this.updateStatisticsButton, gbc);
    }

    private void initStatisticsTab() {
        this.tabPane.setPreferredSize(new Dimension(400, 300));
        this.tabTitles = new HashMap<Integer, String>(6);
        this.tabTables = new HashMap<String, JTable>(6);
        this.tableHeaders = new HashMap<Integer, String[]>(6);
        String id = ElanLocale.getString("Statistics.Panel.Annotation");
        this.tabTitles.put(0, id);
        Object[] headers = new String[]{ElanLocale.getString("Frame.GridFrame.ColumnTierName"), ElanLocale.getString("Frame.GridFrame.ColumnAnnotation"), ElanLocale.getString("Statistics.Occurrences"), ElanLocale.getString("Statistics.MinimalDuration"), ElanLocale.getString("Statistics.MaximalDuration"), ElanLocale.getString("Statistics.AverageDuration"), ElanLocale.getString("Statistics.MedianDuration"), ElanLocale.getString("Statistics.TotalDuration"), ElanLocale.getString("Statistics.Latency")};
        this.tableHeaders.put(0, (String[])headers);
        JTable annTable = new JTable(new DefaultTableModel(headers, 1));
        annTable.setEnabled(false);
        annTable.getTableHeader().addMouseMotionListener(new TableHeaderToolTipAdapter(annTable.getTableHeader()));
        this.tabTables.put(id, annTable);
        this.tabPane.addTab(id, new JScrollPane(annTable));
        id = ElanLocale.getString("Statistics.Panel.Tier");
        this.tabTitles.put(1, id);
        headers = new String[]{ElanLocale.getString("Frame.GridFrame.ColumnTierName"), ElanLocale.getString("Statistics.NumFiles"), ElanLocale.getString("Statistics.NumAnnotations"), ElanLocale.getString("Statistics.MinimalDuration"), ElanLocale.getString("Statistics.MaximalDuration"), ElanLocale.getString("Statistics.AverageDuration"), ElanLocale.getString("Statistics.MedianDuration"), ElanLocale.getString("Statistics.TotalDuration"), ElanLocale.getString("Statistics.Latency")};
        this.tableHeaders.put(1, (String[])headers);
        JTable tiTable = new JTable(new DefaultTableModel(headers, 0));
        tiTable.setEnabled(false);
        tiTable.getTableHeader().addMouseMotionListener(new TableHeaderToolTipAdapter(tiTable.getTableHeader()));
        this.tabTables.put(id, tiTable);
        this.tabPane.addTab(id, new JScrollPane(tiTable));
        id = ElanLocale.getString("Statistics.Panel.Type");
        this.tabTitles.put(2, id);
        headers = new String[]{ElanLocale.getString("Statistics.Type"), ElanLocale.getString("Statistics.NumFiles"), ElanLocale.getString("Statistics.NumTiers"), ElanLocale.getString("Statistics.NumAnnotations"), ElanLocale.getString("Statistics.MinimalDuration"), ElanLocale.getString("Statistics.MaximalDuration"), ElanLocale.getString("Statistics.AverageDuration"), ElanLocale.getString("Statistics.MedianDuration"), ElanLocale.getString("Statistics.TotalDuration"), ElanLocale.getString("Statistics.Latency")};
        this.tableHeaders.put(2, (String[])headers);
        JTable typTable = new JTable(new DefaultTableModel(headers, 0));
        typTable.setEnabled(false);
        typTable.getTableHeader().addMouseMotionListener(new TableHeaderToolTipAdapter(typTable.getTableHeader()));
        this.tabTables.put(id, typTable);
        this.tabPane.addTab(id, new JScrollPane(typTable));
        id = ElanLocale.getString("Statistics.Panel.Participant");
        this.tabTitles.put(3, id);
        headers = new String[]{ElanLocale.getString("Statistics.Participant"), ElanLocale.getString("Statistics.NumFiles"), ElanLocale.getString("Statistics.NumTiers"), ElanLocale.getString("Statistics.NumAnnotations"), ElanLocale.getString("Statistics.MinimalDuration"), ElanLocale.getString("Statistics.MaximalDuration"), ElanLocale.getString("Statistics.AverageDuration"), ElanLocale.getString("Statistics.MedianDuration"), ElanLocale.getString("Statistics.TotalDuration"), ElanLocale.getString("Statistics.Latency")};
        this.tableHeaders.put(3, (String[])headers);
        JTable partTable = new JTable(new DefaultTableModel(headers, 0));
        partTable.setEnabled(false);
        partTable.getTableHeader().addMouseMotionListener(new TableHeaderToolTipAdapter(partTable.getTableHeader()));
        this.tabTables.put(id, partTable);
        this.tabPane.addTab(id, new JScrollPane(partTable));
        id = ElanLocale.getString("Statistics.Panel.Annotator");
        this.tabTitles.put(4, id);
        headers = new String[]{ElanLocale.getString("Statistics.Annotator"), ElanLocale.getString("Statistics.NumFiles"), ElanLocale.getString("Statistics.NumTiers"), ElanLocale.getString("Statistics.NumAnnotations"), ElanLocale.getString("Statistics.MinimalDuration"), ElanLocale.getString("Statistics.MaximalDuration"), ElanLocale.getString("Statistics.AverageDuration"), ElanLocale.getString("Statistics.MedianDuration"), ElanLocale.getString("Statistics.TotalDuration"), ElanLocale.getString("Statistics.Latency")};
        this.tableHeaders.put(4, (String[])headers);
        JTable annotTable = new JTable(new DefaultTableModel(headers, 0));
        annotTable.setEnabled(false);
        annotTable.getTableHeader().addMouseMotionListener(new TableHeaderToolTipAdapter(annotTable.getTableHeader()));
        this.tabTables.put(id, annotTable);
        this.tabPane.addTab(id, new JScrollPane(annotTable));
        id = ElanLocale.getString("Statistics.Panel.Language");
        this.tabTitles.put(5, id);
        headers = new String[]{ElanLocale.getString("MFE.TierHeader.Language"), ElanLocale.getString("Statistics.NumFiles"), ElanLocale.getString("Statistics.NumTiers"), ElanLocale.getString("Statistics.NumAnnotations"), ElanLocale.getString("Statistics.MinimalDuration"), ElanLocale.getString("Statistics.MaximalDuration"), ElanLocale.getString("Statistics.AverageDuration"), ElanLocale.getString("Statistics.MedianDuration"), ElanLocale.getString("Statistics.TotalDuration"), ElanLocale.getString("Statistics.Latency")};
        this.tableHeaders.put(5, (String[])headers);
        JTable langTable = new JTable(new DefaultTableModel(headers, 0));
        langTable.setEnabled(false);
        langTable.getTableHeader().addMouseMotionListener(new TableHeaderToolTipAdapter(langTable.getTableHeader()));
        this.tabTables.put(id, langTable);
        this.tabPane.addTab(id, new JScrollPane(langTable));
    }

    private void updateTableTabs() {
        if (this.curStatsCollection != null) {
            List<String[]> annStats = this.curStatsCollection.getAllAnnotationStatistics();
            JTable annTable = this.tabTables.get(this.tabTitles.get(0));
            Object[] headers = this.tableHeaders.get(0);
            DefaultTableModel model = new DefaultTableModel(0, headers.length);
            for (Object[] objectArray : annStats) {
                model.addRow(objectArray);
            }
            model.setColumnIdentifiers(headers);
            annTable.setModel(model);
            this.addRowSorterAttributeTable(annTable, 2, 3);
            List<String[]> tierStats = this.curStatsCollection.getTierStatistics();
            JTable jTable = this.tabTables.get(this.tabTitles.get(1));
            headers = this.tableHeaders.get(1);
            DefaultTableModel tmodel = new DefaultTableModel(0, headers.length);
            for (Object[] objectArray : tierStats) {
                tmodel.addRow(objectArray);
            }
            tmodel.setColumnIdentifiers(headers);
            jTable.setModel(tmodel);
            this.addRowSorterAttributeTable(jTable, 1, 3);
            List<String[]> typeStats = this.curStatsCollection.getTypeStatistics();
            JTable jTable2 = this.tabTables.get(this.tabTitles.get(2));
            headers = this.tableHeaders.get(2);
            DefaultTableModel typemodel = new DefaultTableModel(0, headers.length);
            for (Object[] objectArray : typeStats) {
                typemodel.addRow(objectArray);
            }
            typemodel.setColumnIdentifiers(headers);
            jTable2.setModel(typemodel);
            this.addRowSorterAttributeTable(jTable2, 1, 4);
            List<String[]> partStats = this.curStatsCollection.getPartStatistics();
            JTable jTable3 = this.tabTables.get(this.tabTitles.get(3));
            headers = this.tableHeaders.get(3);
            DefaultTableModel partModel = new DefaultTableModel(0, headers.length);
            for (Object[] objectArray : partStats) {
                partModel.addRow(objectArray);
            }
            partModel.setColumnIdentifiers(headers);
            jTable3.setModel(partModel);
            this.addRowSorterAttributeTable(jTable3, 1, 4);
            List<String[]> annotatorStats = this.curStatsCollection.getAnnotatorStatistics();
            JTable jTable4 = this.tabTables.get(this.tabTitles.get(4));
            headers = this.tableHeaders.get(4);
            DefaultTableModel annotatorModel = new DefaultTableModel(0, headers.length);
            for (Object[] objectArray : annotatorStats) {
                annotatorModel.addRow(objectArray);
            }
            annotatorModel.setColumnIdentifiers(headers);
            jTable4.setModel(annotatorModel);
            this.addRowSorterAttributeTable(jTable4, 1, 4);
            List<String[]> langStats = this.curStatsCollection.getLanguageStatistics();
            JTable jTable5 = this.tabTables.get(this.tabTitles.get(5));
            headers = this.tableHeaders.get(5);
            DefaultTableModel langModel = new DefaultTableModel(0, headers.length);
            for (Object[] objectArray : langStats) {
                langModel.addRow(objectArray);
            }
            langModel.setColumnIdentifiers(headers);
            jTable5.setModel(langModel);
            this.addRowSorterAttributeTable(jTable5, 1, 4);
        }
    }

    private void addRowSorterAttributeTable(JTable table, int firstIntCol, int firstFloatCol) {
        TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>(table.getModel());
        IntStringComparator intComp = new IntStringComparator();
        for (int i = firstIntCol; i < firstFloatCol; ++i) {
            rowSorter.setComparator(i, intComp);
        }
        FloatStringComparator fsComp = new FloatStringComparator();
        for (int i = firstFloatCol; i < table.getColumnCount(); ++i) {
            rowSorter.setComparator(i, fsComp);
        }
        table.setRowSorter(rowSorter);
    }

    protected void addFiles(File dir, List<String> files) {
        if (dir == null && files == null) {
            return;
        }
        File[] allSubs = dir.listFiles();
        for (int i = 0; i < allSubs.length; ++i) {
            if (allSubs[i].isDirectory() && allSubs[i].canRead()) {
                this.addFiles(allSubs[i], files);
                continue;
            }
            if (!allSubs[i].canRead() || !allSubs[i].getName().toLowerCase().endsWith(FileExtension.EAF_EXT[0])) continue;
            files.add(allSubs[i].getAbsolutePath());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SelectableContentTableModel model;
        JButton sender = (JButton)e.getSource();
        if (sender == this.saveButton) {
            int col = this.tabPane.getSelectedIndex();
            JTable curTable = this.tabTables.get(this.tabTitles.get(col));
            if (curTable.getRowCount() == 0) {
                return;
            }
            new ExportStatistics((Frame)((JFrame)this.getParent()), true, null, curTable);
            return;
        }
        if (sender == this.closeButton) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        if (sender == this.selectDomainButton) {
            MFDomainDialog domainDialog = new MFDomainDialog((Dialog)this, true);
            domainDialog.setVisible(true);
            List<String> searchPaths = domainDialog.getSearchPaths();
            List<String> searchDirs = domainDialog.getSearchDirs();
            this.fileNames = searchPaths;
            if (searchDirs.size() > 0) {
                for (int i = 0; i < searchDirs.size(); ++i) {
                    String name = searchDirs.get(i);
                    File f = new File(name);
                    if (f.isFile() && f.canRead()) {
                        this.fileNames.add(f.getAbsolutePath());
                        continue;
                    }
                    if (!f.isDirectory() || !f.canRead()) continue;
                    this.addFiles(f, this.fileNames);
                }
            }
            if (!this.fileNames.isEmpty()) {
                OpenFilesThread t = new OpenFilesThread(this.fileNames);
                t.start();
            }
        }
        if (sender == this.selectFilesButton) {
            List<String> filenames = this.showMultiFileChooser();
            if (filenames != null && !filenames.isEmpty()) {
                this.fileNames = filenames;
                OpenFilesThread t = new OpenFilesThread(filenames);
                t.start();
            }
            return;
        }
        if (sender == this.selectAllButton) {
            if (this.tierTable.getModel() instanceof SelectableContentTableModel) {
                model = (SelectableContentTableModel)this.tierTable.getModel();
                model.selectAll();
            }
            return;
        }
        if (sender == this.selectNoneButton) {
            if (this.tierTable.getModel() instanceof SelectableContentTableModel) {
                model = (SelectableContentTableModel)this.tierTable.getModel();
                model.selectNone();
            }
            return;
        }
        if (sender == this.updateStatisticsButton) {
            model = (SelectableContentTableModel)this.tierTable.getModel();
            List<Object> selectedTiersList = model.getSelectedValues();
            if (selectedTiersList.size() == 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("Statistics.Multi.NoTierSelected"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            String[] selectedTiers = selectedTiersList.toArray(new String[0]);
            String[] filePaths = this.fileNames.toArray(new String[0]);
            this.curCommand = new MultipleFileStatisticsCommand("Multiple File Statistics");
            this.curCommand.addProgressListener(this);
            this.curCommand.setProcessReport(new SimpleReport(ElanLocale.getString("ProcessReport")));
            this.curStatsCollection = new StatisticsCollectionMF();
            boolean loadAll = selectedTiers.length == model.getRowCount();
            this.curCommand.execute(null, new Object[]{filePaths, selectedTiers, loadAll, this.curStatsCollection});
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selectedRow;
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (e.getValueIsAdjusting() && (selectedRow = lsm.getMinSelectionIndex()) >= 0) {
            this.tierTable.setValueAt((Boolean)this.tierTable.getValueAt(selectedRow, 0) == false, selectedRow, 0);
        }
    }

    @Override
    public void progressCompleted(Object source, String message) {
        this.progressBar.setValue(100);
        this.progressBar.setString(message);
        this.updateTableTabs();
        if (this.curCommand != null && this.curCommand.getProcessReport() != null) {
            new ReportDialog((Dialog)this, this.curCommand.getProcessReport()).setVisible(true);
        }
        this.progressBar.setValue(0);
        this.progressBar.setString("");
    }

    @Override
    public void progressInterrupted(Object source, String message) {
        this.progressBar.setString(message);
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
        if (this.curCommand != null && this.curCommand.getProcessReport() != null) {
            new ReportDialog((Dialog)this, this.curCommand.getProcessReport()).setVisible(true);
        }
    }

    @Override
    public void progressUpdated(Object source, int percent, String message) {
        if (percent == this.progressBar.getMaximum()) {
            this.progressCompleted(source, message);
        } else {
            this.progressBar.setValue(percent);
            this.progressBar.setString(message);
        }
    }

    private List<String> showMultiFileChooser() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowMultiFileDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, FileExtension.EAF_EXT, "LastUsedEAFDir");
        ArrayList<CallSite> fileNames = null;
        Object[] objects = chooser.getSelectedFiles();
        if (objects != null && objects.length > 0) {
            fileNames = new ArrayList<CallSite>();
            for (int i = 0; i < objects.length; ++i) {
                if (fileNames.contains(objects[i])) continue;
                fileNames.add((CallSite)((Object)("" + objects[i])));
            }
        }
        return fileNames;
    }

    private class OpenFilesThread
    extends Thread {
        List<String> filenames;
        DisplayableContentTableModel model;

        public OpenFilesThread(List<String> filenames) {
            this.filenames = filenames;
            this.model = new DisplayableContentTableModel(new String[]{"Busy with Opening Files. Please wait...", "0 out of " + filenames.size() + " opened (0%)"});
            this.model.connectTable(StatisticsMultipleFilesDialog.this.tierTable);
            StatisticsMultipleFilesDialog.this.tierTable.setModel(this.model);
            StatisticsMultipleFilesDialog.this.tierTable.getColumnModel().getColumn(0).setHeaderValue(TIER_SELECTION_TABLE_HEADER);
            StatisticsMultipleFilesDialog.this.progressBar.setString("Extracting tiers...");
        }

        @Override
        public void run() {
            TreeSet<String> uniqueTierNames = new TreeSet<String>();
            ArrayList<String> failed = new ArrayList<String>();
            for (int i = 0; i < this.filenames.size(); ++i) {
                try {
                    EAFSkeletonParser parser = new EAFSkeletonParser(this.filenames.get(i));
                    parser.parse();
                    List<TierImpl> tiers = parser.getTiers();
                    for (int j = 0; j < tiers.size(); ++j) {
                        TierImpl tier = tiers.get(j);
                        if (tier == null) continue;
                        uniqueTierNames.add(tier.getName());
                    }
                }
                catch (ParseException pe) {
                    ClientLogger.LOG.warning("Parsing failed: " + pe.getMessage());
                    failed.add((String)StatisticsMultipleFilesDialog.this.fileNames.get(i));
                }
                StatisticsMultipleFilesDialog.this.progressBar.setValue(Math.round((float)(i + 1) / (float)this.filenames.size() * 100.0f));
                this.model.updateMessage(1, i + 1 + " out of " + this.filenames.size() + " opened (" + Math.round((float)(i + 1) / (float)this.filenames.size() * 100.0f) + "%)");
            }
            if (failed.size() > 0) {
                SimpleReport report = new SimpleReport(ElanLocale.getString("Message.Warning"));
                report.append("A number of files could not be parsed: " + failed.size());
                for (String s : failed) {
                    this.filenames.remove(s);
                    report.append(s);
                }
                new ReportDialog((Dialog)StatisticsMultipleFilesDialog.this, (ProcessReport)report).setVisible(true);
            }
            if (uniqueTierNames.isEmpty()) {
                StatisticsMultipleFilesDialog.this.transImplList.clear();
                StatisticsMultipleFilesDialog.this.fileNames.clear();
                DisplayableContentTableModel model = (DisplayableContentTableModel)StatisticsMultipleFilesDialog.this.tierTable.getModel();
                model.setValueAt(DEFAULT_TABLE_MESSAGE, 0, 0);
                StatisticsMultipleFilesDialog.this.updateStatisticsButton.setEnabled(false);
                StatisticsMultipleFilesDialog.this.selectAllButton.setEnabled(false);
                StatisticsMultipleFilesDialog.this.selectNoneButton.setEnabled(false);
            } else {
                StatisticsMultipleFilesDialog.this.tierTable.setModel(new SelectableContentTableModel(uniqueTierNames));
                StatisticsMultipleFilesDialog.this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
                StatisticsMultipleFilesDialog.this.tierTable.getColumnModel().getColumn(0).setHeaderValue("");
                StatisticsMultipleFilesDialog.this.tierTable.getColumnModel().getColumn(1).setHeaderValue(TIER_SELECTION_TABLE_HEADER);
                StatisticsMultipleFilesDialog.this.tierTable.repaint();
                StatisticsMultipleFilesDialog.this.updateStatisticsButton.setEnabled(true);
                StatisticsMultipleFilesDialog.this.selectAllButton.setEnabled(true);
                StatisticsMultipleFilesDialog.this.selectNoneButton.setEnabled(true);
            }
            TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>(StatisticsMultipleFilesDialog.this.tierTable.getModel());
            EmptyStringComparator emptyComp = new EmptyStringComparator();
            rowSorter.setComparator(1, emptyComp);
            StatisticsMultipleFilesDialog.this.tierTable.setRowSorter(rowSorter);
            StatisticsMultipleFilesDialog.this.progressBar.setValue(0);
            StatisticsMultipleFilesDialog.this.progressBar.setString("");
        }
    }
}

