/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.AbstractStatisticsPanel;
import mpi.eudico.client.util.TableHeaderToolTipAdapter;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.FloatStringComparator;
import mpi.eudico.util.IntStringComparator;

public class TierAttributeStatisticsPanel
extends AbstractStatisticsPanel {
    protected Set<String> tierAttribute;
    protected String attributeHeaderString;
    protected TierImpl.ValueGetter valueGetter;

    public TierAttributeStatisticsPanel(TranscriptionImpl transcription) {
        super(transcription);
    }

    public TierAttributeStatisticsPanel(TranscriptionImpl transcription, long duration) {
        super(transcription, duration);
    }

    public TierAttributeStatisticsPanel(TranscriptionImpl transcription, long duration, String attributeHeaderString, TierImpl.ValueGetter valueGetter) {
        super(transcription, duration);
        this.attributeHeaderString = attributeHeaderString;
        this.valueGetter = valueGetter;
        this.initComponents();
    }

    @Override
    public JTable getStatisticsTable() {
        return this.statTable;
    }

    @Override
    void initComponents() {
        this.statPanel = new JPanel();
        this.statTable = new JTable();
        this.statTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        this.statTable.setEnabled(false);
        this.initTable();
        this.statPane = new JScrollPane(this.statTable);
        Dimension size = new Dimension(600, 100);
        this.statPane.setPreferredSize(size);
        this.updateLocale();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.statPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.statPanel.add((Component)this.statPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.statPanel, gridBagConstraints);
    }

    public void updateLocale() {
        this.statPanel.setBorder(new TitledBorder(ElanLocale.getString("Statistics.Pane.Table")));
    }

    protected void initTable() {
        if (this.transcription != null) {
            this.tierAttribute = new HashSet<String>();
            this.extractAttributeValues();
            int numRows = this.tierAttribute.size();
            int numCols = 10;
            Object[][] data = new String[numRows][numCols];
            Object[] headers = new String[]{ElanLocale.getString(this.attributeHeaderString), ElanLocale.getString("Statistics.NumTiers"), ElanLocale.getString("Statistics.NumAnnotations"), ElanLocale.getString("Statistics.MinimalDuration"), ElanLocale.getString("Statistics.MaximalDuration"), ElanLocale.getString("Statistics.AverageDuration"), ElanLocale.getString("Statistics.MedianDuration"), ElanLocale.getString("Statistics.TotalDuration"), ElanLocale.getString("Statistics.TotalDurationPercentage"), ElanLocale.getString("Statistics.Latency")};
            this.fillTable(numRows, (String[][])data);
            DefaultTableModel model = new DefaultTableModel(data, headers);
            this.statTable.setModel(model);
            this.statTable.getTableHeader().addMouseMotionListener(new TableHeaderToolTipAdapter(this.statTable.getTableHeader()));
            TableRowSorter<DefaultTableModel> rowSorter = new TableRowSorter<DefaultTableModel>(model);
            IntStringComparator intComp = new IntStringComparator();
            rowSorter.setComparator(1, intComp);
            rowSorter.setComparator(2, intComp);
            FloatStringComparator fsComp = new FloatStringComparator();
            for (int i = 3; i < numCols; ++i) {
                rowSorter.setComparator(i, fsComp);
            }
            this.statTable.setRowSorter(rowSorter);
        }
    }

    protected void extractAttributeValues() {
        if (this.transcription != null && this.valueGetter != null) {
            if (this.tierAttribute == null) {
                this.tierAttribute = new HashSet<String>();
            }
            List<TierImpl> tiers = this.transcription.getTiers();
            for (TierImpl tier : tiers) {
                this.tierAttribute.add(this.valueGetter.getSortValue(tier));
            }
        }
    }

    protected void fillTable(int numRows, String[][] data) {
        if (this.valueGetter == null) {
            return;
        }
        int y = 0;
        for (String curAttr : this.tierAttribute) {
            ArrayList<TierImpl> tiersWithCurAttr = new ArrayList<TierImpl>();
            for (TierImpl tier : this.transcription.getTiers()) {
                if (!curAttr.equals(this.valueGetter.getSortValue(tier))) continue;
                tiersWithCurAttr.add(tier);
            }
            data[y][0] = curAttr.length() == 0 ? "-" : curAttr;
            data[y][1] = Integer.toString(tiersWithCurAttr.size());
            Integer nrAnnotations = 0;
            ArrayList<Long> durationList = new ArrayList<Long>(nrAnnotations);
            long timeAnnotated = 0L;
            long maxDuration = 0L;
            long minDuration = Long.MAX_VALUE;
            ArrayList<Long> beginTimes = new ArrayList<Long>(nrAnnotations);
            for (TierImpl tier : tiersWithCurAttr) {
                nrAnnotations = nrAnnotations + tier.getNumberOfAnnotations();
                List<AbstractAnnotation> annotations = tier.getAnnotations();
                for (AbstractAnnotation annotation : annotations) {
                    long begin = annotation.getBeginTimeBoundary();
                    long end = annotation.getEndTimeBoundary();
                    long duration = end - begin;
                    durationList.add(new Long(duration));
                    timeAnnotated += duration;
                    maxDuration = maxDuration < duration ? duration : maxDuration;
                    minDuration = minDuration > duration ? duration : minDuration;
                    beginTimes.add(new Long(begin));
                }
            }
            if (nrAnnotations == 0) {
                data[y][2] = "-";
                data[y][3] = "-";
                data[y][4] = "-";
                data[y][5] = "-";
                data[y][6] = "-";
                data[y][7] = "-";
                data[y][8] = "-";
                data[y][9] = "-";
            } else {
                data[y][2] = nrAnnotations.toString();
                data[y][3] = this.format2.format((float)minDuration / 1000.0f);
                data[y][4] = this.format2.format((float)maxDuration / 1000.0f);
                data[y][5] = this.format2.format((float)(timeAnnotated / (long)nrAnnotations.intValue()) / 1000.0f);
                Collections.sort(durationList);
                int numDurs = durationList.size();
                long medianDur = 0L;
                if (numDurs == 1) {
                    medianDur = (Long)durationList.get(0);
                } else if (numDurs % 2 != 0) {
                    medianDur = (Long)durationList.get(numDurs / 2);
                } else {
                    long h = (Long)durationList.get(numDurs / 2);
                    long l = (Long)durationList.get(numDurs / 2 - 1);
                    medianDur = (h + l) / 2L;
                }
                data[y][6] = this.format2.format((float)medianDur / 1000.0f);
                data[y][7] = this.format2.format((float)timeAnnotated / 1000.0f);
                data[y][8] = this.totalDuration == 0L ? "-" : this.format2.format((float)timeAnnotated / (float)(this.totalDuration * (long)tiersWithCurAttr.size()) * 100.0f);
                if (beginTimes.size() > 0) {
                    Collections.sort(beginTimes);
                    data[y][9] = this.format2.format((float)((Long)beginTimes.get(0)).longValue() / 1000.0f);
                } else {
                    data[y][9] = "-";
                }
            }
            ++y;
        }
    }
}

