/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.AbstractTwoTierOpDialog;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class TokenizeDialog
extends AbstractTwoTierOpDialog
implements ActionListener,
ItemListener,
ChangeListener {
    private JRadioButton customDelimRB;
    private JLabel tokenDelimLabel;
    private JLabel customTokenLabel;
    private JPanel extraOptionsPanel;
    private JRadioButton defaultDelimRB;
    private JTextField customDelimField;
    private JTextField customTokenField;
    private ButtonGroup delimButtonGroup;
    private JLabel warningLabel;
    private final char[] DEF_DELIMS = new char[]{'\t', '\n', '\r', '\f'};

    public TokenizeDialog(Transcription transcription) {
        super(transcription);
        this.initOptionsPanel();
        this.updateLocale();
        this.loadPreferences();
        this.postInit();
    }

    @Override
    protected void extractDestinationTiers() {
        this.destTierComboBox.removeAllItems();
        this.destTierComboBox.addItem("-");
        if (this.sourceTierComboBox.getSelectedItem() != null && this.sourceTierComboBox.getSelectedItem() != "-") {
            String name = (String)this.sourceTierComboBox.getSelectedItem();
            TierImpl source = this.transcription.getTierWithId(name);
            List<TierImpl> tiers = this.transcription.getTiers();
            for (TierImpl dest : tiers) {
                LinguisticType lt = dest.getLinguisticType();
                if ((dest.hasParentTier() || this.isParentOf(dest, source)) && (dest.getParentTier() != source || lt.getConstraints().getStereoType() == 4)) continue;
                this.destTierComboBox.addItem(dest.getName());
            }
            if (this.destTierComboBox.getItemCount() > 1) {
                this.destTierComboBox.removeItem("-");
            }
        }
    }

    private boolean isParentOf(Tier parent, TierImpl child) {
        while ((child = child.getParentTier()) != null) {
            if (child != parent) continue;
            return true;
        }
        return false;
    }

    private boolean hasChildren(String parentName) {
        if (parentName == null) {
            return false;
        }
        TierImpl parent = this.transcription.getTierWithId(parentName);
        if (parent == null) {
            return false;
        }
        for (TierImpl t : this.transcription.getTiers()) {
            if (t.getParentTier() != parent) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void startOperation() {
        String customTokens;
        String sourceName = (String)this.sourceTierComboBox.getSelectedItem();
        String destName = (String)this.destTierComboBox.getSelectedItem();
        String delimsText = null;
        boolean preserveExisting = this.preserveRB.isSelected();
        boolean createEmptyAnnotations = this.emptyAnnCheckBox.isSelected();
        if (sourceName == "-" || destName == "-") {
            this.showWarningDialog(ElanLocale.getString("TokenizeDialog.Message.InvalidTiers"));
            return;
        }
        if (this.customDelimRB.isSelected()) {
            delimsText = this.customDelimField.getText();
            if (delimsText == null || delimsText.length() == 0) {
                this.showWarningDialog(ElanLocale.getString("TokenizeDialog.Message.NoDelimiter"));
                return;
            }
            delimsText = this.checkDelimiters(delimsText);
        }
        if ((customTokens = this.customTokenField.getText()).isEmpty()) {
            customTokens = null;
        }
        this.storePreferences();
        Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.Tokenize");
        Object[] args = new Object[]{sourceName, destName, delimsText, preserveExisting, createEmptyAnnotations, customTokens};
        com.execute(this.transcription, args);
    }

    private String checkDelimiters(String delim) {
        StringBuilder buffer = new StringBuilder(delim);
        for (char element : this.DEF_DELIMS) {
            if (delim.indexOf(element) >= 0) continue;
            buffer.append(element);
        }
        return buffer.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.destTierComboBox) {
            Object selectedItem = this.destTierComboBox.getSelectedItem();
            boolean warn = this.hasChildren((String)selectedItem);
            this.warningLabel.setVisible(warn);
        }
        super.actionPerformed(e);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.destTierComboBox.addActionListener(this);
        this.warningLabel = new JLabel();
        this.warningLabel.setForeground(Color.RED);
        this.warningLabel.setVisible(false);
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.tierSelectionPanel.add((Component)this.warningLabel, gridBagConstraints);
    }

    protected void initOptionsPanel() {
        this.extraOptionsPanel = new JPanel();
        this.delimButtonGroup = new ButtonGroup();
        this.tokenDelimLabel = new JLabel();
        this.customTokenLabel = new JLabel();
        this.defaultDelimRB = new JRadioButton();
        this.customDelimRB = new JRadioButton();
        this.customDelimField = new JTextField();
        this.customTokenField = new JTextField();
        Insets insets = new Insets(2, 0, 2, 6);
        this.extraOptionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)this.tokenDelimLabel, gridBagConstraints);
        this.defaultDelimRB.setSelected(true);
        this.defaultDelimRB.addChangeListener(this);
        this.delimButtonGroup.add(this.defaultDelimRB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)this.defaultDelimRB, gridBagConstraints);
        this.customDelimRB.addChangeListener(this);
        this.delimButtonGroup.add(this.customDelimRB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)this.customDelimRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)this.customTokenLabel, gridBagConstraints);
        this.customDelimField.setEnabled(false);
        this.customDelimField.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)this.customDelimField, gridBagConstraints);
        this.customTokenField.setEnabled(true);
        this.customTokenField.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)this.customTokenField, gridBagConstraints);
        this.addOptionsPanel(this.extraOptionsPanel);
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("TokenizeDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("TokenizeDialog.Title"));
        this.tokenDelimLabel.setText(ElanLocale.getString("TokenizeDialog.Label.TokenDelimiter"));
        this.defaultDelimRB.setText(ElanLocale.getString("TokenizeDialog.RadioButton.Default"));
        this.customDelimRB.setText(ElanLocale.getString("TokenizeDialog.RadioButton.Custom"));
        this.customTokenLabel.setText(ElanLocale.getString("TokenizeDialog.Label.CustomTokens"));
        this.warningLabel.setText(ElanLocale.getString("TokenizeDialog.Label.WarnEraseChildren"));
    }

    private void storePreferences() {
        Preferences.set("TokenizeDialog.SourceTier", this.sourceTierComboBox.getSelectedItem(), this.transcription, false, false);
        Preferences.set("TokenizeDialog.DestTier", this.destTierComboBox.getSelectedItem(), this.transcription, false, false);
        Preferences.set("TokenizeDialog.DefaultDelimiter", this.defaultDelimRB.isSelected(), null, false, false);
        Preferences.set("TokenizeDialog.CustomDelimiter", this.customDelimField.getText(), null, false, false);
        Preferences.set("TokenizeDialog.CustomTokens", this.customTokenField.getText(), null, false, false);
        Preferences.set("TokenizeDialog.Overwrite", this.overwriteRB.isSelected(), null, false, false);
        Preferences.set("TokenizeDialog.ProcessEmptyAnnotations", this.emptyAnnCheckBox.isSelected(), null, false, false);
    }

    private void loadPreferences() {
        boolean defde;
        Boolean boolPref;
        String stringPref = Preferences.getString("TokenizeDialog.SourceTier", this.transcription);
        if (stringPref != null) {
            this.sourceTierComboBox.setSelectedItem(stringPref);
        }
        if ((stringPref = Preferences.getString("TokenizeDialog.DestTier", this.transcription)) != null) {
            this.destTierComboBox.setSelectedItem(stringPref);
        }
        if ((boolPref = Preferences.getBool("TokenizeDialog.DefaultDelimiter", null)) != null && !(defde = boolPref.booleanValue())) {
            this.customDelimRB.setSelected(true);
            stringPref = Preferences.getString("TokenizeDialog.CustomDelimiter", null);
            if (stringPref != null) {
                this.customDelimField.setText(stringPref);
            }
        }
        if ((stringPref = Preferences.getString("TokenizeDialog.CustomTokens", null)) != null) {
            this.customTokenField.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("TokenizeDialog.Overwrite", null)) != null) {
            boolean overwr = boolPref;
            if (overwr) {
                this.overwriteRB.setSelected(true);
            } else {
                this.preserveRB.setSelected(true);
            }
        }
        if ((boolPref = Preferences.getBool("TokenizeDialog.ProcessEmptyAnnotations", null)) != null) {
            this.emptyAnnCheckBox.setSelected(boolPref);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (this.defaultDelimRB.isSelected()) {
            this.customDelimField.setEnabled(false);
        } else {
            this.customDelimField.setEnabled(true);
            this.customDelimField.requestFocus();
        }
    }

    @Override
    protected void closeDialog(WindowEvent evt) {
        this.storePreferences();
        super.closeDialog(evt);
    }
}

