/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.TierTree;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.ControlledVocabulary;

public class TranscriptionCopier
implements ClientLogger {
    public void copyTranscription(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        this.copyHeader(src, dest);
        this.copyMediaDescriptors(src, dest);
        this.copyLinkedFileDescriptors(src, dest);
        this.copyControlledVocabularies(src, dest);
        this.copyLinguisticTypes(src, dest);
        this.copyTiers(src, dest);
        this.copyAnnotations(src, dest);
    }

    public void copyHeader(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        dest.setAuthor(src.getAuthor());
    }

    public void copyMediaDescriptors(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        List<MediaDescriptor> mediaDescs = src.getMediaDescriptors();
        ArrayList<MediaDescriptor> copyDesc = new ArrayList<MediaDescriptor>(mediaDescs.size());
        for (int i = 0; i < mediaDescs.size(); ++i) {
            MediaDescriptor srcMd = mediaDescs.get(i);
            MediaDescriptor copyMd = (MediaDescriptor)srcMd.clone();
            copyDesc.add(copyMd);
        }
        dest.setMediaDescriptors(copyDesc);
    }

    public void copyLinkedFileDescriptors(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        List<LinkedFileDescriptor> linkedfileDescs = src.getLinkedFileDescriptors();
        ArrayList<LinkedFileDescriptor> copyDesc = new ArrayList<LinkedFileDescriptor>(linkedfileDescs.size());
        for (int i = 0; i < linkedfileDescs.size(); ++i) {
            LinkedFileDescriptor srcFileDesc = linkedfileDescs.get(i);
            LinkedFileDescriptor copyFileDesc = (LinkedFileDescriptor)srcFileDesc.clone();
            copyDesc.add(copyFileDesc);
        }
        dest.setLinkedFileDescriptors(copyDesc);
    }

    public void copyControlledVocabularies(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        List<ControlledVocabulary> srcCVS = src.getControlledVocabularies();
        ArrayList<ControlledVocabulary> copyCVS = new ArrayList<ControlledVocabulary>(srcCVS.size());
        for (ControlledVocabulary cv : srcCVS) {
            ControlledVocabulary cpCV = cv.clone();
            copyCVS.add(cpCV);
        }
        dest.setControlledVocabularies(copyCVS);
    }

    public void copyLinguisticTypes(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        List<LinguisticType> srcTypes = src.getLinguisticTypes();
        ArrayList<LinguisticType> destTypes = new ArrayList<LinguisticType>(srcTypes.size());
        for (int i = 0; i < srcTypes.size(); ++i) {
            LinguisticType srcLt = srcTypes.get(i);
            LinguisticType cpLt = new LinguisticType(srcLt.getLinguisticTypeName());
            cpLt.setControlledVocabularyName(srcLt.getControlledVocabularyName());
            cpLt.setTimeAlignable(srcLt.isTimeAlignable());
            cpLt.addConstraint(srcLt.getConstraints());
            destTypes.add(cpLt);
        }
        dest.setLinguisticTypes(destTypes);
    }

    public void copyTiers(TranscriptionImpl src, TranscriptionImpl dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        String parentName = null;
        String typeName = null;
        List<LinguisticType> destTypes = dest.getLinguisticTypes();
        TierTree tierTree = new TierTree(src);
        DefaultMutableTreeNode root = tierTree.getTree();
        Enumeration<TreeNode> ten = root.breadthFirstEnumeration();
        ten.nextElement();
        while (ten.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ten.nextElement();
            Object next = node.getUserObject();
            if (next instanceof String) {
                TierImpl srcTier = src.getTierWithId((String)next);
                if (srcTier == null) {
                    LOG.warning("A tier could not be found in the source transcription: " + next);
                    continue;
                }
                TierImpl parTier = srcTier.getParentTier();
                if (parTier != null) {
                    parentName = parTier.getName();
                }
                LinguisticType lt = srcTier.getLinguisticType();
                typeName = lt.getLinguisticTypeName();
                TierImpl cpTier = null;
                if (parTier == null) {
                    cpTier = new TierImpl(srcTier.getName(), srcTier.getParticipant(), dest, null);
                } else {
                    parTier = dest.getTierWithId(parentName);
                    if (parTier != null) {
                        cpTier = new TierImpl(parTier, srcTier.getName(), srcTier.getParticipant(), dest, null);
                    } else {
                        LOG.warning("The parent tier: " + parentName + " for tier: (null) was not found in the destination transcription");
                    }
                }
                if (cpTier == null) continue;
                LinguisticType destLt = null;
                for (int i = 0; i < destTypes.size(); ++i) {
                    lt = destTypes.get(i);
                    if (!lt.getLinguisticTypeName().equals(typeName)) continue;
                    destLt = lt;
                    break;
                }
                if (destLt != null) {
                    if (dest.getTierWithId(cpTier.getName()) == null) {
                        dest.addTier(cpTier);
                        LOG.info("Created and added tier to destination: " + cpTier.getName());
                    } else {
                        LOG.info("Could not add tier to destination: " + cpTier.getName() + " already exists in the transcription");
                    }
                    cpTier.setLinguisticType(destLt);
                } else {
                    LOG.warning("Could not add tier: " + cpTier.getName() + " because the Linguistic Type was not found in the destination transcription.");
                }
                cpTier.setDefaultLocale(srcTier.getDefaultLocale());
                cpTier.setAnnotator(srcTier.getAnnotator());
                cpTier.setLangRef(srcTier.getLangRef());
                continue;
            }
            LOG.warning("Unknown object in the tier tree.");
        }
    }

    public void copyAnnotations(TranscriptionImpl src, Transcription dest) {
        if (src == null) {
            throw new NullPointerException("Source transcription is null");
        }
        if (dest == null) {
            throw new NullPointerException("Destination transcription is null");
        }
        List<TierImpl> tiers = src.getTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            TierImpl srcTier = tiers.get(i);
            if (srcTier.hasParentTier()) continue;
            List<AlignableAnnotation> annos = srcTier.getAlignableAnnotations();
            int size = annos.size();
            for (int j = 0; j < size; ++j) {
                AlignableAnnotation aa = annos.get(j);
                DefaultMutableTreeNode annNode = AnnotationRecreator.createTreeForAnnotation(aa);
                AnnotationRecreator.createAnnotationFromTree(dest, annNode);
            }
        }
    }
}

