/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.multiplefiles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.imports.multiplefiles.AbstractMFImportStep4;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxDecoderInfo2;
import mpi.eudico.server.corpora.util.ServerLogger;

public class MFToolboxImportStep4
extends AbstractMFImportStep4 {
    private ToolboxDecoderInfo2 decoderInfo;
    private String typFileLinked;

    public MFToolboxImportStep4(MultiStepPane multiPane) {
        super(multiPane);
    }

    @Override
    public void enterStepForward() {
        this.decoderInfo = (ToolboxDecoderInfo2)this.multiPane.getStepProperty("ToolboxDecoderInfo");
        super.enterStepForward();
    }

    @Override
    protected boolean doImport(File sourceFile) {
        File impFile = sourceFile;
        if (impFile == null || !impFile.exists()) {
            ClientLogger.LOG.severe("Toolbox file not found :" + impFile.getAbsolutePath());
            this.report(ElanLocale.getString("MultiFileImport.Report.NoFile"));
            return false;
        }
        if (this.decoderInfo == null) {
            return false;
        }
        this.decoderInfo.setSourceFilePath(impFile.getAbsolutePath());
        this.parseFile(impFile);
        if (this.typFileLinked != null) {
            String typeFileName = FileUtility.fileNameFromPath(this.decoderInfo.getTypeFile());
            if (typeFileName != null && typeFileName.length() > 0) {
                int li = typeFileName.lastIndexOf(".");
                if (!(typeFileName = typeFileName.substring(0, li)).trim().equals(this.typFileLinked.trim())) {
                    this.report("Type file mismatch");
                    this.report("Type file used for import : " + typeFileName.trim());
                    this.report("Required type file : " + this.typFileLinked.trim());
                    this.report("The type file mentioned in the toolbox file is different from the type file selected for this import.");
                    this.report("If an eaf is imported, that might miss some details like tiers,dependency etc..");
                }
            } else if (this.decoderInfo.getShoeboxMarkers() == null || this.decoderInfo.getShoeboxMarkers().isEmpty()) {
                this.report("Neither a .typ file has been specified nor custom markers have been created. The import will probably fail.");
            }
        }
        try {
            this.transImpl = new TranscriptionImpl(impFile.getAbsolutePath(), this.decoderInfo);
        }
        catch (Exception e) {
            ClientLogger.LOG.warning(ElanLocale.getString("MultiFileImport.Report.ExceptionOccured : ") + e.getMessage());
            this.report(ElanLocale.getString("MultiFileImport.Report.ExceptionOccured : ") + e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(File toolboxFile) {
        BufferedReader bufRead = null;
        this.typFileLinked = null;
        try {
            InputStreamReader reader;
            if (this.decoderInfo.isAllUnicode()) {
                reader = new InputStreamReader((InputStream)new FileInputStream(toolboxFile), "UTF-8");
                bufRead = new BufferedReader(reader);
            } else {
                reader = new InputStreamReader((InputStream)new FileInputStream(toolboxFile), "ISO-8859-1");
                bufRead = new BufferedReader(reader);
            }
        }
        catch (FileNotFoundException fne) {
            ClientLogger.LOG.severe("Toolbox file not found :" + toolboxFile.getAbsolutePath());
            this.report(ElanLocale.getString("MultiFileImport.Report.NoFile"));
            return;
        }
        catch (UnsupportedEncodingException uee) {
            ClientLogger.LOG.severe("Encoding not supported");
            return;
        }
        String line = null;
        int lineCount = 0;
        try {
            while ((line = bufRead.readLine()) != null) {
                int lastSpaceIndex;
                line = line.trim();
                if (++lineCount <= 3 && (line.indexOf("\\_sh v4.0") > -1 || line.indexOf("\\_sh v3.0") > -1) && (lastSpaceIndex = line.trim().lastIndexOf(32)) > -1) {
                    this.typFileLinked = line.substring(lastSpaceIndex).trim();
                    ServerLogger.LOG.info("Database type in header: " + this.typFileLinked);
                } else {
                    if (lineCount <= 3) continue;
                    ClientLogger.LOG.severe("No Toolbox header found, no Toolbox file? :" + toolboxFile.getAbsolutePath());
                    this.report("No Toolbox header found, no Toolbox file?");
                }
                break;
            }
        }
        catch (IOException ioe) {
            ClientLogger.LOG.severe("Error reading file: " + ioe.getMessage());
            this.report("Error reading file: " + ioe.getMessage());
        }
        finally {
            try {
                if (bufRead != null) {
                    bufRead.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

