/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.praat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.praat.PraatSpecialChars;

public class PraatTextGrid {
    private final char brack = (char)91;
    private final String eq = "=";
    private final String item = "item";
    private final String cl = "class";
    private final String tierSpec = "IntervalTier";
    private final String textTierSpec = "TextTier";
    private final String nm = "name";
    private final String interval = "intervals";
    private final String min = "xmin";
    private final String max = "xmax";
    private final String tx = "text";
    private final String points = "points";
    private final String time = "time";
    private final String mark = "mark";
    private final String number = "number";
    private final String escapedInnerQuote = "\"\"";
    private final String escapedOuterQuote = "\"\"\"";
    private boolean includeTextTiers = false;
    private int pointDuration = 1;
    private String encoding;
    private File gridFile;
    private List<String> tierNames;
    private Map<String, List<AnnotationDataRecord>> annotationMap;
    private PraatSpecialChars lookUp;

    public PraatTextGrid(String fileName) throws IOException {
        this(fileName, false, 1);
    }

    public PraatTextGrid(String fileName, boolean includeTextTiers, int pointDuration) throws IOException {
        if (fileName != null) {
            this.gridFile = new File(fileName);
        }
        this.includeTextTiers = includeTextTiers;
        this.pointDuration = pointDuration;
        this.parse();
    }

    public PraatTextGrid(File gridFile) throws IOException {
        this(gridFile, false, 1);
    }

    public PraatTextGrid(File gridFile, boolean includeTextTiers, int pointDuration) throws IOException {
        this(gridFile, includeTextTiers, pointDuration, null);
    }

    public PraatTextGrid(File gridFile, boolean includeTextTiers, int pointDuration, String encoding) throws IOException {
        this.gridFile = gridFile;
        this.includeTextTiers = includeTextTiers;
        this.pointDuration = pointDuration;
        this.encoding = encoding;
        this.parse();
    }

    public List<String> getTierNames() {
        return this.tierNames;
    }

    public List<AnnotationDataRecord> getAnnotationRecords(String tierName) {
        if (tierName == null || this.annotationMap == null) {
            return null;
        }
        return this.annotationMap.get(tierName);
    }

    private boolean isShortNotation(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            return false;
        }
        int lineCount = 0;
        boolean xmin = false;
        boolean xmax = false;
        boolean tiers = false;
        while ((line = reader.readLine()) != null && lineCount < 5) {
            if (line.length() == 0) continue;
            if (lineCount == 2) {
                boolean bl = xmin = line.indexOf("xmin") > -1;
            }
            if (lineCount == 3) {
                boolean bl = xmax = line.indexOf("xmax") > -1;
            }
            if (lineCount == 4) {
                tiers = line.indexOf("tiers?") > -1;
            }
            ++lineCount;
        }
        return !xmin && !xmax && !tiers;
    }

    private void parse() throws IOException {
        if (this.gridFile == null || !this.gridFile.exists()) {
            ClientLogger.LOG.warning("No existing file specified.");
            throw new IOException("No existing file specified.");
        }
        try (BufferedReader reader = null;){
            String line;
            if (this.encoding == null) {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.gridFile)));
            } else {
                try {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.gridFile), this.encoding));
                }
                catch (UnsupportedEncodingException uee) {
                    ClientLogger.LOG.warning("Unsupported encoding: " + uee.getMessage());
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.gridFile)));
                }
            }
            ClientLogger.LOG.info("Read encoding: " + this.encoding);
            boolean isShortNotation = this.isShortNotation(reader);
            ClientLogger.LOG.info("Praat TextGrid is in short notation: " + isShortNotation);
            if (isShortNotation) {
                this.parseShortNotation(reader);
                return;
            }
            this.tierNames = new ArrayList<String>(4);
            this.annotationMap = new HashMap<String, List<AnnotationDataRecord>>(4);
            ArrayList<AnnotationDataRecord> records = new ArrayList<AnnotationDataRecord>();
            AnnotationDataRecord record = null;
            String tierName = null;
            String annValue = "";
            long begin = -1L;
            long end = -1L;
            boolean inTier = false;
            boolean inInterval = false;
            boolean inTextTier = false;
            boolean inPoints = false;
            int eqPos = -1;
            block9: while ((line = reader.readLine()) != null) {
                int count;
                Object nextName;
                if (line.indexOf("class") >= 0 && (line.indexOf("IntervalTier") > 5 || line.indexOf("TextTier") > 5)) {
                    if (line.indexOf("TextTier") > 5) {
                        if (this.includeTextTiers) {
                            inTextTier = true;
                        } else {
                            inTextTier = false;
                            inTier = false;
                            continue;
                        }
                    }
                    records = new ArrayList();
                    inTier = true;
                    continue;
                }
                if (!inTier) continue;
                eqPos = line.indexOf("=");
                if (inTextTier) {
                    if (eqPos > 0) {
                        if (!inPoints && line.indexOf("name") >= 0 && line.indexOf("name") < eqPos) {
                            tierName = this.extractTierName(line, eqPos);
                            if (!this.annotationMap.containsKey(tierName)) {
                                this.annotationMap.put(tierName, records);
                                this.tierNames.add(tierName);
                                ClientLogger.LOG.info("Point Tier detected: " + tierName);
                                continue;
                            }
                            nextName = "";
                            for (count = 2; count < 50; ++count) {
                                nextName = tierName + "-" + count;
                                if (this.annotationMap.containsKey(nextName)) continue;
                                this.annotationMap.put((String)nextName, records);
                                this.tierNames.add((String)nextName);
                                ClientLogger.LOG.info("Point Tier detected: " + tierName + " and renamed to: " + (String)nextName);
                                continue block9;
                            }
                            continue;
                        }
                        if (!inPoints) continue;
                        if (line.indexOf("time") > -1 || line.indexOf("number") > -1) {
                            begin = this.extractLong(line, eqPos);
                            continue;
                        }
                        if (line.indexOf("mark") <= -1) continue;
                        annValue = this.extractTextValue(line, eqPos);
                        inPoints = false;
                        record = new AnnotationDataRecord(tierName, annValue, begin, begin + (long)this.pointDuration);
                        records.add(record);
                        annValue = "";
                        begin = -1L;
                        continue;
                    }
                    if (line.indexOf("points") >= 0 && line.indexOf(91) > "points".length()) {
                        inPoints = true;
                        continue;
                    }
                    if (line.indexOf("item") < 0 || line.indexOf(91) <= "item".length()) continue;
                    inTextTier = false;
                    inPoints = false;
                    continue;
                }
                if (eqPos > 0) {
                    if (!inInterval && line.indexOf("name") >= 0 && line.indexOf("name") < eqPos) {
                        tierName = this.extractTierName(line, eqPos);
                        if (!this.annotationMap.containsKey(tierName)) {
                            this.annotationMap.put(tierName, records);
                            this.tierNames.add(tierName);
                            ClientLogger.LOG.info("Tier detected: " + tierName);
                            continue;
                        }
                        nextName = "";
                        for (count = 2; count < 50; ++count) {
                            nextName = tierName + "-" + count;
                            if (this.annotationMap.containsKey(nextName)) continue;
                            this.annotationMap.put((String)nextName, records);
                            this.tierNames.add((String)nextName);
                            ClientLogger.LOG.info("Tier detected: " + tierName + " and renamed to: " + (String)nextName);
                            continue block9;
                        }
                        continue;
                    }
                    if (!inInterval) continue;
                    if (line.indexOf("xmin") > -1) {
                        begin = this.extractLong(line, eqPos);
                        continue;
                    }
                    if (line.indexOf("xmax") > -1) {
                        end = this.extractLong(line, eqPos);
                        continue;
                    }
                    if (line.indexOf("text") <= -1) continue;
                    annValue = this.extractTextValue(line, eqPos);
                    inInterval = false;
                    record = new AnnotationDataRecord(tierName, annValue, begin, end);
                    records.add(record);
                    annValue = "";
                    begin = -1L;
                    end = -1L;
                    continue;
                }
                if (line.indexOf("intervals") >= 0 && line.indexOf(91) > "intervals".length()) {
                    inInterval = true;
                    continue;
                }
                if (line.indexOf("item") < 0 || line.indexOf(91) <= "item".length()) continue;
                inTier = false;
                inInterval = false;
            }
        }
    }

    private void parseShortNotation(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            throw new IOException("The reader object is null, cannot read from the file.");
        }
        this.tierNames = new ArrayList<String>(4);
        this.annotationMap = new HashMap<String, List<AnnotationDataRecord>>(4);
        ArrayList<AnnotationDataRecord> records = new ArrayList<AnnotationDataRecord>();
        AnnotationDataRecord record = null;
        String tierName = null;
        String annValue = "";
        long begin = -1L;
        long end = -1L;
        boolean inTextTier = false;
        boolean inTier = false;
        int eqPos = -1;
        SN_POSITION linePos = SN_POSITION.OUTSIDE;
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0) continue;
            if (line.indexOf("IntervalTier") > -1) {
                linePos = SN_POSITION.NEXT_IS_NAME;
                inTier = true;
                inTextTier = false;
                continue;
            }
            if (line.indexOf("TextTier") > -1) {
                linePos = SN_POSITION.NEXT_IS_NAME;
                inTier = false;
                inTextTier = true;
                continue;
            }
            if (linePos == SN_POSITION.NEXT_IS_NAME) {
                if (!inTier && !inTextTier) {
                    linePos = SN_POSITION.NEXT_IS_TOTAL_MIN;
                    continue;
                }
                if (inTier || inTextTier && this.includeTextTiers) {
                    tierName = this.removeQuotes(line);
                    if (tierName.length() == 0) {
                        tierName = "Noname";
                    }
                    records = new ArrayList();
                    if (!this.annotationMap.containsKey(tierName)) {
                        this.annotationMap.put(tierName, records);
                        this.tierNames.add(tierName);
                        if (inTextTier) {
                            ClientLogger.LOG.info("Point Tier detected: " + tierName);
                        } else {
                            ClientLogger.LOG.info("Interval Tier detected: " + tierName);
                        }
                    } else {
                        Object nextName = "";
                        for (int count = 2; count < 50; ++count) {
                            nextName = tierName + "-" + count;
                            if (this.annotationMap.containsKey(nextName)) continue;
                            this.annotationMap.put((String)nextName, records);
                            this.tierNames.add((String)nextName);
                            if (inTextTier) {
                                ClientLogger.LOG.info("Point Tier detected: " + tierName + " and renamed to: " + (String)nextName);
                                break;
                            }
                            ClientLogger.LOG.info("Interval Tier detected: " + tierName + " and renamed to: " + (String)nextName);
                            break;
                        }
                    }
                }
                linePos = SN_POSITION.NEXT_IS_TOTAL_MIN;
                continue;
            }
            if (linePos == SN_POSITION.NEXT_IS_TOTAL_MIN) {
                linePos = SN_POSITION.NEXT_IS_TOTAL_MAX;
                continue;
            }
            if (linePos == SN_POSITION.NEXT_IS_TOTAL_MAX) {
                linePos = SN_POSITION.NEXT_IS_SIZE;
                continue;
            }
            if (linePos == SN_POSITION.NEXT_IS_SIZE) {
                if (inTextTier) {
                    linePos = SN_POSITION.NEXT_IS_TIME;
                    continue;
                }
                linePos = SN_POSITION.NEXT_IS_MIN;
                continue;
            }
            if (linePos == SN_POSITION.NEXT_IS_TIME) {
                if (this.includeTextTiers) {
                    begin = this.extractLong(line, eqPos);
                }
                linePos = SN_POSITION.NEXT_IS_MARK;
                continue;
            }
            if (linePos == SN_POSITION.NEXT_IS_MARK) {
                if (this.includeTextTiers) {
                    annValue = this.extractTextValue(line, eqPos);
                    record = new AnnotationDataRecord(tierName, annValue, begin, begin + (long)this.pointDuration);
                    records.add(record);
                    annValue = "";
                    begin = -1L;
                }
                linePos = SN_POSITION.NEXT_IS_TIME;
                continue;
            }
            if (linePos == SN_POSITION.NEXT_IS_MIN) {
                begin = this.extractLong(line, eqPos);
                linePos = SN_POSITION.NEXT_IS_MAX;
                continue;
            }
            if (linePos == SN_POSITION.NEXT_IS_MAX) {
                end = this.extractLong(line, eqPos);
                linePos = SN_POSITION.NEXT_IS_TEXT;
                continue;
            }
            if (linePos != SN_POSITION.NEXT_IS_TEXT) continue;
            annValue = this.extractTextValue(line, eqPos);
            record = new AnnotationDataRecord(tierName, annValue, begin, end);
            records.add(record);
            annValue = "";
            begin = -1L;
            end = -1L;
            linePos = SN_POSITION.NEXT_IS_MIN;
        }
    }

    private String extractTierName(String line, int eqPos) {
        if (line.length() > eqPos + 1) {
            String name = line.substring(eqPos + 1).trim();
            if (name.length() < 3) {
                if ("\"\"".equals(name)) {
                    return "Noname";
                }
                return name;
            }
            return this.removeQuotes(name);
        }
        return line;
    }

    private String extractTextValue(String value, int eqPos) {
        if (value.length() > eqPos + 1) {
            String rawV = this.removeQuotes(value.substring(eqPos + 1).trim());
            if (this.lookUp == null) {
                this.lookUp = new PraatSpecialChars();
            }
            if ((rawV = this.lookUp.replaceIllegalXMLChars(rawV)).indexOf(92) > -1) {
                return this.lookUp.convertSpecialChars(rawV);
            }
            return rawV;
        }
        return "";
    }

    private long extractLong(String value, int eqPos) {
        if (value.length() > eqPos + 1) {
            String v = value.substring(eqPos + 1).trim();
            long l = -1L;
            try {
                Double d = new Double(v);
                l = Math.round(d * 1000.0);
            }
            catch (NumberFormatException nfe) {
                ClientLogger.LOG.warning("Not a valid numeric value: " + value);
            }
            return l;
        }
        return -1L;
    }

    private String removeQuotes(String value) {
        boolean removeOuterQuotes = true;
        if (value.startsWith("\"\"\"") && value.endsWith("\"\"\"")) {
            removeOuterQuotes = false;
        }
        value = value.replaceAll("\"\"\"", "\"");
        value = value.replaceAll("\"\"", "\"");
        if (removeOuterQuotes) {
            if (value.charAt(0) == '\"') {
                if (value.charAt(value.length() - 1) == '\"' && value.length() > 1) {
                    return value.substring(1, value.length() - 1);
                }
                return value.substring(1);
            }
            if (value.charAt(value.length() - 1) == '\"') {
                return value.substring(0, value.length() - 1);
            }
            return value;
        }
        return value;
    }

    private static enum SN_POSITION {
        OUTSIDE,
        NEXT_IS_NAME,
        NEXT_IS_MIN,
        NEXT_IS_MAX,
        NEXT_IS_TEXT,
        NEXT_IS_TIME,
        NEXT_IS_MARK,
        NEXT_IS_TOTAL_MIN,
        NEXT_IS_TOTAL_MAX,
        NEXT_IS_SIZE;

    }
}

