/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.AbstractCompareCommand;
import mpi.eudico.client.annotator.commands.CompareAnnotationModKappaCommand;
import mpi.eudico.client.annotator.commands.CompareAnnotationRatioMultiCommand;
import mpi.eudico.client.annotator.commands.CompareAnnotationStaccatoCommand;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.ProgressStepPane;
import mpi.eudico.client.annotator.interannotator.CompareCombi;
import mpi.eudico.client.annotator.interannotator.CompareConstants;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Transcription;

public class CompareProgressStep
extends ProgressStepPane
implements ActionListener {
    private Transcription transcription;
    private Map<Object, Object> allStepProperties;
    private AbstractCompareCommand comCommand;
    private JButton cancelProcessButton;

    public CompareProgressStep(MultiStepPane multiPane, Transcription transcription) {
        super(multiPane);
        this.transcription = transcription;
        this.setName("CompareAnnotatorsDialog.CompareProgressStep");
        this.allStepProperties = new HashMap<Object, Object>();
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.progressLabel.setText(ElanLocale.getString("CompareAnnotatorsDialog.ProgressStep.Title"));
        this.cancelProcessButton = new JButton(ElanLocale.getString("MultiStep.Cancel"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 13;
        this.add((Component)this.cancelProcessButton, gbc);
        this.cancelProcessButton.addActionListener(this);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CompareAnnotatorsDialog.ProgressStep.Title");
    }

    @Override
    public void enterStepForward() {
        this.doFinish();
    }

    @Override
    public void cancelled() {
    }

    @Override
    public boolean doFinish() {
        this.multiPane.setButtonEnabled(8, false);
        this.allStepProperties.clear();
        for (Object key : this.multiPane.getPropertyKeys()) {
            this.allStepProperties.put(key, this.multiPane.getStepProperty(key));
        }
        this.completed = false;
        this.cancelProcessButton.setEnabled(true);
        CompareConstants.METHOD compMethod = (CompareConstants.METHOD)((Object)this.allStepProperties.get("Compare.CompareMethod"));
        if (compMethod == CompareConstants.METHOD.MOD_KAPPA) {
            this.comCommand = new CompareAnnotationModKappaCommand("CompareModifiedKappa");
            this.comCommand.addProgressListener(this);
            this.comCommand.execute(this.transcription, new Object[]{this.allStepProperties});
        } else if (compMethod == CompareConstants.METHOD.STACCATO) {
            this.comCommand = new CompareAnnotationStaccatoCommand("CompareStaccato");
            this.comCommand.addProgressListener(this);
            this.comCommand.execute(this.transcription, new Object[]{this.allStepProperties});
        } else if (compMethod == CompareConstants.METHOD.CLASSIC) {
            this.comCommand = new CompareAnnotationRatioMultiCommand("CompareMultiRatio");
            this.comCommand.addProgressListener(this);
            this.comCommand.execute(this.transcription, new Object[]{this.allStepProperties});
        }
        return false;
    }

    @Override
    public void finished() {
        if (this.comCommand != null) {
            this.comCommand.cancelProcess();
        }
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    protected void endOfProcess() {
        if (!this.completed) {
            ClientLogger.LOG.warning("The calculation process was interrupted.");
            this.setCancelOrPreviousState();
            return;
        }
        List<CompareCombi> resultList = this.comCommand.getCompareSegments();
        if (resultList != null) {
            FileChooser chooser = new FileChooser(this);
            chooser.createAndShowFileAndEncodingDialog(null, 1, FileExtension.TEXT_EXT, "LastUsedExportDir", "UTF-8");
            File exportFile = chooser.getSelectedFile();
            String encoding = chooser.getSelectedEncoding();
            if (exportFile != null) {
                try {
                    this.comCommand.writeResultsAsText(exportFile, encoding);
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Output error: " + ioe.getMessage());
                    this.showMessageDialog(ElanLocale.getString("CompareAnnotatorsDialog.Message.OutputError") + " " + ioe.getMessage());
                }
                catch (Throwable t) {
                    ClientLogger.LOG.warning("Output error: " + t.getMessage());
                    this.showMessageDialog(ElanLocale.getString("CompareAnnotatorsDialog.Message.OutputError") + " " + t.getMessage());
                }
            } else {
                ClientLogger.LOG.info("Saving of the results was cancelled");
                this.setCancelOrPreviousState();
            }
        } else {
            ClientLogger.LOG.warning("No comparison results available.");
            this.showMessageDialog(ElanLocale.getString("CompareAnnotatorsDialog.Message.NoResults"));
        }
        super.endOfProcess();
    }

    private void setCancelOrPreviousState() {
        this.multiPane.setButtonEnabled(4, true);
        this.multiPane.setButtonEnabled(2, true);
        this.cancelProcessButton.setEnabled(false);
        if (this.progressLabel != null) {
            this.progressLabel.setText("");
        }
        this.progressBar.setValue(0);
    }

    private void printSegments(List<CompareCombi> compareSegments) {
        for (int i = 0; i < compareSegments.size(); ++i) {
            System.out.println("Compare index: " + (i + 1));
            CompareCombi cc = compareSegments.get(i);
            System.out.println("F1: " + cc.getFirstUnit().fileName + " T1: " + cc.getFirstUnit().tierName);
            System.out.println("\tA1: " + cc.getFirstUnit().annotations.size());
            System.out.println("F2: " + cc.getSecondUnit().fileName + " T2: " + cc.getSecondUnit().tierName);
            System.out.println("\tA2: " + cc.getSecondUnit().annotations.size());
            System.out.println("Agreement: " + cc.getOverallAgreement());
            System.out.println("#####");
        }
    }

    @Override
    public void progressCompleted(Object source, String message) {
        if (this.progressLabel != null) {
            this.progressLabel.setText(message);
        }
        this.progressBar.setValue(100);
        if (!this.completed) {
            this.completed = true;
            this.endOfProcess();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.cancelProcessButton) {
            if (this.comCommand != null) {
                this.comCommand.cancelProcess();
            }
            this.setCancelOrPreviousState();
        }
    }
}

