/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.interannotator.CompareConstants;

public class CustomizationStep
extends StepPane {
    private CompareConstants.METHOD curMethod = null;
    private JPanel customPanel;
    private JSlider overlapSlider;
    private SliderListener sliderListener;
    private JTextField overlapTF;
    private Insets globalInsets;
    private int defPercentage = 60;
    private JCheckBox verboseOutCB;
    private JFormattedTextField monteCarloTF;
    private JFormattedTextField numNominaTF;
    private JFormattedTextField nullHypTF;

    public CustomizationStep(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.customPanel = new JPanel(new GridBagLayout());
        this.globalInsets = new Insets(5, 10, 5, 10);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.globalInsets;
        this.add((Component)this.customPanel, gbc);
        this.updateLocale();
    }

    public void updateLocale() {
        this.customPanel.setBorder(new TitledBorder(ElanLocale.getString("CompareAnnotatorsDialog.CustomizeStep.TitleBorder")));
    }

    private void updatePanel(CompareConstants.METHOD method) {
        this.customPanel.removeAll();
        if (this.overlapSlider != null) {
            this.overlapSlider.removeChangeListener(this.sliderListener);
        }
        if (method == CompareConstants.METHOD.MOD_KAPPA) {
            Boolean verbosePref;
            int percentage;
            JLabel percentageLabel = new JLabel(ElanLocale.getString("CompareAnnotatorsDialog.CustomizeStep.PercentageLabel"));
            this.overlapTF = new JTextField(4);
            this.overlapTF.setEditable(false);
            this.overlapTF.setText(String.valueOf(this.defPercentage));
            this.overlapSlider = new JSlider(51, 100, this.defPercentage);
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>(10);
            ((Dictionary)labels).put(51, new JLabel("51"));
            ((Dictionary)labels).put(60, new JLabel("60"));
            ((Dictionary)labels).put(70, new JLabel("70"));
            ((Dictionary)labels).put(80, new JLabel("80"));
            ((Dictionary)labels).put(90, new JLabel("90"));
            ((Dictionary)labels).put(100, new JLabel("100"));
            this.overlapSlider.setLabelTable(labels);
            this.overlapSlider.setPaintLabels(true);
            this.sliderListener = new SliderListener();
            this.overlapSlider.addChangeListener(this.sliderListener);
            this.overlapSlider.createStandardLabels(20);
            this.verboseOutCB = new JCheckBox(ElanLocale.getString("CompareAnnotatorsDialog.CustomizeStep.VerboseOutput"), false);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = this.globalInsets;
            gbc.gridwidth = 2;
            this.customPanel.add((Component)percentageLabel, gbc);
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.anchor = 18;
            this.customPanel.add((Component)this.overlapTF, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            this.customPanel.add((Component)this.overlapSlider, gbc);
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            gbc.gridy = 2;
            gbc.insets = new Insets(5, 0, 5, 10);
            this.customPanel.add((Component)this.verboseOutCB, gbc);
            gbc.gridy = 3;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.customPanel.add((Component)new JPanel(), gbc);
            Integer sliderPref = Preferences.getInt("Compare.OverlapPercentage", null);
            if (sliderPref != null && (percentage = sliderPref.intValue()) >= 51 && percentage <= 100) {
                this.overlapSlider.setValue(percentage);
            }
            if ((verbosePref = Preferences.getBool("Compare.Output.PerTierPair", null)) != null) {
                this.verboseOutCB.setSelected(verbosePref);
            }
        } else if (method == CompareConstants.METHOD.STACCATO) {
            Double nullHypObj;
            Integer numNomObj;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = this.globalInsets;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridwidth = 1;
            this.customPanel.add((Component)new JLabel(ElanLocale.getString("CompareAnnotatorsDialog.CustomizeStep.MCSIterations")), gbc);
            gbc.gridy = 1;
            this.customPanel.add((Component)new JLabel(ElanLocale.getString("CompareAnnotatorsDialog.CustomizeStep.NominationLength")), gbc);
            gbc.gridy = 2;
            this.customPanel.add((Component)new JLabel(ElanLocale.getString("CompareAnnotatorsDialog.CustomizeStep.NullHypothesis")), gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            this.monteCarloTF = new JFormattedTextField(new DecimalFormat("#####"));
            this.monteCarloTF.setValue(1000);
            this.monteCarloTF.setPreferredSize(new Dimension(60, this.monteCarloTF.getPreferredSize().height));
            this.customPanel.add((Component)this.monteCarloTF, gbc);
            this.numNominaTF = new JFormattedTextField(NumberFormat.getIntegerInstance());
            this.numNominaTF.setValue(10);
            gbc.gridy = 1;
            this.customPanel.add((Component)this.numNominaTF, gbc);
            this.nullHypTF = new JFormattedTextField(new DecimalFormat("0.0#"));
            this.nullHypTF.setValue(0.05);
            gbc.gridy = 2;
            this.customPanel.add((Component)this.nullHypTF, gbc);
            gbc.gridy = 3;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.customPanel.add((Component)new JPanel(), gbc);
            Integer mcsIterObj = Preferences.getInt("Compare.MonteCarloSimulations", null);
            if (mcsIterObj != null) {
                this.monteCarloTF.setValue(mcsIterObj);
            }
            if ((numNomObj = Preferences.getInt("Compare.NumberOfNominations", null)) != null) {
                this.numNominaTF.setValue(numNomObj);
            }
            if ((nullHypObj = Preferences.getDouble("Compare.NullHypothesis.Value", null)) != null) {
                this.nullHypTF.setValue(nullHypObj);
            }
        }
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CompareAnnotatorsDialog.CustomizeStep.Title");
    }

    @Override
    public void enterStepForward() {
        CompareConstants.METHOD method = (CompareConstants.METHOD)((Object)this.multiPane.getStepProperty("Compare.CompareMethod"));
        if (method == CompareConstants.METHOD.CLASSIC) {
            this.curMethod = method;
            this.leaveStepForward();
            this.multiPane.nextStep();
            return;
        }
        if (method != this.curMethod) {
            this.updatePanel(method);
        }
        this.curMethod = method;
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(2, true);
    }

    @Override
    public boolean leaveStepForward() {
        if (this.curMethod == CompareConstants.METHOD.MOD_KAPPA) {
            if (this.overlapSlider != null) {
                this.multiPane.putStepProperty("Compare.OverlapPercentage", this.overlapSlider.getValue());
                Preferences.set("Compare.OverlapPercentage", (Object)this.overlapSlider.getValue(), null);
            }
            if (this.verboseOutCB != null) {
                this.multiPane.putStepProperty("Compare.Output.PerTierPair", this.verboseOutCB.isSelected());
                Preferences.set("Compare.Output.PerTierPair", this.verboseOutCB.isSelected(), null);
            }
        } else if (this.curMethod == CompareConstants.METHOD.STACCATO && this.monteCarloTF != null) {
            try {
                this.monteCarloTF.commitEdit();
                Integer mcsInteger = Integer.valueOf(this.monteCarloTF.getValue().toString());
                this.multiPane.putStepProperty("Compare.MonteCarloSimulations", mcsInteger);
                Preferences.set("Compare.MonteCarloSimulations", mcsInteger, null);
            }
            catch (ParseException pe) {
                this.monteCarloTF.grabFocus();
                return false;
            }
            try {
                this.numNominaTF.commitEdit();
                Integer nnInteger = Integer.valueOf(this.numNominaTF.getValue().toString());
                this.multiPane.putStepProperty("Compare.NumberOfNominations", nnInteger);
                Preferences.set("Compare.NumberOfNominations", nnInteger, null);
            }
            catch (ParseException pe) {
                this.numNominaTF.grabFocus();
                return false;
            }
            try {
                this.nullHypTF.commitEdit();
                Double nhDouble = Double.valueOf(this.nullHypTF.getValue().toString());
                this.multiPane.putStepProperty("Compare.NullHypothesis.Value", nhDouble);
                Preferences.set("Compare.NullHypothesis.Value", nhDouble, null);
            }
            catch (ParseException pe) {
                this.nullHypTF.grabFocus();
                return false;
            }
        }
        return true;
    }

    @Override
    public void enterStepBackward() {
        if (this.curMethod == CompareConstants.METHOD.CLASSIC) {
            this.leaveStepBackward();
            this.multiPane.previousStep();
        } else {
            this.multiPane.setButtonEnabled(1, true);
            this.multiPane.setButtonEnabled(2, true);
        }
    }

    private class SliderListener
    implements ChangeListener {
        private SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            if (CustomizationStep.this.overlapSlider != null && CustomizationStep.this.overlapTF != null) {
                CustomizationStep.this.overlapTF.setText(String.valueOf(CustomizationStep.this.overlapSlider.getValue()));
            }
        }
    }
}

