/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.export.multiplefiles.AbstractFilesAndTierSelectionStepPane;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.interannotator.CompareConstants;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class FilesSelectionStep
extends AbstractFilesAndTierSelectionStepPane
implements ChangeListener {
    protected JPanel matchingOptionsPanel;
    protected JLabel matchLabel;
    protected JRadioButton prefixMatchRB;
    protected JRadioButton suffixMatchRB;
    protected JCheckBox customSepCB;
    protected JTextField customSepTF;
    protected ArrayList<File> selFiles;
    private JPanel tierMatchingOptionsPanel;
    private JRadioButton tierPrefixMatchRB;
    private JRadioButton tierSuffixMatchRB;
    private JCheckBox tierCustomSepCB;
    private JTextField tierCustomSepTF;
    private final String prefFileSelection = "Compare.FileSelection";
    private final String prefTierAffixType = "Compare.Matching.TierAffix.Type";
    private final String prefFileAffixType = "Compare.Matching.FileAffix.Type";
    private final String prefFileCustomSep = "Compare.Matching.FileCustomSeparator";
    private final String prefTierCustomSep = "Compare.Matching.TierCustomSeparator";

    public FilesSelectionStep(MultiStepPane mp, TranscriptionImpl transcription) {
        super(mp, transcription);
        this.initComponents2();
    }

    @Override
    protected void initComponents() {
    }

    protected void initComponents2() {
        this.initFileSelectionPanel();
        this.initTierSelectionPanel();
        this.initOptionsPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = this.globalInset;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        this.add((Component)this.fileSelectionPanel, gbc);
        gbc.gridy = 1;
        this.add((Component)this.tierMatchingOptionsPanel, gbc);
        this.loadPreferences();
    }

    @Override
    protected void initFileSelectionPanel() {
        super.initFileSelectionPanel();
        this.fileSelectionPanel.remove(this.currentlyOpenedFileRB);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        this.fileSelectionPanel.add((Component)new JPanel(), gbc);
    }

    @Override
    protected void initTierSelectionPanel() {
        this.tierSelectionPanel = new JPanel();
        this.textArea = new JTextArea();
        this.tierMatchingOptionsPanel = new JPanel(new GridBagLayout());
        JPanel innerPanel = new JPanel(new GridBagLayout());
        this.tierSuffixMatchRB = new JRadioButton();
        this.tierSuffixMatchRB.setSelected(true);
        this.tierPrefixMatchRB = new JRadioButton();
        ButtonGroup matchGroup = new ButtonGroup();
        matchGroup.add(this.tierSuffixMatchRB);
        matchGroup.add(this.tierPrefixMatchRB);
        this.tierCustomSepCB = new JCheckBox();
        this.tierCustomSepTF = new JTextField(6);
        this.tierCustomSepTF.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 30, 0, 10);
        innerPanel.add((Component)this.tierSuffixMatchRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        innerPanel.add((Component)this.tierPrefixMatchRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.gridwidth = 3;
        innerPanel.add((Component)this.tierCustomSepCB, gbc);
        gbc.gridy = 3;
        gbc.insets = new Insets(0, 60, 0, 10);
        gbc.fill = 0;
        innerPanel.add((Component)this.tierCustomSepTF, gbc);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        this.tierMatchingOptionsPanel.add((Component)innerPanel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.tierMatchingOptionsPanel.add((Component)new JPanel(), gbc);
        this.tierSuffixMatchRB.setText(ElanLocale.getString("CreateMultiEAFDialog.Label.Suffix"));
        this.tierPrefixMatchRB.setText(ElanLocale.getString("CreateMultiEAFDialog.Label.Prefix"));
        this.tierCustomSepCB.setText(ElanLocale.getString("CreateMultiEAFDialog.Button.Separator"));
        this.tierCustomSepCB.addChangeListener(this);
        this.tierMatchingOptionsPanel.setBorder(new TitledBorder(ElanLocale.getString("CompareAnnotatorsDialog.FilesSelectionStep.CombineTiers")));
    }

    protected void initOptionsPanel() {
        this.matchingOptionsPanel = new JPanel(new GridBagLayout());
        this.matchLabel = new JLabel();
        this.suffixMatchRB = new JRadioButton();
        this.suffixMatchRB.setSelected(true);
        this.prefixMatchRB = new JRadioButton();
        ButtonGroup matchGroup = new ButtonGroup();
        matchGroup.add(this.suffixMatchRB);
        matchGroup.add(this.prefixMatchRB);
        this.customSepCB = new JCheckBox();
        this.customSepTF = new JTextField(6);
        this.customSepTF.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.anchor = 18;
        this.matchingOptionsPanel.add((Component)this.matchLabel, gbc);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 30, 0, 10);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.matchingOptionsPanel.add((Component)this.suffixMatchRB, gbc);
        gbc.gridx = 1;
        this.matchingOptionsPanel.add((Component)this.prefixMatchRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        this.matchingOptionsPanel.add((Component)this.customSepCB, gbc);
        gbc.gridy = 3;
        gbc.insets = new Insets(0, 60, 0, 10);
        gbc.fill = 0;
        this.matchingOptionsPanel.add((Component)this.customSepTF, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.insets = new Insets(15, 10, 5, 10);
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        GridBagConstraints fillConstraints = null;
        GridBagConstraints lastConstraints = null;
        try {
            Component lastRelComp = this.fileSelectionPanel.getComponent(this.fileSelectionPanel.getComponentCount() - 2);
            lastConstraints = ((GridBagLayout)this.fileSelectionPanel.getLayout()).getConstraints(lastRelComp);
            Component filler = this.fileSelectionPanel.getComponent(this.fileSelectionPanel.getComponentCount() - 1);
            fillConstraints = ((GridBagLayout)this.fileSelectionPanel.getLayout()).getConstraints(filler);
            if (lastConstraints != null) {
                gbc.gridy = lastConstraints.gridy + 1;
                if (fillConstraints != null) {
                    this.fileSelectionPanel.remove(filler);
                    fillConstraints.gridy = lastConstraints.gridy + 2;
                    this.fileSelectionPanel.add(filler, fillConstraints);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fileSelectionPanel.add((Component)this.matchingOptionsPanel, gbc);
        this.matchLabel.setText(ElanLocale.getString("CompareAnnotatorsDialog.FilesSelectionStep.CombineFiles"));
        this.suffixMatchRB.setText(ElanLocale.getString("CreateMultiEAFDialog.Label.Suffix"));
        this.prefixMatchRB.setText(ElanLocale.getString("CreateMultiEAFDialog.Label.Prefix"));
        this.customSepCB.setText(ElanLocale.getString("CreateMultiEAFDialog.Button.Separator"));
        this.customSepCB.addChangeListener(this);
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    @Override
    public void updateButtonStates() {
        if (this.selFiles == null || this.selFiles.size() == 0) {
            this.multiPane.setButtonEnabled(1, false);
        } else {
            this.multiPane.setButtonEnabled(1, true);
        }
    }

    @Override
    protected void initializeTierSelectPanel(ArrayList<File> files) {
        if (files != null) {
            if (this.selFiles == null) {
                this.selFiles = new ArrayList();
            }
            this.selFiles.clear();
            this.selFiles.addAll(files);
        }
        this.updateButtonStates();
    }

    @Override
    protected void checkForOpenedFiles(List<String> fileNames) {
    }

    @Override
    public void enterStepForward() {
        Object tierSource = this.multiPane.getStepProperty("Compare.TierSource");
        this.matchingOptionsPanel.setVisible(tierSource == CompareConstants.FILE_MATCHING.ACROSS_FILES);
        Object tierMatching = this.multiPane.getStepProperty("Compare.TierMatching");
        this.tierMatchingOptionsPanel.setVisible(tierMatching == CompareConstants.MATCHING.AFFIX);
        this.multiPane.setButtonEnabled(2, true);
        boolean nextStep = this.selFiles != null && this.selFiles.size() > 0 || this.transcription != null;
        this.multiPane.setButtonEnabled(1, nextStep);
        if (this.transcription != null && tierSource == CompareConstants.FILE_MATCHING.CURRENT_DOC && tierMatching != CompareConstants.MATCHING.AFFIX) {
            this.leaveStepForward();
            this.multiPane.nextStep();
        }
        if (this.transcription != null && tierSource == CompareConstants.FILE_MATCHING.CURRENT_DOC) {
            this.selectedFilesFromDiskRB.setEnabled(false);
            this.filesFromDomainRB.setEnabled(false);
            this.selectFilesBtn.setEnabled(false);
            this.selectDomainBtn.setEnabled(false);
        } else {
            this.selectedFilesFromDiskRB.setEnabled(true);
            this.filesFromDomainRB.setEnabled(true);
            if (this.selectedFilesFromDiskRB.isSelected()) {
                this.selectFilesBtn.setEnabled(true);
            } else {
                this.selectDomainBtn.setEnabled(true);
            }
        }
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(2, true);
        this.multiPane.setButtonEnabled(1, true);
        Object tierSource = this.multiPane.getStepProperty("Compare.TierSource");
        Object tierMatching = this.multiPane.getStepProperty("Compare.TierMatching");
        if (this.transcription != null && tierSource == CompareConstants.FILE_MATCHING.CURRENT_DOC && tierMatching != CompareConstants.MATCHING.SUFFIX && tierMatching != CompareConstants.MATCHING.PREFIX) {
            this.leaveStepBackward();
            this.multiPane.previousStep();
        }
    }

    @Override
    public boolean leaveStepForward() {
        String separator;
        if ((this.selFiles == null || this.selFiles.size() == 0) && this.transcription == null) {
            ClientLogger.LOG.warning("No files selected, cannot proceed to next step.");
            return false;
        }
        if (this.matchingOptionsPanel.isVisible() && this.customSepCB.isSelected() && ((separator = this.customSepTF.getText()) == null || separator.length() == 0)) {
            ClientLogger.LOG.warning("No custom separator specified for file matching, cannot proceed to next step.");
            this.showWarning(ElanLocale.getString("CompareAnnotatorsDialog.DocumentSelectionStep.Warning.NoSeparator"));
            this.customSepTF.requestFocus();
            return false;
        }
        if (this.tierMatchingOptionsPanel.isVisible() && this.tierCustomSepCB.isSelected() && ((separator = this.tierCustomSepTF.getText()) == null || separator.length() == 0)) {
            ClientLogger.LOG.warning("No custom separator specified for tier matching, cannot proceed to next step.");
            this.showWarning(ElanLocale.getString("CompareAnnotatorsDialog.DocumentSelectionStep.Warning.NoTierSeparator"));
            this.tierCustomSepTF.requestFocus();
            return false;
        }
        this.multiPane.putStepProperty("Compare.SelectedFiles", this.selFiles);
        if (this.matchingOptionsPanel.isVisible()) {
            if (this.suffixMatchRB.isSelected()) {
                this.multiPane.putStepProperty("Compare.FileMatching", (Object)CompareConstants.MATCHING.SUFFIX);
            } else {
                this.multiPane.putStepProperty("Compare.FileMatching", (Object)CompareConstants.MATCHING.PREFIX);
            }
            if (this.customSepCB.isSelected()) {
                this.multiPane.putStepProperty("Compare.FileSeparator", this.customSepTF.getText());
            } else {
                this.multiPane.putStepProperty("Compare.FileSeparator", null);
            }
        } else {
            this.multiPane.putStepProperty("Compare.FileMatching", null);
            this.multiPane.putStepProperty("Compare.FileSeparator", null);
        }
        if (this.tierMatchingOptionsPanel.isVisible()) {
            if (this.tierSuffixMatchRB.isSelected()) {
                this.multiPane.putStepProperty("Compare.TierMatching", (Object)CompareConstants.MATCHING.SUFFIX);
            } else {
                this.multiPane.putStepProperty("Compare.TierMatching", (Object)CompareConstants.MATCHING.PREFIX);
            }
            if (this.tierCustomSepCB.isSelected()) {
                this.multiPane.putStepProperty("Compare.TierSeparator", this.tierCustomSepTF.getText());
            } else {
                this.multiPane.putStepProperty("Compare.TierSeparator", null);
            }
        } else {
            this.multiPane.putStepProperty("Compare.TierSeparator", null);
        }
        this.storePreferences();
        return true;
    }

    private void storePreferences() {
        if (this.filesFromDomainRB.isSelected()) {
            Preferences.set("Compare.FileSelection", "Domain", null);
        } else if (this.selectedFilesFromDiskRB.isSelected()) {
            Preferences.set("Compare.FileSelection", "Browse", null);
        }
        if (this.matchingOptionsPanel.isVisible()) {
            CompareConstants.MATCHING curMatching = (CompareConstants.MATCHING)((Object)this.multiPane.getStepProperty("Compare.FileMatching"));
            if (curMatching != null) {
                Preferences.set("Compare.Matching.FileAffix.Type", curMatching.value, null);
            }
            Preferences.set("Compare.Matching.FileCustomSeparator", this.customSepCB.isSelected(), null);
            Preferences.set("Compare.FileSeparator", this.customSepTF.getText(), null);
        }
        if (this.tierMatchingOptionsPanel.isVisible()) {
            if (this.tierSuffixMatchRB.isSelected()) {
                Preferences.set("Compare.Matching.TierAffix.Type", CompareConstants.MATCHING.SUFFIX.value, null);
            } else {
                Preferences.set("Compare.Matching.TierAffix.Type", CompareConstants.MATCHING.PREFIX.value, null);
            }
            Preferences.set("Compare.Matching.TierCustomSeparator", this.tierCustomSepCB.isSelected(), null);
            Preferences.set("Compare.TierSeparator", this.tierCustomSepTF.getText(), null);
        }
    }

    private void loadPreferences() {
        Boolean boolPref;
        String tierPref;
        String stringPref;
        Boolean customFileSep;
        String fileMatchType;
        String fileSelPref = Preferences.getString("Compare.FileSelection", null);
        if ("Domain".equals(fileSelPref)) {
            this.filesFromDomainRB.setSelected(true);
            this.selectDomainBtn.setEnabled(true);
            this.selectFilesBtn.setEnabled(false);
        }
        if (CompareConstants.MATCHING.PREFIX.value.equals(fileMatchType = Preferences.getString("Compare.Matching.FileAffix.Type", null))) {
            this.prefixMatchRB.setSelected(true);
        }
        if ((customFileSep = Preferences.getBool("Compare.Matching.FileCustomSeparator", null)) != null) {
            this.customSepCB.setSelected(customFileSep);
        }
        if ((stringPref = Preferences.getString("Compare.FileSeparator", null)) != null) {
            this.customSepTF.setText(stringPref);
        }
        if (CompareConstants.MATCHING.PREFIX.value.equals(tierPref = Preferences.getString("Compare.Matching.TierAffix.Type", null))) {
            this.tierPrefixMatchRB.setSelected(true);
        }
        if ((boolPref = Preferences.getBool("Compare.Matching.TierCustomSeparator", null)) != null) {
            this.tierCustomSepCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString("Compare.TierSeparator", null)) != null) {
            this.tierCustomSepTF.setText(stringPref);
        }
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CompareAnnotatorsDialog.FilesSelectionStep.Title");
    }

    @Override
    public String getPreferredNextStep() {
        return "Tiers";
    }

    @Override
    public String getPreferredPreviousStep() {
        return "Document";
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.customSepCB) {
            this.customSepTF.setEnabled(this.customSepCB.isSelected());
        } else if (e.getSource() == this.tierCustomSepCB) {
            this.tierCustomSepTF.setEnabled(this.tierCustomSepCB.isSelected());
        }
    }
}

