/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.interannotator.CompareConstants;
import mpi.eudico.server.corpora.clom.Transcription;

public class MethodSelectionStep
extends StepPane {
    private Transcription transcription;
    private static final long serialVersionUID = 1L;
    private JPanel methodPanel = null;
    private TitledBorder border;
    private JRadioButton classicCompareRB;
    private JRadioButton kappaCompareRB;
    private JRadioButton staccatoCompareRB;

    public MethodSelectionStep(MultiStepPane wizard, Transcription transcription) {
        super(wizard);
        this.transcription = transcription;
        this.setName("CompareAnnotatorsDialog.MethodSelectionStep");
        this.createPanel();
    }

    public void updateLocale() {
        this.border.setTitle(ElanLocale.getString("CompareAnnotatorsDialog.MethodSelectionStep.Hint"));
        this.classicCompareRB.setText(ElanLocale.getString("CompareAnnotatorsDialog.MethodSelectionStep.ClassicRB"));
        this.kappaCompareRB.setText(ElanLocale.getString("CompareAnnotatorsDialog.MethodSelectionStep.KappaRB"));
        this.staccatoCompareRB.setText(ElanLocale.getString("CompareAnnotatorsDialog.MethodSelectionStep.StaccatoRB"));
    }

    public void createPanel() {
        this.border = new TitledBorder("");
        this.classicCompareRB = new JRadioButton();
        this.kappaCompareRB = new JRadioButton();
        this.kappaCompareRB.setSelected(true);
        this.staccatoCompareRB = new JRadioButton();
        this.updateLocale();
        ButtonGroup methodButtonGroup = new ButtonGroup();
        methodButtonGroup.add(this.classicCompareRB);
        methodButtonGroup.add(this.kappaCompareRB);
        methodButtonGroup.add(this.staccatoCompareRB);
        this.methodPanel = new JPanel(new GridBagLayout());
        this.methodPanel.setBorder(this.border);
        Insets globalInset = new Insets(5, 10, 5, 10);
        Insets singleTabInset = new Insets(0, 30, 0, 10);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = singleTabInset;
        this.methodPanel.add((Component)this.kappaCompareRB, gbc);
        gbc.gridy = 1;
        this.methodPanel.add((Component)this.classicCompareRB, gbc);
        gbc.gridy = 2;
        this.methodPanel.add((Component)this.staccatoCompareRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.methodPanel.add((Component)new JPanel(), gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.insets = globalInset;
        gbc.fill = 1;
        String prefMethod = Preferences.getString("Compare.CompareMethod", null);
        if (prefMethod != null) {
            if (CompareConstants.METHOD.CLASSIC.value.equals(prefMethod)) {
                this.classicCompareRB.setSelected(true);
            } else if (CompareConstants.METHOD.MOD_KAPPA.value.equals(prefMethod)) {
                this.kappaCompareRB.setEnabled(true);
            } else if (CompareConstants.METHOD.STACCATO.value.equals(prefMethod)) {
                this.staccatoCompareRB.setSelected(true);
            }
        }
        this.add((Component)this.methodPanel, gbc);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CompareAnnotatorsDialog.MethodSelectionStep.Title");
    }

    @Override
    public String getPreferredNextStep() {
        return null;
    }

    @Override
    public void enterStepForward() {
        this.multiPane.setButtonEnabled(1, true);
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(3, false);
    }

    @Override
    public boolean leaveStepForward() {
        if (this.classicCompareRB.isSelected()) {
            this.multiPane.putStepProperty("Compare.CompareMethod", (Object)CompareConstants.METHOD.CLASSIC);
            Preferences.set("Compare.CompareMethod", CompareConstants.METHOD.CLASSIC.value, null);
        } else if (this.kappaCompareRB.isSelected()) {
            this.multiPane.putStepProperty("Compare.CompareMethod", (Object)CompareConstants.METHOD.MOD_KAPPA);
            Preferences.set("Compare.CompareMethod", CompareConstants.METHOD.MOD_KAPPA.value, null);
        } else if (this.staccatoCompareRB.isSelected()) {
            this.multiPane.putStepProperty("Compare.CompareMethod", (Object)CompareConstants.METHOD.STACCATO);
            Preferences.set("Compare.CompareMethod", CompareConstants.METHOD.STACCATO.value, null);
        } else {
            return false;
        }
        return true;
    }
}

