/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import mpi.eudico.client.annotator.interannotator.CompareConstants;
import mpi.eudico.client.annotator.util.ClientLogger;

public class TierAndFileMatcher {
    public List<List<String>> getMatchingTiers(List<String> allTierNames, List<String> selTierNames, CompareConstants.MATCHING tierMatching, String tierNameSeparators) {
        ArrayList<List<String>> matchingNames = new ArrayList<List<String>>();
        ArrayList<String> alreadyProc = new ArrayList<String>();
        char[] delimiters = null;
        delimiters = tierNameSeparators != null ? tierNameSeparators.toCharArray() : new char[]{'-', '_'};
        for (String selName : selTierNames) {
            if (alreadyProc.contains(selName)) continue;
            String substringToMatch = this.getSubstringNoAffix(selName, delimiters, tierMatching);
            if (substringToMatch == null) {
                alreadyProc.add(selName);
                if (!ClientLogger.LOG.isLoggable(Level.INFO)) continue;
                ClientLogger.LOG.info(String.format("No %s detected in tier name: %s", new Object[]{tierMatching, selName}));
                continue;
            }
            ArrayList<String> curMatches = new ArrayList<String>();
            curMatches.add(selName);
            alreadyProc.add(selName);
            for (String curName : allTierNames) {
                if (alreadyProc.contains(curName) || !this.isMatchingName(curName, substringToMatch, tierMatching)) continue;
                curMatches.add(curName);
                alreadyProc.add(curName);
            }
            if (curMatches.size() > 1) {
                matchingNames.add(curMatches);
                continue;
            }
            if (!ClientLogger.LOG.isLoggable(Level.INFO)) continue;
            ClientLogger.LOG.info("Could not find any matching tier for: " + selName);
        }
        return matchingNames;
    }

    public List<List<File>> getMatchingFiles(List<File> selFiles, CompareConstants.MATCHING fileMatching, String fileNameSeparators, String fileExtension) {
        ArrayList<List<File>> matchingFiles = new ArrayList<List<File>>();
        ArrayList<File> alreadyProc = new ArrayList<File>();
        char[] delimiters = null;
        delimiters = fileNameSeparators != null ? fileNameSeparators.toCharArray() : new char[]{'-', '_'};
        String loExtension = null;
        if (fileExtension != null) {
            loExtension = fileExtension.toLowerCase();
        }
        for (int i = 0; i < selFiles.size(); ++i) {
            File f = selFiles.get(i);
            if (alreadyProc.contains(f)) continue;
            String fileName = this.noExtFileName(f.getName(), loExtension);
            String substringToMatch = this.getSubstringNoAffix(fileName, delimiters, fileMatching);
            if (substringToMatch == null) {
                alreadyProc.add(f);
                if (!ClientLogger.LOG.isLoggable(Level.INFO)) continue;
                ClientLogger.LOG.info(String.format("No %s detected in file name: %s", new Object[]{fileMatching, fileName}));
                continue;
            }
            ArrayList<File> currentMatches = new ArrayList<File>();
            currentMatches.add(f);
            alreadyProc.add(f);
            for (int j = i + 1; j < selFiles.size(); ++j) {
                String fileName2;
                File f2 = selFiles.get(j);
                if (alreadyProc.contains(f2) || !this.isMatchingName(fileName2 = this.noExtFileName(f2.getName(), loExtension), substringToMatch, fileMatching)) continue;
                currentMatches.add(f2);
                alreadyProc.add(f2);
            }
            if (currentMatches.size() > 1) {
                matchingFiles.add(currentMatches);
                continue;
            }
            if (!ClientLogger.LOG.isLoggable(Level.INFO)) continue;
            ClientLogger.LOG.info("Could not find any matching file for: " + f.getName());
        }
        return matchingFiles;
    }

    private String noExtFileName(String fileName, String fileExtension) {
        if (fileName != null) {
            if (fileExtension != null) {
                if (fileName.toLowerCase().endsWith(fileExtension)) {
                    return fileName.substring(0, fileName.length() - 4);
                }
            } else {
                int lastDot = fileName.lastIndexOf(46);
                if (lastDot > -1) {
                    return fileName.substring(0, lastDot);
                }
            }
        }
        return fileName;
    }

    private String getSubstringNoAffix(String inputName, char[] delimiters, CompareConstants.MATCHING matchType) {
        String substringWoAffix = null;
        for (char ch : delimiters) {
            int index;
            if (matchType == CompareConstants.MATCHING.PREFIX) {
                index = inputName.indexOf(ch);
                if (index < 1) continue;
                substringWoAffix = inputName.substring(index);
                break;
            }
            index = inputName.lastIndexOf(ch);
            if (index < 1 || index > inputName.length() - 2) continue;
            substringWoAffix = inputName.substring(0, index + 1);
            break;
        }
        return substringWoAffix;
    }

    private boolean isMatchingName(String candidateName, String substringToMatch, CompareConstants.MATCHING matchType) {
        if (matchType == CompareConstants.MATCHING.PREFIX) {
            int subIndex = candidateName.indexOf(substringToMatch);
            if (subIndex > 0) {
                int delIndex = candidateName.indexOf(substringToMatch.charAt(0));
                return candidateName.length() - delIndex == substringToMatch.length();
            }
        } else {
            int subIndex = candidateName.lastIndexOf(substringToMatch);
            if (subIndex == 0) {
                int delIndex = candidateName.lastIndexOf(substringToMatch.charAt(substringToMatch.length() - 1));
                return delIndex == substringToMatch.length() - 1;
            }
        }
        return false;
    }
}

