/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;

public class TierLoader
extends Thread {
    private List<File> fileList;
    private int numFilesProcessed = 0;
    private int numFilesFailed = 0;
    private List<String> tierNames;

    public TierLoader(List<File> files) {
        if (files == null) {
            throw new NullPointerException("There is no list of files.");
        }
        this.fileList = files;
    }

    @Override
    public void run() {
        this.tierNames = new ArrayList<String>();
        for (File f : this.fileList) {
            if (f == null) {
                ++this.numFilesProcessed;
                ++this.numFilesFailed;
                continue;
            }
            try {
                EAFSkeletonParser parser = new EAFSkeletonParser(f.getAbsolutePath());
                parser.parse();
                List<TierImpl> tiers = parser.getTiers();
                for (TierImpl tier : tiers) {
                    if (tier == null || this.tierNames.contains(tier.getName())) continue;
                    this.tierNames.add(tier.getName());
                }
            }
            catch (ParseException pe) {
                ++this.numFilesFailed;
            }
            ++this.numFilesProcessed;
        }
        Collections.sort(this.tierNames);
    }

    public List<String> getTierNames() {
        return this.tierNames;
    }

    public int getNumProccessed() {
        return this.numFilesProcessed;
    }

    public int getNumFailed() {
        return this.numFilesFailed;
    }

    public int getTotalNumberOfFiles() {
        return this.fileList.size();
    }
}

