/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator.modkappa;

public class CKappa {
    public double calcRawAgreement(int[][] matrix) {
        if (matrix.length != 2 || matrix[0].length != 2) {
            throw new IllegalArgumentException("The table should be square, 2 x 2.");
        }
        return this.calcRawAgreementPr(matrix);
    }

    private double calcRawAgreementPr(int[][] matrix) {
        double total = this.totalSumD(matrix);
        if (total == 0.0) {
            return Double.NaN;
        }
        return (double)(matrix[0][0] + matrix[1][1]) / total;
    }

    public double calcChanceAgreement(int[][] matrix) {
        if (matrix.length != 2 || matrix[0].length != 2) {
            throw new IllegalArgumentException("The table should be square, 2 x 2.");
        }
        return this.calcChanceAgreementPr(matrix);
    }

    private double calcChanceAgreementPr(int[][] matrix) {
        double total = this.totalSumD(matrix);
        if (total == 0.0) {
            return Double.NaN;
        }
        return (double)(matrix[0][0] + matrix[0][1]) / total * ((double)(matrix[0][0] + matrix[1][0]) / total) + (double)(matrix[1][0] + matrix[1][1]) / total * ((double)(matrix[0][1] + matrix[1][1]) / total);
    }

    public double calcKappa(int[][] matrix) {
        if (matrix.length != 2 || matrix[0].length != 2) {
            throw new IllegalArgumentException("The table should be square, 2 x 2.");
        }
        double chanceAgree = this.calcChanceAgreementPr(matrix);
        if (chanceAgree == 1.0 || Double.isNaN(chanceAgree)) {
            return Double.NaN;
        }
        double rawAgree = this.calcRawAgreementPr(matrix);
        return (rawAgree - chanceAgree) / (1.0 - chanceAgree);
    }

    public double calcKappa(double rawAgreement, double chanceAgreement) {
        if (chanceAgreement == 1.0) {
            return Double.NaN;
        }
        return (rawAgreement - chanceAgreement) / (1.0 - chanceAgreement);
    }

    public int totalSum(int[][] matrix) {
        if (matrix.length != 2 || matrix[0].length != 2) {
            throw new IllegalArgumentException("The table should be square, 2 x 2.");
        }
        return matrix[0][0] + matrix[1][0] + matrix[0][1] + matrix[1][1];
    }

    private double totalSumD(int[][] matrix) {
        return matrix[0][0] + matrix[1][0] + matrix[0][1] + matrix[1][1];
    }

    public double calcMaxKappa(int[][] matrix) {
        if (matrix.length != 2 || matrix[0].length != 2) {
            throw new IllegalArgumentException("The table should be square, 2 x 2.");
        }
        return this.calcMaxKappaPr(matrix);
    }

    private double calcMaxKappaPr(int[][] matrix) {
        double total = this.totalSumD(matrix);
        if (total == 0.0) {
            return Double.NaN;
        }
        double pe = this.calcChanceAgreementPr(matrix);
        if (pe == 1.0) {
            return Double.NaN;
        }
        int minSum = 0;
        minSum += Math.min(matrix[0][0] + matrix[0][1], matrix[0][0] + matrix[1][0]);
        double poM = (double)(minSum += Math.min(matrix[0][1] + matrix[1][1], matrix[1][0] + matrix[1][1])) / total;
        return (poM - pe) / (1.0 - pe);
    }
}

