/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator.modkappa;

public class IPFUtil {
    private final double ZERO_REPLACE = 0.001;

    public double[][] applyIPF(int[] rowMarginals, int[] columnMarginals, int[][] matrix, int numIterations) {
        if (matrix.length != rowMarginals.length) {
            throw new IllegalArgumentException("The number of row marginals should be equal to the number of rows in the table.");
        }
        if (matrix[0].length != columnMarginals.length) {
            throw new IllegalArgumentException("The number of column marginals should be equal to the number of columns in the table.");
        }
        double[][] ipfMatrix = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                ipfMatrix[i][j] = matrix[i][j] != 0 ? (double)matrix[i][j] : 0.001;
            }
        }
        double[] rowm = new double[rowMarginals.length];
        for (int i = 0; i < rowMarginals.length; ++i) {
            rowm[i] = rowMarginals[i] != 0 ? (double)rowMarginals[i] : 0.001;
        }
        double[] colm = new double[columnMarginals.length];
        for (int i = 0; i < columnMarginals.length; ++i) {
            colm[i] = columnMarginals[i] != 0 ? (double)columnMarginals[i] : 0.001;
        }
        for (int i = 0; i < numIterations; ++i) {
            int k;
            int j;
            for (j = 0; j < ipfMatrix.length; ++j) {
                double rowTotal = this.sum(ipfMatrix[j]);
                for (k = 0; k < ipfMatrix[j].length; ++k) {
                    double cell = ipfMatrix[j][k];
                    ipfMatrix[j][k] = cell / rowTotal * rowm[j];
                }
            }
            for (j = 0; j < colm.length; ++j) {
                double colTotal = this.sumCol(ipfMatrix, j);
                for (k = 0; k < ipfMatrix.length; ++k) {
                    double cell = ipfMatrix[k][j];
                    ipfMatrix[k][j] = cell / colTotal * colm[j];
                }
            }
        }
        return ipfMatrix;
    }

    private double sum(double[] values) {
        double total = 0.0;
        for (double d : values) {
            total += d;
        }
        return total;
    }

    private double sumCol(double[][] matrix, int col) {
        double total = 0.0;
        for (double[] row : matrix) {
            total += row[col];
        }
        return total;
    }
}

