/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.interlinear.InterlinearAnnotation;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class AnnotationBlockCreator {
    public DefaultMutableTreeNode createBlockForAnnotation(AbstractAnnotation aa, List<Tier> visibleTiers) {
        if (aa == null) {
            return null;
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new InterlinearAnnotation(aa));
        List<Annotation> children = null;
        AbstractAnnotation next = null;
        AbstractAnnotation parent = null;
        DefaultMutableTreeNode nextNode = null;
        DefaultMutableTreeNode parentNode = root;
        TierImpl tier = null;
        String tierName = null;
        DefaultMutableTreeNode tempNode = null;
        InterlinearAnnotation dataRecord = null;
        children = aa.getParentListeners();
        if (children.size() > 0) {
            block0: for (int i = 0; i < children.size(); ++i) {
                next = (AbstractAnnotation)children.get(i);
                tier = (TierImpl)next.getTier();
                if (visibleTiers == null || visibleTiers.contains(tier) || tier == aa.getTier()) {
                    nextNode = new DefaultMutableTreeNode(new InterlinearAnnotation(next));
                    if (parentNode.getChildCount() == 0) {
                        parentNode.add(nextNode);
                    } else {
                        long bt = next.getBeginTimeBoundary();
                        tierName = next.getTier().getName();
                        boolean inTierGroup = false;
                        int numChildren = parentNode.getChildCount();
                        for (int k = 0; k < numChildren; ++k) {
                            tempNode = (DefaultMutableTreeNode)parentNode.getChildAt(k);
                            dataRecord = (InterlinearAnnotation)tempNode.getUserObject();
                            if (dataRecord.getTierName().equals(tierName)) {
                                inTierGroup = true;
                            }
                            if (dataRecord.bt > bt && inTierGroup) {
                                parentNode.insert(nextNode, k);
                                break;
                            }
                            if (inTierGroup && !dataRecord.getTierName().equals(tierName)) {
                                parentNode.insert(nextNode, k);
                                break;
                            }
                            if (k != parentNode.getChildCount() - 1) continue;
                            parentNode.add(nextNode);
                        }
                    }
                    if (next.getParentListeners().size() > 0) {
                        children = next.getParentListeners();
                        parentNode = nextNode;
                        i = -1;
                        continue;
                    }
                } else if (next.getParentListeners().size() > 0) {
                    children = next.getParentListeners();
                    i = -1;
                    continue;
                }
                if (i != children.size() - 1) continue;
                while ((parent = (AbstractAnnotation)next.getParentAnnotation()) != null) {
                    int j;
                    if (visibleTiers == null || visibleTiers.contains(next.getTier()) || next.getTier() == aa.getTier()) {
                        parentNode = nextNode != null && nextNode.getParent() != null ? (DefaultMutableTreeNode)nextNode.getParent() : root;
                    }
                    if ((j = (children = parent.getParentListeners()).indexOf(next)) == children.size() - 1) {
                        if (parent == aa) break block0;
                        next = parent;
                        nextNode = parentNode;
                        continue;
                    }
                    i = j;
                    continue block0;
                }
                break block0;
            }
        }
        return root;
    }

    public DefaultMutableTreeNode createBlockFillEmptyPositions(AbstractAnnotation aa, List<Tier> visibleTiers) {
        if (aa == null) {
            return null;
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new InterlinearAnnotation(aa));
        List<Annotation> children = null;
        AbstractAnnotation next = null;
        AbstractAnnotation parent = null;
        DefaultMutableTreeNode nextNode = null;
        DefaultMutableTreeNode parentNode = root;
        TierImpl tier = null;
        String tierName = null;
        DefaultMutableTreeNode tempNode = null;
        InterlinearAnnotation dataRecord = null;
        this.fillEmptyPositions(root, aa, visibleTiers);
        children = aa.getParentListeners();
        if (children.size() > 0) {
            block0: for (int i = 0; i < children.size(); ++i) {
                next = (AbstractAnnotation)children.get(i);
                tier = (TierImpl)next.getTier();
                if (visibleTiers == null || visibleTiers.contains(tier) || tier == aa.getTier()) {
                    nextNode = new DefaultMutableTreeNode(new InterlinearAnnotation(next));
                    this.fillEmptyPositions(nextNode, next, visibleTiers);
                    if (parentNode.getChildCount() == 0) {
                        parentNode.add(nextNode);
                    } else {
                        long bt = next.getBeginTimeBoundary();
                        tierName = next.getTier().getName();
                        boolean inTierGroup = false;
                        int numChildren = parentNode.getChildCount();
                        for (int k = 0; k < numChildren; ++k) {
                            tempNode = (DefaultMutableTreeNode)parentNode.getChildAt(k);
                            dataRecord = (InterlinearAnnotation)tempNode.getUserObject();
                            if (dataRecord.getTierName().equals(tierName)) {
                                inTierGroup = true;
                            }
                            if (dataRecord.bt > bt && inTierGroup) {
                                parentNode.insert(nextNode, k);
                                break;
                            }
                            if (inTierGroup && !dataRecord.getTierName().equals(tierName)) {
                                parentNode.insert(nextNode, k);
                                break;
                            }
                            if (k != parentNode.getChildCount() - 1) continue;
                            parentNode.add(nextNode);
                        }
                    }
                    if (next.getParentListeners().size() > 0) {
                        children = next.getParentListeners();
                        parentNode = nextNode;
                        i = -1;
                        continue;
                    }
                } else {
                    this.fillEmptyPositions(root, next, visibleTiers);
                    if (next.getParentListeners().size() > 0) {
                        children = next.getParentListeners();
                        i = -1;
                        continue;
                    }
                }
                if (i != children.size() - 1) continue;
                while ((parent = (AbstractAnnotation)next.getParentAnnotation()) != null) {
                    int j;
                    if (visibleTiers == null || visibleTiers.contains(next.getTier()) || next.getTier() == aa.getTier()) {
                        parentNode = nextNode != null && nextNode.getParent() != null ? (DefaultMutableTreeNode)nextNode.getParent() : root;
                    }
                    if ((j = (children = parent.getParentListeners()).indexOf(next)) == children.size() - 1) {
                        if (parent == aa) break block0;
                        next = parent;
                        nextNode = parentNode;
                        continue;
                    }
                    i = j;
                    continue block0;
                }
                break block0;
            }
        }
        return root;
    }

    private void fillEmptyPositions(DefaultMutableTreeNode root, Annotation aa, List<Tier> visibleTiers) {
        TierImpl tier = (TierImpl)aa.getTier();
        List<TierImpl> childTiers = tier.getChildTiers();
        int numCh = childTiers.size();
        if (numCh == 0) {
            return;
        }
        DefaultMutableTreeNode nextNode = null;
        for (int i = 0; i < numCh; ++i) {
            TierImpl ct = childTiers.get(i);
            if (visibleTiers == null || visibleTiers.contains(ct)) {
                if (aa.getChildrenOnTier(ct).size() != 0) continue;
                int type = 1;
                if (ct.getLinguisticType().getConstraints().getStereoType() == 1 || ct.getLinguisticType().getConstraints().getStereoType() == 3 || ct.getLinguisticType().getConstraints().getStereoType() == 0) {
                    type = 2;
                }
                nextNode = new DefaultMutableTreeNode(new InterlinearAnnotation(ct.getName(), type));
                root.add(nextNode);
                this.fillEmptyPositions(nextNode, ct, visibleTiers);
                continue;
            }
            if (aa.getChildrenOnTier(ct).size() != 0) continue;
            this.fillEmptyPositions(root, ct, visibleTiers);
        }
    }

    private void fillEmptyPositions(DefaultMutableTreeNode root, TierImpl tier, List<Tier> visibleTiers) {
        List<TierImpl> childTiers = tier.getChildTiers();
        int numCh = childTiers.size();
        if (numCh == 0) {
            return;
        }
        DefaultMutableTreeNode nextNode = null;
        for (int i = 0; i < numCh; ++i) {
            TierImpl ct = childTiers.get(i);
            if (visibleTiers == null || visibleTiers.contains(ct)) {
                int type = 1;
                if (ct.getLinguisticType().getConstraints().getStereoType() == 1 || ct.getLinguisticType().getConstraints().getStereoType() == 3 || ct.getLinguisticType().getConstraints().getStereoType() == 0) {
                    type = 2;
                }
                nextNode = new DefaultMutableTreeNode(new InterlinearAnnotation(ct.getName(), type));
                root.add(nextNode);
                this.fillEmptyPositions(nextNode, ct, visibleTiers);
                continue;
            }
            this.fillEmptyPositions(root, ct, visibleTiers);
        }
    }

    public DefaultMutableTreeNode createTierTree(TranscriptionImpl transcription, List<Tier> visibleTiers) {
        DefaultMutableTreeNode root;
        if (transcription != null) {
            if (visibleTiers != null) {
                TierImpl tier;
                int i;
                HashMap<TierImpl, DefaultMutableTreeNode> tierNodes = new HashMap<TierImpl, DefaultMutableTreeNode>();
                List<TierImpl> tierVector = transcription.getTiers();
                DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[tierVector.size() + 1];
                nodes[0] = new DefaultMutableTreeNode();
                for (i = 0; i < tierVector.size(); ++i) {
                    tier = tierVector.get(i);
                    nodes[i + 1] = new DefaultMutableTreeNode(tier.getName());
                    tierNodes.put(tier, nodes[i + 1]);
                }
                block1: for (i = 0; i < tierVector.size(); ++i) {
                    tier = tierVector.get(i);
                    if (!visibleTiers.contains(tier)) continue;
                    if (tier.hasParentTier()) {
                        TierImpl parent = tier;
                        do {
                            if ((parent = parent.getParentTier()) != null) continue;
                            nodes[0].add(nodes[i + 1]);
                            continue block1;
                        } while (!visibleTiers.contains(parent));
                        if (tierNodes.get(parent) == null) continue;
                        ((DefaultMutableTreeNode)tierNodes.get(parent)).add(nodes[i + 1]);
                        continue;
                    }
                    nodes[0].add(nodes[i + 1]);
                }
                root = nodes[0];
                root.setUserObject("Document");
            } else {
                root = new DefaultMutableTreeNode("Document");
            }
        } else {
            root = new DefaultMutableTreeNode("Document");
        }
        return root;
    }
}

