/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.interlinear.AnnotationBlockCreator;
import mpi.eudico.client.annotator.interlinear.Interlinear;
import mpi.eudico.client.annotator.interlinear.InterlinearAnnotation;
import mpi.eudico.client.annotator.interlinear.InterlinearBlock;
import mpi.eudico.client.annotator.interlinear.InterlinearTier;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeFormatter;
import mpi.eudico.util.TimeRelation;

public class BlockMetrics {
    TranscriptionImpl transcription;
    final Interlinear interlinearizer;
    public final String TC_TIER_NAME = "TC";
    public final String TIME_SEP = " - ";
    public final String SD_TIER_NAME = "SD";
    public final String SD_SEP1 = "(";
    public final String SD_SEP2 = ")";
    public final char SPACE_CHAR = (char)32;
    private Map<String, Integer> tierHeights;
    private Map<String, String> timecodeLabels;
    private Map<String, String> silDurationLabels;
    List<DefaultMutableTreeNode> annotationBlocks;
    List<InterlinearBlock> printBlocks;
    private ArrayList<int[]> pageBreaks;
    List<Tier> visibleTiers;
    List<String> tierTemplate;
    private int leftMargin;
    private DefaultMutableTreeNode tierTree;

    public BlockMetrics(Interlinear interlinearizer) {
        this.interlinearizer = interlinearizer;
        this.transcription = interlinearizer.getTranscription();
        this.tierHeights = new HashMap<String, Integer>();
        this.timecodeLabels = new HashMap<String, String>();
        this.silDurationLabels = new HashMap<String, String>();
        this.annotationBlocks = new ArrayList<DefaultMutableTreeNode>();
        this.tierTemplate = new ArrayList<String>();
        this.printBlocks = new ArrayList<InterlinearBlock>();
        this.pageBreaks = new ArrayList();
        this.tierTree = new DefaultMutableTreeNode();
    }

    public void reset() {
        this.tierHeights.clear();
        this.timecodeLabels.clear();
        this.annotationBlocks.clear();
        this.tierTemplate.clear();
        this.visibleTiers = this.interlinearizer.getVisibleTiers();
        this.tierTree = new DefaultMutableTreeNode();
    }

    public void calculateAnnotationBlocks(Graphics g) {
        TierImpl rootTier;
        TierImpl tier;
        AnnotationBlockCreator creator = new AnnotationBlockCreator();
        this.tierTree = creator.createTierTree(this.interlinearizer.getTranscription(), this.visibleTiers);
        boolean pixelBased = this.interlinearizer.getAlignmentUnit() == 0;
        int maxTierLabelWidth = 0;
        Font font = null;
        FontMetrics fontMetrics = null;
        ArrayList<TierImpl> relevantTopTiers = new ArrayList<TierImpl>();
        for (int i = 0; i < this.visibleTiers.size(); ++i) {
            tier = (TierImpl)this.visibleTiers.get(i);
            String name = tier.getName();
            this.tierTemplate.add(name);
            rootTier = tier.getRootTier();
            if (!relevantTopTiers.contains(rootTier)) {
                int labWidth;
                int tierHeight;
                relevantTopTiers.add(rootTier);
                if (this.interlinearizer.isShowSilenceDuration()) {
                    String sdLabel = "SD";
                    sdLabel = this.createSDLabel(rootTier.getName());
                    if (sdLabel != null) {
                        this.silDurationLabels.put(rootTier.getName(), sdLabel);
                        if (pixelBased) {
                            this.interlinearizer.setFontSize(sdLabel, 10);
                            this.interlinearizer.setFont(sdLabel, Interlinear.DEFAULTFONT);
                            font = this.interlinearizer.getFont(sdLabel);
                            fontMetrics = g.getFontMetrics(font);
                            tierHeight = fontMetrics.getHeight();
                            this.setTierHeight(sdLabel, tierHeight);
                            labWidth = fontMetrics.stringWidth("SD");
                            if (labWidth > maxTierLabelWidth) {
                                maxTierLabelWidth = labWidth;
                            }
                        } else if (maxTierLabelWidth < 2) {
                            maxTierLabelWidth = 2;
                        }
                    }
                }
                if (this.interlinearizer.isTimeCodeShown() || this.interlinearizer.isPlaySoundSel()) {
                    String tcLabel = "TC";
                    tcLabel = this.interlinearizer.getTimeCodeMultiplicity() == 0 ? this.createTCLabel("") : this.createTCLabel(rootTier.getName());
                    if (tcLabel != null) {
                        this.timecodeLabels.put(rootTier.getName(), tcLabel);
                        if (pixelBased) {
                            this.interlinearizer.setFontSize(tcLabel, 10);
                            this.interlinearizer.setFont(tcLabel, Interlinear.DEFAULTFONT);
                            font = this.interlinearizer.getFont(tcLabel);
                            fontMetrics = g.getFontMetrics(font);
                            tierHeight = fontMetrics.getHeight();
                            this.setTierHeight(tcLabel, tierHeight);
                            labWidth = fontMetrics.stringWidth("TC");
                            if (labWidth > maxTierLabelWidth) {
                                maxTierLabelWidth = labWidth;
                            }
                        } else if (maxTierLabelWidth < 2) {
                            maxTierLabelWidth = 2;
                        }
                    }
                }
            }
            if (pixelBased) {
                font = this.interlinearizer.getFont(name);
                fontMetrics = g.getFontMetrics(font);
                int tierHeight = fontMetrics.getHeight();
                this.setTierHeight(name, tierHeight);
                int labWidth = fontMetrics.stringWidth(name);
                if (labWidth <= maxTierLabelWidth) continue;
                maxTierLabelWidth = labWidth;
                continue;
            }
            this.setTierHeight(name, 12);
            int labWidth = name.length();
            if (labWidth <= maxTierLabelWidth) continue;
            maxTierLabelWidth = labWidth;
        }
        if (pixelBased) {
            this.setLeftMargin(maxTierLabelWidth + this.interlinearizer.getEmptySpace());
        } else {
            this.setLeftMargin(maxTierLabelWidth + 3);
        }
        tier = null;
        rootTier = null;
        DefaultMutableTreeNode node = null;
        InterlinearAnnotation prann = null;
        long selBT = 0L;
        long selET = Long.MAX_VALUE;
        if (this.interlinearizer.isSelectionOnly() && this.interlinearizer.getSelection() != null && this.interlinearizer.getSelection()[0] != this.interlinearizer.getSelection()[1]) {
            selBT = this.interlinearizer.getSelection()[0];
            selET = this.interlinearizer.getSelection()[1];
        }
        for (int i = 0; i < relevantTopTiers.size(); ++i) {
            rootTier = (TierImpl)relevantTopTiers.get(i);
            List<AbstractAnnotation> annots = rootTier.getAnnotations();
            for (AbstractAnnotation ann : annots) {
                if (!TimeRelation.overlaps(ann, selBT, selET) || (node = this.interlinearizer.isEmptySlotsShown() ? creator.createBlockFillEmptyPositions(ann, this.visibleTiers) : creator.createBlockForAnnotation(ann, this.visibleTiers)) == null) continue;
                if ((this.interlinearizer.isTimeCodeShown() || this.interlinearizer.isPlaySoundSel() && this.interlinearizer.getOutputMode() == 103) && (prann = (InterlinearAnnotation)node.getUserObject()) != null) {
                    StringBuilder timeString = new StringBuilder();
                    if (this.interlinearizer.getTimeCodeType() == 0) {
                        timeString.append(TimeFormatter.toString(prann.bt));
                        timeString.append(" - ");
                        timeString.append(TimeFormatter.toString(prann.et));
                    } else if (this.interlinearizer.getTimeCodeType() == 1) {
                        timeString.append(TimeFormatter.toSSMSString(prann.bt));
                        timeString.append(" - ");
                        timeString.append(TimeFormatter.toSSMSString(prann.et));
                    } else {
                        timeString.append(prann.bt);
                        timeString.append(" - ");
                        timeString.append(prann.et);
                    }
                    String tcLabel = this.timecodeLabels.get(rootTier.getName());
                    InterlinearAnnotation tcAnn = new InterlinearAnnotation(timeString.toString(), tcLabel);
                    node.add(new DefaultMutableTreeNode(tcAnn));
                }
                this.annotationBlocks.add(node);
                this.calculateBlock(node, g);
            }
        }
        Collections.sort(this.annotationBlocks, new AnnotationNodeComparator());
        if (this.interlinearizer.isShowSilenceDuration()) {
            DefaultMutableTreeNode n = null;
            DefaultMutableTreeNode nextN = null;
            for (int i = 0; i < this.annotationBlocks.size(); ++i) {
                long dur;
                InterlinearAnnotation ann;
                String sdLabel;
                nextN = this.annotationBlocks.get(i);
                InterlinearAnnotation nextAnn = (InterlinearAnnotation)nextN.getUserObject();
                if (n != null && (sdLabel = this.silDurationLabels.get((ann = (InterlinearAnnotation)n.getUserObject()).getTierName())) != null && (dur = nextAnn.bt - ann.et) >= (long)this.interlinearizer.getMinSilenceDuration()) {
                    String silDur = null;
                    if (this.interlinearizer.getNumOfDecimalDigits() == 1) {
                        silDur = "(" + String.valueOf((float)Math.round((float)dur / 100.0f) / 10.0f) + ")";
                    } else if (this.interlinearizer.getNumOfDecimalDigits() == 2) {
                        silDur = "(" + String.valueOf((float)Math.round(dur / 10L) / 100.0f) + ")";
                    } else if (this.interlinearizer.getNumOfDecimalDigits() == 3) {
                        silDur = "(" + String.valueOf((float)Math.round(dur) / 1000.0f) + ")";
                    }
                    InterlinearAnnotation sdAnn = new InterlinearAnnotation(silDur, sdLabel);
                    n.add(new DefaultMutableTreeNode(sdAnn));
                    this.calculateBlock(n, g);
                }
                n = nextN;
            }
        }
    }

    public void calculatePrintBlocks() {
        TierImpl root;
        TierImpl t;
        String name;
        int i;
        ArrayList<String> done;
        if (this.annotationBlocks.size() == 0) {
            return;
        }
        if (this.interlinearizer.isTimeCodeShown() || this.interlinearizer.isPlaySoundSel()) {
            if (this.interlinearizer.getTimeCodeMultiplicity() == 0) {
                this.tierTemplate.add(this.createTCLabel(""));
            } else {
                done = new ArrayList<String>();
                for (i = this.tierTemplate.size() - 1; i >= 0; --i) {
                    name = this.tierTemplate.get(i);
                    t = (TierImpl)this.getTierWithId(name);
                    root = t.getRootTier();
                    if (done.contains(root.getName())) continue;
                    this.tierTemplate.add(i + 1, this.timecodeLabels.get(root.getName()));
                    done.add(root.getName());
                }
            }
        }
        if (this.interlinearizer.isShowSilenceDuration()) {
            done = new ArrayList();
            for (i = this.tierTemplate.size() - 1; i >= 0; --i) {
                name = this.tierTemplate.get(i);
                t = (TierImpl)this.getTierWithId(name);
                if (t == null || done.contains((root = t.getRootTier()).getName())) continue;
                if (this.interlinearizer.isTimeCodeShown()) {
                    this.tierTemplate.add(i + 2, this.silDurationLabels.get(root.getName()));
                    done.add(root.getName());
                    continue;
                }
                this.tierTemplate.add(i + 1, this.silDurationLabels.get(root.getName()));
                done.add(root.getName());
            }
        }
        switch (this.interlinearizer.getBlockWrapStyle()) {
            case 0: {
                this.calcPrintBlocksWrapEach();
                break;
            }
            case 1: {
                this.calcPrintBlocksWrapBoundary();
                break;
            }
            case 2: {
                this.calcPrintBlocksWrapWithin();
                break;
            }
            case 3: {
                this.calcPrintBlocksNoWrap();
                break;
            }
        }
        if (this.interlinearizer.getOutputMode() == 103) {
            this.addHiddenCellsAndColSpan();
        }
    }

    public void calculatePageBreaks() {
        this.pageBreaks.clear();
        if (this.printBlocks.size() == 0) {
            return;
        }
        InterlinearBlock curBlock = null;
        List<InterlinearTier> printTiers = null;
        int curPageHeight = 0;
        if (this.interlinearizer.getOutputMode() == 101 || this.interlinearizer.getOutputMode() == 102) {
            for (int block = 0; block < this.printBlocks.size(); ++block) {
                curBlock = this.printBlocks.get(block);
                curPageHeight += curBlock.getNumberOfLines() * 12;
                curPageHeight += this.interlinearizer.getBlockSpacing() * 12;
            }
            this.interlinearizer.setHeight(curPageHeight);
            curBlock = this.printBlocks.get(this.printBlocks.size() - 1);
            this.pageBreaks.add(new int[]{0, 0, this.printBlocks.size() - 1, curBlock.getNumberOfLines() - 1});
            return;
        }
        int pageHeight = this.interlinearizer.getPageHeight();
        if (this.interlinearizer.getOutputMode() == 100 && this.interlinearizer.isShowPageNumber()) {
            pageHeight -= this.interlinearizer.pageNumberAreaHeight;
        }
        int beginBlock = 0;
        int beginLine = 0;
        int line = 0;
        InterlinearTier curTier = null;
        for (int block = 0; block < this.printBlocks.size(); ++block) {
            curBlock = this.printBlocks.get(block);
            printTiers = curBlock.getPrintTiers();
            line = 0;
            for (int j = 0; j < printTiers.size(); ++j) {
                curTier = printTiers.get(j);
                for (int k = 0; k < curTier.getNumLines(); ++k) {
                    if ((curPageHeight += curTier.getPrintHeight()) > pageHeight) {
                        if (line == 0 && block > 0) {
                            InterlinearBlock prev = this.printBlocks.get(block - 1);
                            this.pageBreaks.add(new int[]{beginBlock, beginLine, block - 1, prev.getNumberOfLines() - 1});
                        } else {
                            this.pageBreaks.add(new int[]{beginBlock, beginLine, block, line - 1});
                        }
                        beginBlock = block;
                        beginLine = line;
                        curPageHeight = curTier.getPrintHeight();
                    }
                    if (k != curTier.getNumLines() - 1) {
                        curPageHeight += this.interlinearizer.getLineSpacing();
                    }
                    ++line;
                }
                if (j == printTiers.size() - 1) continue;
                curPageHeight += this.interlinearizer.getLineSpacing();
            }
            if (block != this.printBlocks.size() - 1) {
                curPageHeight += this.interlinearizer.getBlockSpacing();
                continue;
            }
            this.pageBreaks.add(new int[]{beginBlock, beginLine, block, line - 1});
        }
    }

    public List<InterlinearBlock> getPrintBlocks() {
        return this.printBlocks;
    }

    public List<int[]> getPageBreaks() {
        return this.pageBreaks;
    }

    private void printoutNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        Enumeration<TreeNode> nodeEnum = node.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)nodeEnum.nextElement();
            InterlinearAnnotation prann = (InterlinearAnnotation)curNode.getUserObject();
            System.out.println("T: " + prann.getTierName() + " A: " + prann.getValue() + " X: " + prann.x + " C: " + prann.calcWidth + " R: " + prann.realWidth);
            if (prann.nrOfLines <= 1) continue;
            System.out.println("Num lines: " + prann.nrOfLines);
            for (int i = 0; i < prann.nrOfLines; ++i) {
                System.out.println(i + " " + prann.getLines()[i]);
            }
        }
    }

    private void printoutPrintBlock(InterlinearBlock block) {
        if (block == null) {
            return;
        }
        System.out.println("New block:");
        List<InterlinearTier> pts = block.getPrintTiers();
        for (int i = 0; i < pts.size(); ++i) {
            InterlinearTier pt = pts.get(i);
            System.out.println("Tier: " + pt.getTierName());
            List<InterlinearAnnotation> anns = pt.getAnnotations();
            for (int j = 0; j < anns.size(); ++j) {
                InterlinearAnnotation pa = anns.get(j);
                if (pa.nrOfLines > 1) {
                    System.out.println("A: " + pa.getLines()[0]);
                    for (int k = 1; k < pa.nrOfLines; ++k) {
                        System.out.println("..." + pa.getLines()[k]);
                    }
                } else {
                    System.out.println("A: " + pa.getValue());
                }
                System.out.println("\tX: " + pa.x + " W: " + pa.calcWidth);
            }
        }
    }

    private void calculateBlock(DefaultMutableTreeNode rootNode, Graphics g) {
        int i;
        if (rootNode == null || g == null && this.interlinearizer.getAlignmentUnit() == 0) {
            return;
        }
        Enumeration<TreeNode> en = rootNode.breadthFirstEnumeration();
        ArrayList<DefaultMutableTreeNode> allNodes = new ArrayList<DefaultMutableTreeNode>();
        Font font = null;
        FontMetrics fontMetrics = null;
        DefaultMutableTreeNode curNode = null;
        DefaultMutableTreeNode otherNode = null;
        InterlinearAnnotation curAnn = null;
        InterlinearAnnotation otherAnn = null;
        boolean includeRootInCalculations = true;
        int availableWidth = Math.max(1, this.interlinearizer.getWidth() - this.getLeftMargin());
        while (en.hasMoreElements()) {
            curNode = (DefaultMutableTreeNode)en.nextElement();
            curAnn = (InterlinearAnnotation)curNode.getUserObject();
            if (curNode == rootNode && !this.visibleTiers.contains(this.getTierWithId(curAnn.getTierName()))) {
                includeRootInCalculations = false;
            }
            int size = 0;
            if (this.interlinearizer.getAlignmentUnit() == 0) {
                font = curAnn.type == 3 ? this.interlinearizer.getFont(curAnn.getTierName()) : this.interlinearizer.getFont(curAnn.getTierName());
                fontMetrics = g.getFontMetrics(font);
                size = Math.max(fontMetrics.stringWidth(curAnn.getValue()), this.interlinearizer.getEmptySpace());
            } else {
                size = curAnn.getValue().length();
                if (this.interlinearizer.getOutputMode() == 101) {
                    size -= this.getNumNonSpacingCharacters(curAnn.getValue());
                } else if (this.interlinearizer.getOutputMode() == 102) {
                    size += this.getNumExtraBytes(curAnn.getValue());
                }
            }
            if (curNode.isRoot() && !includeRootInCalculations) {
                curAnn.realWidth = 0;
                curAnn.calcWidth = 0;
            } else {
                curAnn.realWidth = size;
                curAnn.calcWidth = size;
            }
            if (this.interlinearizer.getBlockWrapStyle() != 3 && (this.interlinearizer.getLineWrapStyle() == 4 || this.interlinearizer.getLineWrapStyle() == 5) && curAnn.realWidth > availableWidth) {
                if (this.interlinearizer.getAlignmentUnit() == 0) {
                    this.splitAnnotation(curAnn, availableWidth, fontMetrics);
                } else {
                    this.splitAnnotation(curAnn, availableWidth);
                }
            }
            allNodes.add(curNode);
        }
        for (i = allNodes.size() - 1; i >= 0; --i) {
            curNode = (DefaultMutableTreeNode)allNodes.get(i);
            curAnn = (InterlinearAnnotation)curNode.getUserObject();
            if (curNode.getChildCount() == 0) continue;
            if (curNode.getChildCount() == 1) {
                otherNode = (DefaultMutableTreeNode)curNode.getFirstChild();
                otherAnn = (InterlinearAnnotation)otherNode.getUserObject();
                if (otherAnn.calcWidth > curAnn.calcWidth && curAnn.nrOfLines == 1) {
                    curAnn.calcWidth = otherAnn.calcWidth;
                    continue;
                }
                if (otherAnn.calcWidth >= curAnn.calcWidth || otherAnn.nrOfLines != 1) continue;
                otherAnn.calcWidth = curAnn.calcWidth;
                this.propagateSizeDown(otherNode);
                continue;
            }
            this.propagateSizeDown(curNode);
        }
        for (i = 0; i < allNodes.size(); ++i) {
            curNode = (DefaultMutableTreeNode)allNodes.get(i);
            if (i == 0) {
                curAnn = (InterlinearAnnotation)curNode.getUserObject();
                curAnn.x = 0;
            }
            this.calculateXPosDown(curNode);
        }
    }

    private void propagateSizeDown(DefaultMutableTreeNode rootNode) {
        if (rootNode == null) {
            return;
        }
        if (rootNode.getChildCount() == 1) {
            InterlinearAnnotation curAnn = (InterlinearAnnotation)rootNode.getUserObject();
            DefaultMutableTreeNode otherNode = (DefaultMutableTreeNode)rootNode.getFirstChild();
            InterlinearAnnotation otherAnn = (InterlinearAnnotation)otherNode.getUserObject();
            if (otherAnn.calcWidth > curAnn.calcWidth && curAnn.nrOfLines == 1) {
                curAnn.calcWidth = otherAnn.calcWidth;
            } else if (otherAnn.calcWidth < curAnn.calcWidth && otherAnn.nrOfLines == 1) {
                otherAnn.calcWidth = curAnn.calcWidth;
                if (otherNode.getChildCount() > 0) {
                    this.propagateSizeDown(otherNode);
                }
            }
        } else if (rootNode.getChildCount() > 1) {
            InterlinearAnnotation curAnn = (InterlinearAnnotation)rootNode.getUserObject();
            int maxWidth = curAnn.calcWidth;
            DefaultMutableTreeNode otherNode = null;
            DefaultMutableTreeNode prevNode = null;
            InterlinearAnnotation otherAnn = null;
            InterlinearAnnotation prevAnn = null;
            String tierName = null;
            String lastTierName = null;
            int widthPerTier = 0;
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                otherNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
                otherAnn = (InterlinearAnnotation)otherNode.getUserObject();
                tierName = otherAnn.getTierName();
                if (tierName == lastTierName) {
                    widthPerTier += this.interlinearizer.getEmptySpace() + otherAnn.calcWidth;
                } else if (lastTierName != null) {
                    if (widthPerTier > maxWidth) {
                        maxWidth = widthPerTier;
                    } else if (widthPerTier < curAnn.calcWidth && prevAnn.nrOfLines == 1) {
                        prevAnn.calcWidth += curAnn.calcWidth - widthPerTier;
                        if (prevNode.getChildCount() > 0) {
                            this.propagateSizeDown(prevNode);
                        }
                    }
                    widthPerTier = otherAnn.calcWidth;
                } else {
                    widthPerTier = otherAnn.calcWidth;
                }
                if (i == rootNode.getChildCount() - 1) {
                    if (widthPerTier > maxWidth) {
                        maxWidth = widthPerTier;
                    } else if (widthPerTier < curAnn.calcWidth && otherAnn.nrOfLines == 1) {
                        otherAnn.calcWidth += curAnn.calcWidth - widthPerTier;
                        if (otherNode.getChildCount() > 0) {
                            this.propagateSizeDown(otherNode);
                        }
                    }
                }
                lastTierName = tierName;
                prevAnn = otherAnn;
                prevNode = otherNode;
            }
            if (maxWidth > curAnn.calcWidth && curAnn.nrOfLines == 1) {
                curAnn.calcWidth = maxWidth;
                this.propagateSizeDown(rootNode);
            }
        }
    }

    private void calculateXPosDown(DefaultMutableTreeNode rootNode) {
        if (rootNode == null) {
            return;
        }
        if (rootNode.getChildCount() == 1) {
            InterlinearAnnotation curAnn = (InterlinearAnnotation)rootNode.getUserObject();
            DefaultMutableTreeNode otherNode = (DefaultMutableTreeNode)rootNode.getFirstChild();
            InterlinearAnnotation otherAnn = (InterlinearAnnotation)otherNode.getUserObject();
            otherAnn.x = curAnn.x;
            if (otherNode.getChildCount() > 0) {
                this.calculateXPosDown(otherNode);
            }
        } else if (rootNode.getChildCount() > 1) {
            InterlinearAnnotation curAnn = (InterlinearAnnotation)rootNode.getUserObject();
            DefaultMutableTreeNode otherNode = null;
            InterlinearAnnotation otherAnn = null;
            InterlinearAnnotation prevAnn = null;
            String tierName = null;
            String lastTierName = null;
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                otherNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
                otherAnn = (InterlinearAnnotation)otherNode.getUserObject();
                tierName = otherAnn.getTierName();
                otherAnn.x = tierName == lastTierName ? prevAnn.x + prevAnn.calcWidth + this.interlinearizer.getEmptySpace() : curAnn.x;
                if (otherNode.getChildCount() > 0) {
                    this.calculateXPosDown(otherNode);
                }
                lastTierName = tierName;
                prevAnn = otherAnn;
            }
        }
    }

    private void splitAnnotation(InterlinearAnnotation prAnn, int available, FontMetrics metrics) {
        ArrayList<String> lines;
        block12: {
            int estimatedNrLines = (int)Math.ceil(prAnn.realWidth / available);
            lines = new ArrayList<String>();
            if (estimatedNrLines <= 2) {
                String value = prAnn.getValue();
                int charIndex = value.length();
                int size = prAnn.realWidth;
                String temp = null;
                while (true) {
                    if ((charIndex = value.lastIndexOf(32, charIndex)) < 0) {
                        lines.add(value);
                        break block12;
                    }
                    temp = value.substring(0, charIndex);
                    size = metrics.stringWidth(temp);
                    if (size < available) {
                        lines.add(temp);
                        value = value.substring(charIndex + 1);
                        size = metrics.stringWidth(value);
                        if (size < available) {
                            lines.add(value);
                            break block12;
                        }
                        charIndex = value.length();
                        continue;
                    }
                    --charIndex;
                }
            }
            String value = prAnn.getValue();
            int charIndex = 0;
            int prevIndex = -1;
            int size = prAnn.realWidth;
            String temp = null;
            while (true) {
                if ((charIndex = value.indexOf(32, charIndex)) < 0) {
                    if (prevIndex > 0) {
                        temp = value.substring(0, prevIndex);
                        lines.add(temp);
                        value = value.substring(prevIndex + 1);
                        lines.add(value);
                        break;
                    }
                    lines.add(value);
                    break;
                }
                temp = value.substring(0, charIndex);
                size = metrics.stringWidth(temp);
                if (size > available) {
                    if (prevIndex < 0) {
                        lines.add(temp);
                        value = value.substring(charIndex + 1);
                        prevIndex = charIndex;
                        if (metrics.stringWidth(value) >= available) continue;
                        lines.add(value);
                        break;
                    }
                    temp = value.substring(0, prevIndex);
                    lines.add(temp);
                    value = value.substring(prevIndex + 1);
                    if (metrics.stringWidth(value) < available) {
                        lines.add(value);
                        break;
                    }
                    charIndex = 0;
                    prevIndex = -1;
                    continue;
                }
                prevIndex = charIndex++;
            }
        }
        if (lines.size() > 1) {
            prAnn.setLines(lines.toArray(new String[0]));
            prAnn.calcWidth = available;
            prAnn.realWidth = available;
        }
    }

    private void splitAnnotation(InterlinearAnnotation prAnn, int available) {
        String val = prAnn.getValue();
        if (val.indexOf(32) < 0 || val.length() < available) {
            return;
        }
        ArrayList<String> vals = new ArrayList<String>();
        String sub = null;
        while (val.length() > available) {
            sub = val.substring(0, available);
            int breakSpace = sub.lastIndexOf(32);
            if (breakSpace < 0) {
                breakSpace = val.indexOf(32);
                if (breakSpace < 0) {
                    vals.add(val);
                    break;
                }
                vals.add(val.substring(0, breakSpace + 1));
                val = val.substring(breakSpace + 1);
            } else {
                vals.add(sub.substring(0, breakSpace + 1));
                val = val.substring(breakSpace + 1);
            }
            if (val.length() > available) continue;
            vals.add(val);
            break;
        }
        if (vals.size() > 1) {
            prAnn.setLines(vals.toArray(new String[0]));
            prAnn.calcWidth = available;
            prAnn.realWidth = available;
        }
    }

    private String createTCLabel(String tierName) {
        if (tierName == null) {
            return null;
        }
        String label = tierName + "-TC";
        if (this.getTierWithId(label) == null) {
            return label;
        }
        for (int i = 0; i < 10; ++i) {
            String nl = label + i;
            if (this.getTierWithId(nl) != null) continue;
            return nl;
        }
        return null;
    }

    private String createSDLabel(String tierName) {
        if (tierName == null) {
            return null;
        }
        String label = tierName + "-SD";
        if (this.getTierWithId(label) == null) {
            return label;
        }
        for (int i = 0; i < 10; ++i) {
            String nl = label + i;
            if (this.getTierWithId(nl) != null) continue;
            return nl;
        }
        return null;
    }

    private InterlinearBlock createPrintBlock(List<String> names) {
        if (names == null) {
            return null;
        }
        ArrayList<InterlinearTier> printTiers = new ArrayList<InterlinearTier>(names.size());
        InterlinearTier pt = null;
        for (int i = 0; i < names.size(); ++i) {
            String tierName = names.get(i);
            pt = new InterlinearTier(tierName);
            pt.setMarginWidth(this.getLeftMargin());
            int height = this.getTierHeight(tierName);
            if (height != 0) {
                pt.setPrintHeight(height);
            }
            if (this.timecodeLabels.containsValue(tierName)) {
                pt.setTimeCode(true);
            }
            if (this.silDurationLabels.containsValue(tierName)) {
                pt.setSilDuration(true);
            }
            printTiers.add(pt);
        }
        if (printTiers.size() > 0) {
            return new InterlinearBlock(printTiers);
        }
        return null;
    }

    private void calcPrintBlocksNoWrap() {
        this.printBlocks.clear();
        InterlinearBlock currentBlock = this.createPrintBlock(this.tierTemplate);
        currentBlock.setStartOfAnnotationBlock(true);
        DefaultMutableTreeNode curNode = null;
        InterlinearAnnotation curAnn = null;
        for (int i = 0; i < this.annotationBlocks.size(); ++i) {
            curNode = this.annotationBlocks.get(i);
            curAnn = (InterlinearAnnotation)curNode.getUserObject();
            int w = curAnn.calcWidth;
            Enumeration<TreeNode> en = curNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                curNode = (DefaultMutableTreeNode)en.nextElement();
                curAnn = (InterlinearAnnotation)curNode.getUserObject();
                InterlinearTier pt = currentBlock.getPrintTier(curAnn.getTierName());
                int cur = pt.getPrintAdvance();
                if (cur != 0) {
                    curAnn.x = cur + this.interlinearizer.getEmptySpace();
                }
                this.addToPrintTier(pt, curAnn);
            }
            if (i == 0) {
                currentBlock.setOccupiedBlockWidth(w);
                continue;
            }
            currentBlock.setOccupiedBlockWidth(currentBlock.getOccupiedBlockWidth() + this.interlinearizer.getEmptySpace() + w);
        }
        if (this.interlinearizer.getEmptyLineStyle() == 1) {
            currentBlock.removeEmptyTiers();
            if (this.interlinearizer.isEmptySlotsShown()) {
                currentBlock.removeEmptySlotOnlyTiers();
            }
        }
        this.printBlocks.add(currentBlock);
    }

    private void calcPrintBlocksWrapEach() {
        this.printBlocks.clear();
        InterlinearBlock currentBlock = null;
        InterlinearTier pt = null;
        ArrayList<DefaultMutableTreeNode> leftovers = new ArrayList<DefaultMutableTreeNode>();
        DefaultMutableTreeNode curNode = null;
        InterlinearAnnotation curAnn = null;
        int availableWidth = this.interlinearizer.getWidth() - this.getLeftMargin();
        for (int i = 0; i < this.annotationBlocks.size(); ++i) {
            currentBlock = this.createPrintBlock(this.tierTemplate);
            currentBlock.setStartOfAnnotationBlock(true);
            this.printBlocks.add(currentBlock);
            leftovers.clear();
            curNode = this.annotationBlocks.get(i);
            Enumeration<TreeNode> en = curNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                curNode = (DefaultMutableTreeNode)en.nextElement();
                curAnn = (InterlinearAnnotation)curNode.getUserObject();
                pt = currentBlock.getPrintTier(curAnn.getTierName());
                if (curNode.isRoot()) {
                    this.addToPrintTier(pt, curAnn);
                    continue;
                }
                if (leftovers.contains(curNode.getParent())) {
                    leftovers.add(curNode);
                    continue;
                }
                if (curAnn.calcWidth > availableWidth) {
                    if (curAnn.x + curAnn.realWidth <= availableWidth) {
                        this.addToPrintTier(pt, curAnn);
                        continue;
                    }
                    leftovers.add(curNode);
                    continue;
                }
                if (curAnn.x + curAnn.calcWidth <= availableWidth) {
                    this.addToPrintTier(pt, curAnn);
                    continue;
                }
                leftovers.add(curNode);
            }
            if (this.interlinearizer.getEmptyLineStyle() == 1) {
                currentBlock.removeEmptyTiers();
                if (this.interlinearizer.isEmptySlotsShown()) {
                    currentBlock.removeEmptySlotOnlyTiers();
                }
            }
            HashMap<String, Integer> shifts = new HashMap<String, Integer>();
            while (leftovers.size() > 0) {
                this.getXShiftPerTopNode(leftovers, shifts);
                currentBlock = this.createPrintBlock(this.tierTemplate);
                ArrayList<DefaultMutableTreeNode> temp = new ArrayList<DefaultMutableTreeNode>();
                for (int k = 0; k < leftovers.size(); ++k) {
                    curNode = leftovers.get(k);
                    if (temp.contains(curNode.getParent())) {
                        temp.add(curNode);
                        continue;
                    }
                    curAnn = (InterlinearAnnotation)curNode.getUserObject();
                    pt = currentBlock.getPrintTier(curAnn.getTierName());
                    int xShift = shifts.get(curAnn.getTierName());
                    if (curAnn.x + curAnn.calcWidth - xShift <= availableWidth) {
                        curAnn.x -= xShift;
                        this.addToPrintTier(pt, curAnn);
                        continue;
                    }
                    if (curAnn.calcWidth > availableWidth) {
                        curAnn.x -= xShift;
                        this.addToPrintTier(pt, curAnn);
                        continue;
                    }
                    temp.add(curNode);
                }
                if (this.interlinearizer.getEmptyLineStyle() == 1) {
                    currentBlock.removeEmptyTiers();
                    if (this.interlinearizer.isEmptySlotsShown()) {
                        currentBlock.removeEmptySlotOnlyTiers();
                    }
                }
                this.printBlocks.add(currentBlock);
                leftovers = temp;
            }
        }
    }

    private void calcPrintBlocksWrapBoundary() {
        this.printBlocks.clear();
        InterlinearBlock currentBlock = this.createPrintBlock(this.tierTemplate);
        currentBlock.setStartOfAnnotationBlock(true);
        InterlinearTier pt = null;
        ArrayList<DefaultMutableTreeNode> leftovers = new ArrayList<DefaultMutableTreeNode>();
        DefaultMutableTreeNode curNode = null;
        InterlinearAnnotation curAnn = null;
        int availableWidth = this.interlinearizer.getWidth() - this.getLeftMargin();
        int xShift = 0;
        for (int i = 0; i < this.annotationBlocks.size(); ++i) {
            leftovers.clear();
            curNode = this.annotationBlocks.get(i);
            int blockwidth = 0;
            int curOccup = 0;
            Enumeration<TreeNode> en = curNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                int relWidth;
                curNode = (DefaultMutableTreeNode)en.nextElement();
                curAnn = (InterlinearAnnotation)curNode.getUserObject();
                pt = currentBlock.getPrintTier(curAnn.getTierName());
                if (curNode.isRoot()) {
                    blockwidth = curAnn.calcWidth;
                    if (blockwidth > availableWidth) {
                        blockwidth = availableWidth;
                    }
                    if ((curOccup = currentBlock.getOccupiedBlockWidth()) > 0) {
                        xShift = curOccup + this.interlinearizer.getEmptySpace();
                    }
                    if (i == 0 || curOccup == 0) {
                        this.addToPrintTier(pt, curAnn);
                        continue;
                    }
                    if (xShift + blockwidth <= availableWidth) {
                        if (curOccup > 0) {
                            curAnn.x += xShift;
                        }
                        this.addToPrintTier(pt, curAnn);
                        continue;
                    }
                    if (this.interlinearizer.getEmptyLineStyle() == 1) {
                        currentBlock.removeEmptyTiers();
                        if (this.interlinearizer.isEmptySlotsShown()) {
                            currentBlock.removeEmptySlotOnlyTiers();
                        }
                    }
                    this.printBlocks.add(currentBlock);
                    currentBlock = this.createPrintBlock(this.tierTemplate);
                    currentBlock.setStartOfAnnotationBlock(true);
                    pt = currentBlock.getPrintTier(curAnn.getTierName());
                    this.addToPrintTier(pt, curAnn);
                    xShift = 0;
                    continue;
                }
                if (leftovers.contains(curNode.getParent())) {
                    leftovers.add(curNode);
                    continue;
                }
                int n = relWidth = curAnn.calcWidth > availableWidth ? curAnn.realWidth : curAnn.calcWidth;
                if (curAnn.x + relWidth + xShift <= availableWidth) {
                    curAnn.x += xShift;
                    this.addToPrintTier(pt, curAnn);
                    continue;
                }
                leftovers.add(curNode);
            }
            if (leftovers.size() == 0) {
                currentBlock.setOccupiedBlockWidth(currentBlock.getOccupiedBlockWidth() + this.interlinearizer.getEmptySpace() + blockwidth);
                continue;
            }
            if (this.interlinearizer.getEmptyLineStyle() == 1) {
                currentBlock.removeEmptyTiers();
                if (this.interlinearizer.isEmptySlotsShown()) {
                    currentBlock.removeEmptySlotOnlyTiers();
                }
            }
            this.printBlocks.add(currentBlock);
            HashMap<String, Integer> shifts = new HashMap<String, Integer>();
            while (leftovers.size() > 0) {
                this.getXShiftPerTopNode(leftovers, shifts);
                currentBlock = this.createPrintBlock(this.tierTemplate);
                ArrayList<DefaultMutableTreeNode> temp = new ArrayList<DefaultMutableTreeNode>();
                for (int k = 0; k < leftovers.size(); ++k) {
                    curNode = leftovers.get(k);
                    if (temp.contains(curNode.getParent())) {
                        temp.add(curNode);
                        continue;
                    }
                    curAnn = (InterlinearAnnotation)curNode.getUserObject();
                    pt = currentBlock.getPrintTier(curAnn.getTierName());
                    xShift = shifts.get(curAnn.getTierName());
                    if (curAnn.x + curAnn.calcWidth - xShift <= availableWidth) {
                        curAnn.x -= xShift;
                        this.addToPrintTier(pt, curAnn);
                        continue;
                    }
                    if (curAnn.calcWidth > availableWidth) {
                        curAnn.x -= xShift;
                        this.addToPrintTier(pt, curAnn);
                        continue;
                    }
                    temp.add(curNode);
                }
                leftovers = temp;
                if (leftovers.size() > 0) {
                    if (this.interlinearizer.getEmptyLineStyle() == 1) {
                        currentBlock.removeEmptyTiers();
                        if (this.interlinearizer.isEmptySlotsShown()) {
                            currentBlock.removeEmptySlotOnlyTiers();
                        }
                    }
                    this.printBlocks.add(currentBlock);
                    continue;
                }
                currentBlock.setOccupiedBlockWidth(currentBlock.calculateOccupiedBlockWidth());
            }
        }
        if (!this.printBlocks.contains(currentBlock)) {
            if (this.interlinearizer.getEmptyLineStyle() == 1) {
                currentBlock.removeEmptyTiers();
                if (this.interlinearizer.isEmptySlotsShown()) {
                    currentBlock.removeEmptySlotOnlyTiers();
                }
            }
            this.printBlocks.add(currentBlock);
        }
    }

    private void calcPrintBlocksWrapWithin() {
        this.printBlocks.clear();
        InterlinearBlock currentBlock = this.createPrintBlock(this.tierTemplate);
        InterlinearTier pt = null;
        ArrayList<DefaultMutableTreeNode> leftovers = new ArrayList<DefaultMutableTreeNode>();
        DefaultMutableTreeNode curNode = null;
        InterlinearAnnotation curAnn = null;
        int availableWidth = this.interlinearizer.getWidth() - this.getLeftMargin();
        int xShift = 0;
        for (int i = 0; i < this.annotationBlocks.size(); ++i) {
            leftovers.clear();
            curNode = this.annotationBlocks.get(i);
            int relMaxWidth = this.getMaximumWidthOfFirstChildren(curNode);
            ArrayList<InterlinearAnnotation> firstChildren = this.getFirstChildrenOfRoot(curNode);
            int blockwidth = 0;
            int curOccup = 0;
            Enumeration<TreeNode> en = curNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                int relWidth;
                curNode = (DefaultMutableTreeNode)en.nextElement();
                curAnn = (InterlinearAnnotation)curNode.getUserObject();
                pt = currentBlock.getPrintTier(curAnn.getTierName());
                if (curNode.isRoot()) {
                    blockwidth = curAnn.calcWidth;
                    if (blockwidth > availableWidth) {
                        blockwidth = availableWidth;
                    }
                    if ((curOccup = currentBlock.getOccupiedBlockWidth()) > 0) {
                        xShift = curOccup + this.interlinearizer.getEmptySpace();
                    }
                    if (i == 0 || curOccup == 0) {
                        this.addToPrintTier(pt, curAnn);
                        continue;
                    }
                    if (xShift + relMaxWidth <= availableWidth) {
                        if (curOccup > 0) {
                            curAnn.x += xShift;
                        }
                        this.addToPrintTier(pt, curAnn);
                        continue;
                    }
                    if (this.interlinearizer.getEmptyLineStyle() == 1) {
                        currentBlock.removeEmptyTiers();
                        if (this.interlinearizer.isEmptySlotsShown()) {
                            currentBlock.removeEmptySlotOnlyTiers();
                        }
                    }
                    this.printBlocks.add(currentBlock);
                    currentBlock = this.createPrintBlock(this.tierTemplate);
                    pt = currentBlock.getPrintTier(curAnn.getTierName());
                    this.addToPrintTier(pt, curAnn);
                    xShift = 0;
                    continue;
                }
                if (leftovers.contains(curNode.getParent())) {
                    leftovers.add(curNode);
                    continue;
                }
                int n = relWidth = curAnn.calcWidth > availableWidth ? curAnn.realWidth : curAnn.calcWidth;
                if (curAnn.x + relWidth + xShift <= availableWidth) {
                    curAnn.x += xShift;
                    this.addToPrintTier(pt, curAnn);
                    continue;
                }
                if (firstChildren.contains(curAnn)) {
                    curAnn.x += xShift;
                    this.addToPrintTier(pt, curAnn);
                    continue;
                }
                leftovers.add(curNode);
            }
            if (leftovers.size() == 0) {
                currentBlock.setOccupiedBlockWidth(currentBlock.getOccupiedBlockWidth() + this.interlinearizer.getEmptySpace() + blockwidth);
                continue;
            }
            if (this.interlinearizer.getEmptyLineStyle() == 1) {
                currentBlock.removeEmptyTiers();
                if (this.interlinearizer.isEmptySlotsShown()) {
                    currentBlock.removeEmptySlotOnlyTiers();
                }
            }
            this.printBlocks.add(currentBlock);
            HashMap<String, Integer> shifts = new HashMap<String, Integer>();
            while (leftovers.size() > 0) {
                this.getXShiftPerTopNode(leftovers, shifts);
                currentBlock = this.createPrintBlock(this.tierTemplate);
                ArrayList<DefaultMutableTreeNode> temp = new ArrayList<DefaultMutableTreeNode>();
                for (int k = 0; k < leftovers.size(); ++k) {
                    curNode = leftovers.get(k);
                    if (temp.contains(curNode.getParent())) {
                        temp.add(curNode);
                        continue;
                    }
                    curAnn = (InterlinearAnnotation)curNode.getUserObject();
                    pt = currentBlock.getPrintTier(curAnn.getTierName());
                    xShift = shifts.get(curAnn.getTierName());
                    if (curAnn.x + curAnn.calcWidth - xShift <= availableWidth) {
                        curAnn.x -= xShift;
                        this.addToPrintTier(pt, curAnn);
                        continue;
                    }
                    if (curAnn.calcWidth > availableWidth) {
                        curAnn.x -= xShift;
                        this.addToPrintTier(pt, curAnn);
                        continue;
                    }
                    temp.add(curNode);
                }
                leftovers = temp;
                if (leftovers.size() > 0) {
                    if (this.interlinearizer.getEmptyLineStyle() == 1) {
                        currentBlock.removeEmptyTiers();
                        if (this.interlinearizer.isEmptySlotsShown()) {
                            currentBlock.removeEmptySlotOnlyTiers();
                        }
                    }
                    this.printBlocks.add(currentBlock);
                    continue;
                }
                currentBlock.setOccupiedBlockWidth(currentBlock.calculateOccupiedBlockWidth());
            }
        }
        if (!this.printBlocks.contains(currentBlock)) {
            if (this.interlinearizer.getEmptyLineStyle() == 1) {
                currentBlock.removeEmptyTiers();
                if (this.interlinearizer.isEmptySlotsShown()) {
                    currentBlock.removeEmptySlotOnlyTiers();
                }
            }
            this.printBlocks.add(currentBlock);
        }
    }

    private void addToPrintTier(InterlinearTier pt, InterlinearAnnotation prann) {
        if (pt != null && prann != null) {
            pt.addAnnotation(prann);
            if (prann.nrOfLines > pt.getNumLines()) {
                pt.setNumLines(prann.nrOfLines);
            }
        }
    }

    private void getXShiftPerTopNode(List<DefaultMutableTreeNode> printNodes, HashMap<String, Integer> shiftMap) {
        shiftMap.clear();
        InterlinearAnnotation prann = null;
        InterlinearAnnotation otherAnn = null;
        DefaultMutableTreeNode node = null;
        DefaultMutableTreeNode otherNode = null;
        ArrayList<DefaultMutableTreeNode> tempPerTier = new ArrayList<DefaultMutableTreeNode>();
        if (printNodes != null) {
            int i;
            if (printNodes.size() == 0) {
                return;
            }
            for (i = 0; i < printNodes.size(); ++i) {
                node = printNodes.get(i);
                prann = (InterlinearAnnotation)node.getUserObject();
                if (shiftMap.containsKey(prann.getTierName())) continue;
                shiftMap.put(prann.getTierName(), prann.x);
                tempPerTier.add(node);
            }
            for (i = 0; i < tempPerTier.size(); ++i) {
                node = (DefaultMutableTreeNode)tempPerTier.get(i);
                for (int j = 0; j < tempPerTier.size(); ++j) {
                    otherNode = (DefaultMutableTreeNode)tempPerTier.get(j);
                    if (node == otherNode) continue;
                    prann = (InterlinearAnnotation)node.getUserObject();
                    otherAnn = (InterlinearAnnotation)otherNode.getUserObject();
                    if (!this.isTierAncestor(prann.getTierName(), otherAnn.getTierName())) continue;
                    shiftMap.put(otherAnn.getTierName(), prann.x);
                }
            }
        }
    }

    private boolean isTierAncestor(String tier, String otherTier) {
        if (this.tierTree == null) {
            return false;
        }
        DefaultMutableTreeNode node = null;
        DefaultMutableTreeNode otherNode = null;
        Enumeration<TreeNode> en = this.tierTree.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode temp = (DefaultMutableTreeNode)en.nextElement();
            if (temp.getUserObject() == tier) {
                node = temp;
            }
            if (temp.getUserObject() != otherTier) continue;
            otherNode = temp;
        }
        if (node == null || otherNode == null) {
            return false;
        }
        return otherNode.isNodeAncestor(node);
    }

    private ArrayList<InterlinearAnnotation> getFirstChildrenOfRoot(DefaultMutableTreeNode root) {
        ArrayList<InterlinearAnnotation> list = new ArrayList<InterlinearAnnotation>();
        InterlinearAnnotation prann = null;
        if (root != null) {
            prann = (InterlinearAnnotation)root.getUserObject();
            DefaultMutableTreeNode otherNode = null;
            String tierName = null;
            String lastTierName = null;
            for (int i = 0; i < root.getChildCount(); ++i) {
                otherNode = (DefaultMutableTreeNode)root.getChildAt(i);
                prann = (InterlinearAnnotation)otherNode.getUserObject();
                tierName = prann.getTierName();
                if (tierName == lastTierName) continue;
                list.add(prann);
                lastTierName = tierName;
            }
        }
        return list;
    }

    private int getMaximumWidthOfFirstChildren(DefaultMutableTreeNode root) {
        int width = 0;
        InterlinearAnnotation prann = null;
        if (root != null) {
            prann = (InterlinearAnnotation)root.getUserObject();
            width = prann.realWidth;
            DefaultMutableTreeNode otherNode = null;
            String tierName = null;
            String lastTierName = null;
            for (int i = 0; i < root.getChildCount(); ++i) {
                otherNode = (DefaultMutableTreeNode)root.getChildAt(i);
                prann = (InterlinearAnnotation)otherNode.getUserObject();
                tierName = prann.getTierName();
                if (tierName == lastTierName) continue;
                int cw = prann.realWidth;
                if (cw > width) {
                    width = cw;
                }
                lastTierName = tierName;
            }
        }
        return width;
    }

    private void addHiddenCellsAndColSpan() {
        if (this.printBlocks.size() == 0) {
            return;
        }
        int maxw = 0;
        int pw = this.interlinearizer.getWidth() - this.getLeftMargin();
        for (int i = 0; i < this.printBlocks.size(); ++i) {
            InterlinearAnnotation ia;
            InterlinearTier pt;
            int j;
            InterlinearBlock block = this.printBlocks.get(i);
            maxw = 0;
            for (j = 0; j < block.getPrintTiers().size(); ++j) {
                pt = block.getPrintTiers().get(j);
                if (pt.getAnnotations().size() > 0) {
                    ia = pt.getAnnotations().get(pt.getAnnotations().size() - 1);
                    if (ia.x + ia.realWidth > maxw) {
                        maxw = ia.x + ia.realWidth;
                    }
                }
                if (pt.getPrintWidth() > maxw && pt.getPrintWidth() > pw) continue;
            }
            for (j = 0; j < block.getPrintTiers().size(); ++j) {
                pt = block.getPrintTiers().get(j);
                for (int k = pt.getAnnotations().size() - 1; k >= 0; --k) {
                    InterlinearAnnotation nextIA;
                    ia = pt.getAnnotations().get(k);
                    if (k == pt.getAnnotations().size() - 1 && ia.x + ia.calcWidth + this.interlinearizer.getEmptySpace() < maxw) {
                        nextIA = new InterlinearAnnotation(pt.getTierName(), 1);
                        nextIA.x = ia.x + ia.calcWidth + this.interlinearizer.getEmptySpace();
                        nextIA.calcWidth = maxw - nextIA.x;
                        nextIA.hidden = true;
                        pt.getAnnotations().add(nextIA);
                    }
                    if (k == 0) {
                        if (ia.x <= this.interlinearizer.getEmptySpace()) continue;
                        nextIA = new InterlinearAnnotation(pt.getTierName(), 1);
                        nextIA.x = 0;
                        nextIA.calcWidth = ia.x - this.interlinearizer.getEmptySpace();
                        nextIA.hidden = true;
                        pt.getAnnotations().add(0, nextIA);
                        continue;
                    }
                    InterlinearAnnotation iaPrev = pt.getAnnotations().get(k - 1);
                    if (ia.x <= iaPrev.x + iaPrev.calcWidth + 2 * this.interlinearizer.getEmptySpace()) continue;
                    nextIA = new InterlinearAnnotation(pt.getTierName(), 1);
                    nextIA.x = iaPrev.x + iaPrev.calcWidth + this.interlinearizer.getEmptySpace();
                    nextIA.calcWidth = ia.x - this.interlinearizer.getEmptySpace() - nextIA.x;
                    nextIA.hidden = true;
                    pt.getAnnotations().add(k, nextIA);
                }
            }
            ArrayList<Integer> xValues = new ArrayList<Integer>();
            maxw = pw;
            for (int k = 0; k < block.getPrintTiers().size(); ++k) {
                pt = block.getPrintTiers().get(k);
                for (int j2 = 0; j2 < pt.getAnnotations().size(); ++j2) {
                    ia = pt.getAnnotations().get(j2);
                    Integer xInt = ia.x;
                    if (xValues.contains(xInt)) continue;
                    xValues.add(xInt);
                }
            }
            Integer xInt = maxw;
            if (!xValues.contains(xInt)) {
                xValues.add(xInt);
            }
            Collections.sort(xValues);
            int lastv = 0;
            for (int k = 1; k < xValues.size(); ++k) {
                xInt = (Integer)xValues.get(k);
                if (xInt - lastv <= this.interlinearizer.getEmptySpace()) {
                    xValues.remove(k);
                    --k;
                    continue;
                }
                lastv = xInt;
            }
            int[] xval = new int[xValues.size()];
            for (int k = 0; k < xval.length; ++k) {
                xInt = (Integer)xValues.get(k);
                xval[k] = xInt;
            }
            for (int n = 0; n < block.getPrintTiers().size(); ++n) {
                pt = block.getPrintTiers().get(n);
                int usedCol = 0;
                for (int j3 = 0; j3 < pt.getAnnotations().size(); ++j3) {
                    ia = pt.getAnnotations().get(j3);
                    int col = 1;
                    int b = 0;
                    int e = 0;
                    int w = Math.min(ia.x + ia.calcWidth, maxw);
                    if (j3 == pt.getAnnotations().size() - 1) {
                        col = xval.length - 1 - usedCol;
                    } else {
                        w += this.interlinearizer.getEmptySpace();
                        for (int k = usedCol; k < xval.length; ++k) {
                            if (Math.abs(ia.x - xval[k]) <= this.interlinearizer.getEmptySpace()) {
                                b = k;
                                continue;
                            }
                            if (Math.abs(w - xval[k]) > this.interlinearizer.getEmptySpace()) continue;
                            e = k;
                            break;
                        }
                        if ((col = e - b) < 1) {
                            col = 1;
                        }
                        usedCol += col;
                    }
                    ia.colSpan = col;
                }
            }
        }
    }

    private int getNumNonSpacingCharacters(String value) {
        char[] chars;
        if (value == null || value.length() == 0) {
            return 0;
        }
        int count = 0;
        for (char c : chars = value.toCharArray()) {
            if (!this.isNonSpacing(c)) continue;
            ++count;
        }
        return count;
    }

    private int getNumExtraBytes(String value) {
        char[] chars;
        if (value == null || value.length() == 0) {
            return 0;
        }
        int count = 0;
        for (char c : chars = value.toCharArray()) {
            count += this.getNumExtraBytes(c);
        }
        return count;
    }

    private boolean isNonSpacing(char c) {
        int type = Character.getType(c);
        return type == 6 || type == 7 || type == 8;
    }

    private int getNumExtraBytes(char c) {
        if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
            return 1;
        }
        if (c >= '\u0800' && c <= '\uffff') {
            return 2;
        }
        return 0;
    }

    Tier getTierWithId(String name) {
        return this.transcription.getTierWithId(name);
    }

    public void setTierHeight(String tierName, int tierHeight) {
        this.tierHeights.put(tierName, tierHeight);
    }

    public int getTierHeight(String forTier) {
        Integer i = this.tierHeights.get(forTier);
        if (i != null) {
            return i;
        }
        return 0;
    }

    public int getLeftMargin() {
        if (this.interlinearizer.isTierLabelsShown()) {
            return this.leftMargin;
        }
        return 0;
    }

    public void setLeftMargin(int i) {
        this.leftMargin = i;
    }

    class AnnotationNodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        AnnotationNodeComparator() {
        }

        @Override
        public int compare(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
            InterlinearAnnotation a1 = (InterlinearAnnotation)o1.getUserObject();
            InterlinearAnnotation a2 = (InterlinearAnnotation)o2.getUserObject();
            if (a1.bt < a2.bt) {
                return -1;
            }
            if (a1.bt > a2.bt) {
                return 1;
            }
            if (a1.et < a2.et) {
                return -1;
            }
            if (a1.et > a2.et) {
                return 1;
            }
            return 0;
        }
    }
}

