/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import mpi.eudico.client.annotator.interlinear.Interlinear;
import mpi.eudico.client.annotator.interlinear.InterlinearAnnotation;
import mpi.eudico.client.annotator.interlinear.InterlinearBlock;
import mpi.eudico.client.annotator.interlinear.InterlinearTier;

public class CharacterRenderer {
    private final String NEW_LINE = "\n";
    private final String SPACE = " ";
    private final String TAB = "\t";
    private Interlinear interlinear;
    private File outFile;
    private String charEncoding;

    public CharacterRenderer(Interlinear interlinear, File outFile) {
        this(interlinear, outFile, "UTF-8");
    }

    public CharacterRenderer(Interlinear interlinear, File outFile, String charEncoding) {
        this.interlinear = interlinear;
        this.outFile = outFile;
        this.charEncoding = charEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderText() throws IOException, FileNotFoundException {
        if (this.interlinear == null) {
            throw new NullPointerException("Interlinear object is null");
        }
        if (this.outFile == null) {
            throw new NullPointerException("Export file is null");
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(this.outFile);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, this.charEncoding);
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            writer.write(this.interlinear.getTranscription().getFullPath());
            writer.write("\n");
            writer.write(DateFormat.getDateTimeInstance(0, 3, Locale.getDefault()).format(new Date(System.currentTimeMillis())));
            writer.write("\n");
            writer.write("\n");
            List<InterlinearBlock> blocks = this.interlinear.getMetrics().getPrintBlocks();
            InterlinearBlock printBlock = null;
            List<InterlinearTier> tiers = null;
            InterlinearTier pt = null;
            for (int i = 0; i < blocks.size(); ++i) {
                int j;
                printBlock = blocks.get(i);
                tiers = printBlock.getPrintTiers();
                for (j = 0; j < tiers.size(); ++j) {
                    pt = tiers.get(j);
                    this.renderTier(this.interlinear, pt, writer);
                }
                for (j = 0; j < this.interlinear.getBlockSpacing(); ++j) {
                    writer.write("\n");
                }
            }
            writer.flush();
            writer.close();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void renderTier(Interlinear inter, InterlinearTier pt, Writer writer) throws IOException {
        if (inter.isTierLabelsShown() || inter.isShowSilenceDuration()) {
            String label = pt.isTimeCode() ? inter.getMetrics().TC_TIER_NAME : (pt.isSilDuration() ? inter.getMetrics().SD_TIER_NAME : pt.getTierName());
            writer.write(label);
            this.padSpacesAndOrTab(writer, inter, inter.getMetrics().getLeftMargin() - label.length());
        }
        List<InterlinearAnnotation> annos = pt.getAnnotations();
        InterlinearAnnotation prevPa = null;
        for (int i = 0; i < annos.size(); ++i) {
            InterlinearAnnotation pa = annos.get(i);
            if (prevPa != null) {
                int pad = pa.x - (prevPa.x + prevPa.realWidth);
                this.padSpacesAndOrTab(writer, inter, pad);
            }
            if (pa.nrOfLines == 1) {
                writer.write(pa.getValue());
            } else {
                int numLines = pa.getLines().length;
                for (int line = 0; line < numLines; ++line) {
                    if (line == 0) {
                        writer.write(pa.getLines()[line]);
                        if (line == numLines - 1) continue;
                        writer.write("\n");
                        continue;
                    }
                    if (inter.isTierLabelsShown()) {
                        this.padSpacesAndOrTab(writer, inter, inter.getMetrics().getLeftMargin());
                    }
                    writer.write(pa.getLines()[line]);
                    if (line == numLines - 1) continue;
                    writer.write("\n");
                }
            }
            prevPa = pa;
        }
        writer.write("\n");
    }

    private void padSpacesAndOrTab(Writer writer, Interlinear inter, int pad) throws IOException {
        if (!inter.isInsertTabs() || inter.isInsertTabs() && !inter.isTabsReplaceSpaces()) {
            this.padSpaces(writer, pad);
        }
        if (inter.isInsertTabs()) {
            writer.write("\t");
        }
    }

    private void padSpaces(Writer writer, int numSpaces) throws IOException {
        if (numSpaces <= 0) {
            return;
        }
        for (int i = 0; i < numSpaces; ++i) {
            writer.write(" ");
        }
    }
}

