/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mpi.eudico.client.annotator.interlinear.HTMLRenderer;
import mpi.eudico.client.annotator.interlinear.Interlinear;

public class PreviewPanel
extends JPanel
implements ComponentListener,
AdjustmentListener {
    private Interlinear interlinear;
    private BufferedImage bi;
    private ImagePanel drawPanel;
    private JScrollPane scrollPane;
    private int[] offset = new int[]{0, 0};
    private Dimension visibleDimensions = new Dimension(550, 600);
    private JEditorPane htmlPanel;
    private HTMLRenderer htmlRenderer;

    public PreviewPanel(Interlinear interlinear) {
        this.interlinear = interlinear;
        this.initComponents();
    }

    private void initComponents() {
        if (this.interlinear.getOutputMode() == 103) {
            this.htmlRenderer = new HTMLRenderer(this.interlinear);
            this.htmlPanel = new JEditorPane();
            this.htmlPanel.setContentType("text/html");
            this.htmlPanel.setEditable(false);
            this.scrollPane = new JScrollPane(this.htmlPanel);
        } else {
            this.drawPanel = new ImagePanel();
            this.scrollPane = new JScrollPane(this.drawPanel);
        }
        this.scrollPane.setPreferredSize(this.visibleDimensions);
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(12);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(12);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.scrollPane, gbc);
        if (this.interlinear.getOutputMode() == 103) {
            this.createBufferedImage(10, 10);
        } else {
            this.createBufferedImage(this.visibleDimensions.width, this.visibleDimensions.height);
        }
        this.addComponentListener(this);
    }

    private void createBufferedImage(int width, int height) {
        if (this.bi == null || this.bi.getWidth() < width || this.bi.getHeight() < height) {
            this.bi = new BufferedImage(width, height, 1);
            this.repaint();
        }
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    public int[] getOffset() {
        return this.offset;
    }

    public void setImageableSize(Dimension size) {
        if (this.drawPanel != null) {
            this.drawPanel.setPreferredSize(size);
            this.drawPanel.revalidate();
        }
    }

    public void updateView() {
        if (this.interlinear.getOutputMode() == 103) {
            this.htmlPanel.setText(this.htmlRenderer.renderToText());
        } else {
            this.drawPanel.setPreferredSize(new Dimension(this.interlinear.getWidth(), this.interlinear.getHeight()));
            this.drawPanel.revalidate();
            this.interlinear.drawViewOnImage(this.bi, this.offset);
        }
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.interlinear.getOutputMode() != 103) {
            this.createBufferedImage(this.getWidth(), this.getHeight());
            this.interlinear.drawViewOnImage(this.bi, this.offset);
        }
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.offset[0] = this.scrollPane.getHorizontalScrollBar().getValue();
        this.offset[1] = this.scrollPane.getVerticalScrollBar().getValue();
        if (this.interlinear.getOutputMode() != 103) {
            this.interlinear.drawViewOnImage(this.bi, this.offset);
        }
        this.repaint();
    }

    private class ImagePanel
    extends JPanel {
        private ImagePanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (PreviewPanel.this.bi != null) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.drawImage((Image)PreviewPanel.this.bi, PreviewPanel.this.offset[0], PreviewPanel.this.offset[1], null);
            }
        }
    }
}

