/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.List;
import mpi.eudico.client.annotator.interlinear.EmptyPrintTier;
import mpi.eudico.client.annotator.interlinear.Interlinear;
import mpi.eudico.client.annotator.interlinear.InterlinearAnnotation;
import mpi.eudico.client.annotator.interlinear.InterlinearBlock;
import mpi.eudico.client.annotator.interlinear.InterlinearTier;
import mpi.eudico.client.annotator.interlinear.ToolboxMetrics;
import mpi.eudico.client.annotator.interlinear.ToolboxRecordBlock;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxEncoderInfo;

public class ToolboxRenderer
implements ClientLogger {
    private final String NEW_LINE = "\n";
    private final String SPACE = " ";
    private final char SPACE_CH = (char)32;
    private final String B_S = "\\";
    private final char U_S = (char)95;

    public void renderText(Writer writer, Interlinear interlinear, ToolboxEncoderInfo tei) throws IOException {
        if (writer == null) {
            LOG.severe("Writer object is null");
            throw new NullPointerException("Writer object is null");
        }
        if (interlinear == null) {
            LOG.severe("The interlinear object is null");
            throw new NullPointerException("The interlinear object is null");
        }
        ToolboxMetrics metrics = (ToolboxMetrics)interlinear.getMetrics();
        metrics.setVisibleMarkerNames(tei.getOrderedVisibleTiers());
        metrics.setMarkersWithBlankLine(tei.getMarkersWithBlankLines());
        if (tei.isIncludeMediaMarker()) {
            metrics.setMediaMarker(tei.getMediaMarker());
            metrics.setMediaURL(tei.getMediaFileName());
        }
        metrics.calculateAnnotationBlocks(null);
        metrics.calculatePrintBlocks();
        this.renderBlocks(writer, interlinear, tei);
    }

    private void renderBlocks(Writer writer, Interlinear interlinear, ToolboxEncoderInfo tei) throws IOException {
        ToolboxMetrics metrics = (ToolboxMetrics)interlinear.getMetrics();
        int numPos = 3;
        int numBlocks = metrics.getToolboxBlocks().size();
        if (numBlocks > 999) {
            String nm = String.valueOf(numBlocks);
            numPos = nm.length();
        }
        StringBuilder sb = new StringBuilder("#");
        for (int i = 0; i < numPos; ++i) {
            sb.append("0");
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        if (metrics.getToolboxBlocks() != null) {
            List<ToolboxRecordBlock> blocks = metrics.getToolboxBlocks();
            ToolboxRecordBlock printBlock = null;
            InterlinearTier pt = null;
            String recMarker = null;
            int count = 1;
            for (int i = 0; i < blocks.size(); ++i) {
                printBlock = blocks.get(i);
                if (printBlock.getPrintTiers().size() <= 0) continue;
                pt = printBlock.getPrintTiers().get(0);
                if (pt.getTierName().equals(tei.getRecordMarker())) {
                    this.renderToolboxBlock(writer, printBlock, metrics, tei, null);
                    continue;
                }
                recMarker = "\\" + tei.getRecordMarker() + " " + df.format(count++);
                this.renderToolboxBlock(writer, printBlock, metrics, tei, recMarker);
            }
        } else {
            List<InterlinearBlock> blocks = metrics.getPrintBlocks();
            InterlinearBlock printBlock = null;
            String recMarker = null;
            int count = 1;
            for (int i = 0; i < blocks.size(); ++i) {
                printBlock = blocks.get(i);
                if (printBlock.getPrintTier(tei.getRecordMarker()) == null && printBlock.isStartOfAnnotationBlock()) {
                    recMarker = "\\" + tei.getRecordMarker() + " " + df.format(count++);
                }
                this.renderBlock(writer, printBlock, metrics, tei, recMarker);
            }
        }
    }

    private void renderToolboxBlock(Writer writer, ToolboxRecordBlock block, ToolboxMetrics metrics, ToolboxEncoderInfo tei, String recMarker) throws IOException {
        List<InterlinearTier> tiers = null;
        InterlinearTier tier = null;
        InterlinearTier pt = null;
        if (recMarker != null) {
            writer.write(recMarker);
            writer.write("\n");
            if (metrics.isMarkerWithBlankLine(tei.getRecordMarker())) {
                writer.write("\n");
            }
        }
        tiers = block.getPrintTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            tier = tiers.get(i);
            if (tier instanceof EmptyPrintTier) {
                writer.write("\n");
                continue;
            }
            pt = tier;
            if (pt.getAnnotations().size() == 0 && !tei.isIncludeEmptyMarkers()) continue;
            this.renderTier(writer, pt);
            if (!metrics.isMarkerWithBlankLine(pt.getTierName())) continue;
            if (i < tiers.size() - 1) {
                if (tiers.get(i + 1) instanceof EmptyPrintTier) continue;
                writer.write("\n");
                continue;
            }
            writer.write("\n");
        }
        writer.write("\n");
    }

    private void renderTier(Writer writer, InterlinearTier pt) throws IOException {
        List<InterlinearAnnotation> annos = pt.getAnnotations();
        InterlinearAnnotation pa = null;
        InterlinearAnnotation prevPa = null;
        writer.write("\\" + pt.getTierName().replace(' ', '_') + " ");
        for (int i = 0; i < annos.size(); ++i) {
            pa = annos.get(i);
            if (pa.nrOfLines == 1) {
                int pad = 0;
                pad = prevPa != null ? pa.x - (prevPa.x + prevPa.realWidth) : pa.x;
                this.padSpaces(writer, pad);
                writer.write(pa.getValue());
            } else {
                for (int line = 0; line < pa.getLines().length; ++line) {
                    if (line == 0) {
                        writer.write(pa.getLines()[line]);
                        if (line == pa.getLines().length - 1) continue;
                        writer.write("\n");
                        continue;
                    }
                    writer.write(pa.getLines()[line]);
                    if (line == pa.getLines().length - 1) continue;
                    writer.write("\n");
                }
            }
            prevPa = pa;
        }
        writer.write("\n");
    }

    private void renderBlock(Writer writer, InterlinearBlock block, ToolboxMetrics metrics, ToolboxEncoderInfo tei, String recMarker) throws IOException {
        List<InterlinearTier> tiers = null;
        InterlinearTier pt = null;
        if (recMarker != null && block.isStartOfAnnotationBlock()) {
            writer.write(recMarker);
            writer.write("\n");
            if (metrics.isMarkerWithBlankLine(tei.getRecordMarker())) {
                writer.write("\n");
            }
        }
        tiers = block.getPrintTiers();
        int numIterstions = 1;
        boolean wrapEndOfBlock = false;
        for (int j = 0; j < numIterstions; ++j) {
            for (int i = 0; i < tiers.size(); ++i) {
                pt = tiers.get(i);
                if (pt.getAnnotations().size() == 0 && (!tei.isIncludeEmptyMarkers() || !block.isStartOfAnnotationBlock())) continue;
                this.renderTier(writer, pt, j, wrapEndOfBlock);
                if (!metrics.isMarkerWithBlankLine(pt.getTierName())) continue;
                writer.write("\n");
            }
        }
        writer.write("\n");
    }

    private void renderTier(Writer writer, InterlinearTier pt, int lineIndex, boolean wrapEndOfBlock) throws IOException {
        List<InterlinearAnnotation> annos = pt.getAnnotations();
        InterlinearAnnotation pa = null;
        InterlinearAnnotation prevPa = null;
        if (!wrapEndOfBlock) {
            writer.write("\\" + pt.getTierName().replace(' ', '_') + " ");
            for (int i = 0; i < annos.size(); ++i) {
                pa = annos.get(i);
                if (pa.nrOfLines == 1) {
                    int pad = 0;
                    pad = prevPa != null ? pa.x - (prevPa.x + prevPa.realWidth) : pa.x;
                    this.padSpaces(writer, pad);
                    writer.write(pa.getValue());
                } else {
                    for (int line = 0; line < pa.getLines().length; ++line) {
                        if (line == 0) {
                            writer.write(pa.getLines()[line]);
                            if (line == pa.getLines().length - 1) continue;
                            writer.write("\n");
                            continue;
                        }
                        writer.write(pa.getLines()[line]);
                        if (line == pa.getLines().length - 1) continue;
                        writer.write("\n");
                    }
                }
                prevPa = pa;
            }
        } else {
            if (lineIndex >= pt.getNumLines()) {
                return;
            }
            writer.write("\\" + pt.getTierName().replace(' ', '_') + " ");
            for (int i = 0; i < annos.size(); ++i) {
                pa = annos.get(i);
                if (pa.nrOfLines == 1 && lineIndex == 0) {
                    int pad = 0;
                    pad = prevPa != null ? pa.x - (prevPa.x + prevPa.realWidth) : pa.x;
                    this.padSpaces(writer, pad);
                    writer.write(pa.getValue());
                } else if (pa.nrOfLines > lineIndex) {
                    writer.write(pa.getLines()[lineIndex]);
                }
                prevPa = pa;
            }
        }
        writer.write("\n");
    }

    private void padSpaces(Writer writer, int numSpaces) throws IOException {
        if (numSpaces <= 0) {
            return;
        }
        for (int i = 0; i < numSpaces; ++i) {
            writer.write(" ");
        }
    }
}

