/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import mpi.eudico.client.annotator.interlinear.IGTTierType;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTDataModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTNode;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTSuggestionModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTTier;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTNodeRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTSuggestionViewerRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTViewerRenderInfo;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;

public class IGTCalculator
implements ClientLogger {
    private static final int MIN_ANNOTATION_PIXEL_WIDTH = 10;

    private IGTCalculator() {
    }

    public static int calculateTierYPosition(Graphics g2d, IGTViewerRenderInfo viewerRenderInfo, IGTTier tier, int yPosStart) {
        int lineHeight = viewerRenderInfo.getHeightForTier(g2d, tier.getTierName());
        tier.getRenderInfo().y = yPosStart;
        int totHeight = 0;
        int numLines = tier.getRenderInfo().getNumLines();
        totHeight += numLines * lineHeight;
        tier.getRenderInfo().height = lineHeight;
        tier.getRenderInfo().renderHeight = totHeight += (numLines - 1) * viewerRenderInfo.vertLineMargin;
        for (int i = 0; i < tier.getAnnotations().size(); ++i) {
            IGTAnnotation igtAnn = tier.getAnnotations().get(i);
            igtAnn.getRenderInfo().y = yPosStart;
            igtAnn.getRenderInfo().height = totHeight;
        }
        return totHeight += viewerRenderInfo.vertLineMargin;
    }

    public static int calculateTierYPositionRecursive(Graphics g2d, IGTViewerRenderInfo viewerRenderInfo, IGTTier tier, int yPosStart) {
        int curHeight = viewerRenderInfo.getHeightForTier(g2d, tier.getTierName());
        tier.getRenderInfo().clearYPositions();
        tier.getRenderInfo().y = yPosStart;
        tier.getRenderInfo().height = curHeight;
        int totHeight = 0;
        int numBlocks = 1;
        List<Integer> wrapIndices = tier.getRenderInfo().getWrapIndices();
        if (wrapIndices != null) {
            numBlocks = wrapIndices.size() + 1;
        }
        int tempY = yPosStart;
        List<IGTTier> descendants = tier.getDescendantTiers();
        for (int j = 0; j < numBlocks; ++j) {
            tier.getRenderInfo().addYPosition(tempY);
            int minA = 0;
            ArrayList<IGTAnnotation> annotations = tier.getAnnotations();
            int numAnnotations = annotations.size();
            int maxA = numAnnotations - 1;
            if (maxA < 0) {
                // empty if block
            }
            if (j > 0) {
                minA = wrapIndices.get(j - 1);
            }
            if (j < numBlocks - 1) {
                maxA = wrapIndices.get(j) - 1;
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(String.format("Y: calculateTierYPositionRecursive: minA=%d, maxA=%d", minA, maxA));
            }
            for (int a = minA; a <= maxA; ++a) {
                IGTAnnotation igtAnn = annotations.get(a);
                igtAnn.getRenderInfo().y = tempY;
                igtAnn.getRenderInfo().height = curHeight;
                if (!LOG.isLoggable(Level.FINER)) continue;
                LOG.finer(String.format("Y: calculateTierYPositionRecursive: a=%d, y=%d\n%s", a, tempY, igtAnn.toString()));
            }
            tempY += curHeight + viewerRenderInfo.vertLineMargin;
            totHeight += curHeight + viewerRenderInfo.vertLineMargin;
            long chminX = 0L;
            long chMaxX = 0L;
            boolean useChXVal = true;
            if (minA >= 0 && minA < numAnnotations) {
                IGTAnnotation igtMinAnnotation = annotations.get(minA);
                if (igtMinAnnotation.getAnnotation() == null) {
                    chminX = igtMinAnnotation.getRenderInfo().x;
                } else {
                    chminX = igtMinAnnotation.getAnnotation().getBeginTimeBoundary();
                    useChXVal = false;
                }
            }
            if (maxA >= 0 && maxA < numAnnotations) {
                IGTAnnotation igtMaxAnnotation = annotations.get(maxA);
                chMaxX = useChXVal ? (long)(igtMaxAnnotation.getRenderInfo().x + igtMaxAnnotation.getRenderInfo().calcWidth) : igtMaxAnnotation.getAnnotation().getEndTimeBoundary();
            }
            for (int k = 0; k < descendants.size(); ++k) {
                IGTTier depTier = descendants.get(k);
                int deptHeight = g2d == null ? depTier.getRenderInfo().height : viewerRenderInfo.getHeightForTier(g2d, depTier.getTierName());
                totHeight += deptHeight + viewerRenderInfo.vertLineMargin;
                if (j == 0) {
                    depTier.getRenderInfo().clearYPositions();
                }
                depTier.getRenderInfo().height = deptHeight;
                depTier.getRenderInfo().y = tempY;
                depTier.getRenderInfo().addYPosition(tempY);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer(String.format("Y: calculateTierYPositionRecursive: start on %d descendant annotations, useChXVal=%b, minA=%d chminX=%d maxA=%d chmaxX=%d", depTier.getAnnotations().size(), useChXVal, minA, chminX, maxA, chMaxX));
                }
                for (int a = 0; a < depTier.getAnnotations().size(); ++a) {
                    IGTAnnotation igtAnn = depTier.getAnnotations().get(a);
                    IGTNodeRenderInfo annRender = igtAnn.getRenderInfo();
                    if (useChXVal) {
                        if ((long)annRender.x < chminX) {
                            if (!LOG.isLoggable(Level.FINER)) continue;
                            LOG.finer(String.format("Y: calculateTierYPositionRecursive: skip anno %d: annRender.x < chminX (%d < %d)", a, annRender.x, chminX));
                            continue;
                        }
                        if ((long)annRender.x > chMaxX) {
                            if (!LOG.isLoggable(Level.FINER)) break;
                            LOG.finer(String.format("Y: calculateTierYPositionRecursive: stop after anno %d: annRender.x > chMaxX (%d > %d)", a, annRender.x, chMaxX));
                            break;
                        }
                    } else {
                        long beginDep = igtAnn.getAnnotation().getBeginTimeBoundary();
                        long endDep = igtAnn.getAnnotation().getBeginTimeBoundary();
                        if (beginDep < chminX) {
                            if (!LOG.isLoggable(Level.FINER)) continue;
                            LOG.finer(String.format("Y: calculateTierYPositionRecursive: skip anno %d: beginDep < chminX (%d < %d)", a, beginDep, chminX));
                            continue;
                        }
                        if (endDep > chMaxX) {
                            if (!LOG.isLoggable(Level.FINER)) break;
                            LOG.finer(String.format("Y: calculateTierYPositionRecursive: stop after anno %d: endDep > chMaxX (%d > %d)", a, endDep, chMaxX));
                            break;
                        }
                    }
                    annRender.y = tempY;
                    annRender.height = deptHeight;
                    if (!LOG.isLoggable(Level.FINER)) continue;
                    LOG.finer(String.format("calculateTierYPositionRecursive: anno=%d y=%d\n%s", a, tempY, igtAnn.toString()));
                }
                tempY += deptHeight + viewerRenderInfo.vertLineMargin;
            }
        }
        return totHeight += viewerRenderInfo.vertLineMargin;
    }

    public static int calculateTierAndAnnotationsLAS(Graphics g2d, IGTViewerRenderInfo viewerRenderInfo, IGTTier tier, boolean recursive) {
        if (tier == null) {
            return 0;
        }
        ArrayList<IGTAnnotation> anns = tier.getAnnotations();
        int curXAdvance = 0;
        int curXStart = 0;
        FontMetrics fm = g2d.getFontMetrics(viewerRenderInfo.getFontForTier(tier.getTierName()));
        for (IGTAnnotation ia : anns) {
            int rw;
            IGTNodeRenderInfo renderInfo = ia.getRenderInfo();
            renderInfo.realWidth = rw = IGTCalculator.annotationWidth(fm, ia.getTextValue()) + viewerRenderInfo.getHorizontalBBoxInsets();
            renderInfo.calcWidth = rw;
            renderInfo.x = curXStart;
            curXAdvance += rw;
            if (recursive && ia.getChildCount() > 0) {
                int maxChildrenWidth = 0;
                int curXChildStart = curXStart;
                Map<IGTTier, List<IGTNode>> groupedChildren = ia.getChildrenPerTier();
                for (List<IGTNode> children : groupedChildren.values()) {
                    int curWidth = IGTCalculator.calculateChildrenLAS(g2d, viewerRenderInfo, children, curXChildStart);
                    if (curWidth <= maxChildrenWidth) continue;
                    maxChildrenWidth = curWidth;
                }
                if (maxChildrenWidth > renderInfo.calcWidth) {
                    renderInfo.calcWidth = maxChildrenWidth;
                }
                IGTCalculator.updateLastChildSize(ia);
                curXAdvance = renderInfo.x + renderInfo.calcWidth;
            }
            curXStart += renderInfo.calcWidth + viewerRenderInfo.whitespaceWidth;
            if (!LOG.isLoggable(Level.FINER)) continue;
            LOG.finer(String.format("X: calculateTierAndAnnotationsLAS %s", ia.toString()));
        }
        return curXAdvance;
    }

    private static int annotationWidth(FontMetrics fm, String text) {
        return Math.max(10, fm.stringWidth(text));
    }

    public static int calculateChildrenLAS(Graphics g2d, IGTViewerRenderInfo viewerRenderInfo, List<IGTNode> children, int startX) {
        if (children == null || children.size() == 0) {
            return 0;
        }
        int curXAdvance = startX;
        int totalChildWidth = 0;
        for (int i = 0; i < children.size(); ++i) {
            IGTAnnotation ia = (IGTAnnotation)children.get(i);
            FontMetrics fm = g2d.getFontMetrics(viewerRenderInfo.getFontForTier(ia.getIGTTier().getTierName()));
            int width = IGTCalculator.annotationWidth(fm, ia.getTextValue()) + viewerRenderInfo.getHorizontalBBoxInsets();
            ia.getRenderInfo().x = curXAdvance;
            ia.getRenderInfo().realWidth = width;
            ia.getRenderInfo().calcWidth = width;
            if (ia.getChildCount() > 0) {
                int maxChildrenWidth = 0;
                Map<IGTTier, List<IGTNode>> groupedChildren = ia.getChildrenPerTier();
                for (List<IGTNode> grchildren : groupedChildren.values()) {
                    int curWidth = IGTCalculator.calculateChildrenLAS(g2d, viewerRenderInfo, grchildren, ia.getRenderInfo().x);
                    if (curWidth <= maxChildrenWidth) continue;
                    maxChildrenWidth = curWidth;
                }
                if (maxChildrenWidth > width) {
                    width = maxChildrenWidth;
                    ia.getRenderInfo().calcWidth = maxChildrenWidth;
                }
                IGTCalculator.updateLastChildSize(ia);
            }
            curXAdvance += width;
            totalChildWidth += width;
            if (i >= children.size() - 1) continue;
            curXAdvance += viewerRenderInfo.whitespaceWidth;
            totalChildWidth += viewerRenderInfo.whitespaceWidth;
        }
        return totalChildWidth;
    }

    public static void updateLastChildSize(IGTNode currentNode) {
        if (currentNode != null && currentNode.getChildCount() > 0) {
            Map<IGTTier, List<IGTNode>> groupedChildren = currentNode.getChildrenPerTier();
            for (Map.Entry<IGTTier, List<IGTNode>> e : groupedChildren.entrySet()) {
                List<IGTNode> children = e.getValue();
                IGTTier tier = e.getKey();
                if (children.size() <= 0) continue;
                IGTNode lastNode = children.get(children.size() - 1);
                if (LOG.isLoggable(Level.FINER) && lastNode instanceof IGTAnnotation) {
                    IGTAnnotation igtAnno = (IGTAnnotation)lastNode;
                    AbstractAnnotation anno = igtAnno.getAnnotation();
                    String value = anno == null ? "null" : anno.getValue();
                    LOG.finer(String.format("X: updateLastChildSize: anno='%s'", value));
                }
                int rhs = currentNode.getRenderInfo().x + currentNode.getRenderInfo().calcWidth;
                IGTNodeRenderInfo lastNodeRenderInfo = lastNode.getRenderInfo();
                int lastNodeRhs = lastNodeRenderInfo.x + lastNodeRenderInfo.calcWidth;
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer(String.format("X: updateLastChildSize: rhs=%d lastNodeRhs=%d .x=%d .calcWidth=%d, .realWidth=%d", rhs, lastNodeRhs, lastNodeRenderInfo.x, lastNodeRenderInfo.calcWidth, lastNodeRenderInfo.realWidth));
                }
                if (lastNodeRhs >= rhs) continue;
                lastNodeRenderInfo.calcWidth = rhs - lastNodeRenderInfo.x;
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer(String.format("X: updateLastChildSize: .calcWidth:=%d", lastNodeRenderInfo.calcWidth));
                }
                IGTCalculator.updateLastChildSize(lastNode);
            }
        }
    }

    public static void calculateWrappingInfo(Graphics g2d, IGTViewerRenderInfo viewerRenderInfo, IGTTier curTier, int width) {
        if (curTier == null || width == 0) {
            return;
        }
        if (curTier.isInWordLevelBlock()) {
            IGTCalculator.calculateBlockWrapping(curTier, width);
        } else {
            ArrayList<IGTAnnotation> anns = curTier.getAnnotations();
            if (anns.size() > 0) {
                IGTAnnotation ann = curTier.getAnnotations().get(0);
                FontMetrics fm = g2d.getFontMetrics(viewerRenderInfo.getFontForTier(curTier.getTierName()));
                IGTCalculator.calculateLineWrappingSimple(g2d, fm, ann, width);
            }
        }
    }

    private static void calculateLineWrappingSimple(Graphics g2d, FontMetrics fm, IGTAnnotation ann, int width) {
        if (ann == null || ann.getTextValue() == null || ann.getTextValue().isEmpty()) {
            return;
        }
        int numLines = 1;
        IGTNodeRenderInfo annRenderInfo = ann.getRenderInfo();
        annRenderInfo.clearWrappedLines();
        if (annRenderInfo.realWidth > width) {
            String total = ann.getTextValue().replace("\n", " ");
            int[] indices = IGTCalculator.getWordEndIndices(total);
            if (indices.length > 0) {
                int bIndex = 0;
                String prevSubstring = null;
                int prevEIndex = -1;
                for (int i = 0; i < indices.length; ++i) {
                    int eIndex = indices[i];
                    String substring = total.substring(bIndex, eIndex);
                    int subWidth = IGTCalculator.annotationWidth(fm, substring);
                    if (subWidth > width) {
                        if (prevSubstring == null) {
                            annRenderInfo.addWrappedLine(substring);
                            bIndex = eIndex + 1;
                            continue;
                        }
                        annRenderInfo.addWrappedLine(prevSubstring);
                        bIndex = prevEIndex + 1;
                        prevSubstring = null;
                        --i;
                        continue;
                    }
                    prevSubstring = substring;
                    prevEIndex = eIndex;
                }
                if (prevSubstring != null) {
                    annRenderInfo.addWrappedLine(prevSubstring);
                }
                annRenderInfo.calcWidth = width;
                numLines = annRenderInfo.getWrappedLines().size();
            }
        } else if (annRenderInfo.calcWidth > width) {
            annRenderInfo.calcWidth = width;
        }
        annRenderInfo.setNumLines(numLines);
        ann.getIGTTier().getRenderInfo().setNumLines(numLines);
    }

    public static void calculateBlockWrapping(IGTTier tier, int width) {
        if (tier != null && tier.isInWordLevelBlock()) {
            tier.getRenderInfo().clearWrapIndices();
            int xShift = 0;
            int numAnnotations = tier.getAnnotations().size();
            for (int i = 0; i < numAnnotations; ++i) {
                IGTAnnotation ann = tier.getAnnotations().get(i);
                int calcW = ann.getRenderInfo().calcWidth;
                if (i == numAnnotations - 1) {
                    int realW = ann.getRenderInfo().realWidth;
                    List<IGTNode> children = ann.getChildren();
                    if (children != null && !children.isEmpty()) {
                        int size = children.size();
                        for (int j = 0; j < size; ++j) {
                            IGTAnnotation ca = (IGTAnnotation)children.get(j);
                            realW = Math.max(realW, ca.getRenderInfo().realWidth);
                        }
                    }
                    if (LOG.isLoggable(Level.FINER) && realW != calcW) {
                        LOG.finer(String.format("X: i=%d calcW := realW: %d <- %d", i, calcW, realW));
                    }
                    calcW = realW;
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer(String.format("X: i=%d: %d + %d + %d = %d >= %d?", i, ann.getRenderInfo().x, calcW, xShift, ann.getRenderInfo().x + calcW + xShift, width));
                }
                if (i > 0 && ann.getRenderInfo().x + calcW + xShift > width) {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer(String.format("break before wrapIndex %d", i));
                    }
                    tier.getRenderInfo().addWrapIndex(i);
                    xShift = -ann.getRenderInfo().x;
                } else if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer(String.format("X: no break before wrapIndex %d", i));
                }
                if (xShift == 0) continue;
                IGTCalculator.shiftAnnotationAndChildren(ann, xShift);
            }
        }
    }

    private static void wrapTierAndChildren(IGTTier tier, int wrapIndex) {
        if (wrapIndex >= 0) {
            tier.getRenderInfo().addWrapIndex(wrapIndex);
        }
        tier.getRenderInfo().setNumLines(tier.getRenderInfo().getNumLines() + 1);
        List<IGTTier> children = tier.getChildTiers();
        if (children != null && children.size() > 0) {
            for (IGTTier childTier : children) {
                IGTCalculator.wrapTierAndChildren(childTier, -1);
            }
        }
    }

    private static void shiftAnnotationAndChildren(IGTNode ann, int xShift) {
        ann.getRenderInfo().x += xShift;
        List<IGTNode> children = ann.getChildren();
        if (children != null && !children.isEmpty()) {
            for (IGTNode child : children) {
                IGTCalculator.shiftAnnotationAndChildren(child, xShift);
            }
        }
    }

    static int[] getWordEndIndices(String s) {
        if (s == null) {
            return new int[0];
        }
        ArrayList<Integer> inds = new ArrayList<Integer>();
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            inds.add(i);
        }
        inds.add(length);
        if (inds.size() > 0) {
            int[] indices = new int[inds.size()];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)inds.get(i);
            }
            return indices;
        }
        return new int[0];
    }

    public static void calculateShortTierLabels(Graphics g2d, IGTDataModel dModel, int availWidth) {
        if (dModel == null || availWidth <= 0) {
            return;
        }
        FontMetrics fm = g2d.getFontMetrics();
        int netWidth = availWidth - dModel.getRowHeaderRenderInfo().getHorizontalMargins();
        for (int i = 0; i < dModel.getRowCount(); ++i) {
            IGTTier igtTier = dModel.getRowData(i);
            int tierWidth = netWidth - igtTier.getLevel() * igtTier.getRenderInfo().indentPerLevel;
            int totalWidth = fm.stringWidth(igtTier.getTierName());
            if (totalWidth >= tierWidth) {
                String shortName = igtTier.getTierName().substring(0, igtTier.getTierName().length() - 1);
                while (fm.stringWidth(shortName) > tierWidth && shortName.length() > 1) {
                    shortName = shortName.substring(0, shortName.length() - 1);
                }
                dModel.setShortTierNameForIndex(i, shortName);
                continue;
            }
            dModel.setShortTierNameForIndex(i, igtTier.getTierName());
        }
    }

    public static int calcSuggestionRowHeaderWidth(Graphics g2d, IGTSuggestionModel sugModel, IGTSuggestionViewerRenderInfo renderInfo) {
        int leftMargin = 0;
        int rightMargin = 0;
        if (renderInfo.getTextInsets() != null) {
            leftMargin = renderInfo.getTextInsets().left;
            rightMargin = renderInfo.getTextInsets().right;
        }
        FontMetrics fm = g2d.getFontMetrics(renderInfo.getHeaderFont());
        int minWidth = 0;
        for (int i = 0; i < sugModel.getRowCount(); ++i) {
            IGTTier igtTier = sugModel.getRowData(i);
            if (igtTier.getType() == IGTTierType.ROOT) continue;
            int tierNameWidth = fm.stringWidth(igtTier.getTierName()) + leftMargin + rightMargin;
            if (renderInfo.visualizeIndentation) {
                tierNameWidth += igtTier.getLevel() * renderInfo.indentPerLevel;
            }
            if (tierNameWidth <= minWidth) continue;
            minWidth = tierNameWidth;
        }
        return minWidth;
    }

    public static boolean updateLASRecursiveFromNode(IGTAnnotation igtAnn, int calcWidth, int availWidth) {
        IGTTier topTier;
        IGTAnnotation parentAnn;
        if (igtAnn == null) {
            return false;
        }
        int widthDiff = calcWidth - igtAnn.getRenderInfo().calcWidth;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer(String.format("X: updateLASRecursiveFromNode: %d", widthDiff));
        }
        igtAnn.getRenderInfo().calcWidth = calcWidth;
        IGTCalculator.updateLastChildSize(igtAnn);
        IGTTier wlTier = null;
        IGTAnnotation curAnn = igtAnn;
        IGTTier curTier = curAnn.getIGTTier();
        if (curTier.isInWordLevelBlock()) {
            while (true) {
                IGTTier parentTier;
                if ((parentTier = curTier.getParentTier()) == null || !parentTier.isInWordLevelBlock()) {
                    wlTier = curTier;
                    break;
                }
                curTier = parentTier;
            }
        }
        if (wlTier != null && wlTier != igtAnn.getIGTTier() && (parentAnn = wlTier.getAnnotationAtPoint(new Point(curAnn.getRenderInfo().x, wlTier.getRenderInfo().y))) != null) {
            parentAnn.getRenderInfo().calcWidth += widthDiff;
            curAnn = parentAnn;
        }
        boolean shiftedOutOfView = false;
        IGTAnnotation nextAnn = curAnn.getIGTTier().getNextAnnotation(curAnn);
        while (nextAnn != null) {
            IGTCalculator.shiftAnnotationAndChildren(nextAnn, widthDiff);
            shiftedOutOfView = shiftedOutOfView || nextAnn.getRenderInfo().x + nextAnn.getRenderInfo().calcWidth > availWidth;
            nextAnn = curAnn.getIGTTier().getNextAnnotation(nextAnn);
        }
        for (topTier = igtAnn.getIGTTier(); topTier != null && topTier.getParentTier() != null; topTier = topTier.getParentTier()) {
        }
        if (topTier != null && topTier != igtAnn.getIGTTier() && (nextAnn = topTier.getAnnotations().get(0)) != null) {
            nextAnn.getRenderInfo().calcWidth += widthDiff;
            IGTCalculator.updateLastChildSize(nextAnn);
        }
        return shiftedOutOfView;
    }
}

