/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import mpi.eudico.client.annotator.util.ClientLogger;
import nl.mpi.lexan.analyzers.helpers.TierNodeType;
import nl.mpi.lexan.analyzers.helpers.parameters.Parameter;
import nl.mpi.lexan.analyzers.helpers.parameters.TierTypeParameter;

public class PotentialTiers
implements ClientLogger {
    private List<Parameter> parameters;
    private int nrSourceTiers;
    private int nrTargetTiers;
    private ArrayList<String> fixedTierNames;
    private Map<String, List<String>> childMap;
    private boolean isTypeMode;

    public PotentialTiers(List<Parameter> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            TierTypeParameter source = new TierTypeParameter("Default source", TierNodeType.SOURCE, 0, -1);
            TierTypeParameter target = new TierTypeParameter("Default target", TierNodeType.TARGET, 1, 0);
            parameters = new ArrayList<Parameter>(2);
            parameters.add((Parameter)source);
            parameters.add((Parameter)target);
        }
        this.parameters = parameters;
        int size = parameters.size();
        int nrOtherParameters = 0;
        for (int n = 0; n < size; ++n) {
            Object type = parameters.get(n).getValue();
            if (type == TierNodeType.TARGET) {
                ++this.nrTargetTiers;
                continue;
            }
            if (type == TierNodeType.SOURCE) {
                ++this.nrSourceTiers;
                continue;
            }
            ++nrOtherParameters;
        }
        if (this.nrTargetTiers == 0) {
            this.nrTargetTiers = 1;
            ++size;
            TierTypeParameter target = new TierTypeParameter("Default target", TierNodeType.TARGET, 1, 0);
            parameters.add((Parameter)target);
        }
        this.fixedTierNames = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.fixedTierNames.add("");
        }
    }

    public int getNumberOfSourceTiers() {
        return this.nrSourceTiers;
    }

    public int getNumberOfTargetTiers() {
        return this.nrTargetTiers;
    }

    public void setTierName(int index, String tier) {
        this.fixedTierNames.set(index, tier);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("setTierName: %d := '%s': %s", index, tier, this.fixedTierNames.toString()));
        }
        int size = this.fixedTierNames.size();
        for (int i = index + 1; i < size; ++i) {
            TierTypeParameter ttp;
            Parameter p = this.parameters.get(i);
            if (!(p instanceof TierTypeParameter) || (ttp = (TierTypeParameter)p).getRelativeToParameter() != index) continue;
            this.setTierName(i, "");
        }
    }

    public void setChildMap(Map<String, List<String>> childMap, boolean isTypeMode) {
        this.childMap = childMap;
        this.isTypeMode = isTypeMode;
    }

    public List<String> getPotentialSourceNames(int index, List<String> exclude) {
        Parameter p = this.parameters.get(index);
        if (p.getValue() == TierNodeType.SOURCE) {
            return this.getPotentialNames(index, exclude);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("getPotentialSourceNames: parameter %d: EMPTY because not SOURCE", index));
        }
        return Collections.emptyList();
    }

    public List<String> getPotentialTargetNames(int index) {
        Parameter p = this.parameters.get(index);
        if (p.getValue() == TierNodeType.TARGET) {
            return this.getPotentialNames(index, null);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("getPotentialTargetNames: parameter %d: EMPTY because not TARGET", index));
        }
        return Collections.emptyList();
    }

    private List<String> getPotentialNames(int index, List<String> exclude) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("getPotentialNames: parameter %d exclude %s", index, String.valueOf(exclude)));
        }
        Set<String> set = this.getPotentialNames(index);
        if (!this.isTypeMode) {
            set.removeAll(this.fixedTierNames);
        }
        if (!this.isTypeMode && exclude != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("getPotentialNames: removeAll %s from %s", exclude.toString(), set.toString()));
            }
            set.removeAll(exclude);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("getPotentialNames: parameter %d: %s", index, set.toString()));
        }
        return new ArrayList<String>(set);
    }

    private Set<String> getPotentialNames(int index) {
        HashSet<String> set = new HashSet<String>();
        Parameter p = this.parameters.get(index);
        if (p instanceof TierTypeParameter) {
            TierTypeParameter ttp = (TierTypeParameter)p;
            int constraint = ttp.getConstraint();
            int parm = ttp.getRelativeToParameter();
            if (parm >= index) {
                constraint = 0;
            }
            switch (constraint) {
                default: {
                    this.addAllPossible(index, set, this.childMap.get(""));
                    break;
                }
                case 1: {
                    String tierName = this.fixedTierNames.get(parm);
                    if (tierName == null) break;
                    this.addAllPossible(index, set, this.childMap.get(tierName));
                    break;
                }
                case 2: {
                    String tierName = this.fixedTierNames.get(parm);
                    if (tierName == null) break;
                    this.addAllPossible(index, set, this.indirectChildren(this.childMap, tierName));
                }
            }
        }
        return set;
    }

    private List<String> indirectChildren(Map<String, List<String>> childMap, String tierName) {
        HashSet<String> accumulator = new HashSet<String>();
        this.accumulateChildren(accumulator, childMap, tierName);
        return new ArrayList<String>(accumulator);
    }

    private void accumulateChildren(Set<String> accumulator, Map<String, List<String>> childMap, String tierName) {
        List<String> directChildren = childMap.get(tierName);
        if (directChildren != null) {
            for (String child : directChildren) {
                if (!accumulator.add(child)) continue;
                this.accumulateChildren(accumulator, childMap, child);
            }
        }
    }

    private void addAllPossible(int index, Set<String> set, List<String> candidates) {
        if (candidates != null) {
            for (String c : candidates) {
                if (!this.isPossible(index, c)) continue;
                set.add(c);
            }
        }
    }

    private boolean isPossible(int position, String candidate) {
        boolean possible = true;
        String backup = this.fixedTierNames.get(position);
        this.fixedTierNames.set(position, candidate);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("isPossible: %d '%s'?", position, candidate));
        }
        int size = this.fixedTierNames.size();
        for (int i = position + 1; possible && i < size; ++i) {
            List<String> options;
            TierTypeParameter ttp;
            Parameter p = this.parameters.get(i);
            if (!(p instanceof TierTypeParameter) || (ttp = (TierTypeParameter)p).getRelativeToParameter() != position) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("isPossible: %d '%s': %d relates to it", position, candidate, i));
            }
            if ((options = this.getPotentialNames(i, null)).isEmpty()) {
                possible = false;
                continue;
            }
            possible = this.isPossible(position, i, options);
            break;
        }
        this.fixedTierNames.set(position, backup);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("isPossible: %d '%s'? %s!", position, candidate, String.valueOf(possible)));
        }
        return possible;
    }

    private boolean isPossible(int relates_to, int position, List<String> candidates) {
        int size = this.fixedTierNames.size();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("isPossible: relates_to=%d position=%d %s?", relates_to, position, candidates.toString()));
        }
        if (position >= size - 1) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("isPossible: relates_to=%d position=%d %s: TRUE because there are no more parameters", relates_to, position, candidates.toString()));
            }
            return true;
        }
        boolean possible = true;
        String backup = this.fixedTierNames.get(position);
        block0: for (int i = position + 1; i < size; ++i) {
            TierTypeParameter ttp;
            Parameter p = this.parameters.get(i);
            if (!(p instanceof TierTypeParameter) || (ttp = (TierTypeParameter)p).getRelativeToParameter() != relates_to) continue;
            possible = false;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("isPossible/3: %d '%s': %d relates to it", relates_to, String.valueOf(candidates), i));
            }
            for (String candidate : candidates) {
                List<String> options;
                this.fixedTierNames.set(position, candidate);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(String.format("isPossible/3: relates_to=%d position=%d %s", relates_to, position, candidate));
                }
                if ((options = this.getPotentialNames(i, null)).isEmpty()) continue;
                possible = true;
                break block0;
            }
            break;
        }
        this.fixedTierNames.set(position, backup);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("isPossible/3: relates_to=%d position=%d %s? %s!", relates_to, position, candidates.toString(), String.valueOf(possible)));
        }
        return possible;
    }
}

