/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.interlinear.edit.SuggestionComponent;
import mpi.eudico.client.annotator.interlinear.edit.SuggestionSetSelector;
import mpi.eudico.client.annotator.interlinear.edit.event.SuggestionSelectionEvent;
import mpi.eudico.client.annotator.interlinear.edit.event.SuggestionSelectionListener;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTSuggestionViewerModel;
import mpi.eudico.client.annotator.util.ClientLogger;

public class SuggestionWindow
extends JFrame
implements MouseListener,
MouseMotionListener,
ComponentListener,
KeyListener,
SuggestionComponent.MouseAndMotionListener,
ActionListener,
ItemListener {
    private static final int MAX_INITIAL_WIDTH = 1538;
    private static final int MAX_INITIAL_HEIGHT = 768;
    private JScrollPane selectorScrollPane;
    private SuggestionSetSelector selector;
    private SuggestionSelectionListener suggestionSelectionListener;
    private JToggleButton reverseButton;
    private JCheckBox incrementalSelectCB;
    private JLabel incrementalLevelLabel;
    private JCheckBox reuseWindowBoundsCB;
    private JPanel toolBarPanel;
    private SpringLayout springLayout;
    private WindowHandler windowListener;
    private Point dragStartPoint;
    private Point dragEndPoint;
    private static final int DRAG_WINDOW = 0;
    private int dragCorner = 0;
    private Insets windowMargins;
    private final int MARGIN_TO_SCROLLBAR = 5;
    private int scrollBarWidth;
    private boolean incrementalMode = false;
    private int incrementLevel = -1;
    private final int MAX_INCREMENT_LEVEL = Integer.MAX_VALUE;
    private Map<Integer, List<SuggestionComponent>> incrementMap = null;
    private boolean reversedOrderMode = false;
    private Rectangle prefWindowBounds = null;
    private final String PREF_INCREMENTAL = "SuggestionWindow.Incremental";
    private final String PREF_REVERSED = "SuggestionWindow.ReversedOrder";
    private final String PREF_REUSE_WINDOW_BOUNDS = "SuggestionWindow.ReuseWindowBounds";
    private final String PREF_WINDOW_BOUNDS = "SuggestionWindow.WindowBounds";

    public SuggestionWindow(Frame frame, SuggestionSetSelector selector) {
        this.setIconImage(frame.getIconImage());
        this.selector = selector;
        this.initComponents();
    }

    public SuggestionWindow(Window window, SuggestionSetSelector selector) {
        this.selector = selector;
        this.initComponents();
    }

    private void initComponents() {
        this.selectorScrollPane = new JScrollPane(this.selector);
        this.getContentPane().setLayout(new BorderLayout(2, 2));
        this.toolBarPanel = this.createToolPanel();
        this.getContentPane().add((Component)this.toolBarPanel, "First");
        this.getContentPane().add((Component)this.selectorScrollPane, "Center");
        this.windowMargins = new Insets(0, 0, 0, 0);
        Object sbWidth = UIManager.getDefaults().get("ScrollBar.width");
        if (sbWidth instanceof Integer) {
            this.scrollBarWidth = (Integer)sbWidth;
        }
        this.selectorScrollPane.addMouseListener(this);
        this.selectorScrollPane.addMouseMotionListener(this);
        this.getContentPane().addMouseListener(this);
        this.getContentPane().addMouseMotionListener(this);
        this.addComponentListener(this);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.selectorScrollPane.requestFocusInWindow();
        this.addKeyListener(this);
        this.windowListener = new WindowHandler();
        this.addWindowListener(this.windowListener);
        this.readPrefs();
    }

    private JPanel createToolPanel() {
        int gap;
        this.springLayout = new SpringLayout();
        JPanel p = new JPanel(this.springLayout);
        int w = gap = 4;
        int h = gap;
        ImageIcon ascendIcon = null;
        ImageIcon descendIcon = null;
        try {
            ascendIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
            descendIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reverseButton = new JToggleButton(descendIcon);
        this.reverseButton.setSelectedIcon(ascendIcon);
        this.reverseButton.setToolTipText(ElanLocale.getString("InterlinearEditor.Suggestions.ReverseToolTip"));
        this.reverseButton.addActionListener(this);
        p.add(this.reverseButton);
        w += this.reverseButton.getPreferredSize().width + gap;
        this.incrementalSelectCB = new JCheckBox(ElanLocale.getString("InterlinearEditor.Suggestions.IncrementalSelection"));
        this.incrementalSelectCB.setToolTipText(ElanLocale.getString("InterlinearEditor.Suggestions.IncrementalSelectionToolTip"));
        this.incrementalSelectCB.addItemListener(this);
        p.add(this.incrementalSelectCB);
        w += this.incrementalSelectCB.getPreferredSize().width + gap;
        h += Math.max(this.reverseButton.getPreferredSize().height, this.incrementalSelectCB.getPreferredSize().height);
        h += gap;
        this.incrementalLevelLabel = new JLabel();
        this.incrementalLevelLabel.setForeground(Color.BLUE);
        p.add(this.incrementalLevelLabel);
        this.springLayout.putConstraint("West", (Component)this.reverseButton, gap, "West", (Component)p);
        this.springLayout.putConstraint("VerticalCenter", (Component)this.reverseButton, 0, "VerticalCenter", (Component)p);
        this.springLayout.putConstraint("West", (Component)this.incrementalSelectCB, gap, "East", (Component)this.reverseButton);
        this.springLayout.putConstraint("VerticalCenter", (Component)this.incrementalSelectCB, 0, "VerticalCenter", (Component)p);
        this.springLayout.putConstraint("West", (Component)this.incrementalLevelLabel, 2 * gap, "East", (Component)this.incrementalSelectCB);
        this.springLayout.putConstraint("VerticalCenter", (Component)this.incrementalLevelLabel, 0, "VerticalCenter", (Component)p);
        this.reuseWindowBoundsCB = new JCheckBox(ElanLocale.getString("InterlinearEditor.Suggestions.RestoreWindowBounds"));
        p.add(this.reuseWindowBoundsCB);
        this.springLayout.putConstraint("East", (Component)this.reuseWindowBoundsCB, -gap, "East", (Component)p);
        this.springLayout.putConstraint("VerticalCenter", (Component)this.reuseWindowBoundsCB, 0, "VerticalCenter", (Component)p);
        p.setPreferredSize(new Dimension(w += this.reuseWindowBoundsCB.getPreferredSize().width + 2 * gap, h));
        return p;
    }

    private void removeListeners() {
        this.getContentPane().removeMouseListener(this);
        this.getContentPane().removeMouseMotionListener(this);
        this.selectorScrollPane.removeMouseListener(this);
        this.selectorScrollPane.removeMouseMotionListener(this);
        this.selector.removeWorkAroundToolTipBug(this);
        this.removeKeyListener(this);
        this.removeWindowListener(this.windowListener);
        this.suggestionSelectionListener = null;
    }

    private void closeSelectionWindow() {
        this.storePrefs();
        this.removeListeners();
        this.setVisible(false);
        this.dispose();
    }

    private void readPrefs() {
        Boolean reuseWinBounds;
        Boolean incrementalPref;
        Boolean reversedPref = Preferences.getBool("SuggestionWindow.ReversedOrder", null);
        if (reversedPref != null && reversedPref.booleanValue()) {
            this.reversedOrderMode = true;
            this.reverseButton.setSelected(this.reversedOrderMode);
        }
        if ((incrementalPref = Preferences.getBool("SuggestionWindow.Incremental", null)) != null && incrementalPref.booleanValue()) {
            this.incrementalMode = true;
            this.incrementalSelectCB.setSelected(true);
        }
        if ((reuseWinBounds = Preferences.getBool("SuggestionWindow.ReuseWindowBounds", null)) != null) {
            this.reuseWindowBoundsCB.setSelected(reuseWinBounds);
            if (reuseWinBounds.booleanValue()) {
                this.prefWindowBounds = Preferences.getRect("SuggestionWindow.WindowBounds", null);
            }
        }
    }

    private void storePrefs() {
        Preferences.set("SuggestionWindow.ReversedOrder", this.reversedOrderMode, null);
        Preferences.set("SuggestionWindow.Incremental", this.incrementalMode, null);
        boolean reuseWindowBounds = this.reuseWindowBoundsCB.isSelected();
        Preferences.set("SuggestionWindow.ReuseWindowBounds", reuseWindowBounds, null);
        if (reuseWindowBounds) {
            Preferences.set("SuggestionWindow.WindowBounds", this.getBounds(), null);
        }
    }

    public void setSuggestionSelectionListener(SuggestionSelectionListener listener) {
        this.suggestionSelectionListener = listener;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (this.suggestionSelectionListener != null && this.selector != null && this.selector.getModel().getRowCount() == 1) {
            KeyEvent ke = new KeyEvent(this, 401, System.currentTimeMillis(), 0, 49, '1');
            this.keyPressed(ke);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.selector != null) {
            Dimension d = this.selector.getPreferredSize();
            Dimension toolDim = this.toolBarPanel.getPreferredSize();
            Dimension maxDim = this.getMaximumSize();
            if (maxDim == null || maxDim.width == Integer.MAX_VALUE || maxDim.height == Integer.MAX_VALUE) {
                if (d.width > 1538) {
                    d.width = 1538;
                }
                if (d.height > 768) {
                    d.height = 768;
                }
            } else {
                if (d.height > maxDim.height + this.windowMargins.top + this.windowMargins.bottom + this.scrollBarWidth) {
                    int origPrefHeight = d.height;
                    d.height = maxDim.height - this.windowMargins.top - this.windowMargins.bottom - this.scrollBarWidth;
                    int numMissing = (int)Math.ceil((double)(origPrefHeight - d.height) / (double)this.selector.getUnitHeight());
                    int numInCurrentViewHeight = (int)Math.ceil((double)d.height / (double)this.selector.getUnitHeight());
                    int numExtraColumns = (int)Math.ceil((double)numMissing / (double)numInCurrentViewHeight);
                    int extraWidth = numExtraColumns * 2 * this.selector.getUnitHeight();
                    d.width += extraWidth;
                }
                if (d.width < toolDim.width) {
                    d.width = toolDim.width;
                }
                if (d.width > maxDim.width + this.windowMargins.left + this.windowMargins.right + this.scrollBarWidth + 5) {
                    d.width = maxDim.width - this.windowMargins.left - this.windowMargins.right - this.scrollBarWidth - 5;
                }
            }
            return new Dimension(d.width + this.windowMargins.left + this.windowMargins.right + this.scrollBarWidth + 5, d.height + this.windowMargins.top + this.windowMargins.bottom + this.scrollBarWidth);
        }
        return super.getPreferredSize();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dragEndPoint = e.getPoint();
        int dx = this.dragEndPoint.x - this.dragStartPoint.x;
        int dy = this.dragEndPoint.y - this.dragStartPoint.y;
        Rectangle bounds = this.getBounds();
        if (this.dragCorner == 0) {
            bounds.x += dx;
            bounds.y += dy;
            this.setBounds(bounds);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JComponent source = (JComponent)e.getSource();
        if (source == this.selectorScrollPane) {
            if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                ClientLogger.LOG.finer(String.format("SuggestionWindow.mouseClicked: Scrollpane %s", String.valueOf(e.getPoint())));
            }
            if (e.isShiftDown() || e.isAltDown()) {
                if (!this.incrementalMode) {
                    this.increaseChoiceOfSuggestions();
                }
            } else {
                int visIndex;
                int xp = e.getPoint().x + this.selectorScrollPane.getHorizontalScrollBar().getValue();
                int xy = e.getPoint().y + this.selectorScrollPane.getVerticalScrollBar().getValue();
                int selectedIndex = this.selector.getSuggestionIndexAtPoint(xp, xy);
                if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                    ClientLogger.LOG.finer(String.format("Selected index: " + selectedIndex, new Object[0]));
                }
                if (!this.incrementalMode || this.incrementLevel == Integer.MAX_VALUE) {
                    this.applySelectedSuggestionAndClose(selectedIndex);
                } else if (selectedIndex > -1 && (visIndex = this.selector.convertModelIndexToVisible(selectedIndex)) > -1) {
                    SuggestionComponent sc = this.selector.getSuggestionAtVisibleIndex(visIndex);
                    int hashValue = sc.getHashOfFrag(this.incrementLevel);
                    ++this.incrementLevel;
                    this.updateIncrementLevel(this.incrementLevel, hashValue);
                }
            }
        } else if (source instanceof SuggestionComponent) {
            if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                ClientLogger.LOG.finer(String.format("SuggestionWindow.mouseClicked: SuggestionComponent %s", String.valueOf(e.getPoint())));
            }
            if (e.isShiftDown() || e.isAltDown()) {
                if (!this.incrementalMode) {
                    this.reduceChoiceOfSuggestions((SuggestionComponent)source);
                }
            } else if (!this.incrementalMode || this.incrementLevel == Integer.MAX_VALUE) {
                this.applySelectedSuggestionAndClose(((SuggestionComponent)source).getIndex());
            } else {
                int selHash = ((SuggestionComponent)source).getHashOfFrag(this.incrementLevel);
                ++this.incrementLevel;
                this.updateIncrementLevel(this.incrementLevel, selHash);
            }
        } else if (source == this.getContentPane()) {
            if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                ClientLogger.LOG.finer(String.format("SuggestionWindow.mouseClicked: contentPane %s", String.valueOf(e.getPoint())));
            }
        } else if (ClientLogger.LOG.isLoggable(Level.FINER)) {
            ClientLogger.LOG.finer(String.format("SuggestionWindow.mouseClicked: other source %s", String.valueOf(e)));
        }
    }

    private void applySelectedSuggestionAndClose(int selectedIndexInModel) {
        if (this.suggestionSelectionListener != null) {
            SuggestionSelectionEvent event = new SuggestionSelectionEvent(this.selector.getModel(), selectedIndexInModel);
            if (selectedIndexInModel > -1) {
                this.suggestionSelectionListener.suggestionSelected(event);
            } else {
                this.suggestionSelectionListener.suggestionIgnored(event);
            }
        }
        this.closeSelectionWindow();
    }

    private void reduceChoiceOfSuggestions(SuggestionComponent selected) {
        int fragNr = selected.getFragNr();
        int hash = selected.getHashOfFrag(fragNr);
        int nextFragNr = fragNr >= 0 ? fragNr + 1 : fragNr - 1;
        Component[] components = this.selector.getComponents();
        int nVisible = 0;
        for (int i = components.length - 1; i >= 0; --i) {
            Component c = components[i];
            if (!c.isVisible() || !(c instanceof SuggestionComponent)) continue;
            SuggestionComponent sc = (SuggestionComponent)c;
            if (hash == sc.getHashOfFrag(fragNr)) {
                sc.setFragNr(nextFragNr);
                ++nVisible;
                continue;
            }
            sc.setVisible(false);
        }
        if (nVisible <= 1 && nVisible == 1) {
            this.applySelectedSuggestionAndClose(selected.getIndex());
        }
        this.selector.revalidate();
        this.selectorScrollPane.revalidate();
        this.selector.revalidate();
        this.invalidate();
        this.repaint();
    }

    private void increaseChoiceOfSuggestions() {
        Component[] components = this.selector.getComponents();
        for (int i = components.length - 1; i >= 0; --i) {
            Component c = components[i];
            if (!(c instanceof SuggestionComponent)) continue;
            ((SuggestionComponent)c).setFragNr(-99999);
            ((SuggestionComponent)c).setIncrementalModeLevel(-1);
            c.setVisible(true);
        }
        this.selector.doLayout();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void updateIncrementLevel(int level, int selectedFragHash) {
        if (level == Integer.MAX_VALUE) {
            return;
        }
        Component[] components = this.selector.getComponents();
        ArrayList<SuggestionComponent> curCompList = new ArrayList<SuggestionComponent>();
        if (level == 0) {
            for (Component c : components) {
                if (!(c instanceof SuggestionComponent)) continue;
                curCompList.add((SuggestionComponent)c);
            }
            this.incrementMap.put(level, curCompList);
        } else {
            List<SuggestionComponent> prevCompList = this.incrementMap.get(level - 1);
            for (SuggestionComponent sc : prevCompList) {
                int hash = sc.getHashOfFrag(level - 1);
                if (hash != selectedFragHash) continue;
                curCompList.add(sc);
            }
            this.incrementMap.put(level, curCompList);
        }
        if (curCompList.size() == 1) {
            if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                ClientLogger.LOG.finer(String.format("Incremental selection, one suggestion left: %s", this.selector.getModel().getRowData(((SuggestionComponent)curCompList.get(0)).getIndex())));
            }
            this.applySelectedSuggestionAndClose(((SuggestionComponent)curCompList.get(0)).getIndex());
        }
        HashMap uniqueHashMap = new HashMap();
        ArrayList<SuggestionComponent> arrayList = new ArrayList<SuggestionComponent>();
        for (SuggestionComponent sc : curCompList) {
            int hash = sc.getHashOfFrag(level);
            if (!uniqueHashMap.containsKey(hash)) {
                ArrayList<SuggestionComponent> compPerHash = new ArrayList<SuggestionComponent>();
                uniqueHashMap.put(hash, compPerHash);
                compPerHash.add(sc);
                arrayList.add(sc);
                continue;
            }
            ((List)uniqueHashMap.get(hash)).add(sc);
        }
        if (uniqueHashMap.size() == 1) {
            int onlyHash = (Integer)uniqueHashMap.keySet().iterator().next();
            List onlyLeftList = (List)uniqueHashMap.get(onlyHash);
            int numSuggestions = onlyLeftList.size();
            if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                ClientLogger.LOG.finer(String.format("Incremental, last hash value left: %d, number of suggestions: %d, is last level: %b", onlyHash, numSuggestions, onlyHash == 0));
            }
            if (onlyHash == 0) {
                if (numSuggestions <= 1) {
                    this.applySelectedSuggestionAndClose(((SuggestionComponent)onlyLeftList.get(0)).getIndex());
                    return;
                }
                this.incrementLevel = Integer.MAX_VALUE;
                List list = onlyLeftList;
            } else {
                if (numSuggestions == 1) {
                    this.applySelectedSuggestionAndClose(((SuggestionComponent)onlyLeftList.get(0)).getIndex());
                    return;
                }
                ++this.incrementLevel;
                this.updateIncrementLevel(this.incrementLevel, onlyHash);
                return;
            }
        }
        for (int i = components.length - 1; i >= 0; --i) {
            void var6_10;
            Component c;
            c = components[i];
            if (!var6_10.contains(c)) {
                if (!(c instanceof SuggestionComponent)) continue;
                c.setVisible(false);
                ((SuggestionComponent)c).setIncrementalModeLevel(-1);
                continue;
            }
            ((SuggestionComponent)c).setIncrementalModeLevel(this.incrementLevel != Integer.MAX_VALUE ? this.incrementLevel : -1);
            c.setVisible(true);
        }
        if (this.incrementLevel != Integer.MAX_VALUE) {
            this.incrementalLevelLabel.setText(String.format("%s: -%d-", ElanLocale.getString("InterlinearEditor.Suggestions.SelectNextFragment"), this.incrementLevel + 1));
        } else {
            this.incrementalLevelLabel.setText(ElanLocale.getString("InterlinearEditor.Suggestions.SelectFinal"));
        }
        this.springLayout.layoutContainer(this.toolBarPanel);
        this.selector.doLayout();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Container contentPane = this.getContentPane();
        this.dragStartPoint = e.getPoint();
        Object source = e.getSource();
        if (source == contentPane) {
            this.dragCorner = 0;
        } else if (e.getSource() == this.selectorScrollPane) {
            if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                ClientLogger.LOG.finer(String.format("SuggestionWindow.mousePressed: Scrollpane %s", e.getPoint().toString()));
            }
        } else if (ClientLogger.LOG.isLoggable(Level.FINER)) {
            ClientLogger.LOG.finer(String.format("SuggestionWindow.mousePressed: other source %s", e.toString()));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragCorner = 0;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.checkToolPanelLabels();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.selector.init();
        this.selector.workAroundTooltipBug(this);
        int unitHeight = this.selector.getUnitHeight();
        int sideMargin = (this.getWidth() - this.getContentPane().getWidth()) / 2;
        int topMargin = this.getHeight() - this.getContentPane().getHeight() - sideMargin;
        this.windowMargins.set(Math.max(topMargin, 0) + this.toolBarPanel.getHeight(), sideMargin, sideMargin, sideMargin);
        this.selectorScrollPane.getVerticalScrollBar().setUnitIncrement(unitHeight);
        this.selectorScrollPane.getHorizontalScrollBar().setUnitIncrement(unitHeight);
        this.selectorScrollPane.revalidate();
        if (this.prefWindowBounds != null) {
            this.setBoundsChecked(this.prefWindowBounds);
        } else {
            this.setSize(this.getPreferredSize());
        }
        if (this.incrementalMode) {
            this.incrementMap = new LinkedHashMap<Integer, List<SuggestionComponent>>(8);
            this.incrementLevel = 0;
            this.updateIncrementLevel(this.incrementLevel, -1);
        }
        if (this.reversedOrderMode) {
            this.selector.reverseOrderOfSuggestions();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (ClientLogger.LOG.isLoggable(Level.FINER)) {
            ClientLogger.LOG.finer(String.format("SuggestionWindow.keyTyped %s", String.valueOf(e)));
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (ClientLogger.LOG.isLoggable(Level.FINER)) {
            ClientLogger.LOG.finer(String.format("SuggestionWindow.keyPressed %s", String.valueOf(e)));
        }
        if (this.suggestionSelectionListener != null) {
            IGTSuggestionViewerModel model = this.selector.getModel();
            int selectedIndex = 1;
            int code = e.getKeyCode();
            switch (code) {
                case 10: 
                case 32: {
                    code = 49;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    selectedIndex = code - 48;
                    if (selectedIndex == 0) {
                        selectedIndex = 10;
                    }
                    if (e.isShiftDown()) {
                        selectedIndex += 10;
                    }
                    if (selectedIndex > this.selector.getVisibleSuggestionCount()) break;
                    if (!this.incrementalMode || this.incrementLevel == Integer.MAX_VALUE) {
                        int modelIndex = this.selector.convertVisibleIndexToModel(selectedIndex - 1);
                        if (modelIndex <= -1 || modelIndex >= model.getRowCount()) break;
                        if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                            ClientLogger.LOG.finer(String.format("visibleSuggestionSelected %d\n", modelIndex));
                        }
                        this.applySelectedSuggestionAndClose(modelIndex);
                        break;
                    }
                    SuggestionComponent sugComp = this.selector.getSuggestionAtVisibleIndex(selectedIndex - 1);
                    int hash = sugComp.getHashOfFrag(this.incrementLevel);
                    ++this.incrementLevel;
                    this.updateIncrementLevel(this.incrementLevel, hash);
                    break;
                }
                case 8: 
                case 9: 
                case 127: {
                    if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                        ClientLogger.LOG.finer("suggestionIgnored");
                    }
                    this.applySelectedSuggestionAndClose(-1);
                    break;
                }
                case 27: 
                case 87: {
                    SuggestionSelectionEvent event = new SuggestionSelectionEvent(model, -1);
                    if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                        ClientLogger.LOG.finer("suggestionClosed");
                    }
                    this.suggestionSelectionListener.suggestionClosed(event);
                    this.closeSelectionWindow();
                    break;
                }
                case 33: {
                    JScrollBar sb = this.selectorScrollPane.getVerticalScrollBar();
                    sb.setValue(sb.getValue() - sb.getBlockIncrement(-1));
                    break;
                }
                case 34: {
                    JScrollBar sb = this.selectorScrollPane.getVerticalScrollBar();
                    sb.setValue(sb.getValue() + sb.getBlockIncrement(1));
                    break;
                }
                case 38: {
                    JScrollBar sb = this.selectorScrollPane.getVerticalScrollBar();
                    sb.setValue(sb.getValue() - sb.getUnitIncrement(-1));
                    break;
                }
                case 40: {
                    JScrollBar sb = this.selectorScrollPane.getVerticalScrollBar();
                    sb.setValue(sb.getValue() + sb.getUnitIncrement(1));
                    break;
                }
                case 37: {
                    JScrollBar sb = this.selectorScrollPane.getHorizontalScrollBar();
                    sb.setValue(sb.getValue() - sb.getUnitIncrement(-1));
                    break;
                }
                case 39: {
                    JScrollBar sb = this.selectorScrollPane.getHorizontalScrollBar();
                    sb.setValue(sb.getValue() + sb.getUnitIncrement(1));
                    break;
                }
                case 82: {
                    this.reverseButton.doClick();
                    break;
                }
                case 73: {
                    this.incrementalSelectCB.doClick();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (ClientLogger.LOG.isLoggable(Level.FINER)) {
            ClientLogger.LOG.finer(String.format("SuggestionWindow.keyReleased %s", String.valueOf(e)));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.reverseButton) {
            if (this.selector != null) {
                this.selector.reverseOrderOfSuggestions();
            }
            this.reverseButton.transferFocusUpCycle();
            this.reversedOrderMode = !this.reversedOrderMode;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.incrementalSelectCB) {
            if (this.selector != null) {
                boolean bl = this.incrementalMode = e.getStateChange() == 1;
                if (this.incrementalMode) {
                    this.incrementMap = new LinkedHashMap<Integer, List<SuggestionComponent>>(8);
                    this.incrementLevel = 0;
                    this.updateIncrementLevel(this.incrementLevel, -1);
                } else {
                    this.incrementLevel = -1;
                    this.increaseChoiceOfSuggestions();
                    this.incrementalLevelLabel.setText("");
                }
            }
            this.checkToolPanelLabels();
            this.incrementalSelectCB.transferFocusUpCycle();
        }
    }

    private void checkToolPanelLabels() {
        if (this.reuseWindowBoundsCB == null) {
            return;
        }
        if (this.incrementalMode) {
            if (this.reuseWindowBoundsCB.getX() > 0 && this.reuseWindowBoundsCB.getY() > 0) {
                Rectangle leftComp = this.incrementalLevelLabel.getBounds();
                if (leftComp.x + leftComp.width >= this.reuseWindowBoundsCB.getX()) {
                    this.reuseWindowBoundsCB.setToolTipText(this.reuseWindowBoundsCB.getText());
                    this.reuseWindowBoundsCB.setText("");
                } else {
                    this.reuseWindowBoundsCB.setToolTipText(null);
                    this.reuseWindowBoundsCB.setText(ElanLocale.getString("InterlinearEditor.Suggestions.RestoreWindowBounds"));
                }
            }
        } else if (this.reuseWindowBoundsCB.getText().isEmpty()) {
            this.reuseWindowBoundsCB.setToolTipText(null);
            this.reuseWindowBoundsCB.setText(ElanLocale.getString("InterlinearEditor.Suggestions.RestoreWindowBounds"));
        }
    }

    private void setBoundsChecked(Rectangle restBounds) {
        try {
            Dimension screenSizeDim = Toolkit.getDefaultToolkit().getScreenSize();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
            if (restBounds.x < screenInsets.left) {
                restBounds.x = screenInsets.left;
            }
            if (restBounds.x + restBounds.width > screenSizeDim.width - screenInsets.right) {
                restBounds.x = screenSizeDim.width - screenInsets.right - restBounds.width;
            }
            if (restBounds.y < screenInsets.top) {
                restBounds.y = screenInsets.top;
            }
            if (restBounds.y + restBounds.height > screenSizeDim.height - screenInsets.bottom) {
                restBounds.y = screenSizeDim.height - screenInsets.bottom - restBounds.height;
            }
            this.setBounds(restBounds);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (SuggestionWindow.this.selector != null) {
                if (SuggestionWindow.this.suggestionSelectionListener != null) {
                    SuggestionSelectionEvent event = new SuggestionSelectionEvent(SuggestionWindow.this.selector.getModel(), -1);
                    SuggestionWindow.this.suggestionSelectionListener.suggestionClosed(event);
                }
                SuggestionWindow.this.closeSelectionWindow();
            }
        }
    }
}

