/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import mpi.eudico.util.ExtClassLoader;
import nl.mpi.lexan.analyzers.TextAnalyzer;
import nl.mpi.lexan.analyzers.helpers.Information;

public class TextAnalyzerRegistry {
    private static TextAnalyzerRegistry analyzerRegistry;
    private final Logger LOG = Logger.getLogger("ClientLogger");
    private List<TextAnalyzer> instantiatedAnalyzers = new ArrayList<TextAnalyzer>();
    private List<Class<? extends TextAnalyzer>> analyzersClassList = new ArrayList<Class<? extends TextAnalyzer>>();
    private List<Information> informationList = new ArrayList<Information>();
    private Map<Information, Class<? extends TextAnalyzer>> info2analyzerClass = new HashMap<Information, Class<? extends TextAnalyzer>>();
    private Map<Information, TextAnalyzer> info2Analyzer = new HashMap<Information, TextAnalyzer>();
    private Map<String, Map<Information, TextAnalyzer>> doc2AnalyzerMap = new HashMap<String, Map<Information, TextAnalyzer>>();

    private TextAnalyzerRegistry() {
        this.initLoad();
    }

    public static TextAnalyzerRegistry getInstance() {
        if (analyzerRegistry == null) {
            analyzerRegistry = new TextAnalyzerRegistry();
        }
        return analyzerRegistry;
    }

    private void initLoad() {
        List<TextAnalyzer> instList = ExtClassLoader.getInstance().getInstanceList(TextAnalyzer.class);
        if (instList != null) {
            for (TextAnalyzer ta : instList) {
                this.instantiatedAnalyzers.add(ta);
                this.analyzersClassList.add(ta.getClass());
                Information information = ta.getInformation();
                this.informationList.add(information);
                this.info2analyzerClass.put(information, ta.getClass());
                this.info2Analyzer.put(information, ta);
            }
        }
    }

    public List<TextAnalyzer> getTextAnalyzers() {
        return this.instantiatedAnalyzers;
    }

    public List<Information> getAnalyzersInfo() {
        return this.informationList;
    }

    public TextAnalyzer getAnalyzerInstance(Information info) {
        TextAnalyzer ta = this.info2Analyzer.get(info);
        if (ta != null) {
            return ta;
        }
        Class<? extends TextAnalyzer> taClass = this.info2analyzerClass.get(info);
        if (taClass != null) {
            ta = ExtClassLoader.getInstance().createInstance(taClass);
            this.info2Analyzer.put(info, ta);
        }
        return ta;
    }

    public TextAnalyzer getAnalyzerForDoc(String documentId, Information info) {
        Class<? extends TextAnalyzer> taClass;
        if (documentId == null || info == null) {
            return null;
        }
        TextAnalyzer ta = null;
        Map<Information, TextAnalyzer> mapForDoc = this.doc2AnalyzerMap.get(documentId);
        if (mapForDoc == null) {
            mapForDoc = new HashMap<Information, TextAnalyzer>();
            this.doc2AnalyzerMap.put(documentId, mapForDoc);
        }
        if ((ta = mapForDoc.get(info)) == null && (taClass = this.info2analyzerClass.get(info)) != null) {
            ta = ExtClassLoader.getInstance().createInstance(taClass);
            mapForDoc.put(info, ta);
        }
        return ta;
    }

    public void removeAnalyzerForDoc(String documentId, Information info) {
        TextAnalyzer ta;
        Map<Information, TextAnalyzer> mapForDoc = this.doc2AnalyzerMap.remove(documentId);
        if (mapForDoc == null || (ta = mapForDoc.remove(info)) != null) {
            // empty if block
        }
    }

    public void removeAnalyzersForDoc(String documentId) {
        Map<Information, TextAnalyzer> mapForDoc = this.doc2AnalyzerMap.remove(documentId);
        if (mapForDoc != null) {
            mapForDoc.clear();
        }
    }
}

