/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.actions;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.interlinear.edit.TextAnalyzerLexiconHostContext;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTEditAction;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;

public class IGTAddToLexiconAction
extends IGTEditAction {
    private TextAnalyzerLexiconHostContext lexHostContext;

    public IGTAddToLexiconAction(IGTAnnotation igtAnnotation, TextAnalyzerLexiconHostContext lexHostContext, String label) {
        super(igtAnnotation, label);
        this.lexHostContext = lexHostContext;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.lexHostContext != null) {
            AbstractAnnotation annotation = null;
            if (this.igtAnnotation != null) {
                annotation = this.igtAnnotation.getAnnotation();
            } else {
                Transcription tr = this.lexHostContext.getTranscription();
                ViewerManager2 vm = ELANCommandFactory.getViewerManager(tr);
                annotation = (AbstractAnnotation)vm.getActiveAnnotation().getAnnotation();
            }
            LexiconQueryBundle2 lexiconBundle = null;
            if (annotation == null) {
                if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                    ClientLogger.LOG.info("Add to Lexicon action called without a selected or active annotation");
                }
                return;
            }
            lexiconBundle = annotation.getTier().getLinguisticType().getLexiconQueryBundle();
            if (lexiconBundle != null) {
                HashMap<String, String> initValues = new HashMap<String, String>(6);
                initValues.put(lexiconBundle.getFldId().getName(), annotation.getValue());
                this.addAncestorFields(annotation, initValues);
                this.addDescendantFields(annotation, initValues);
                this.lexHostContext.initiateCreateNewEntry(lexiconBundle, initValues);
            } else if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                ClientLogger.LOG.info("Cannot add to lexicon: the tier of this annotation is not linked to a lexicon field");
            }
        } else if (ClientLogger.LOG.isLoggable(Level.INFO)) {
            ClientLogger.LOG.info("Cannot add to lexicon: lexicon host context is missing");
        }
    }

    private void addAncestorFields(AbstractAnnotation annotation, Map<String, String> fieldValues) {
        AbstractAnnotation parentAnn = (AbstractAnnotation)annotation.getParentAnnotation();
        if (parentAnn != null) {
            LexiconQueryBundle2 lexiconBundle = parentAnn.getTier().getLinguisticType().getLexiconQueryBundle();
            if (lexiconBundle != null) {
                fieldValues.put(lexiconBundle.getFldId().getName(), parentAnn.getValue());
            }
            this.addAncestorFields(parentAnn, fieldValues);
        }
    }

    private void addDescendantFields(AbstractAnnotation annotation, Map<String, String> fieldValues) {
        Tier t = annotation.getTier();
        List<? extends Tier> childList = t.getChildTiers();
        for (Tier tier : childList) {
            AbstractAnnotation chAnn;
            if (tier.getLinguisticType().getConstraints().getStereoType() != 4 || tier.getLinguisticType().getLexiconQueryBundle() == null || (chAnn = (AbstractAnnotation)((TierImpl)tier).getAnnotationAtTime((annotation.getBeginTimeBoundary() + annotation.getEndTimeBoundary()) / 2L)) == null) continue;
            if (!chAnn.getValue().isEmpty()) {
                fieldValues.put(tier.getLinguisticType().getLexiconQueryBundle().getFldId().getName(), chAnn.getValue());
            }
            this.addDescendantFields(chAnn, fieldValues);
        }
    }
}

