/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.interlinear.edit.TextAnalyzerHostContext;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTEditAction;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import nl.mpi.lexan.analyzers.helpers.Position;

public class IGTCreateDependentAnnotationsAction
extends IGTEditAction {
    protected TextAnalyzerHostContext hostContext;

    public IGTCreateDependentAnnotationsAction(IGTAnnotation igtAnnotation, TextAnalyzerHostContext hostContext) {
        super(igtAnnotation);
        this.hostContext = hostContext;
    }

    public IGTCreateDependentAnnotationsAction(IGTAnnotation igtAnnotation, TextAnalyzerHostContext hostContext, String label) {
        super(igtAnnotation, label);
        this.hostContext = hostContext;
    }

    public IGTCreateDependentAnnotationsAction(IGTAnnotation igtAnnotation, TextAnalyzerHostContext hostContext, String label, Icon icon) {
        super(igtAnnotation, label, icon);
        this.hostContext = hostContext;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.hostContext != null) {
            AbstractAnnotation aa = null;
            Transcription tr = this.hostContext.getTranscription();
            if (this.igtAnnotation != null) {
                aa = this.igtAnnotation.getAnnotation();
            } else {
                ViewerManager2 vm = ELANCommandFactory.getViewerManager(tr);
                aa = (AbstractAnnotation)vm.getActiveAnnotation().getAnnotation();
            }
            if (aa != null) {
                Position pos = new Position(aa.getTier().getName(), aa.getBeginTimeBoundary(), aa.getEndTimeBoundary());
                TierImpl tier = (TierImpl)aa.getTier();
                if (!tier.getChildTiers().isEmpty()) {
                    Command command = ELANCommandFactory.createCommand(tr, "Menu.Annotation.CreateDependingAnnotations");
                    Object[] args = new Object[]{new Long(aa.getBeginTimeBoundary()), new Long(aa.getEndTimeBoundary())};
                    command.execute(tier, args);
                    this.hostContext.annotationsAdded(pos);
                }
            }
        }
    }
}

