/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Icon;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.interlinear.edit.TextAnalyzerHostContext;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTEditAction;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import nl.mpi.lexan.analyzers.helpers.Position;

public class IGTSplitAnnotationAction
extends IGTEditAction {
    public static final int SPLIT = 0;
    public static final int NEW_BEFORE = 1;
    public static final int NEW_AFTER = 2;
    protected TextAnalyzerHostContext hostContext;
    protected int variant;

    public IGTSplitAnnotationAction(IGTAnnotation igtAnnotation, TextAnalyzerHostContext hostContext, int variant) {
        super(igtAnnotation);
        this.hostContext = hostContext;
        this.variant = variant;
    }

    public IGTSplitAnnotationAction(IGTAnnotation igtAnnotation, TextAnalyzerHostContext hostContext, int variant, String label) {
        super(igtAnnotation, label);
        this.hostContext = hostContext;
        this.variant = variant;
    }

    public IGTSplitAnnotationAction(IGTAnnotation igtAnnotation, TextAnalyzerHostContext hostContext, int variant, String label, Icon icon) {
        super(igtAnnotation, label, icon);
        this.hostContext = hostContext;
        this.variant = variant;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.hostContext != null) {
            AbstractAnnotation aa = null;
            Transcription tr = this.hostContext.getTranscription();
            if (this.igtAnnotation != null) {
                aa = this.igtAnnotation.getAnnotation();
            } else {
                ViewerManager2 vm = ELANCommandFactory.getViewerManager(tr);
                aa = (AbstractAnnotation)vm.getActiveAnnotation().getAnnotation();
            }
            if (aa != null) {
                Position pos = new Position(aa.getTier().getName(), aa.getBeginTimeBoundary(), aa.getEndTimeBoundary());
                if (this.variant == 0) {
                    if (this.canSplit(aa)) {
                        Command command = ELANCommandFactory.createCommand(tr, "Menu.Annotation.SplitAnnotation");
                        Object[] args = new Object[]{aa};
                        command.execute(tr, args);
                        this.hostContext.annotationsAdded(pos);
                    }
                } else {
                    TierImpl t = (TierImpl)aa.getTier();
                    Constraint c = t.getLinguisticType().getConstraints();
                    if (c != null && c.supportsInsertion()) {
                        String cmd = this.variant == 2 ? "Menu.Annotation.NewAnnotationAfter" : "Menu.Annotation.NewAnnotationBefore";
                        Command command = ELANCommandFactory.createCommand(tr, cmd);
                        Object[] args = new Object[]{aa};
                        command.execute(t, args);
                        this.hostContext.annotationsAdded(pos);
                    }
                }
            }
        }
    }

    private boolean canSplit(AbstractAnnotation aa) {
        TierImpl t = (TierImpl)aa.getTier();
        if (t.getParentTier() == null) {
            boolean onlySymAssChildren = true;
            List<TierImpl> childTiers = t.getChildTiers();
            if (childTiers.isEmpty()) {
                return true;
            }
            for (TierImpl ti : childTiers) {
                if (ti.getLinguisticType().getConstraints().getStereoType() == 4 || aa.getChildrenOnTier(ti).isEmpty()) continue;
                onlySymAssChildren = false;
                break;
            }
            return onlySymAssChildren;
        }
        return false;
    }
}

