/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.interlinear.edit.PotentialTiers;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerConfig;
import mpi.eudico.client.annotator.layout.InterlinearizationManager;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import nl.mpi.lexan.analyzers.helpers.Information;

public class AnalyzerConfigDialog
extends ClosableDialog
implements ActionListener {
    private static final String SELECT = ElanLocale.getString("InterlinearAnalyzerConfigDlg.ComboBoxDefaultString");
    private static final String NO_TIERS = ElanLocale.getString("InterlinearAnalyzerConfigDlg.NoSource");
    private static final String COLUMN_NO = ElanLocale.getString("TranscriptionTable.Column.No");
    private static final int TIER_MODE = 0;
    private static final int TYPE_MODE = 1;
    private InterlinearizationManager manager;
    private JRadioButton tierRB;
    private JRadioButton typeRB;
    private JLabel infoLabel;
    private JTable configsTable;
    private DefaultTableModel configsModel;
    private JComboBox annotSelCB;
    private JComboBox sourceCB;
    private JComboBox destinationCB;
    private JButton deleteButton;
    private JButton applyButton;
    private JButton cancelButton;
    private Map<String, List<String>> typesMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> tiersMap = new HashMap<String, List<String>>();
    private int currentMode = -1;
    private boolean isApplied = false;
    private List<AConfig> typeConfigMap = new ArrayList<AConfig>();
    private List<AConfig> tierConfigMap = new ArrayList<AConfig>();
    private Map<String, PotentialTiers> potentialTiersMap = new HashMap<String, PotentialTiers>();
    int maxTargetTiers = 1;
    private PotentialTiers potentialTiers;
    private ArrayList<String> usedSources;
    private static final int NUMBER_INDEX = 0;
    private static final int ANALYZER_INDEX = 1;
    private static final int SOURCE_INDEX = 2;
    private static final int TARGET1_INDEX = 3;

    public AnalyzerConfigDialog(ElanFrame2 frame, InterlinearizationManager manager) {
        super(frame, ElanLocale.getString("InterlinearAnalyzerConfigDlg.Title"), true);
        this.manager = manager;
        this.currentMode = 1;
        this.initComponents();
        this.postInit();
    }

    private void postInit() {
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.tierRB = new JRadioButton(ElanLocale.getString("InterlinearAnalyzerConfigDlg.Tiers"));
        this.tierRB.addActionListener(this);
        this.typeRB = new JRadioButton(ElanLocale.getString("InterlinearAnalyzerConfigDlg.Types"));
        this.typeRB.addActionListener(this);
        this.sourceCB = new JComboBox();
        this.destinationCB = new JComboBox();
        this.annotSelCB = new JComboBox();
        this.infoLabel = new JLabel(ElanLocale.getString("InterlinearAnalyzerConfigDlg.Info"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.tierRB);
        group.add(this.typeRB);
        this.deleteButton = new JButton(ElanLocale.getString("Button.Delete"));
        this.deleteButton.addActionListener(this);
        this.applyButton = new JButton(ElanLocale.getString("Button.Apply"));
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        if (this.manager != null) {
            List<Information> analyzersList = this.manager.getTextAnalyzerContext().listTextAnalyzersInfo();
            if (analyzersList != null && analyzersList.size() > 0) {
                for (Information i : analyzersList) {
                    int nrTargetTiers = 0;
                    String idOrName = i.getName();
                    if (idOrName == null || idOrName.length() == 0) continue;
                    this.annotSelCB.addItem(idOrName);
                    List parameters = i.getParameters();
                    PotentialTiers potentialTiers = new PotentialTiers(parameters);
                    nrTargetTiers = potentialTiers.getNumberOfTargetTiers();
                    this.maxTargetTiers = Math.max(this.maxTargetTiers, nrTargetTiers);
                    this.potentialTiersMap.put(idOrName, potentialTiers);
                }
            } else {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("InterlinearAnalyzerConfigDlg.NoInfo"), ElanLocale.getString("Message.Warning"), 2);
            }
        }
        Object[] columnIdentifiers = new String[3 + this.maxTargetTiers];
        columnIdentifiers[0] = COLUMN_NO;
        columnIdentifiers[1] = "Analyzer";
        columnIdentifiers[2] = "Source";
        for (int i = 0; i < this.maxTargetTiers; ++i) {
            columnIdentifiers[3 + i] = "Target" + (i + 1);
        }
        this.configsModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (this.getColumnName(column).equals(COLUMN_NO)) {
                    return false;
                }
                Object value = this.getValueAt(row, column);
                return value != null && !value.equals(NO_TIERS);
            }
        };
        this.configsModel.setColumnIdentifiers(columnIdentifiers);
        this.configsTable = new JTable(this.configsModel){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                if (enabled) {
                    AnalyzerConfigDialog.this.configsTable.setGridColor(Color.BLACK);
                } else {
                    AnalyzerConfigDialog.this.configsTable.setGridColor(Color.GRAY);
                }
            }
        };
        DefaultTableCellRenderer render = new DefaultTableCellRenderer(){
            private Font italic;
            private Font plain;
            {
                this.italic = new Font(AnalyzerConfigDialog.this.configsTable.getFont().getFontName(), 2, AnalyzerConfigDialog.this.configsTable.getFont().getSize());
                this.plain = new Font(AnalyzerConfigDialog.this.configsTable.getFont().getFontName(), 0, AnalyzerConfigDialog.this.configsTable.getFont().getSize());
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int viewRow, int viewColumn) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, viewRow, viewColumn);
                if (value == null) {
                    int modelColumn = table.convertColumnIndexToModel(viewColumn);
                    if (modelColumn > 2) {
                        int targetTiers;
                        int modelRow = table.convertRowIndexToModel(viewRow);
                        String analyzer = (String)AnalyzerConfigDialog.this.configsModel.getValueAt(modelRow, 1);
                        if (!analyzer.equals(SELECT) && modelColumn > 2 + (targetTiers = ((PotentialTiers)AnalyzerConfigDialog.this.potentialTiersMap.get(analyzer)).getNumberOfTargetTiers())) {
                            cell.setBackground(Color.GRAY);
                            return cell;
                        }
                    }
                    cell.setBackground(Color.WHITE);
                    return cell;
                }
                cell.setBackground(Color.WHITE);
                if (table.isEnabled()) {
                    cell.setForeground(Color.BLACK);
                } else {
                    cell.setForeground(Color.GRAY);
                }
                if (value.equals(SELECT)) {
                    cell.setFont(this.italic);
                } else {
                    cell.setFont(this.plain);
                }
                return cell;
            }
        };
        this.configsTable.setCellSelectionEnabled(true);
        this.configsTable.setDefaultEditor(Object.class, new TableCellEditor());
        this.configsTable.setDefaultRenderer(Object.class, render);
        this.configsTable.setShowGrid(true);
        this.configsTable.setSelectionBackground(Color.WHITE);
        this.configsTable.setRowHeight(this.configsTable.getRowHeight() + 5);
        this.configsTable.getColumnModel().getColumn(0).setMinWidth(50);
        this.configsTable.getColumnModel().getColumn(0).setMaxWidth(50);
        this.configsTable.setEnabled(false);
        Insets inset = new Insets(5, 10, 5, 10);
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(4, 6, 4, 6);
        JPanel sourceTypePanel = new JPanel(new GridBagLayout());
        sourceTypePanel.setBorder(new TitledBorder(ElanLocale.getString("InterlinearAnnoInterlinearAnalyzerConfigDlgConfigDlg.Mode")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 18;
        sourceTypePanel.add((Component)this.tierRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        sourceTypePanel.add((Component)this.typeRB, gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = inset;
        gbc.weightx = 1.0;
        buttonPanel.add((Component)this.deleteButton, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.anchor = 14;
        buttonPanel.add((Component)this.applyButton, gbc);
        gbc.gridx = 3;
        buttonPanel.add((Component)this.cancelButton, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 10, 6);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        this.getContentPane().add((Component)this.infoLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)new JScrollPane(this.configsTable), gbc);
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                AnalyzerConfigDialog.this.doClose();
            }
        });
        this.loadTierAndTypeMap();
        if (this.tiersMap.size() < 1) {
            this.tierRB.setEnabled(false);
            this.typeRB.setEnabled(false);
            JOptionPane.showMessageDialog(this, ElanLocale.getString("InterlinearAnalyzerConfigDlg.NoTier"), ElanLocale.getString("Message.Warning"), 2);
        } else {
            List<AnalyzerConfig> list = this.manager.getTextAnalyzerContext().getConfigurations();
            for (AnalyzerConfig analyzerConfig : list) {
                AConfig mappings = new AConfig(analyzerConfig.annotId.getName(), analyzerConfig.getSource(), analyzerConfig.getDest());
                if (analyzerConfig.isTypeMode()) {
                    this.typeConfigMap.add(mappings);
                    continue;
                }
                this.tierConfigMap.add(mappings);
            }
            this.readPreferences();
        }
    }

    private void storePreferences() {
    }

    private void readPreferences() {
        this.updateTableForMode(1, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.tierRB) {
            if (this.currentMode != 0) {
                this.updateTableForMode(0, true);
            }
        } else if (source == this.typeRB) {
            if (this.currentMode != 1) {
                this.addConfigurations();
                this.updateTableForMode(1, true);
            }
        } else if (source == this.cancelButton) {
            this.tierConfigMap.clear();
            this.typeConfigMap.clear();
            this.storePreferences();
            this.doClose();
        } else if (source == this.applyButton) {
            this.isApplied = true;
            this.addConfigurations();
            this.storePreferences();
            this.doClose();
        } else if (source == this.deleteButton) {
            int row = this.configsTable.getSelectedRow();
            int rowcount = this.configsTable.getRowCount();
            Object[] obj = new Object[3 + this.maxTargetTiers];
            obj[0] = 0;
            obj[1] = SELECT;
            obj[2] = null;
            for (int i = 0; i < this.maxTargetTiers; ++i) {
                obj[3 + i] = null;
            }
            if (row == rowcount - 1) {
                this.configsModel.removeRow(row);
                this.configsModel.addRow(obj);
                this.configsModel.setValueAt(this.configsTable.getRowCount(), this.configsTable.getRowCount() - 1, 0);
            } else if (row > -1) {
                for (int n = row + 1; n < rowcount; ++n) {
                    this.configsModel.setValueAt(n, n, 0);
                }
                this.configsModel.removeRow(row);
                if (this.configsModel.getRowCount() == 0) {
                    this.configsModel.addRow(obj);
                    this.configsModel.setValueAt(1, 0, 0);
                } else {
                    String t = (String)this.configsModel.getValueAt(this.configsModel.getRowCount() - 1, 1);
                    if (t == null || t.equals(NO_TIERS)) {
                        this.configsModel.setValueAt(SELECT, this.configsModel.getRowCount() - 1, 1);
                    } else if (!t.equals(SELECT)) {
                        this.configsModel.addRow(obj);
                        this.configsModel.setValueAt(this.configsTable.getRowCount(), this.configsTable.getRowCount() - 1, 0);
                    }
                }
                ((TableCellEditor)this.configsTable.getDefaultEditor(Object.class)).setLastUpdatedRow(-1);
            }
        }
    }

    private void loadTierAndTypeMap() {
        List<TierImpl> list = ((TranscriptionImpl)this.manager.getTranscription()).getTiers();
        ArrayList<String> allTierNames = new ArrayList<String>(list.size());
        ArrayList<String> allTypeNames = new ArrayList<String>();
        this.tiersMap.clear();
        this.typesMap.clear();
        for (TierImpl tier : list) {
            List<TierImpl> childList;
            String typeName = tier.getLinguisticType().getLinguisticTypeName();
            allTierNames.add(tier.getName());
            if (!allTypeNames.contains(typeName)) {
                allTypeNames.add(typeName);
            }
            List<String> childTypeNamesList = null;
            if (this.typesMap.containsKey(typeName)) {
                childTypeNamesList = this.typesMap.get(typeName);
            }
            if ((childList = tier.getChildTiers()) == null || childList.isEmpty()) continue;
            ArrayList<String> childTierNamesList = new ArrayList<String>();
            if (childTypeNamesList == null) {
                childTypeNamesList = new ArrayList<String>();
            }
            for (TierImpl child : childList) {
                childTierNamesList.add(child.getName());
                String linguisticTypeName = child.getLinguisticType().getLinguisticTypeName();
                if (childTypeNamesList.contains(linguisticTypeName)) continue;
                childTypeNamesList.add(linguisticTypeName);
            }
            this.tiersMap.put(tier.getName(), childTierNamesList);
            this.typesMap.put(typeName, childTypeNamesList);
        }
        this.tiersMap.put("", allTierNames);
        this.typesMap.put("", allTypeNames);
    }

    private void addConfigurations() {
        List<AConfig> configMap = this.getConfigurationMap();
        configMap.clear();
        int rowCount = this.configsModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String sourceName;
            ArrayList<String> destList = new ArrayList<String>();
            String analyzerName = (String)this.configsModel.getValueAt(i, 1);
            if (analyzerName.equals(SELECT) || (sourceName = (String)this.configsModel.getValueAt(i, 2)).equals(NO_TIERS) || sourceName.equals(SELECT)) continue;
            int columnCount = this.configsModel.getColumnCount();
            for (int c = 3; c < columnCount; ++c) {
                String destName = (String)this.configsModel.getValueAt(i, c);
                if (destName == null || destName.equals(SELECT)) continue;
                destList.add(destName);
            }
            if (this.potentialTiersMap.get(analyzerName).getNumberOfTargetTiers() != destList.size()) continue;
            AConfig config = new AConfig(analyzerName, sourceName, destList);
            configMap.add(config);
        }
    }

    private List<AConfig> getConfigurationMap() {
        return this.getConfigurationMap(this.isTypeMode());
    }

    public List<AConfig> getConfigurationMap(boolean isTypeMode) {
        if (isTypeMode) {
            return this.typeConfigMap;
        }
        return this.tierConfigMap;
    }

    public boolean isTypeMode() {
        return this.currentMode != 0;
    }

    public boolean isApplied() {
        return this.isApplied;
    }

    private void updateTableForMode(int mode, boolean saveCurrentMapping) {
        if (this.configsTable.isEditing()) {
            this.configsTable.editingStopped(new ChangeEvent(this));
        }
        if (saveCurrentMapping) {
            this.addConfigurations();
        }
        while (this.configsModel.getRowCount() > 0) {
            this.configsModel.removeRow(this.configsModel.getRowCount() - 1);
        }
        this.configsTable.setEnabled(false);
        this.currentMode = mode;
        List<AConfig> configList = this.getConfigurationMap();
        int n = 1;
        for (AConfig config : configList) {
            Object[] rowEntry = new Object[3 + this.maxTargetTiers];
            rowEntry[0] = n++;
            rowEntry[1] = config.getAnalyzer();
            rowEntry[2] = config.getSource();
            List<String> targetList = config.getTargetTierList();
            int numTargetTiers = targetList.size();
            for (int i = 0; i < this.maxTargetTiers; ++i) {
                rowEntry[3 + i] = i < numTargetTiers ? targetList.get(i) : null;
            }
            this.configsModel.addRow(rowEntry);
        }
        this.configsModel.addRow(new Object[]{n++, SELECT, null, null});
        this.configsTable.setEnabled(true);
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    private void setupPotentialTiers(int modelRow) {
        Map<String, List<String>> theMap = this.isTypeMode() ? this.typesMap : this.tiersMap;
        String analyzerName = (String)this.configsModel.getValueAt(modelRow, 1);
        this.potentialTiers = this.potentialTiersMap.get(analyzerName);
        this.potentialTiers.setChildMap(theMap, this.isTypeMode());
        this.usedSources = new ArrayList();
        int rowCount = this.configsModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String sourceName;
            if (i == modelRow || this.usedSources.contains(sourceName = (String)this.configsModel.getValueAt(i, 2))) continue;
            this.usedSources.add(sourceName);
        }
    }

    private class TableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private int startEditInOneClick;
        private int viewRow;
        private int lastUpdatedRow;
        private int modelColumn;

        public TableCellEditor() {
            super(new JComboBox());
            this.startEditInOneClick = 1;
            this.lastUpdatedRow = -1;
            this.setClickCountToStart(this.startEditInOneClick);
        }

        public void setLastUpdatedRow(int row) {
            this.lastUpdatedRow = row;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int viewRow, int viewColumn) {
            this.viewRow = viewRow;
            this.modelColumn = table.convertColumnIndexToModel(viewColumn);
            if (this.modelColumn == 1) {
                AnalyzerConfigDialog.this.annotSelCB.removeActionListener(this);
                if (value.equals(SELECT)) {
                    AnalyzerConfigDialog.this.annotSelCB.setSelectedItem(null);
                } else {
                    AnalyzerConfigDialog.this.annotSelCB.setSelectedItem(value);
                }
                AnalyzerConfigDialog.this.annotSelCB.addActionListener(this);
                AnalyzerConfigDialog.this.potentialTiers = null;
                return AnalyzerConfigDialog.this.annotSelCB;
            }
            if (this.lastUpdatedRow != viewRow) {
                AnalyzerConfigDialog.this.setupPotentialTiers(table.convertRowIndexToModel(viewRow));
                this.lastUpdatedRow = viewRow;
            }
            if (this.modelColumn == 2) {
                AnalyzerConfigDialog.this.sourceCB.removeActionListener(this);
                AnalyzerConfigDialog.this.sourceCB.removeAllItems();
                AnalyzerConfigDialog.this.potentialTiers.setTierName(this.modelColumn - 2, "");
                List<String> sources = AnalyzerConfigDialog.this.potentialTiers.getPotentialSourceNames(this.modelColumn - 2, Collections.emptyList());
                if (sources.isEmpty()) {
                    table.setValueAt(NO_TIERS, viewRow, viewColumn);
                    return null;
                }
                for (String s : sources) {
                    AnalyzerConfigDialog.this.sourceCB.addItem(s);
                }
                if (value.equals(SELECT)) {
                    AnalyzerConfigDialog.this.sourceCB.setSelectedItem(null);
                } else {
                    AnalyzerConfigDialog.this.sourceCB.setSelectedItem(value);
                }
                AnalyzerConfigDialog.this.sourceCB.addActionListener(this);
                return AnalyzerConfigDialog.this.sourceCB;
            }
            AnalyzerConfigDialog.this.destinationCB.removeActionListener(this);
            AnalyzerConfigDialog.this.destinationCB.removeAllItems();
            AnalyzerConfigDialog.this.potentialTiers.setTierName(this.modelColumn - 2, "");
            List<String> destList = AnalyzerConfigDialog.this.potentialTiers.getPotentialTargetNames(this.modelColumn - 2);
            for (String n : destList) {
                AnalyzerConfigDialog.this.destinationCB.addItem(n);
            }
            if (value.equals(SELECT)) {
                AnalyzerConfigDialog.this.destinationCB.setSelectedItem(null);
            } else {
                AnalyzerConfigDialog.this.destinationCB.setSelectedItem(value);
            }
            AnalyzerConfigDialog.this.destinationCB.addActionListener(this);
            return AnalyzerConfigDialog.this.destinationCB;
        }

        @Override
        public Object getCellEditorValue() {
            Object editorValue = null;
            editorValue = this.modelColumn == 1 ? AnalyzerConfigDialog.this.annotSelCB.getSelectedItem() : (this.modelColumn == 2 ? AnalyzerConfigDialog.this.sourceCB.getSelectedItem() : AnalyzerConfigDialog.this.destinationCB.getSelectedItem());
            if (editorValue == null) {
                return SELECT;
            }
            return editorValue;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int numTargetTiers;
            int nextModelColumn;
            if (!(e.getSource() instanceof JComboBox)) {
                return;
            }
            int modelRow = AnalyzerConfigDialog.this.configsTable.convertRowIndexToModel(this.viewRow);
            Object selectedItem = this.getCellEditorValue();
            if (this.modelColumn == 1) {
                this.lastUpdatedRow = -1;
            } else if (this.modelColumn >= 2 && AnalyzerConfigDialog.this.potentialTiers != null) {
                AnalyzerConfigDialog.this.potentialTiers.setTierName(this.modelColumn - 2, selectedItem.toString());
            }
            if (selectedItem.toString().equals(AnalyzerConfigDialog.this.configsModel.getValueAt(modelRow, this.modelColumn))) {
                AnalyzerConfigDialog.this.configsTable.editingStopped(new ChangeEvent(this));
                return;
            }
            AnalyzerConfigDialog.this.configsTable.editingStopped(new ChangeEvent(this));
            if (selectedItem.toString().equals(SELECT)) {
                for (nextModelColumn = this.modelColumn + 1; nextModelColumn <= AnalyzerConfigDialog.this.configsModel.getColumnCount() - 1; ++nextModelColumn) {
                    AnalyzerConfigDialog.this.configsModel.setValueAt(null, modelRow, nextModelColumn);
                }
                return;
            }
            int n = numTargetTiers = AnalyzerConfigDialog.this.potentialTiers == null ? 0 : AnalyzerConfigDialog.this.potentialTiers.getNumberOfTargetTiers();
            if ((this.modelColumn == numTargetTiers + 2 || this.modelColumn == AnalyzerConfigDialog.this.configsModel.getColumnCount() - 1) && modelRow == AnalyzerConfigDialog.this.configsModel.getRowCount() - 1) {
                Object[] obj = new Object[3 + AnalyzerConfigDialog.this.maxTargetTiers];
                obj[0] = AnalyzerConfigDialog.this.configsModel.getRowCount() + 1;
                obj[1] = SELECT;
                obj[2] = null;
                for (int i = 0; i < AnalyzerConfigDialog.this.maxTargetTiers; ++i) {
                    obj[3 + i] = null;
                }
                AnalyzerConfigDialog.this.configsModel.addRow(obj);
                return;
            }
            if (this.modelColumn == numTargetTiers + 2) {
                return;
            }
            while (nextModelColumn <= AnalyzerConfigDialog.this.configsModel.getColumnCount() - 1) {
                if (nextModelColumn == this.modelColumn + 1) {
                    AnalyzerConfigDialog.this.configsModel.setValueAt(SELECT, modelRow, nextModelColumn);
                } else {
                    AnalyzerConfigDialog.this.configsModel.setValueAt(null, modelRow, nextModelColumn);
                }
                ++nextModelColumn;
            }
        }
    }

    public class AConfig {
        private String analyzer;
        private String source;
        private List<String> targetTierList;

        AConfig(String name, String src, List<String> dst) {
            this.analyzer = name;
            this.source = src;
            this.targetTierList = dst;
        }

        public String getAnalyzer() {
            return this.analyzer;
        }

        public String getSource() {
            return this.source;
        }

        public List<String> getTargetTierList() {
            return this.targetTierList;
        }

        public String toString() {
            return "[" + this.analyzer + ": " + this.source + " -> " + String.valueOf(this.targetTierList) + "]";
        }
    }
}

