/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerConfig;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerConfigDialog;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerTypeConfig;
import mpi.eudico.client.annotator.layout.InterlinearizationManager;
import nl.mpi.lexan.analyzers.helpers.Information;

public class AnalyzerConfigPanel
extends JPanel
implements ComponentListener,
ActionListener,
ListSelectionListener {
    private static final int ANALYZER_NAME_COL = 0;
    private static final int SOURCE_COL = 1;
    private static final int TARGET_COL = 2;
    private static final int TYPE_MODE_COL = 3;
    private static final int CONFIG_COL = 4;
    private static final int TIER_SUBCONFIG_COL = 5;
    private static final String LIN_TYPE = "LinType";
    private static final String ANNOT_CONFIG = "AnalyzerConfig";
    private static final String SUB_CONFIG = "SubConfig";
    private static final Color TYPE_BG = Color.WHITE;
    private static final Color TYPE_FG = Color.BLACK;
    private static final Color TIER_BG = Color.LIGHT_GRAY;
    private static final Color TIER_FG = Color.WHITE;
    private InterlinearizationManager manager;
    private JButton editConfigButton;
    private JButton removeConfigButton;
    private JCheckBox showTiersCB;
    private JTable configsTable;
    private DefaultTableModel configsModel;
    private JPanel configPanel;

    public AnalyzerConfigPanel(InterlinearizationManager manager) {
        this.manager = manager;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        this.configPanel = new JPanel(new GridBagLayout());
        this.configPanel.setBorder(new TitledBorder(""));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.configPanel, gbc);
        this.configsModel = new DefaultTableModel(new String[]{ElanLocale.getString("InterlinearAnalyzerConfigPanel.Analyzer"), ElanLocale.getString("InterlinearAnalyzerConfigPanel.SourceTier"), ElanLocale.getString("InterlinearAnalyzerConfigPanel.TargetTier"), LIN_TYPE, ANNOT_CONFIG, SUB_CONFIG}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.configsTable = new JTable(this.configsModel);
        DefaultTableCellRenderer render = new DefaultTableCellRenderer(){
            private Font italic;
            private Font plain;
            {
                this.italic = new Font(AnalyzerConfigPanel.this.configsTable.getFont().getFontName(), 2, AnalyzerConfigPanel.this.configsTable.getFont().getSize() - 4);
                this.plain = new Font(AnalyzerConfigPanel.this.configsTable.getFont().getFontName(), 0, AnalyzerConfigPanel.this.configsTable.getFont().getSize());
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null && table.getValueAt(row, 0) == null) {
                    cell.setFont(this.italic);
                    cell.setBackground(TIER_BG);
                    cell.setForeground(TIER_FG);
                } else {
                    cell.setFont(this.plain);
                    if (value != null && !((Boolean)AnalyzerConfigPanel.this.configsModel.getValueAt(row, 3)).booleanValue()) {
                        cell.setBackground(TIER_BG);
                        cell.setForeground(TIER_FG);
                    } else {
                        cell.setBackground(TYPE_BG);
                        cell.setForeground(TYPE_FG);
                    }
                }
                if (table.getSelectedRow() == row) {
                    cell.setBackground(table.getSelectionBackground());
                    cell.setForeground(table.getSelectionForeground());
                }
                return cell;
            }
        };
        this.configsTable.setDefaultRenderer(Object.class, render);
        this.configsTable.getTableHeader().setReorderingAllowed(false);
        this.configsTable.getSelectionModel().setSelectionMode(0);
        this.configsTable.getSelectionModel().addListSelectionListener(this);
        this.configsTable.removeColumn(this.configsTable.getColumn(LIN_TYPE));
        this.configsTable.removeColumn(this.configsTable.getColumn(ANNOT_CONFIG));
        this.configsTable.removeColumn(this.configsTable.getColumn(SUB_CONFIG));
        this.removeConfigButton = new JButton();
        this.removeConfigButton.addActionListener(this);
        this.editConfigButton = new JButton();
        this.editConfigButton.addActionListener(this);
        this.showTiersCB = new JCheckBox();
        this.showTiersCB.setSelected(true);
        this.showTiersCB.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.gridwidth = 3;
        this.configPanel.add((Component)new JScrollPane(this.configsTable), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        this.configPanel.add((Component)this.showTiersCB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 12;
        this.configPanel.add((Component)this.removeConfigButton, gbc);
        gbc.gridx = 2;
        gbc.anchor = 12;
        this.configPanel.add((Component)this.editConfigButton, gbc);
        this.addComponentListener(this);
        this.updateLocale();
    }

    public void updateLocale() {
        ((TitledBorder)this.configPanel.getBorder()).setTitle(ElanLocale.getString("InterlinearAnalyzerConfigDlg.Title"));
        this.removeConfigButton.setText(ElanLocale.getString("InterlinearAnalyzerConfigPanel.RemoveConfig"));
        this.editConfigButton.setText(ElanLocale.getString("InterlinearAnalyzerConfigPanel.EditConfig"));
        this.showTiersCB.setText(ElanLocale.getString("InterlinearAnalyzerConfigPanel.ShowTiers"));
        this.configsModel.setColumnIdentifiers(new String[]{ElanLocale.getString("InterlinearAnalyzerConfigPanel.Analyzer"), ElanLocale.getString("InterlinearAnalyzerConfigPanel.SourceTier"), ElanLocale.getString("InterlinearAnalyzerConfigPanel.TargetTier"), LIN_TYPE, ANNOT_CONFIG, SUB_CONFIG});
        this.configsTable.removeColumn(this.configsTable.getColumn(LIN_TYPE));
        this.configsTable.removeColumn(this.configsTable.getColumn(ANNOT_CONFIG));
        this.configsTable.removeColumn(this.configsTable.getColumn(SUB_CONFIG));
        this.repaint();
    }

    public void configsChanged() {
        this.configsTable.getSelectionModel().removeListSelectionListener(this);
        if (this.configsModel.getRowCount() > 0) {
            for (int i = this.configsModel.getRowCount() - 1; i >= 0; --i) {
                this.configsModel.removeRow(i);
            }
        }
        List<AnalyzerConfig> conf = this.manager.getTextAnalyzerContext().getConfigurations();
        AnalyzerConfig activeConf = this.manager.getInterEditor().getActiveConfiguration();
        int activeConfRowIndex = -1;
        for (AnalyzerConfig ac : conf) {
            String target = null;
            for (String s : ac.getDest()) {
                if (target == null) {
                    target = s;
                    continue;
                }
                target = target.concat(",").concat(s);
            }
            this.configsModel.addRow(new Object[]{ac.getAnnotId().getName(), ac.getSource(), target, ac.isTypeMode(), ac, null});
            if (activeConf == null) {
                activeConf = ac;
                activeConfRowIndex = 0;
                this.manager.getInterEditor().setActiveConfiguration(ac);
            }
            if (ac.isTypeMode() && this.showTiersCB.isSelected()) {
                List<AnalyzerConfig> tierConfig = ((AnalyzerTypeConfig)ac).getTierConfigurations();
                for (AnalyzerConfig atc : tierConfig) {
                    target = null;
                    for (String s : atc.getDest()) {
                        if (target == null) {
                            target = s;
                            continue;
                        }
                        target = target.concat(",").concat(s);
                    }
                    this.configsModel.addRow(new Object[]{null, atc.getSource(), target, null, ac, atc});
                    if (activeConfRowIndex >= 0 || !atc.equals(activeConf)) continue;
                    activeConfRowIndex = this.configsModel.getRowCount() - 1;
                }
            }
            if (activeConfRowIndex >= 0 || !ac.equals(activeConf)) continue;
            activeConfRowIndex = this.configsModel.getRowCount() - 1;
        }
        this.configsTable.getSelectionModel().addListSelectionListener(this);
        if (activeConfRowIndex < 0 && conf.size() > 0) {
            activeConfRowIndex = 0;
            activeConf = conf.get(0);
            this.configsTable.getSelectionModel().setSelectionInterval(0, 0);
            this.manager.getInterEditor().setActiveConfiguration(activeConf);
        } else {
            this.configsTable.getSelectionModel().setSelectionInterval(activeConfRowIndex, activeConfRowIndex);
        }
    }

    protected void updateConfigurations(List<AnalyzerConfigDialog.AConfig> configList, boolean typeMode) {
        if (configList == null) {
            return;
        }
        List<Information> analyzers = this.manager.getTextAnalyzerContext().listTextAnalyzersInfo();
        ArrayList<AnalyzerConfig> oldConfigs = new ArrayList<AnalyzerConfig>(this.manager.getTextAnalyzerContext().getConfigurations());
        boolean changed = false;
        for (AnalyzerConfigDialog.AConfig annotConfig : configList) {
            String annot = annotConfig.getAnalyzer();
            String source = annotConfig.getSource();
            List<String> targetList = annotConfig.getTargetTierList();
            Information info = null;
            if (analyzers != null) {
                for (Information li : analyzers) {
                    if (!annot.equals(li.getName())) continue;
                    info = li;
                    break;
                }
            }
            if (info == null) {
                JOptionPane.showMessageDialog(this, annot + ": " + ElanLocale.getString("InterlinearAnalyzerConfigPanel.AnalyzerNotFound") + " -" + source, "Warning", 2);
                continue;
            }
            if (typeMode) {
                AnalyzerTypeConfig atc = new AnalyzerTypeConfig(info, source, targetList);
                this.manager.fillWithTierConfigs(info, atc, null);
                changed = this.updateConfig(oldConfigs, atc) | changed;
                continue;
            }
            AnalyzerConfig ac = new AnalyzerConfig(info, source, targetList);
            changed = this.updateConfig(oldConfigs, ac) | changed;
        }
        for (AnalyzerConfig toRemove : oldConfigs) {
            if (toRemove.isTypeMode() != typeMode) continue;
            this.manager.getTextAnalyzerContext().removeConfig(toRemove);
            changed = true;
        }
        if (changed) {
            this.configsChanged();
        }
    }

    private boolean updateConfig(ArrayList<AnalyzerConfig> oldConfigs, AnalyzerConfig config) {
        int index = oldConfigs.indexOf(config);
        if (index < 0) {
            this.manager.getTextAnalyzerContext().addConfig(config);
            return true;
        }
        oldConfigs.remove(index);
        return false;
    }

    public List<String> getTargetList(String target) {
        ArrayList<String> targetList = null;
        if (target != null) {
            String[] targets;
            targetList = new ArrayList<String>();
            for (String s : targets = target.split(",")) {
                targetList.add(s);
            }
        }
        return targetList;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.removeConfigButton) {
            int row = this.configsTable.getSelectedRow();
            if (row > -1) {
                int selOption = JOptionPane.showConfirmDialog(this, ElanLocale.getString("InterlinearAnalyzerConfigPanel.RemoveWarning"), ElanLocale.getString("Message.Warning"), 2, 2, null);
                if (selOption != 0) {
                    return;
                }
                AnalyzerConfig ac = (AnalyzerConfig)this.configsModel.getValueAt(row, 4);
                AnalyzerConfig atsc = (AnalyzerConfig)this.configsModel.getValueAt(row, 5);
                if (atsc != null && ac instanceof AnalyzerTypeConfig) {
                    AnalyzerTypeConfig atc = (AnalyzerTypeConfig)ac;
                    this.configsModel.removeRow(row);
                    atc.removeTierConf(atsc);
                    if (atc.getTierConfigurations().isEmpty()) {
                        this.configsModel.removeRow(row - 1);
                        this.manager.getTextAnalyzerContext().removeConfig(ac);
                    }
                } else {
                    if (ac instanceof AnalyzerTypeConfig && this.showTiersCB.isSelected()) {
                        int n = row + 1;
                        while (this.configsModel.getRowCount() > n && this.configsModel.getValueAt(n, 4) == ac) {
                            this.configsModel.removeRow(n);
                        }
                    }
                    this.configsModel.removeRow(row);
                    this.manager.getTextAnalyzerContext().removeConfig(ac);
                }
                this.repaint();
            }
        } else if (e.getSource() == this.editConfigButton) {
            AnalyzerConfigDialog configDialog = new AnalyzerConfigDialog(null, this.manager);
            configDialog.setVisible(true);
            if (configDialog.isApplied()) {
                this.updateConfigurations(configDialog.getConfigurationMap(false), false);
                this.updateConfigurations(configDialog.getConfigurationMap(true), true);
            }
        } else if (e.getSource() == this.showTiersCB) {
            this.configsChanged();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this.configsTable.getSelectedRow();
        if (row > -1 && !e.getValueIsAdjusting()) {
            AnalyzerConfig ac = (AnalyzerConfig)this.configsModel.getValueAt(row, 5);
            if (ac == null) {
                ac = (AnalyzerConfig)this.configsModel.getValueAt(row, 4);
            }
            if (ac != null) {
                this.manager.getInterEditor().setActiveConfiguration(ac);
            }
        }
    }
}

