/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.interlinear.edit.TextAnalyzerHostContext;
import nl.mpi.lexan.analyzers.helpers.Information;

public class AnalyzerSettingsPanel
extends JPanel {
    private TextAnalyzerHostContext hostContext;
    private List<Information> analyzers;
    private JTabbedPane tabPane;
    private TitledBorder titledBorder;

    public AnalyzerSettingsPanel(TextAnalyzerHostContext hostContext) {
        this.hostContext = hostContext;
        this.analyzers = hostContext.listTextAnalyzersInfo();
        this.initComponents();
    }

    private void initComponents() {
        if (this.analyzers == null || this.analyzers.isEmpty()) {
            return;
        }
        this.tabPane = new JTabbedPane();
        int tabNr = 0;
        for (int i = 0; i < this.analyzers.size(); ++i) {
            Information analyzer = this.analyzers.get(i);
            Component comp = this.hostContext.getConfigurationComponent(analyzer, true);
            if (comp == null) continue;
            this.tabPane.addTab(analyzer.getName(), new JScrollPane(comp));
            if (tabNr < 10) {
                this.tabPane.setMnemonicAt(tabNr, 48 + (tabNr + 1) % 10);
            }
            ++tabNr;
        }
        EmptyBorder marginBorder = new EmptyBorder(4, 6, 4, 6);
        this.titledBorder = new TitledBorder(ElanLocale.getString("InterlinearAnalyzerConfigPanel.ConfigureSettings"));
        this.setBorder(new CompoundBorder(marginBorder, this.titledBorder));
        if (tabNr > 0) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.add((Component)this.tabPane, gbc);
            this.readPreferences();
        }
    }

    public void updateLocale() {
        this.titledBorder.setTitle(ElanLocale.getString("InterlinearAnalyzerConfigPanel.ConfigureSettings"));
    }

    private void readPreferences() {
        int tabNr;
        String analyzer;
        if (this.tabPane != null && (analyzer = Preferences.getString("AnalyzerConfigurationPanel.CurrentAnalyzer", this.hostContext.getTranscription())) != null && (tabNr = this.tabPane.indexOfTab(analyzer)) >= 0) {
            this.tabPane.setSelectedIndex(tabNr);
        }
    }

    public void storePreferences() {
        if (this.tabPane != null && this.tabPane.getSelectedIndex() >= 0) {
            Preferences.set("AnalyzerConfigurationPanel.CurrentAnalyzer", this.tabPane.getTitleAt(this.tabPane.getSelectedIndex()), this.hostContext.getTranscription());
        }
    }
}

