/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.model;

import java.util.List;
import mpi.eudico.client.annotator.interlinear.IGTTierType;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAbstractDataModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTTier;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTBlockRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTSuggestionRenderInfo;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.helpers.Suggestion;
import nl.mpi.lexan.analyzers.helpers.SuggestionSet;

public class IGTSuggestionModel
extends IGTAbstractDataModel {
    private SuggestionSet suggestionSet;
    private long beginTime = Long.MAX_VALUE;
    private long endTime = -1L;
    private IGTSuggestionRenderInfo suggestRenderInfo;

    public IGTSuggestionModel(SuggestionSet suggestionSet) {
        this.suggestionSet = suggestionSet;
        this.fillModel();
        this.suggestRenderInfo = new IGTSuggestionRenderInfo();
    }

    public SuggestionSet getSuggestionSet() {
        return this.suggestionSet;
    }

    public boolean showTierLabels() {
        return this.suggestRenderInfo.tierLabelsVisible;
    }

    public void showTierLabels(boolean maybe) {
        this.suggestRenderInfo.tierLabelsVisible = maybe;
    }

    private void fillModel() {
        if (this.suggestionSet != null) {
            IGTTier rootTier = new IGTTier("ROOT", IGTTierType.ROOT);
            this.rowData.add(rootTier);
            this.rowHeader.addHeader("ROOT");
            IGTAnnotation rootAnn = new IGTAnnotation("ROOT");
            rootTier.addAnnotation(rootAnn);
            List suggestions = this.suggestionSet.getSuggestions();
            for (Suggestion suggestion : suggestions) {
                Position pos = suggestion.getPosition();
                IGTTier wlRootTier = this.getRowDataForTier(pos.getTierId());
                if (wlRootTier == null) {
                    wlRootTier = new IGTTier(pos.getTierId(), IGTTierType.WORD_LEVEL_ROOT, true);
                    this.rowData.add(wlRootTier);
                    this.rowHeader.addHeader(pos.getTierId());
                    rootTier.addChildTier(wlRootTier);
                    wlRootTier.setParentTier(rootTier);
                }
                IGTAnnotation igtAnn = new IGTAnnotation(suggestion.getContent());
                wlRootTier.addAnnotation(igtAnn);
                rootAnn.addChild(igtAnn);
                if (pos.getBeginTime() < this.beginTime) {
                    this.beginTime = pos.getBeginTime();
                }
                if (pos.getEndTime() > this.endTime) {
                    this.endTime = pos.getEndTime();
                }
                this.addChildNodes(wlRootTier, igtAnn, suggestion.getChildren());
            }
        }
    }

    private void addChildNodes(IGTTier parentTier, IGTAnnotation parentAnn, List<Suggestion> children) {
        if (children != null) {
            for (Suggestion sug : children) {
                Position pos = sug.getPosition();
                IGTTier childTier = this.getRowDataForTier(pos.getTierId());
                if (childTier == null) {
                    childTier = new IGTTier(pos.getTierId(), IGTTierType.SUBDIVISION, true);
                    this.rowData.add(childTier);
                    this.rowHeader.addHeader(pos.getTierId());
                    parentTier.addChildTier(childTier);
                    childTier.setParentTier(parentTier);
                }
                IGTAnnotation igtAnn = new IGTAnnotation(sug.getContent());
                childTier.addAnnotation(igtAnn);
                parentAnn.addChild(igtAnn);
                if (pos.getBeginTime() < this.beginTime) {
                    this.beginTime = pos.getBeginTime();
                }
                if (pos.getEndTime() > this.endTime) {
                    this.endTime = pos.getEndTime();
                }
                this.addChildNodes(childTier, igtAnn, sug.getChildren());
            }
        }
    }

    @Override
    public long getBeginTime() {
        if (this.beginTime != Long.MAX_VALUE) {
            return this.beginTime;
        }
        return 0L;
    }

    @Override
    public long getEndTime() {
        if (this.endTime > -1L) {
            return this.endTime;
        }
        return 0L;
    }

    @Override
    public IGTBlockRenderInfo getRenderInfo() {
        return this.suggestRenderInfo;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("IGTSuggestionModel:[");
        buf.append(this.suggestionSet.toString());
        buf.append(" showTierLabels=");
        buf.append(String.valueOf(this.suggestRenderInfo.tierLabelsVisible));
        buf.append(" beginTime=");
        buf.append(String.valueOf(this.beginTime));
        buf.append(" endTime=");
        buf.append(String.valueOf(this.endTime));
        IGTBlockRenderInfo ri = this.getRenderInfo();
        buf.append(String.valueOf(ri));
        buf.append("]");
        return buf.toString();
    }
}

