/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit.render;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.ColorDialog;
import mpi.eudico.client.annotator.interlinear.edit.IGTConstants;

public class RenderingConfigDialog
extends ClosableDialog {
    private JLabel rowBgEvenLB;
    private JPanel rowBgEvenColorP;
    private JButton rowBgEvenColorB;
    private JButton rowBgEvenResetB;
    private JLabel rowBgOddLB;
    private JPanel rowBgOddColorP;
    private JButton rowBgOddColorB;
    private JButton rowBgOddResetB;
    private JCheckBox showAnnBorderCB;
    private JLabel annBorderColorLB;
    private JPanel annBorderColorP;
    private JButton annBorderColorB;
    private JButton annBorderResetB;
    private JCheckBox showAnnBgCB;
    private JLabel annBgColorLB;
    private JPanel annBgColorP;
    private JButton annBgColorB;
    private JButton annBgResetB;
    private JLabel annBboxMarginsLB;
    private JLabel annBboxTopBotLB;
    private JSpinner annBboxTopBotSP;
    private JButton annBboxTopBotResetB;
    private JLabel annBboxLeRiLB;
    private JSpinner annBboxLeRiSP;
    private JButton annBboxLeRiResetB;
    private JLabel whitespaceWidthLB;
    private JSpinner whitespaceWidthSP;
    private JButton whitespaceResetB;
    private JButton applyB;
    private JButton cancelB;
    private JButton resetAllB;
    private JPanel settingsPanel;
    private JPanel buttonPanel;
    private UIEventListener eventListener;
    private Color annBorderEnabledColor;
    private Color annBgEnabledColor;
    private Map<String, Object> settings = null;

    public RenderingConfigDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initComponents();
        this.loadSettings();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public RenderingConfigDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initComponents();
        this.loadSettings();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.settingsPanel = new JPanel(new GridBagLayout());
        this.buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(this.buttonPanel, 0);
        this.buttonPanel.setLayout(buttonLayout);
        this.rowBgEvenLB = new JLabel();
        this.rowBgEvenColorP = new JPanel();
        this.rowBgEvenColorP.setBorder(new LineBorder(Color.GRAY, 1));
        this.rowBgEvenColorP.setPreferredSize(new Dimension(32, 12));
        this.rowBgEvenColorB = new JButton();
        this.rowBgEvenResetB = new JButton();
        this.rowBgOddLB = new JLabel();
        this.rowBgOddColorP = new JPanel();
        this.rowBgOddColorP.setBorder(new LineBorder(Color.GRAY, 1));
        this.rowBgOddColorB = new JButton();
        this.rowBgOddResetB = new JButton();
        this.showAnnBorderCB = new JCheckBox();
        this.annBorderColorLB = new JLabel();
        this.annBorderColorP = new JPanel();
        this.annBorderColorP.setBorder(new LineBorder(Color.GRAY, 1));
        this.annBorderColorB = new JButton();
        this.annBorderResetB = new JButton();
        this.showAnnBgCB = new JCheckBox();
        this.annBgColorLB = new JLabel();
        this.annBgColorP = new JPanel();
        this.annBgColorP.setBorder(new LineBorder(Color.GRAY, 1));
        this.annBgColorB = new JButton();
        this.annBgResetB = new JButton();
        this.annBboxMarginsLB = new JLabel();
        this.annBboxTopBotLB = new JLabel();
        this.annBboxTopBotSP = new JSpinner(new SpinnerNumberModel(1, 1, 20, 1));
        this.annBboxTopBotResetB = new JButton();
        this.annBboxLeRiLB = new JLabel();
        this.annBboxLeRiSP = new JSpinner(new SpinnerNumberModel(1, 1, 20, 1));
        this.annBboxLeRiResetB = new JButton();
        this.whitespaceWidthLB = new JLabel();
        this.whitespaceWidthSP = new JSpinner(new SpinnerNumberModel(1, 1, 20, 1));
        this.whitespaceResetB = new JButton();
        this.applyB = new JButton();
        this.cancelB = new JButton();
        this.resetAllB = new JButton();
        int margin = 4;
        int margin2 = margin + margin;
        int indent = margin2 * margin;
        Insets genInsets = new Insets(margin, margin, margin, margin);
        Insets leftButInsets = new Insets(margin, margin2 + margin, margin, margin);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = genInsets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.settingsPanel.add((Component)this.rowBgEvenLB, gbc);
        gbc.gridy = 1;
        this.settingsPanel.add((Component)this.rowBgOddLB, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = leftButInsets;
        this.settingsPanel.add((Component)this.rowBgEvenColorP, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = genInsets;
        this.settingsPanel.add((Component)this.rowBgEvenColorB, gbc);
        gbc.gridx = 3;
        this.settingsPanel.add((Component)this.rowBgEvenResetB, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = leftButInsets;
        this.settingsPanel.add((Component)this.rowBgOddColorP, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = genInsets;
        this.settingsPanel.add((Component)this.rowBgOddColorB, gbc);
        gbc.gridx = 3;
        this.settingsPanel.add((Component)this.rowBgOddResetB, gbc);
        gbc.gridwidth = 4;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(margin + margin2, margin, margin, margin);
        this.settingsPanel.add((Component)this.showAnnBorderCB, gbc);
        gbc.gridwidth = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(margin, indent, margin, margin);
        this.settingsPanel.add((Component)this.annBorderColorLB, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.insets = leftButInsets;
        this.settingsPanel.add((Component)this.annBorderColorP, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.insets = genInsets;
        this.settingsPanel.add((Component)this.annBorderColorB, gbc);
        gbc.gridx = 3;
        this.settingsPanel.add((Component)this.annBorderResetB, gbc);
        gbc.gridwidth = 4;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 4;
        this.settingsPanel.add((Component)this.showAnnBgCB, gbc);
        gbc.gridwidth = 1;
        gbc.gridy = 5;
        gbc.insets = new Insets(margin, indent, margin, margin);
        this.settingsPanel.add((Component)this.annBgColorLB, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.insets = leftButInsets;
        this.settingsPanel.add((Component)this.annBgColorP, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.insets = genInsets;
        this.settingsPanel.add((Component)this.annBgColorB, gbc);
        gbc.gridx = 3;
        this.settingsPanel.add((Component)this.annBgResetB, gbc);
        gbc.gridwidth = 4;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.insets = new Insets(margin + margin2, margin, margin, margin);
        this.settingsPanel.add((Component)this.annBboxMarginsLB, gbc);
        gbc.gridwidth = 2;
        gbc.gridy = 7;
        gbc.insets = new Insets(margin, indent, margin, margin);
        this.settingsPanel.add((Component)this.annBboxTopBotLB, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.insets = genInsets;
        this.settingsPanel.add((Component)this.annBboxTopBotSP, gbc);
        gbc.gridx = 3;
        this.settingsPanel.add((Component)this.annBboxTopBotResetB, gbc);
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.insets = new Insets(margin, indent, margin, margin);
        this.settingsPanel.add((Component)this.annBboxLeRiLB, gbc);
        gbc.anchor = 13;
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = genInsets;
        this.settingsPanel.add((Component)this.annBboxLeRiSP, gbc);
        gbc.gridx = 3;
        this.settingsPanel.add((Component)this.annBboxLeRiResetB, gbc);
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(margin + margin2, margin, margin, margin);
        this.settingsPanel.add((Component)this.whitespaceWidthLB, gbc);
        gbc.anchor = 13;
        gbc.gridwidth = 1;
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = genInsets;
        this.settingsPanel.add((Component)this.whitespaceWidthSP, gbc);
        gbc.gridx = 3;
        this.settingsPanel.add((Component)this.whitespaceResetB, gbc);
        this.buttonPanel.setBorder(new EmptyBorder(margin, margin, margin, margin));
        this.buttonPanel.add(this.resetAllB);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.applyB);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(margin2, 0)));
        this.buttonPanel.add(this.cancelB);
        GridBagConstraints gpc = new GridBagConstraints();
        gpc.fill = 1;
        gpc.weightx = 1.0;
        gpc.weighty = 1.0;
        gpc.insets = new Insets(4, 6, 4, 6);
        this.getContentPane().add((Component)this.settingsPanel, gpc);
        gpc.fill = 2;
        gpc.weighty = 0.0;
        gpc.gridy = 1;
        this.getContentPane().add((Component)this.buttonPanel, gpc);
        this.updateLocale();
        this.eventListener = new UIEventListener();
        this.showAnnBorderCB.addItemListener(this.eventListener);
        this.showAnnBgCB.addItemListener(this.eventListener);
        this.rowBgEvenColorB.addActionListener(this.eventListener);
        this.rowBgEvenResetB.addActionListener(this.eventListener);
        this.rowBgOddColorB.addActionListener(this.eventListener);
        this.rowBgOddResetB.addActionListener(this.eventListener);
        this.annBorderColorB.addActionListener(this.eventListener);
        this.annBorderResetB.addActionListener(this.eventListener);
        this.annBgColorB.addActionListener(this.eventListener);
        this.annBgResetB.addActionListener(this.eventListener);
        this.annBboxLeRiResetB.addActionListener(this.eventListener);
        this.annBboxTopBotResetB.addActionListener(this.eventListener);
        this.whitespaceResetB.addActionListener(this.eventListener);
        this.resetAllB.addActionListener(this.eventListener);
        this.cancelB.addActionListener(this.eventListener);
        this.applyB.addActionListener(this.eventListener);
    }

    private void updateLocale() {
        this.settingsPanel.setBorder(new TitledBorder(ElanLocale.getString("InterlinearEditor.RenderDialog.Settings")));
        this.rowBgEvenLB.setText(ElanLocale.getString("InterlinearEditor.RenderDialog.EvenRowsBgLabel"));
        this.rowBgEvenColorB.setText(ElanLocale.getString("Button.Browse"));
        this.rowBgEvenResetB.setText(ElanLocale.getString("Button.Reset"));
        this.rowBgOddLB.setText(ElanLocale.getString("InterlinearEditor.RenderDialog.OddRowsBgLabel"));
        this.rowBgOddColorB.setText(ElanLocale.getString("Button.Browse"));
        this.rowBgOddResetB.setText(ElanLocale.getString("Button.Reset"));
        this.showAnnBorderCB.setText(ElanLocale.getString("InterlinearEditor.RenderDialog.BorderPaintLabel"));
        this.annBorderColorLB.setText(ElanLocale.getString("InterlinearEditor.RenderDialog.BorderColorLabel"));
        this.annBorderColorB.setText(ElanLocale.getString("Button.Browse"));
        this.annBorderResetB.setText(ElanLocale.getString("Button.Reset"));
        this.showAnnBgCB.setText(ElanLocale.getString("InterlinearEditor.RenderDialog.BackgroundPaintLabel"));
        this.annBgColorLB.setText(ElanLocale.getString("InterlinearEditor.RenderDialog.BackgroundColorLabel"));
        this.annBgColorB.setText(ElanLocale.getString("Button.Browse"));
        this.annBgResetB.setText(ElanLocale.getString("Button.Reset"));
        this.annBboxMarginsLB.setText(ElanLocale.getString("InterlinearEditor.RenderDialog.BBMarginsLabel"));
        this.annBboxTopBotLB.setText(ElanLocale.getString("InterlinearEditor.RenderDialog.BBMarginTopLabel"));
        this.annBboxTopBotResetB.setText(ElanLocale.getString("Button.Reset"));
        this.annBboxLeRiLB.setText(ElanLocale.getString("InterlinearEditor.RenderDialog.BBMarginLeftLabel"));
        this.annBboxLeRiResetB.setText(ElanLocale.getString("Button.Reset"));
        this.whitespaceWidthLB.setText(ElanLocale.getString("InterlinearEditor.RenderDialog.SpaceWidthLabel"));
        this.whitespaceResetB.setText(ElanLocale.getString("Button.Reset"));
        this.applyB.setText(ElanLocale.getString("Button.Apply"));
        this.cancelB.setText(ElanLocale.getString("Button.Cancel"));
        this.resetAllB.setText(ElanLocale.getString("InterlinearEditor.RenderDialog.RestoreDefaultsLabel"));
    }

    private void loadSettings() {
        Color evenRowColor = Preferences.getColor("InterlinearEditor.BackgroundColor.Even", null);
        if (evenRowColor != null) {
            this.rowBgEvenColorP.setBackground(evenRowColor);
        } else {
            this.rowBgEvenColorP.setBackground(IGTConstants.TABLE_BACKGROUND_COLOR1);
        }
        Color oddRowColor = Preferences.getColor("InterlinearEditor.BackgroundColor.Odd", null);
        if (oddRowColor != null) {
            this.rowBgOddColorP.setBackground(oddRowColor);
        } else {
            this.rowBgOddColorP.setBackground(IGTConstants.TABLE_BACKGROUND_COLOR2);
        }
        Color annBorderColor = Preferences.getColor("InterlinearEditor.Annotation.BorderColor", null);
        if (annBorderColor != null) {
            this.annBorderColorP.setBackground(annBorderColor);
            this.annBorderEnabledColor = annBorderColor;
        } else {
            this.annBorderColorP.setBackground(IGTConstants.ANNO_BORDER_COLOR);
            this.annBorderEnabledColor = IGTConstants.ANNO_BORDER_COLOR;
        }
        Color annBgColor = Preferences.getColor("InterlinearEditor.Annotation.BackgroundColor", null);
        if (annBgColor != null) {
            this.annBgColorP.setBackground(annBgColor);
            this.annBgEnabledColor = annBgColor;
        } else {
            this.annBgColorP.setBackground(IGTConstants.ANNO_BACKGROUND_COLOR);
            this.annBgEnabledColor = IGTConstants.ANNO_BACKGROUND_COLOR;
        }
        Integer leftMargin = Preferences.getInt("InterlinearEditor.Annotation.BB.LeftMargin", null);
        if (leftMargin != null) {
            this.annBboxLeRiSP.setValue(leftMargin);
        } else {
            this.annBboxLeRiSP.setValue(4);
        }
        Integer topMargin = Preferences.getInt("InterlinearEditor.Annotation.BB.TopMargin", null);
        if (topMargin != null) {
            this.annBboxTopBotSP.setValue(topMargin);
        } else {
            this.annBboxTopBotSP.setValue(2);
        }
        Integer spaceWidth = Preferences.getInt("InterlinearEditor.WhitespaceWidth", null);
        if (spaceWidth != null) {
            this.whitespaceWidthSP.setValue(spaceWidth);
        } else {
            this.whitespaceWidthSP.setValue(8);
        }
        Boolean showAnnoBorders = Preferences.getBool("InterlinearEditor.PaintAnnotationBorders", null);
        boolean annBorderVisible = true;
        if (showAnnoBorders != null) {
            annBorderVisible = showAnnoBorders;
        }
        this.showAnnBorderCB.setSelected(annBorderVisible);
        Boolean showAnnoBG = Preferences.getBool("InterlinearEditor.PaintAnnotationBackground", null);
        boolean annBGPainted = false;
        if (showAnnoBG != null) {
            annBGPainted = showAnnoBG;
        }
        this.showAnnBgCB.setSelected(annBGPainted);
        this.updateAnnBorderItems(annBorderVisible);
        this.updateAnnBgItems(annBGPainted);
    }

    private void applySettings() {
        Integer wSpaceWidth;
        Integer leftRightMarg;
        Integer topBottomMarg;
        boolean showAnnoBgSetting;
        boolean showAnnoBorderSetting;
        this.settings = new HashMap<String, Object>();
        Color color = this.rowBgEvenColorP.getBackground();
        if (color != IGTConstants.TABLE_BACKGROUND_COLOR1) {
            this.settings.put("InterlinearEditor.BackgroundColor.Even", color);
        }
        if ((color = this.rowBgOddColorP.getBackground()) != IGTConstants.TABLE_BACKGROUND_COLOR2) {
            this.settings.put("InterlinearEditor.BackgroundColor.Odd", color);
        }
        if (!(showAnnoBorderSetting = this.showAnnBorderCB.isSelected())) {
            this.settings.put("InterlinearEditor.PaintAnnotationBorders", showAnnoBorderSetting);
        }
        color = this.annBorderColorP.getBackground();
        if (!showAnnoBorderSetting) {
            color = this.annBorderEnabledColor;
        }
        if (color != IGTConstants.ANNO_BORDER_COLOR) {
            this.settings.put("InterlinearEditor.Annotation.BorderColor", color);
        }
        if (showAnnoBgSetting = this.showAnnBgCB.isSelected()) {
            this.settings.put("InterlinearEditor.PaintAnnotationBackground", showAnnoBgSetting);
        }
        color = this.annBgColorP.getBackground();
        if (!showAnnoBgSetting) {
            color = this.annBgEnabledColor;
        }
        if (color != IGTConstants.ANNO_BACKGROUND_COLOR) {
            this.settings.put("InterlinearEditor.Annotation.BackgroundColor", color);
        }
        if ((topBottomMarg = (Integer)this.annBboxTopBotSP.getValue()) != 2) {
            this.settings.put("InterlinearEditor.Annotation.BB.TopMargin", topBottomMarg);
        }
        if ((leftRightMarg = (Integer)this.annBboxLeRiSP.getValue()) != 4) {
            this.settings.put("InterlinearEditor.Annotation.BB.LeftMargin", leftRightMarg);
        }
        if ((wSpaceWidth = (Integer)this.whitespaceWidthSP.getValue()) != 8) {
            this.settings.put("InterlinearEditor.WhitespaceWidth", wSpaceWidth);
        }
    }

    private void restoreDefaultSettings() {
        this.rowBgEvenColorP.setBackground(IGTConstants.TABLE_BACKGROUND_COLOR1);
        this.rowBgOddColorP.setBackground(IGTConstants.TABLE_BACKGROUND_COLOR2);
        this.annBorderEnabledColor = IGTConstants.ANNO_BORDER_COLOR;
        this.showAnnBorderCB.setSelected(true);
        this.updateAnnBorderItems(true);
        this.annBorderColorP.setBackground(IGTConstants.ANNO_BORDER_COLOR);
        this.annBgEnabledColor = IGTConstants.ANNO_BACKGROUND_COLOR;
        this.showAnnBgCB.setSelected(false);
        this.updateAnnBgItems(false);
        this.annBgColorP.setBackground(IGTConstants.ANNO_BACKGROUND_COLOR);
        this.annBboxLeRiSP.setValue(4);
        this.annBboxTopBotSP.setValue(2);
        this.whitespaceWidthSP.setValue(8);
    }

    private void updateAnnBorderItems(boolean selected) {
        this.annBorderColorLB.setEnabled(selected);
        this.annBorderColorB.setEnabled(selected);
        this.annBorderResetB.setEnabled(selected);
        if (!selected) {
            this.annBorderColorP.setBackground(this.annBorderColorLB.getBackground());
        } else {
            this.annBorderColorP.setBackground(this.annBorderEnabledColor);
        }
    }

    private void updateAnnBgItems(boolean selected) {
        this.annBgColorLB.setEnabled(selected);
        this.annBgColorB.setEnabled(selected);
        this.annBgResetB.setEnabled(selected);
        if (!selected) {
            this.annBgColorP.setBackground(this.annBgColorLB.getBackground());
        } else {
            this.annBgColorP.setBackground(this.annBgEnabledColor);
        }
    }

    private Color getColor(Color curColor) {
        ColorDialog colDialog = new ColorDialog(this, curColor);
        return colDialog.chooseColor();
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    private class UIEventListener
    implements ActionListener,
    ItemListener {
        private UIEventListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == RenderingConfigDialog.this.showAnnBorderCB) {
                RenderingConfigDialog.this.updateAnnBorderItems(RenderingConfigDialog.this.showAnnBorderCB.isSelected());
            } else if (e.getSource() == RenderingConfigDialog.this.showAnnBgCB) {
                RenderingConfigDialog.this.updateAnnBgItems(RenderingConfigDialog.this.showAnnBgCB.isSelected());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == RenderingConfigDialog.this.resetAllB) {
                RenderingConfigDialog.this.restoreDefaultSettings();
            } else if (source == RenderingConfigDialog.this.cancelB) {
                RenderingConfigDialog.this.setVisible(false);
                RenderingConfigDialog.this.dispose();
            } else if (source == RenderingConfigDialog.this.applyB) {
                RenderingConfigDialog.this.applySettings();
                RenderingConfigDialog.this.setVisible(false);
                RenderingConfigDialog.this.dispose();
            } else if (source == RenderingConfigDialog.this.rowBgEvenColorB) {
                Color cl = RenderingConfigDialog.this.getColor(RenderingConfigDialog.this.rowBgEvenColorP.getBackground());
                if (cl != null && !cl.equals(RenderingConfigDialog.this.rowBgEvenColorP.getBackground())) {
                    RenderingConfigDialog.this.rowBgEvenColorP.setBackground(cl);
                }
            } else if (source == RenderingConfigDialog.this.rowBgEvenResetB) {
                RenderingConfigDialog.this.rowBgEvenColorP.setBackground(IGTConstants.TABLE_BACKGROUND_COLOR1);
            } else if (source == RenderingConfigDialog.this.rowBgOddColorB) {
                Color cl = RenderingConfigDialog.this.getColor(RenderingConfigDialog.this.rowBgOddColorP.getBackground());
                if (cl != null && !cl.equals(RenderingConfigDialog.this.rowBgOddColorP.getBackground())) {
                    RenderingConfigDialog.this.rowBgOddColorP.setBackground(cl);
                }
            } else if (source == RenderingConfigDialog.this.rowBgOddResetB) {
                RenderingConfigDialog.this.rowBgOddColorP.setBackground(IGTConstants.TABLE_BACKGROUND_COLOR2);
            } else if (source == RenderingConfigDialog.this.annBorderColorB) {
                Color cl = RenderingConfigDialog.this.getColor(RenderingConfigDialog.this.annBorderColorP.getBackground());
                if (cl != null && !cl.equals(RenderingConfigDialog.this.annBorderColorP.getBackground())) {
                    RenderingConfigDialog.this.annBorderEnabledColor = cl;
                    RenderingConfigDialog.this.annBorderColorP.setBackground(cl);
                }
            } else if (source == RenderingConfigDialog.this.annBorderResetB) {
                RenderingConfigDialog.this.annBorderColorP.setBackground(IGTConstants.ANNO_BORDER_COLOR);
            } else if (source == RenderingConfigDialog.this.annBgColorB) {
                Color cl = RenderingConfigDialog.this.getColor(RenderingConfigDialog.this.annBgColorP.getBackground());
                if (cl != null && !cl.equals(RenderingConfigDialog.this.annBgColorP.getBackground())) {
                    RenderingConfigDialog.this.annBgEnabledColor = cl;
                    RenderingConfigDialog.this.annBgColorP.setBackground(cl);
                }
            } else if (source == RenderingConfigDialog.this.annBgResetB) {
                RenderingConfigDialog.this.annBgColorP.setBackground(IGTConstants.ANNO_BACKGROUND_COLOR);
            } else if (source == RenderingConfigDialog.this.annBboxTopBotResetB) {
                RenderingConfigDialog.this.annBboxTopBotSP.setValue(2);
            } else if (source == RenderingConfigDialog.this.annBboxLeRiResetB) {
                RenderingConfigDialog.this.annBboxLeRiSP.setValue(4);
            } else if (source == RenderingConfigDialog.this.whitespaceResetB) {
                RenderingConfigDialog.this.whitespaceWidthSP.setValue(8);
            }
        }
    }
}

