/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.Zoomable;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.grid.GridViewer;
import mpi.eudico.client.annotator.gui.ResizeComponent;
import mpi.eudico.client.annotator.layout.ModeLayoutManager;
import mpi.eudico.client.annotator.layout.PlayerLayoutModel;
import mpi.eudico.client.annotator.layout.ViewerLayoutModel;
import mpi.eudico.client.annotator.recognizer.gui.AbstractRecognizerPanel;
import mpi.eudico.client.annotator.recognizer.gui.RecognizerPanel;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.CommentViewer;
import mpi.eudico.client.annotator.viewer.InterlinearViewer;
import mpi.eudico.client.annotator.viewer.LexiconEntryViewer;
import mpi.eudico.client.annotator.viewer.MetadataViewer;
import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.client.annotator.viewer.SignalViewerControlPanel;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewerPanel;
import mpi.eudico.client.annotator.viewer.SubtitleViewer;
import mpi.eudico.client.annotator.viewer.TextViewer;
import mpi.eudico.client.annotator.viewer.TimeLineViewer;
import mpi.eudico.client.annotator.viewer.TimeSeriesViewer;

public class AnnotationManager
implements ModeLayoutManager {
    private ElanLayoutManager layoutManager;
    Container container;
    private ViewerManager2 viewerManager;
    private boolean showTimeLineViewer;
    private boolean showInterlinearViewer;
    List<ViewerLayoutModel> viewerList;
    private ElanMediaPlayerController mediaPlayerController;
    private SignalViewer signalViewer;
    JComponent signalComponent;
    private SignalViewerControlPanel signalControlPanel;
    private TimeLineViewer timeLineViewer;
    private InterlinearViewer interlinearViewer;
    TimeSeriesViewer timeseriesViewer;
    JComponent timeseriesComponent;
    JSplitPane wav_tsSplitPane;
    private JPanel timeLineComponent;
    private MultiTierControlPanel multiTierControlPanel;
    private JSplitPane timeLineSplitPane;
    private ResizeComponent vertMediaResizer;
    private JTabbedPane tabPane;
    private JTabbedPane leftTabPane;
    private SingleTierViewerPanel gridPanel;
    private SingleTierViewerPanel textPanel;
    private JPanel subtitlePanel;
    private JComponent lexiconPanel;
    private CommentViewer commentPanel;
    private JComponent recognizerPanel;
    private JPanel controlPanel;
    private JScrollPane controlPanelScrollPane;
    private JComponent metadataPanel;
    private boolean mediaInCentre = false;
    private boolean gridViewerLeft;
    private boolean textViewerLeft;
    private boolean subtitleViewerLeft;
    private boolean lexiconViewerLeft;
    private boolean commentViewerLeft;
    private boolean recognizerLeft;
    private boolean metaDataLeft;
    private List<String> viewerSortOrder;
    private boolean oneRowForVisuals = false;
    private boolean preferenceChanged = false;
    private int minTabWidth = 150;
    private int numOfPlayers;
    private List<KeyStroke> ksNotToBeConsumed;

    public AnnotationManager(ViewerManager2 viewerManager, ElanLayoutManager elanLayoutManager) {
        this.viewerManager = viewerManager;
        this.layoutManager = elanLayoutManager;
        this.container = this.layoutManager.getContainer();
        this.viewerList = new ArrayList<ViewerLayoutModel>(4);
        this.showTimeLineViewer = true;
        this.viewerSortOrder = new ArrayList<String>();
    }

    @Override
    public void add(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof ElanMediaPlayerController) {
            this.setMediaPlayerController((ElanMediaPlayerController)object);
        } else if (object instanceof SignalViewer) {
            this.setSignalViewer((SignalViewer)object);
        } else if (object instanceof TimeLineViewer) {
            this.setTimeLineViewer((TimeLineViewer)object);
        } else if (object instanceof InterlinearViewer) {
            this.setInterlinearViewer((InterlinearViewer)object);
        } else if (object instanceof GridViewer) {
            this.addSingleTierViewer((SingleTierViewer)object);
        } else if (object instanceof TextViewer) {
            this.addSingleTierViewer((SingleTierViewer)object);
        } else if (object instanceof SubtitleViewer) {
            this.addSingleTierViewer((SingleTierViewer)object);
        } else if (object instanceof TimeSeriesViewer) {
            this.setTimeSeriesViewer((TimeSeriesViewer)object);
        } else if (object instanceof RecognizerPanel) {
            this.recognizerPanel = (JComponent)object;
            this.addToTabPane(ElanLocale.getString("Tab.Recognizer"), this.recognizerPanel);
        } else if (object instanceof MetadataViewer) {
            this.metadataPanel = (JComponent)object;
            this.addToTabPane(ElanLocale.getString("Tab.Metadata"), (MetadataViewer)object);
        } else if (object instanceof LexiconEntryViewer) {
            this.lexiconPanel = (JComponent)object;
            this.addToTabPane(ElanLocale.getString("LexiconEntryViewer.Lexicon"), this.lexiconPanel);
        } else if (object instanceof CommentViewer) {
            this.commentPanel = (CommentViewer)object;
            this.addToTabPane(ElanLocale.getString("CommentViewer.Comment"), this.commentPanel);
        }
    }

    private void setMediaPlayerController(ElanMediaPlayerController mediaPlayerController) {
        this.mediaPlayerController = mediaPlayerController;
        mediaPlayerController.getSliderPanel().addMouseListener(mediaPlayerController.getAnnotationDensityViewer());
        this.container.add(mediaPlayerController.getPlayButtonsPanel());
        this.container.add(mediaPlayerController.getTimePanel());
        this.container.add(mediaPlayerController.getModePanel());
        this.container.add(mediaPlayerController.getSelectionPanel());
        this.container.add(mediaPlayerController.getSelectionButtonsPanel());
        this.container.add(mediaPlayerController.getAnnotationNavigationPanel());
        this.container.add(mediaPlayerController.getSliderPanel());
        this.container.add(mediaPlayerController.getAnnotationDensityViewer());
        this.container.add(mediaPlayerController.getVolumeIconPanel());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        this.controlPanel.add((Component)mediaPlayerController.getVolumePanel(), gbc);
        this.controlPanel.add((Component)mediaPlayerController.getPlayersVolumePanel(), gbc);
        JPanel filler = new JPanel();
        gbc.weighty = 3.0;
        this.controlPanel.add((Component)filler, gbc);
        gbc.weighty = 1.0;
        this.controlPanel.add((Component)mediaPlayerController.getRatePanel(), gbc);
        this.controlPanelScrollPane = new JScrollPane(this.controlPanel);
        this.addToTabPane(ElanLocale.getString("Tab.Controls"), this.controlPanelScrollPane);
    }

    private void removeMediaPlayerController() {
        this.mediaPlayerController.getSliderPanel().removeMouseListener(this.mediaPlayerController.getAnnotationDensityViewer());
        this.container.remove(this.mediaPlayerController.getPlayButtonsPanel());
        this.container.remove(this.mediaPlayerController.getTimePanel());
        this.viewerManager.destroyTimePanel();
        this.container.remove(this.mediaPlayerController.getModePanel());
        this.container.remove(this.mediaPlayerController.getSelectionPanel());
        this.container.remove(this.mediaPlayerController.getSelectionButtonsPanel());
        this.container.remove(this.mediaPlayerController.getAnnotationNavigationPanel());
        this.container.remove(this.mediaPlayerController.getSliderPanel());
        this.viewerManager.destroyMediaPlayerControlSlider();
        this.container.remove(this.mediaPlayerController.getAnnotationDensityViewer());
        this.viewerManager.destroyAnnotationDensityViewer();
        this.container.remove(this.mediaPlayerController.getVolumeIconPanel());
        this.controlPanel.removeAll();
        this.viewerManager.destroyElanMediaPlayerController();
        this.mediaPlayerController = null;
    }

    private void setTimeLineViewer(TimeLineViewer timeLineViewer) {
        this.timeLineViewer = timeLineViewer;
        if (this.timeLineComponent == null) {
            this.timeLineComponent = new JPanel();
            this.timeLineComponent.setLayout(null);
        }
        if (this.multiTierControlPanel == null) {
            this.multiTierControlPanel = this.viewerManager.getMultiTierControlPanel();
            this.multiTierControlPanel.setSize(120, 120);
            ResizeComponent mcpResize = new ResizeComponent(this.layoutManager, 0, 1);
            mcpResize.setSize(8, 16);
            this.multiTierControlPanel.setResizeComponent(mcpResize);
            this.timeLineComponent.add(this.multiTierControlPanel);
        }
        if (this.interlinearViewer != null) {
            this.viewerManager.disableViewer(this.interlinearViewer);
        }
        this.timeLineComponent.add(timeLineViewer);
        this.getTimeLineSplitPane().setBottomComponent(this.timeLineComponent);
        if (this.getTimeLineSplitPane().getTopComponent() != null) {
            Integer sigHeight = Preferences.getInt("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription());
            if (sigHeight != null && sigHeight > 70) {
                this.getTimeLineSplitPane().setDividerLocation(sigHeight);
            } else {
                this.getTimeLineSplitPane().setDividerLocation(70);
            }
            this.getTimeLineSplitPane().setDividerLocation(70);
        }
        this.doLayout();
    }

    private void setInterlinearViewer(InterlinearViewer interlinearViewer) {
        this.interlinearViewer = interlinearViewer;
        if (this.timeLineComponent == null) {
            this.timeLineComponent = new JPanel();
            this.timeLineComponent.setLayout(null);
        }
        if (this.multiTierControlPanel == null) {
            this.multiTierControlPanel = this.viewerManager.getMultiTierControlPanel();
            this.multiTierControlPanel.setSize(120, 120);
            ResizeComponent mcpResize = new ResizeComponent(this.layoutManager, 0, 1);
            mcpResize.setSize(8, 16);
            this.multiTierControlPanel.setResizeComponent(mcpResize);
            this.timeLineComponent.add(this.multiTierControlPanel);
        }
        if (this.timeLineViewer != null) {
            this.viewerManager.disableViewer(this.timeLineViewer);
        }
        this.timeLineComponent.add(interlinearViewer);
        this.getTimeLineSplitPane().setBottomComponent(this.timeLineComponent);
        this.doLayout();
    }

    private void setSignalViewer(SignalViewer signalViewer) {
        this.signalViewer = signalViewer;
        if (this.signalControlPanel == null) {
            this.signalControlPanel = this.viewerManager.getSignalViewerControlPanel();
            this.signalControlPanel.setSize(120, 120);
        }
        if (this.timeseriesViewer == null) {
            if (this.signalComponent == null) {
                this.signalComponent = new JPanel();
                this.signalComponent.setLayout(null);
                this.signalComponent.addComponentListener(new ElanLayoutManager.SignalSplitPaneListener(this.layoutManager));
                this.signalComponent.add(this.signalControlPanel);
            }
            this.signalComponent.add(signalViewer);
            this.getTimeLineSplitPane().setTopComponent(this.signalComponent);
            Integer sigHeight = Preferences.getInt("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription());
            if (sigHeight != null && sigHeight > 70) {
                this.timeLineSplitPane.setDividerLocation(sigHeight);
            } else {
                this.timeLineSplitPane.setDividerLocation(70);
            }
        } else {
            int curHeight = this.timeseriesComponent.getHeight();
            this.getTimeLineSplitPane().setTopComponent(null);
            this.signalComponent = new JPanel();
            this.signalComponent.setLayout(null);
            this.signalComponent.add(signalViewer);
            this.signalComponent.add(this.signalControlPanel);
            this.wav_tsSplitPane = this.getWav_TSSplitPane();
            this.wav_tsSplitPane.setTopComponent(this.timeseriesComponent);
            this.wav_tsSplitPane.setBottomComponent(this.signalComponent);
            this.wav_tsSplitPane.setDividerLocation(curHeight / 2);
            this.getTimeLineSplitPane().setTopComponent(this.wav_tsSplitPane);
            this.timeLineComponent.addComponentListener(new ElanLayoutManager.SignalSplitPaneListener(this.layoutManager));
            this.getTimeLineSplitPane().setDividerLocation(curHeight);
            Integer divLoc = Preferences.getInt("LayoutManager.TSWavSplitPaneDividerLocation", this.viewerManager.getTranscription());
            Integer spliDivLoc = Preferences.getInt("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription());
            if (divLoc != null && spliDivLoc != null) {
                if (this.wav_tsSplitPane != null) {
                    this.wav_tsSplitPane.setDividerLocation(divLoc);
                }
                this.getTimeLineSplitPane().setDividerLocation(spliDivLoc);
            }
        }
        this.doLayout();
    }

    void setTimeSeriesViewer(TimeSeriesViewer timeseriesViewer) {
        if (this.timeseriesViewer == null) {
            this.timeseriesViewer = timeseriesViewer;
            ViewerLayoutModel vlm = new ViewerLayoutModel(timeseriesViewer, this.layoutManager);
            this.viewerList.add(vlm);
            boolean detached = false;
            Boolean detObj = Preferences.getBool("TimeSeriesViewer.Detached", this.viewerManager.getTranscription());
            if (detObj != null) {
                detached = detObj;
            }
            if (detached) {
                vlm.detach();
                timeseriesViewer.setAttached(false);
                return;
            }
        }
        if (this.signalViewer == null) {
            this.timeseriesComponent = new JPanel();
            this.timeseriesComponent.setLayout(null);
            this.timeseriesComponent.addComponentListener(new ElanLayoutManager.SignalSplitPaneListener(this.layoutManager));
            this.timeseriesComponent.add(timeseriesViewer);
            this.getTimeLineSplitPane().setTopComponent(this.timeseriesComponent);
            int divLoc = this.timeseriesComponent.getHeight() < 70 ? 70 : this.timeseriesComponent.getHeight();
            Integer sigHeight = Preferences.getInt("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription());
            if (sigHeight != null && sigHeight > 70) {
                divLoc = sigHeight;
            }
            this.timeLineSplitPane.setDividerLocation(divLoc);
            timeseriesViewer.setAttached(true);
            if (this.multiTierControlPanel != null) {
                timeseriesViewer.setVerticalRulerWidth(this.multiTierControlPanel.getWidth());
            }
        } else {
            Integer divLoc;
            ComponentListener[] cListeners;
            for (ComponentListener cListener : cListeners = this.signalComponent.getComponentListeners()) {
                if (!(cListener instanceof ElanLayoutManager.SignalSplitPaneListener)) continue;
                this.signalComponent.removeComponentListener(cListener);
            }
            int curHeight = this.getTimeLineSplitPane().getDividerLocation();
            this.timeseriesComponent = new JPanel();
            this.timeseriesComponent.setLayout(null);
            this.timeseriesComponent.add(timeseriesViewer);
            this.getTimeLineSplitPane().setTopComponent(null);
            this.wav_tsSplitPane = this.getWav_TSSplitPane();
            this.wav_tsSplitPane.setTopComponent(this.timeseriesComponent);
            this.wav_tsSplitPane.setBottomComponent(this.signalComponent);
            this.wav_tsSplitPane.setDividerLocation(curHeight / 2);
            this.getTimeLineSplitPane().setTopComponent(this.wav_tsSplitPane);
            this.getTimeLineSplitPane().setDividerLocation(curHeight);
            this.timeseriesComponent.addComponentListener(new ElanLayoutManager.SignalSplitPaneListener(this.layoutManager));
            this.timeLineComponent.addComponentListener(new ElanLayoutManager.SignalSplitPaneListener(this.layoutManager));
            timeseriesViewer.setAttached(true);
            if (this.multiTierControlPanel != null) {
                timeseriesViewer.setVerticalRulerWidth(this.multiTierControlPanel.getWidth());
                timeseriesViewer.setBounds(this.timeseriesComponent.getBounds());
            }
            if ((divLoc = Preferences.getInt("LayoutManager.TSWavSplitPaneDividerLocation", this.viewerManager.getTranscription())) != null && this.wav_tsSplitPane != null && divLoc < curHeight - 20) {
                this.wav_tsSplitPane.setDividerLocation(divLoc);
            }
        }
        this.doLayout();
    }

    private void addToTabPane(String tabName, Component component) {
        this.getTabPane().insertTab(tabName, null, component, tabName, this.getIndexOfComponent(this.getTabPane(), component));
        this.preferenceChanged = true;
        this.doLayout();
    }

    private void addSingleTierViewer(SingleTierViewer viewer) {
        SingleTierViewerPanel panel = this.viewerManager.createSingleTierViewerPanel();
        panel.setViewer(viewer);
        if (viewer instanceof GridViewer) {
            this.gridPanel = panel;
            this.addToTabPane(ElanLocale.getString("Tab.Grid"), panel);
        } else if (viewer instanceof TextViewer) {
            this.textPanel = panel;
            this.addToTabPane(ElanLocale.getString("Tab.Text"), panel);
        } else if (viewer instanceof SubtitleViewer) {
            this.getSubtitlePanel().add(panel);
        }
        this.doLayout();
    }

    @Override
    public void remove(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof SignalViewer) {
            this.removeSignalViewer();
        } else if (object instanceof TimeSeriesViewer) {
            this.removeTimeSeriesViewer();
        } else if (object instanceof RecognizerPanel) {
            this.removeFromTabPane((Component)object);
        } else if (object instanceof MetadataViewer) {
            this.removeFromTabPane((Component)object);
        } else if (object instanceof GridViewer) {
            this.removeFromTabPane(this.gridPanel);
        } else if (object instanceof TextViewer) {
            this.removeFromTabPane(this.textPanel);
        } else if (object instanceof SubtitleViewer) {
            this.removeFromTabPane(this.subtitlePanel);
        } else if (object instanceof LexiconEntryViewer) {
            this.removeFromTabPane((Component)object);
        } else if (object instanceof CommentViewer) {
            this.removeFromTabPane((Component)object);
        }
    }

    private void removeFromTabPane(Component component) {
        if (component == null) {
            return;
        }
        if (this.getTabPane().indexOfComponent(component) >= 0) {
            this.getTabPane().remove(component);
        } else if (this.getLeftTabPane().indexOfComponent(component) >= 0) {
            this.getLeftTabPane().remove(component);
        }
    }

    private void removeSignalViewer() {
        if (this.signalViewer != null) {
            if (this.timeLineSplitPane != null) {
                this.layoutManager.setPreference("LayoutManager.SplitPaneDividerLocation", this.timeLineSplitPane.getDividerLocation(), this.viewerManager.getTranscription());
            }
            if (this.signalComponent != null) {
                if (this.wav_tsSplitPane != null && this.wav_tsSplitPane.getBottomComponent() == this.signalComponent) {
                    Component topComp = this.wav_tsSplitPane.getTopComponent();
                    this.wav_tsSplitPane.setTopComponent(null);
                    this.wav_tsSplitPane.setBottomComponent(null);
                    this.getTimeLineSplitPane().setTopComponent(topComp);
                    this.signalComponent.remove(this.signalViewer);
                    this.signalComponent.remove(this.signalControlPanel);
                    this.signalViewer = null;
                    this.signalComponent = null;
                    this.signalControlPanel = null;
                } else {
                    this.signalComponent.remove(this.signalViewer);
                    this.signalComponent.remove(this.signalControlPanel);
                    this.getTimeLineSplitPane().setTopComponent(null);
                    this.signalViewer = null;
                    this.signalComponent = null;
                    this.signalControlPanel = null;
                }
            }
        }
    }

    private void removeTimeSeriesViewer() {
        if (this.timeseriesViewer != null) {
            if (this.timeLineSplitPane != null) {
                this.layoutManager.setPreference("LayoutManager.SplitPaneDividerLocation", this.timeLineSplitPane.getDividerLocation(), this.viewerManager.getTranscription());
            }
            ViewerLayoutModel vlm = null;
            for (int i = 0; i < this.viewerList.size(); ++i) {
                vlm = this.viewerList.get(i);
                if (vlm.viewer == this.timeseriesViewer) break;
                vlm = null;
            }
            if (vlm == null) {
                return;
            }
            if (vlm.isAttached()) {
                if (this.wav_tsSplitPane != null) {
                    int curHeight = this.getTimeLineSplitPane().getDividerLocation();
                    this.wav_tsSplitPane.setTopComponent(null);
                    this.wav_tsSplitPane.setBottomComponent(null);
                    this.timeseriesComponent.remove(this.timeseriesViewer);
                    this.timeseriesComponent = null;
                    this.wav_tsSplitPane = null;
                    if (this.signalComponent != null) {
                        this.getTimeLineSplitPane().setTopComponent(this.signalComponent);
                        this.getTimeLineSplitPane().setDividerLocation(curHeight);
                        this.signalComponent.setSize(this.signalComponent.getWidth(), curHeight);
                    } else {
                        this.getTimeLineSplitPane().setTopComponent(null);
                    }
                } else {
                    this.getTimeLineSplitPane().setTopComponent(null);
                    if (this.timeseriesComponent != null) {
                        this.timeseriesComponent.remove(this.timeseriesViewer);
                        this.timeseriesComponent = null;
                    }
                }
                this.timeseriesViewer = null;
                this.doLayout();
            } else {
                vlm.attach();
                this.viewerList.remove(vlm);
                if (this.timeseriesComponent != null) {
                    this.timeseriesComponent.remove(vlm.viewer);
                    this.timeseriesComponent = null;
                }
                this.timeseriesViewer = null;
            }
        }
    }

    private JTabbedPane getTabPane() {
        if (this.tabPane == null) {
            this.tabPane = new JTabbedPane();
            this.container.add(this.tabPane);
        }
        return this.tabPane;
    }

    private JTabbedPane getLeftTabPane() {
        if (this.leftTabPane == null) {
            this.leftTabPane = new JTabbedPane();
            this.container.add(this.leftTabPane);
        }
        return this.leftTabPane;
    }

    private void destroyLeftPane() {
        if (this.leftTabPane != null) {
            this.container.remove(this.leftTabPane);
            this.leftTabPane = null;
        }
    }

    @Override
    public boolean destroyAndRemoveViewer(String viewerName) {
        boolean doLayout = false;
        if (viewerName == null) {
            return doLayout;
        }
        if (viewerName.equals("Menu.View.Viewers.Recognizer")) {
            if (this.recognizerPanel != null) {
                this.removeFromTabPane(this.recognizerPanel);
                this.recognizerPanel = null;
                doLayout = true;
            }
            this.viewerManager.destroyPanel("Menu.View.Viewers.Recognizer");
        } else if (viewerName.equals("Menu.View.Viewers.MetaData")) {
            if (this.metadataPanel != null) {
                this.removeFromTabPane(this.metadataPanel);
                this.metadataPanel = null;
                doLayout = true;
            }
            this.viewerManager.destroyMetaDataViewer();
        } else if (viewerName.equals("Menu.View.Viewers.Grid")) {
            if (this.gridPanel != null) {
                this.removeFromTabPane(this.gridPanel);
                ((GridViewer)this.gridPanel.getViewer()).isClosing();
                this.viewerManager.destroySingleTierViewerPanel(this.gridPanel);
                this.gridPanel = null;
                doLayout = true;
            }
            this.viewerManager.destroyGridViewer();
        } else if (viewerName.equals("Menu.View.Viewers.Text")) {
            if (this.textPanel != null) {
                this.removeFromTabPane(this.textPanel);
                this.viewerManager.destroySingleTierViewerPanel(this.textPanel);
                this.textPanel = null;
                doLayout = true;
            }
            this.viewerManager.destroyTextViewer();
        } else if (viewerName.equals("Menu.View.Viewers.Subtitles")) {
            if (this.subtitlePanel != null) {
                Component[] panel;
                this.removeFromTabPane(this.subtitlePanel);
                for (Component element : panel = this.subtitlePanel.getComponents()) {
                    if (!(element instanceof SingleTierViewerPanel)) continue;
                    ((SubtitleViewer)((SingleTierViewerPanel)element).getViewer()).isClosing();
                    this.viewerManager.destroySingleTierViewerPanel((SingleTierViewerPanel)element);
                }
                this.subtitlePanel = null;
                doLayout = true;
            }
            this.viewerManager.destroySubtitleViewers();
        } else if (viewerName.equals("Menu.View.Viewers.InterLinear")) {
            if (this.interlinearViewer != null) {
                this.remove(this.interlinearViewer);
                this.interlinearViewer.isClosing();
                if (this.layoutManager.getMode() == 1) {
                    this.showTimeLineViewer();
                }
                this.interlinearViewer = null;
                doLayout = true;
            }
            this.viewerManager.destroyInterlinearViewer();
            this.multiTierControlPanel.disableShowInterlinearViewer(true);
        } else if (viewerName.equals("LexiconEntryViewer.Lexicon")) {
            if (this.lexiconPanel != null) {
                this.removeFromTabPane(this.lexiconPanel);
                this.lexiconPanel = null;
                doLayout = true;
            }
            this.viewerManager.destroyLexiconViewer();
        } else if (viewerName.equals("CommentViewer.Comment")) {
            if (this.commentPanel != null) {
                this.removeFromTabPane(this.commentPanel);
                this.commentPanel = null;
                doLayout = true;
            }
            this.viewerManager.destroyCommentViewer();
        } else if (viewerName.equals("Menu.View.Viewers.Signal")) {
            if (this.signalViewer != null) {
                this.removeSignalViewer();
                doLayout = true;
            }
            this.viewerManager.destroySignalViewer();
        } else if (viewerName.equals("Menu.View.Viewers.TimeSeries") && this.timeseriesViewer != null) {
            this.layoutManager.remove(this.layoutManager.getTimeSeriesViewer());
            doLayout = true;
            this.viewerManager.connectViewer(this.timeseriesViewer, false);
        }
        return doLayout;
    }

    @Override
    public void createAndAddViewer(String viewerName) {
        Boolean val;
        if (viewerName == null) {
            return;
        }
        if (viewerName.equals("Menu.View.Viewers.Recognizer")) {
            this.add(this.viewerManager.createRecognizerPanel());
        } else if (viewerName.equals("Menu.View.Viewers.MetaData")) {
            this.add(this.viewerManager.createMetadataViewer());
        } else if (viewerName.equals("Menu.View.Viewers.Grid")) {
            this.add(this.viewerManager.createGridViewer());
            if (this.viewerManager.getGridViewer() != null) {
                this.viewerManager.getGridViewer().setKeyStrokesNotToBeConsumed(this.ksNotToBeConsumed);
            }
        } else if (viewerName.equals("Menu.View.Viewers.Text")) {
            this.add(this.viewerManager.createTextViewer());
        } else if (viewerName.equals("Menu.View.Viewers.Subtitles")) {
            this.createSubtitleViewer();
        } else if (viewerName.equals("Menu.View.Viewers.InterLinear")) {
            this.add(this.viewerManager.createInterlinearViewer());
            if (this.interlinearViewer != null) {
                this.interlinearViewer.setKeyStrokesNotToBeConsumed(this.ksNotToBeConsumed);
                this.multiTierControlPanel.disableShowInterlinearViewer(false);
                this.showTimeLineViewer();
            }
        } else if (viewerName.equals("LexiconEntryViewer.Lexicon")) {
            this.add(this.viewerManager.createLexiconEntryViewer());
        } else if (viewerName.equals("CommentViewer.Comment")) {
            this.add(this.viewerManager.createCommentViewer(this.viewerManager.getTranscription()));
        } else if (viewerName.equals("Menu.View.Viewers.Signal")) {
            this.layoutManager.add(this.viewerManager.createSignalViewer());
        } else if (viewerName.equals("Menu.View.Viewers.TimeSeries") && ((val = Preferences.getBool("Menu.View.Viewers.TimeSeries", null)) == null || val.booleanValue())) {
            this.add(this.layoutManager.getTimeSeriesViewer());
            if (this.timeseriesViewer != null) {
                this.viewerManager.connectViewer(this.timeseriesViewer, true);
            }
        }
    }

    private JPanel getSubtitlePanel() {
        if (this.subtitlePanel == null) {
            this.subtitlePanel = new JPanel(new GridLayout(0, 1));
            this.addToTabPane(ElanLocale.getString("Tab.Subtitles"), this.subtitlePanel);
        }
        return this.subtitlePanel;
    }

    private JSplitPane getTimeLineSplitPane() {
        if (this.timeLineSplitPane == null) {
            this.timeLineSplitPane = new JSplitPane(0);
            this.timeLineSplitPane.setOneTouchExpandable(true);
            this.timeLineSplitPane.setDividerLocation(0);
            this.timeLineSplitPane.setContinuousLayout(true);
            this.container.add(this.timeLineSplitPane);
        }
        return this.timeLineSplitPane;
    }

    private JSplitPane getWav_TSSplitPane() {
        if (this.wav_tsSplitPane == null) {
            this.wav_tsSplitPane = new JSplitPane(0);
            this.wav_tsSplitPane.setOneTouchExpandable(true);
            this.wav_tsSplitPane.setBorder(null);
            this.wav_tsSplitPane.setDividerLocation(0);
            this.wav_tsSplitPane.setDividerSize(6);
            this.wav_tsSplitPane.setContinuousLayout(true);
        }
        return this.wav_tsSplitPane;
    }

    public TimeLineViewer getTimeLineViewer() {
        return this.timeLineViewer;
    }

    public InterlinearViewer getInterlinearViewer() {
        return this.interlinearViewer;
    }

    public TimeSeriesViewer getTimeSeriesViewer() {
        return this.timeseriesViewer;
    }

    public MultiTierControlPanel getMultiTierControlPanel() {
        return this.multiTierControlPanel;
    }

    public MultiTierViewer getVisibleMultiTierViewer() {
        if (this.showTimeLineViewer) {
            return this.timeLineViewer;
        }
        return this.interlinearViewer;
    }

    private int getIndexOfComponent(JTabbedPane pane, Component component) {
        int index = 0;
        if (component == this.controlPanel) {
            return pane.getTabCount();
        }
        if (this.viewerSortOrder != null && this.viewerSortOrder.size() > 0) {
            for (int i = 0; i < this.viewerSortOrder.size(); ++i) {
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Grid"))) {
                    if (component == this.gridPanel) break;
                    if (pane.indexOfComponent(this.gridPanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Text"))) {
                    if (component == this.textPanel) break;
                    if (pane.indexOfComponent(this.textPanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Subtitles"))) {
                    if (component == this.subtitlePanel) break;
                    if (pane.indexOfComponent(this.subtitlePanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("LexiconEntryViewer.Lexicon"))) {
                    if (component == this.lexiconPanel) break;
                    if (pane.indexOfComponent(this.lexiconPanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("CommentViewer.Comment"))) {
                    if (component == this.commentPanel) break;
                    if (pane.indexOfComponent(this.commentPanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Recognizer"))) {
                    if (component == this.recognizerPanel) break;
                    if (pane.indexOfComponent(this.recognizerPanel) >= 0) {
                        ++index;
                    }
                }
                if (!this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.MetaData"))) continue;
                if (component == this.metadataPanel) break;
                if (pane.indexOfComponent(this.metadataPanel) < 0) continue;
                ++index;
            }
            return index;
        }
        if (component == this.gridPanel) {
            return index;
        }
        if (pane.indexOfComponent(this.gridPanel) >= 0) {
            ++index;
        }
        if (component == this.textPanel) {
            return index;
        }
        if (pane.indexOfComponent(this.textPanel) >= 0) {
            ++index;
        }
        if (component == this.subtitlePanel) {
            return index;
        }
        if (pane.indexOfComponent(this.subtitlePanel) >= 0) {
            ++index;
        }
        if (component == this.lexiconPanel) {
            return index;
        }
        if (pane.indexOfComponent(this.lexiconPanel) >= 0) {
            ++index;
        }
        if (component == this.commentPanel) {
            return index;
        }
        if (pane.indexOfComponent(this.commentPanel) >= 0) {
            ++index;
        }
        if (component == this.recognizerPanel) {
            return index;
        }
        if (pane.indexOfComponent(this.recognizerPanel) >= 0) {
            ++index;
        }
        if (pane.indexOfComponent(this.metadataPanel) >= 0) {
            ++index;
        } else if (component == this.metadataPanel) {
            return index;
        }
        return index;
    }

    private void reArrangeViewers() {
        if (this.mediaInCentre) {
            String tabName;
            int selectedIndexLeftPane = 0;
            int selectedIndexRightPane = 0;
            Component selectedLeftComponent = null;
            Component selectedRightComponent = null;
            if (this.getLeftTabPane().getTabCount() > 0) {
                selectedIndexLeftPane = this.getLeftTabPane().getSelectedIndex();
                selectedLeftComponent = this.getLeftTabPane().getSelectedComponent();
            }
            if (this.getTabPane().getTabCount() > 0) {
                selectedIndexRightPane = this.getTabPane().getSelectedIndex();
                selectedRightComponent = this.getTabPane().getSelectedComponent();
            }
            if (this.gridPanel != null) {
                tabName = ElanLocale.getString("Tab.Grid");
                this.getTabPane().remove(this.gridPanel);
                this.getLeftTabPane().remove(this.gridPanel);
                if (this.gridViewerLeft) {
                    this.getLeftTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.gridPanel));
                } else {
                    this.getTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.gridPanel));
                }
            }
            if (this.textPanel != null) {
                tabName = ElanLocale.getString("Tab.Text");
                this.getTabPane().remove(this.textPanel);
                this.getLeftTabPane().remove(this.textPanel);
                if (this.textViewerLeft) {
                    this.getLeftTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.textPanel));
                } else {
                    this.getTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.textPanel));
                }
            }
            if (this.subtitlePanel != null) {
                tabName = ElanLocale.getString("Tab.Subtitles");
                this.getTabPane().remove(this.subtitlePanel);
                this.getLeftTabPane().remove(this.subtitlePanel);
                if (this.subtitleViewerLeft) {
                    this.getLeftTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.subtitlePanel));
                } else {
                    this.getTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.subtitlePanel));
                }
            }
            if (this.lexiconPanel != null) {
                tabName = ElanLocale.getString("LexiconEntryViewer.Lexicon");
                this.getTabPane().remove(this.lexiconPanel);
                this.getLeftTabPane().remove(this.lexiconPanel);
                if (this.lexiconViewerLeft) {
                    this.getLeftTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.lexiconPanel));
                } else {
                    this.getTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.lexiconPanel));
                }
            }
            if (this.commentPanel != null) {
                tabName = ElanLocale.getString("CommentViewer.Comment");
                this.getTabPane().remove(this.commentPanel);
                this.getLeftTabPane().remove(this.commentPanel);
                if (this.commentViewerLeft) {
                    this.getLeftTabPane().insertTab(tabName, null, this.commentPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.commentPanel));
                } else {
                    this.getTabPane().insertTab(tabName, null, this.commentPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.commentPanel));
                }
            }
            if (this.recognizerPanel != null) {
                tabName = ElanLocale.getString("Tab.Recognizer");
                this.getTabPane().remove(this.recognizerPanel);
                this.getLeftTabPane().remove(this.recognizerPanel);
                if (this.recognizerLeft) {
                    this.getLeftTabPane().insertTab(tabName, null, this.recognizerPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.recognizerPanel));
                } else {
                    this.getTabPane().insertTab(tabName, null, this.recognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.recognizerPanel));
                }
            }
            if (this.metadataPanel != null) {
                tabName = ElanLocale.getString("Tab.Metadata");
                this.getTabPane().remove(this.metadataPanel);
                this.getLeftTabPane().remove(this.metadataPanel);
                if (this.metaDataLeft) {
                    this.getLeftTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.metadataPanel));
                } else {
                    this.getTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.metadataPanel));
                }
            }
            if (this.getLeftTabPane().indexOfComponent(selectedLeftComponent) > 0) {
                this.getLeftTabPane().setSelectedComponent(selectedLeftComponent);
            } else if (this.getLeftTabPane().getTabCount() > selectedIndexLeftPane) {
                this.getLeftTabPane().setSelectedIndex(selectedIndexLeftPane);
            } else {
                this.getLeftTabPane().setSelectedIndex(this.getLeftTabPane().getTabCount() - 1);
            }
            if (this.getTabPane().indexOfComponent(selectedRightComponent) > 0) {
                this.getTabPane().setSelectedComponent(selectedRightComponent);
            } else if (this.getTabPane().getTabCount() > selectedIndexRightPane) {
                this.getTabPane().setSelectedIndex(selectedIndexRightPane);
            } else {
                this.getTabPane().setSelectedIndex(this.getTabPane().getTabCount() - 1);
            }
        } else {
            String tabName;
            int selectedIndex = 0;
            Component selectedComponent = null;
            if (this.getTabPane().getTabCount() > 0) {
                selectedIndex = this.getTabPane().getSelectedIndex();
                selectedComponent = this.getTabPane().getSelectedComponent();
            }
            if (this.gridPanel != null) {
                tabName = ElanLocale.getString("Tab.Grid");
                this.getTabPane().remove(this.gridPanel);
                this.getTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.gridPanel));
            }
            if (this.textPanel != null) {
                tabName = ElanLocale.getString("Tab.Text");
                this.getTabPane().remove(this.textPanel);
                this.getTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.textPanel));
            }
            if (this.subtitlePanel != null) {
                tabName = ElanLocale.getString("Tab.Subtitles");
                this.getTabPane().remove(this.subtitlePanel);
                this.getTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.subtitlePanel));
            }
            if (this.lexiconPanel != null) {
                tabName = ElanLocale.getString("LexiconEntryViewer.Lexicon");
                this.getTabPane().remove(this.lexiconPanel);
                this.getTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.lexiconPanel));
            }
            if (this.commentPanel != null) {
                tabName = ElanLocale.getString("CommentViewer.Comment");
                this.getTabPane().remove(this.commentPanel);
                this.getTabPane().insertTab(tabName, null, this.commentPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.commentPanel));
            }
            if (this.recognizerPanel != null) {
                tabName = ElanLocale.getString("Tab.Recognizer");
                this.getTabPane().remove(this.recognizerPanel);
                this.getTabPane().insertTab(tabName, null, this.recognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.recognizerPanel));
            }
            if (this.metadataPanel != null) {
                tabName = ElanLocale.getString("Tab.Metadata");
                this.getTabPane().remove(this.metadataPanel);
                this.getTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.metadataPanel));
            }
            if (this.getTabPane().indexOfComponent(selectedComponent) > 0) {
                this.getTabPane().setSelectedComponent(selectedComponent);
            } else if (this.getTabPane().getTabCount() > selectedIndex) {
                this.getTabPane().setSelectedIndex(selectedIndex);
            } else {
                this.getTabPane().setSelectedIndex(this.getTabPane().getTabCount() - 1);
            }
        }
    }

    public void showTimeLineViewer() {
        this.showTimeLineViewer = true;
        this.showInterlinearViewer = false;
        this.enableDisableLogic();
        this.doLayout();
    }

    public void showInterlinearViewer() {
        this.showTimeLineViewer = false;
        this.showInterlinearViewer = true;
        this.enableDisableLogic();
        this.doLayout();
    }

    private void enableDisableLogic() {
        if (this.showTimeLineViewer) {
            if (this.timeLineViewer != null) {
                this.viewerManager.enableViewer(this.timeLineViewer);
            }
            if (this.interlinearViewer != null) {
                this.interlinearViewer.isClosing();
                this.viewerManager.disableViewer(this.interlinearViewer);
            }
            this.layoutManager.setPreference("LayoutManager.VisibleMultiTierViewer", TimeLineViewer.class.getName(), this.viewerManager.getTranscription());
            this.timeLineViewer.preferencesChanged();
        } else if (this.showInterlinearViewer) {
            if (this.timeLineViewer != null) {
                this.timeLineViewer.isClosing();
                this.viewerManager.disableViewer(this.timeLineViewer);
            }
            if (this.interlinearViewer != null) {
                this.viewerManager.enableViewer(this.interlinearViewer);
            }
            this.layoutManager.setPreference("LayoutManager.VisibleMultiTierViewer", InterlinearViewer.class.getName(), this.viewerManager.getTranscription());
            this.interlinearViewer.preferencesChanged();
        }
    }

    @Override
    public void detach(Object object) {
        if (object instanceof AbstractViewer) {
            this.container.remove((Component)object);
            if (object instanceof TimeSeriesViewer) {
                ViewerLayoutModel vlm = null;
                for (int i = 0; i < this.viewerList.size(); ++i) {
                    vlm = this.viewerList.get(i);
                    if (vlm.viewer == object) break;
                    vlm = null;
                }
                if (vlm == null) {
                    return;
                }
                if (this.wav_tsSplitPane != null) {
                    int curHeight = this.getTimeLineSplitPane().getDividerLocation();
                    this.wav_tsSplitPane.setTopComponent(null);
                    this.wav_tsSplitPane.setBottomComponent(null);
                    this.timeseriesComponent.remove(this.timeseriesViewer);
                    this.timeseriesComponent = null;
                    this.wav_tsSplitPane = null;
                    if (this.signalComponent != null) {
                        this.getTimeLineSplitPane().setTopComponent(this.signalComponent);
                        this.getTimeLineSplitPane().setDividerLocation(curHeight);
                        this.signalComponent.setSize(this.signalComponent.getWidth(), curHeight);
                    } else {
                        this.getTimeLineSplitPane().setTopComponent(null);
                    }
                } else {
                    this.getTimeLineSplitPane().setTopComponent(null);
                    if (this.timeseriesComponent != null) {
                        this.timeseriesComponent.remove(this.timeseriesViewer);
                        this.timeseriesComponent = null;
                    }
                }
                this.doLayout();
                vlm.detach();
            }
        }
    }

    @Override
    public void attach(Object object) {
        if (object instanceof AbstractViewer) {
            ViewerLayoutModel vlm = null;
            for (int i = 0; i < this.viewerList.size(); ++i) {
                vlm = this.viewerList.get(i);
                if (vlm.viewer == object) break;
                vlm = null;
            }
            if (vlm == null) {
                return;
            }
            vlm.attach();
            if (vlm.viewer instanceof TimeSeriesViewer) {
                this.setTimeSeriesViewer((TimeSeriesViewer)vlm.viewer);
            }
        }
    }

    @Override
    public void doLayout() {
        Integer selIndex;
        int rMargin;
        float aspectRatio;
        if (!this.layoutManager.isIntialized()) {
            return;
        }
        int containerWidth = this.container.getWidth();
        int containerHeight = this.container.getHeight();
        int containerMargin = 3;
        int componentMargin = 5;
        PlayerLayoutModel[] visualPlayers = this.layoutManager.getAttachedVisualPlayers();
        int numVisualPlayers = visualPlayers.length;
        int mediaAreaHeight = this.layoutManager.getMediaAreaHeight();
        int visibleMediaX = containerMargin;
        int visibleMediaY = containerMargin;
        int visibleMediaWidth = 0;
        int visibleMediaHeight = mediaAreaHeight;
        int firstMediaWidth = visibleMediaWidth;
        int firstMediaHeight = mediaAreaHeight;
        if (this.oneRowForVisuals) {
            if (numVisualPlayers >= 1) {
                int maxPerMedia = (containerWidth - this.minTabWidth) / numVisualPlayers;
                int maxUsedHeight = 0;
                for (int i = 0; i < numVisualPlayers && i < 4; ++i) {
                    Component visComp = visualPlayers[i].visualComponent;
                    aspectRatio = visualPlayers[i].player.getAspectRatio();
                    int curWidth = 0;
                    int curHeight = 0;
                    if ((float)mediaAreaHeight * aspectRatio > (float)maxPerMedia) {
                        curWidth = maxPerMedia;
                        curHeight = (int)((float)maxPerMedia / aspectRatio);
                        maxUsedHeight = curHeight > maxUsedHeight ? curHeight : maxUsedHeight;
                    } else {
                        curWidth = (int)((float)mediaAreaHeight * aspectRatio);
                        curHeight = mediaAreaHeight;
                    }
                    if (i == 0) {
                        visibleMediaWidth = visibleMediaX + curWidth + componentMargin;
                        visComp.setBounds(visibleMediaX, visibleMediaY, curWidth, curHeight);
                        firstMediaWidth = curWidth;
                        continue;
                    }
                    visComp.setBounds(visibleMediaX + visibleMediaWidth, visibleMediaY, curWidth, curHeight);
                    visibleMediaWidth = visibleMediaWidth + curWidth + componentMargin;
                }
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - visibleMediaWidth) / 2;
                    int shiftX = 0;
                    for (int i = 0; i < numVisualPlayers && i < 4; ++i) {
                        if (i == 0) {
                            shiftX = visibleMediaX - visualPlayers[i].visualComponent.getX();
                        }
                        Point p = visualPlayers[i].visualComponent.getLocation();
                        visualPlayers[i].visualComponent.setLocation(p.x + shiftX, p.y);
                    }
                }
            }
        } else {
            float secondAR;
            Component secondVisualComp;
            int maxWidthForMedia = containerWidth - this.minTabWidth;
            if (numVisualPlayers >= 1) {
                Component firstVisualComp = visualPlayers[0].visualComponent;
                aspectRatio = visualPlayers[0].player.getAspectRatio();
                firstMediaWidth = 352;
                firstMediaWidth = visualPlayers[0].player.getSourceWidth() > 704 && mediaAreaHeight == 250 ? visualPlayers[0].player.getSourceWidth() / 2 : (int)((float)firstMediaHeight * aspectRatio);
                firstMediaHeight = (int)((float)(firstMediaWidth = firstMediaWidth > maxWidthForMedia ? maxWidthForMedia : firstMediaWidth) / aspectRatio);
                if (firstMediaHeight > mediaAreaHeight) {
                    firstMediaHeight = mediaAreaHeight;
                    firstMediaWidth = (int)((float)firstMediaHeight * aspectRatio);
                }
                visibleMediaWidth = firstMediaWidth + componentMargin;
                visibleMediaHeight = firstMediaHeight;
                if (numVisualPlayers == 1) {
                    if (this.mediaInCentre) {
                        visibleMediaX = (containerWidth - visibleMediaWidth) / 2;
                    }
                    firstVisualComp.setBounds(containerMargin + visibleMediaX, visibleMediaY, firstMediaWidth, firstMediaHeight);
                }
            }
            if (numVisualPlayers == 2) {
                secondVisualComp = visualPlayers[1].visualComponent;
                secondAR = visualPlayers[1].player.getAspectRatio();
                int secondMediaWidth = (int)((float)visibleMediaHeight * secondAR);
                int secondMediaHeight = visibleMediaHeight;
                if (visualPlayers[1].player.getSourceWidth() > 704 && visualPlayers[1].player.getSourceWidth() > visualPlayers[0].player.getSourceWidth() && (secondMediaHeight = (int)((float)(secondMediaWidth = visualPlayers[1].player.getSourceWidth() / 2) / secondAR)) > mediaAreaHeight) {
                    secondMediaHeight = mediaAreaHeight;
                    secondMediaWidth = (int)((float)secondMediaHeight * secondAR);
                }
                if (firstMediaWidth + secondMediaWidth + componentMargin > maxWidthForMedia) {
                    float sizeRatio = (float)(maxWidthForMedia - componentMargin) / (float)(firstMediaWidth + secondMediaWidth);
                    firstMediaWidth = (int)(sizeRatio * (float)firstMediaWidth);
                    firstMediaHeight = (int)((float)firstMediaWidth / visualPlayers[0].player.getAspectRatio());
                    visibleMediaWidth = firstMediaWidth + componentMargin;
                    secondMediaWidth = (int)(sizeRatio * (float)secondMediaWidth);
                    secondMediaHeight = (int)((float)secondMediaWidth / secondAR);
                    secondMediaHeight = firstMediaHeight;
                }
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - (visibleMediaWidth + secondMediaWidth)) / 2;
                }
                visualPlayers[0].visualComponent.setBounds(containerMargin + visibleMediaX, visibleMediaY, firstMediaWidth, firstMediaHeight);
                secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth, visibleMediaY, secondMediaWidth, secondMediaHeight);
                visibleMediaWidth += secondMediaWidth + componentMargin;
            } else if (numVisualPlayers == 3) {
                secondVisualComp = visualPlayers[1].visualComponent;
                secondAR = visualPlayers[1].player.getAspectRatio();
                Component thirdVisualComp = visualPlayers[2].visualComponent;
                float thirdAR = visualPlayers[2].player.getAspectRatio();
                int heightPerPlayer = (visibleMediaHeight - componentMargin) / 2;
                int secondWidth = (int)(secondAR * (float)heightPerPlayer);
                int thirdWidth = (int)(thirdAR * (float)heightPerPlayer);
                int widthPerPlayer = Math.max(secondWidth, thirdWidth);
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - (visibleMediaWidth + widthPerPlayer)) / 2;
                }
                visualPlayers[0].visualComponent.setBounds(visibleMediaX, visibleMediaY, firstMediaWidth, (int)((float)firstMediaWidth / visualPlayers[0].player.getAspectRatio()));
                secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - secondWidth) / 2, visibleMediaY, secondWidth, heightPerPlayer);
                thirdVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - thirdWidth) / 2, visibleMediaY + heightPerPlayer + componentMargin, thirdWidth, heightPerPlayer);
                visibleMediaWidth += widthPerPlayer + componentMargin;
            } else if (numVisualPlayers >= 4) {
                secondVisualComp = visualPlayers[1].visualComponent;
                secondAR = visualPlayers[1].player.getAspectRatio();
                Component thirdVisualComp = visualPlayers[2].visualComponent;
                float thirdAR = visualPlayers[2].player.getAspectRatio();
                Component fourthVisualComp = visualPlayers[3].visualComponent;
                float fourthAR = visualPlayers[3].player.getAspectRatio();
                int heightPerPlayer = (visibleMediaHeight - 2 * componentMargin) / 3;
                int secondWidth = (int)(secondAR * (float)heightPerPlayer);
                int thirdWidth = (int)(thirdAR * (float)heightPerPlayer);
                int fourthWidth = (int)(fourthAR * (float)heightPerPlayer);
                int widthPerPlayer = Math.max(secondWidth, thirdWidth);
                widthPerPlayer = Math.max(widthPerPlayer, fourthWidth);
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - (visibleMediaWidth + widthPerPlayer)) / 2;
                }
                visualPlayers[0].visualComponent.setBounds(visibleMediaX, visibleMediaY, firstMediaWidth, (int)((float)firstMediaWidth / visualPlayers[0].player.getAspectRatio()));
                secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - secondWidth) / 2, visibleMediaY, secondWidth, heightPerPlayer);
                thirdVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - thirdWidth) / 2, visibleMediaY + heightPerPlayer + componentMargin, thirdWidth, heightPerPlayer);
                fourthVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - fourthWidth) / 2, visibleMediaY + 2 * heightPerPlayer + 2 * componentMargin, fourthWidth, heightPerPlayer);
                visibleMediaWidth += widthPerPlayer + componentMargin;
            }
        }
        int tabPaneX = visibleMediaX + visibleMediaWidth;
        int tabPaneY = visibleMediaY;
        int tabPaneWidth = containerWidth - tabPaneX;
        int tabPaneHeight = visibleMediaHeight;
        if (this.mediaInCentre) {
            if (numVisualPlayers > 0) {
                tabPaneWidth = visibleMediaX;
            } else {
                tabPaneX = tabPaneWidth /= 2;
            }
            tabPaneX -= containerMargin;
            this.getLeftTabPane().setBounds(containerMargin, containerMargin, tabPaneWidth, tabPaneHeight);
        } else {
            this.destroyLeftPane();
        }
        if (this.tabPane != null) {
            this.tabPane.setBounds(tabPaneX, tabPaneY, tabPaneWidth, tabPaneHeight);
            if (this.mediaPlayerController != null && this.controlPanel != null) {
                this.controlPanel.setSize(tabPaneWidth, tabPaneHeight);
            }
        }
        if (this.numOfPlayers != numVisualPlayers && this.numOfPlayers == 0) {
            this.preferenceChanged = true;
        }
        if (this.preferenceChanged || numVisualPlayers == 0) {
            this.reArrangeViewers();
            this.preferenceChanged = false;
        }
        int timePanelX = 0;
        int timePanelY = visibleMediaY + visibleMediaHeight + 2;
        int timePanelWidth = 0;
        int timePanelHeight = 0;
        if (this.mediaPlayerController != null) {
            timePanelWidth = this.mediaPlayerController.getTimePanel().getPreferredSize().width;
            timePanelHeight = this.mediaPlayerController.getTimePanel().getPreferredSize().height;
            timePanelX = numVisualPlayers == 0 ? containerMargin : (this.mediaInCentre ? visibleMediaX : containerMargin + firstMediaWidth / 2 - timePanelWidth / 2);
            this.mediaPlayerController.getTimePanel().setBounds(timePanelX, timePanelY, timePanelWidth, timePanelHeight);
        }
        int playButtonsX = 3;
        int playButtonsY = timePanelY + timePanelHeight + 4;
        int playButtonsWidth = 0;
        int playButtonsHeight = 0;
        if (this.mediaPlayerController != null) {
            playButtonsWidth = this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().width;
            playButtonsHeight = this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().height;
            if (numVisualPlayers > 0) {
                if (this.mediaInCentre) {
                    playButtonsX = visibleMediaX;
                } else {
                    playButtonsX = containerMargin + firstMediaWidth / 2 - playButtonsWidth / 2;
                    if (playButtonsX < 3) {
                        playButtonsX = 3;
                    }
                }
            }
            this.mediaPlayerController.getPlayButtonsPanel().setBounds(playButtonsX, playButtonsY, playButtonsWidth, playButtonsHeight);
        }
        int selectionPanelX = playButtonsX + playButtonsWidth + 20;
        int selectionPanelY = visibleMediaY + visibleMediaHeight + 2;
        int selectionPanelWidth = 0;
        int selectionPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            selectionPanelWidth = 100 + this.mediaPlayerController.getSelectionPanel().getPreferredSize().width;
            selectionPanelHeight = this.mediaPlayerController.getSelectionPanel().getPreferredSize().height;
            this.mediaPlayerController.getSelectionPanel().setBounds(selectionPanelX, selectionPanelY, selectionPanelWidth, selectionPanelHeight);
        }
        int selectionButtonsX = selectionPanelX;
        int selectionButtonsY = selectionPanelY + selectionPanelHeight + 4;
        int selectionButtonsWidth = 0;
        int selectionButtonsHeight = 0;
        if (this.mediaPlayerController != null) {
            selectionButtonsWidth = this.mediaPlayerController.getSelectionButtonsPanel().getPreferredSize().width;
            selectionButtonsHeight = this.mediaPlayerController.getSelectionButtonsPanel().getPreferredSize().height;
            this.mediaPlayerController.getSelectionButtonsPanel().setBounds(selectionButtonsX, selectionButtonsY, selectionButtonsWidth, selectionButtonsHeight);
        }
        int annotationButtonsX = selectionButtonsX + selectionButtonsWidth + 15;
        int annotationButtonsY = selectionPanelY + selectionPanelHeight + 4;
        int annotationButtonsWidth = 0;
        int annotationButtonsHeight = 0;
        if (this.mediaPlayerController != null) {
            annotationButtonsWidth = this.mediaPlayerController.getAnnotationNavigationPanel().getPreferredSize().width;
            annotationButtonsHeight = this.mediaPlayerController.getAnnotationNavigationPanel().getPreferredSize().height;
            this.mediaPlayerController.getAnnotationNavigationPanel().setBounds(annotationButtonsX, annotationButtonsY, annotationButtonsWidth, annotationButtonsHeight);
        }
        int modePanelX = annotationButtonsX + annotationButtonsWidth + 10;
        int modePanelY = annotationButtonsY;
        int modePanelWidth = 0;
        int modePanelHeight = 0;
        if (this.mediaPlayerController != null) {
            modePanelWidth = this.mediaPlayerController.getModePanel().getPreferredSize().width;
            modePanelHeight = this.mediaPlayerController.getModePanel().getPreferredSize().height;
            if (modePanelHeight > annotationButtonsHeight && annotationButtonsHeight > 0) {
                modePanelY -= (modePanelHeight - annotationButtonsHeight) / 2;
            }
            this.mediaPlayerController.getModePanel().setBounds(modePanelX, modePanelY, modePanelWidth, modePanelHeight);
        }
        int butVolumeX = modePanelX + modePanelWidth + 10;
        int butVolumeY = annotationButtonsY;
        int butVolumeWidth = 0;
        int butVolumeHeight = 0;
        if (this.mediaPlayerController != null) {
            butVolumeWidth = this.mediaPlayerController.getButtonSize().width;
            butVolumeHeight = this.mediaPlayerController.getButtonSize().height;
            this.mediaPlayerController.getVolumeIconPanel().setBounds(butVolumeX, butVolumeY, butVolumeWidth, butVolumeHeight);
        }
        if (butVolumeX + butVolumeWidth > containerWidth && this.mediaPlayerController != null) {
            timePanelX = numVisualPlayers == 0 ? containerMargin : containerMargin + firstMediaWidth / 2 - timePanelWidth / 2;
            this.mediaPlayerController.getTimePanel().setBounds(timePanelX, timePanelY, timePanelWidth, timePanelHeight);
            playButtonsX = containerMargin + firstMediaWidth / 2 - playButtonsWidth / 2;
            if (playButtonsX < 3) {
                playButtonsX = 3;
            }
            this.mediaPlayerController.getPlayButtonsPanel().setBounds(playButtonsX, playButtonsY, playButtonsWidth, playButtonsHeight);
            selectionPanelX = playButtonsX + playButtonsWidth + 20;
            this.mediaPlayerController.getSelectionPanel().setBounds(selectionPanelX, selectionPanelY, selectionPanelWidth, selectionPanelHeight);
            selectionButtonsX = selectionPanelX;
            this.mediaPlayerController.getSelectionButtonsPanel().setBounds(selectionButtonsX, selectionButtonsY, selectionButtonsWidth, selectionButtonsHeight);
            annotationButtonsX = selectionButtonsX + selectionButtonsWidth + 15;
            this.mediaPlayerController.getAnnotationNavigationPanel().setBounds(annotationButtonsX, annotationButtonsY, annotationButtonsWidth, annotationButtonsHeight);
            modePanelX = annotationButtonsX + annotationButtonsWidth + 10;
            this.mediaPlayerController.getModePanel().setBounds(modePanelX, modePanelY, modePanelWidth, modePanelHeight);
            butVolumeX = modePanelX + modePanelWidth;
            this.mediaPlayerController.getVolumeIconPanel().setBounds(butVolumeX, butVolumeY, butVolumeWidth, butVolumeHeight);
        }
        int divX = 0;
        int divY = playButtonsY + playButtonsHeight + 4;
        int divHeight = this.vertMediaResizer.getPreferredSize().height;
        this.vertMediaResizer.setBounds(divX, divY, containerWidth, divHeight);
        int sliderPanelX = 3;
        int sliderPanelY = divY + divHeight + 4;
        int sliderPanelWidth = 0;
        int sliderPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            sliderPanelWidth = containerWidth - 6;
            sliderPanelHeight = this.mediaPlayerController.getSliderPanel().getPreferredSize().height;
            this.mediaPlayerController.getSliderPanel().setBounds(sliderPanelX, sliderPanelY, sliderPanelWidth, sliderPanelHeight);
        }
        int densityPanelX = 3;
        int densityPanelY = sliderPanelY - 3;
        int densityPanelWidth = sliderPanelWidth;
        int densityPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            densityPanelHeight = this.mediaPlayerController.getAnnotationDensityViewer().getPreferredSize().height;
            this.mediaPlayerController.getAnnotationDensityViewer().setBounds(densityPanelX, densityPanelY, densityPanelWidth, densityPanelHeight);
        }
        int timeLineSplitPaneX = 3;
        int timeLineSplitPaneY = densityPanelY + densityPanelHeight + 4;
        int timeLineSplitPaneWidth = 0;
        int timeLineSplitPaneHeight = 0;
        if (this.timeLineSplitPane != null) {
            timeLineSplitPaneWidth = containerWidth - 6;
            timeLineSplitPaneHeight = containerHeight - timeLineSplitPaneY;
            this.timeLineSplitPane.setBounds(timeLineSplitPaneX, timeLineSplitPaneY, timeLineSplitPaneWidth, timeLineSplitPaneHeight);
        }
        int multiTierControlX = 0;
        int multiTierControlY = 0;
        int multiTierControlWidth = 0;
        int multiTierControlHeight = 0;
        int timeLineX = 0;
        int timeLineY = 0;
        int timeLineWidth = 0;
        int timeLineHeight = 0;
        int interlinearX = 0;
        int interlinearY = 0;
        int interlinearWidth = 0;
        int interlinearHeight = 0;
        if (this.timeLineComponent != null) {
            int bottomHeight = this.timeLineSplitPane.getHeight() - this.timeLineSplitPane.getDividerLocation() - this.timeLineSplitPane.getDividerSize();
            Insets insets = this.timeLineSplitPane.getInsets();
            this.timeLineComponent.setSize(this.timeLineSplitPane.getWidth() - insets.left - insets.top, bottomHeight - insets.bottom);
            this.timeLineComponent.setPreferredSize(this.timeLineComponent.getSize());
            multiTierControlWidth = this.layoutManager.getMultiTierControlPanelWidth();
            multiTierControlHeight = bottomHeight;
            this.multiTierControlPanel.setSize(multiTierControlWidth, multiTierControlHeight);
            this.multiTierControlPanel.setBounds(multiTierControlX, multiTierControlY, multiTierControlWidth, multiTierControlHeight);
            if (this.showTimeLineViewer) {
                timeLineX = multiTierControlWidth;
                timeLineWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth;
                timeLineHeight = bottomHeight;
            } else {
                interlinearX = multiTierControlWidth;
                interlinearWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth;
                interlinearHeight = bottomHeight;
            }
            if (this.timeLineViewer != null) {
                this.timeLineViewer.setBounds(timeLineX, timeLineY, timeLineWidth, timeLineHeight);
                this.timeLineViewer.setPreferredSize(new Dimension(timeLineWidth, timeLineHeight));
                this.timeLineViewer.componentResized(null);
            }
            if (this.interlinearViewer != null) {
                this.interlinearViewer.setBounds(interlinearX, interlinearY, interlinearWidth, interlinearHeight);
                this.interlinearViewer.setPreferredSize(new Dimension(interlinearWidth, interlinearHeight));
                this.interlinearViewer.componentResized(null);
            }
        }
        int signalX = multiTierControlWidth;
        int signalY = 0;
        int signalWidth = 0;
        int signalHeight = 0;
        if (this.wav_tsSplitPane != null && this.signalComponent != null && this.timeseriesComponent != null) {
            int topHeight = this.wav_tsSplitPane.getDividerLocation();
            int rMargin2 = 0;
            if (this.timeLineViewer != null) {
                rMargin2 = this.timeLineViewer.getRightMargin();
            }
            signalWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth - rMargin2;
            signalHeight = this.wav_tsSplitPane.getHeight() - this.wav_tsSplitPane.getDividerSize() - topHeight;
            this.signalControlPanel.setBounds(0, 0, multiTierControlWidth, signalHeight);
            this.signalViewer.setBounds(signalX, signalY, signalWidth, signalHeight);
            this.signalComponent.setPreferredSize(new Dimension(signalWidth, signalHeight));
            int tsWidth = 0;
            this.timeseriesViewer.setRightMargin(rMargin2);
            this.timeseriesViewer.setVerticalRulerWidth(multiTierControlWidth);
            tsWidth = this.timeLineSplitPane.getWidth();
            this.timeseriesViewer.setBounds(0, signalY, tsWidth, topHeight);
            this.timeseriesComponent.setPreferredSize(new Dimension(tsWidth, topHeight));
        } else if (this.signalComponent != null && this.signalViewer != null) {
            rMargin = 0;
            if (this.timeLineViewer != null) {
                rMargin = this.timeLineViewer.getRightMargin();
            }
            signalWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth - rMargin;
            signalHeight = this.signalComponent.getHeight();
            this.signalControlPanel.setBounds(0, 0, multiTierControlWidth, signalHeight);
            this.signalViewer.setBounds(signalX, signalY, signalWidth, signalHeight);
            this.signalComponent.setPreferredSize(new Dimension(signalWidth, signalHeight));
        } else if (this.timeseriesComponent != null && this.timeseriesViewer != null) {
            rMargin = 0;
            int tsWidth = 0;
            if (this.timeLineViewer != null) {
                rMargin = this.timeLineViewer.getRightMargin();
                this.timeseriesViewer.setRightMargin(rMargin);
            }
            this.timeseriesViewer.setVerticalRulerWidth(multiTierControlWidth);
            tsWidth = this.timeLineSplitPane.getWidth();
            signalHeight = this.timeseriesComponent.getHeight();
            this.timeseriesViewer.setBounds(0, signalY, tsWidth, signalHeight);
            this.timeseriesComponent.setPreferredSize(new Dimension(tsWidth, signalHeight));
        }
        if (this.timeLineSplitPane != null) {
            this.timeLineSplitPane.resetToPreferredSizes();
        }
        if (this.mediaInCentre && (selIndex = Preferences.getInt("LayoutManager.SelectedLeftTabIndex", this.viewerManager.getTranscription())) != null) {
            int index = selIndex;
            if (index >= 0 && index < this.getLeftTabPane().getTabCount()) {
                this.getLeftTabPane().setSelectedIndex(index);
            } else if (this.getLeftTabPane().getTabCount() > 0) {
                this.getLeftTabPane().setSelectedIndex(0);
            }
        }
        this.numOfPlayers = numVisualPlayers;
        this.container.validate();
    }

    @Override
    public void updateLocale() {
        if (this.tabPane != null) {
            int nTabs = this.tabPane.getTabCount();
            for (int i = 0; i < nTabs; ++i) {
                Component component = this.tabPane.getComponentAt(i);
                if (component == this.gridPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Grid"));
                    continue;
                }
                if (component == this.textPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Text"));
                    continue;
                }
                if (component == this.subtitlePanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Subtitles"));
                    continue;
                }
                if (component == this.controlPanelScrollPane || component == this.controlPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Controls"));
                    continue;
                }
                if (component == this.recognizerPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Recognizer"));
                    continue;
                }
                if (component == this.metadataPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Metadata"));
                    continue;
                }
                if (component == this.lexiconPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("LexiconEntryViewer.Lexicon"));
                    continue;
                }
                if (component != this.commentPanel) continue;
                this.tabPane.setTitleAt(i, ElanLocale.getString("CommentViewer.Comment"));
            }
        }
    }

    @Override
    public void clearLayout() {
        if (this.layoutManager.containsComponent(this.getTabPane())) {
            this.container.remove(this.getTabPane());
        }
        if (this.layoutManager.containsComponent(this.getLeftTabPane())) {
            this.container.remove(this.getLeftTabPane());
        }
        if (this.layoutManager.containsComponent(this.timeLineSplitPane)) {
            this.container.remove(this.timeLineSplitPane);
        }
        if (this.layoutManager.containsComponent(this.vertMediaResizer)) {
            this.container.remove(this.vertMediaResizer);
        }
        this.destroyAndRemoveViewer("Menu.View.Viewers.InterLinear");
        this.destroyAndRemoveViewer("Menu.View.Viewers.Grid");
        this.destroyAndRemoveViewer("Menu.View.Viewers.Text");
        this.destroyAndRemoveViewer("Menu.View.Viewers.Subtitles");
        this.destroyAndRemoveViewer("LexiconEntryViewer.Lexicon");
        this.destroyAndRemoveViewer("CommentViewer.Comment");
        this.destroyAndRemoveViewer("Menu.View.Viewers.Recognizer");
        this.destroyAndRemoveViewer("Menu.View.Viewers.MetaData");
        this.removeMediaPlayerController();
        if (this.signalViewer != null) {
            this.container.remove(this.signalViewer);
        }
        this.timeseriesViewer = null;
        if (this.timeLineComponent != null) {
            this.timeLineComponent.removeAll();
        }
        this.multiTierControlPanel = null;
        this.timeLineViewer = null;
        this.viewerManager.destroyTimeLineViewer();
        this.viewerManager.destroyMultiTierControlPanel();
        this.container.repaint();
    }

    @Override
    public void cleanUpOnClose() {
    }

    @Override
    public void isClosing() {
        Boolean val;
        this.mediaPlayerController.stopLoop();
        this.layoutManager.setPreference("LayoutManager.SelectedTabIndex", this.getTabPane().getSelectedIndex(), this.viewerManager.getTranscription());
        if (this.mediaInCentre && this.getLeftTabPane().getSelectedIndex() >= 0) {
            this.layoutManager.setPreference("LayoutManager.SelectedLeftTabIndex", this.getLeftTabPane().getSelectedIndex(), this.viewerManager.getTranscription());
        }
        if ((val = Preferences.getBool("InlineEdit.DeselectCommits", null)) != null && val.booleanValue()) {
            if (this.gridPanel != null) {
                ((GridViewer)this.gridPanel.getViewer()).isClosing();
            }
            if (this.interlinearViewer != null) {
                this.interlinearViewer.isClosing();
            }
            if (this.subtitlePanel != null) {
                Component[] panel;
                for (Component element : panel = this.subtitlePanel.getComponents()) {
                    if (!(element instanceof SingleTierViewerPanel)) continue;
                    ((SubtitleViewer)((SingleTierViewerPanel)element).getViewer()).isClosing();
                }
            }
        }
        if (this.timeLineViewer != null) {
            this.timeLineViewer.isClosing();
        }
        if (this.commentPanel != null) {
            this.commentPanel.isClosing();
        }
        if (this.recognizerPanel != null && this.recognizerPanel instanceof AbstractRecognizerPanel) {
            ((AbstractRecognizerPanel)this.recognizerPanel).isClosing();
        }
        if (this.timeLineSplitPane != null) {
            this.layoutManager.setPreference("LayoutManager.SplitPaneDividerLocation", this.timeLineSplitPane.getDividerLocation(), this.viewerManager.getTranscription());
        }
        if (this.wav_tsSplitPane != null) {
            this.layoutManager.setPreference("LayoutManager.TSWavSplitPaneDividerLocation", this.wav_tsSplitPane.getDividerLocation(), this.viewerManager.getTranscription());
        }
    }

    private void createSubtitleViewer() {
        SubtitleViewer subtitleViewer;
        int numSubtitles = 4;
        Integer val = Preferences.getInt("NumberOfSubtitleViewers", null);
        if (val instanceof Integer) {
            numSubtitles = val;
        }
        for (int i = 0; i < numSubtitles && (subtitleViewer = this.viewerManager.createSubtitleViewer()) != null; ++i) {
            subtitleViewer.setViewerIndex(i + 1);
            subtitleViewer.setKeyStrokesNotToBeConsumed(this.ksNotToBeConsumed);
            this.add(subtitleViewer);
        }
    }

    @Override
    public void initComponents() {
        this.controlPanel = new JPanel();
        this.controlPanel.setName(ElanLocale.getString("Tab.Controls"));
        this.controlPanel.setLayout(new GridBagLayout());
        this.controlPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.vertMediaResizer = new ResizeComponent(this.layoutManager, 1);
        this.vertMediaResizer.setBorder(new SoftBevelBorder(0));
        this.vertMediaResizer.setPreferredSize(new Dimension(this.container.getWidth(), 7));
        Component n = this.vertMediaResizer.getComponent(0);
        this.vertMediaResizer.remove(n);
        this.vertMediaResizer.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        this.vertMediaResizer.add(n, gbc);
        this.container.add(this.vertMediaResizer);
        Boolean val = Preferences.getBool("Media.VideosCentre", null);
        if (val != null) {
            this.mediaInCentre = val;
        }
        this.ksNotToBeConsumed = new ArrayList<KeyStroke>();
        this.loadKSNottoBeConsumed();
        this.viewerManager.getMultiTierControlPanel().preferencesChanged();
        this.layoutManager.add(this.viewerManager.getMediaPlayerController());
        this.viewerManager.getMediaPlayerController().preferencesChanged();
        TimeLineViewer timeLineViewer = this.viewerManager.createTimeLineViewer();
        this.add(timeLineViewer);
        this.timeLineViewer.setKeyStrokesNotToBeConsumed(this.ksNotToBeConsumed);
        this.createAndAddViewer("Menu.View.Viewers.InterLinear");
        String conViewerName = Preferences.getString("LayoutManager.VisibleMultiTierViewer", this.viewerManager.getTranscription());
        if (conViewerName == null) {
            this.showTimeLineViewer();
            this.viewerManager.getMultiTierControlPanel().disableShowInterlinearViewer(true);
        } else if (conViewerName.equals(TimeLineViewer.class.getName())) {
            if (timeLineViewer != null) {
                this.showTimeLineViewer();
                this.multiTierControlPanel.setViewer(timeLineViewer);
            }
        } else if (conViewerName.equals(InterlinearViewer.class.getName()) && this.interlinearViewer != null) {
            this.showInterlinearViewer();
            this.getMultiTierControlPanel().setViewer(this.interlinearViewer);
        }
        this.createAndAddViewer("Menu.View.Viewers.Grid");
        this.createAndAddViewer("Menu.View.Viewers.Text");
        this.createAndAddViewer("Menu.View.Viewers.Subtitles");
        this.createAndAddViewer("LexiconEntryViewer.Lexicon");
        this.createAndAddViewer("CommentViewer.Comment");
        this.createAndAddViewer("Menu.View.Viewers.Signal");
        this.createAndAddViewer("Menu.View.Viewers.Recognizer");
        this.createAndAddViewer("Menu.View.Viewers.MetaData");
        this.layoutManager.add(this.layoutManager.getTimeSeriesViewer());
        timeLineViewer.requestFocus();
        this.preferencesChanged();
    }

    @Override
    public void preferencesChanged() {
        Boolean boolPref;
        List<String> los;
        Boolean sameSize;
        Integer sigHeight;
        String conViewerName;
        Integer selIndex = Preferences.getInt("LayoutManager.SelectedTabIndex", this.viewerManager.getTranscription());
        if (selIndex != null) {
            int index = selIndex;
            if (index >= 0 && index < this.tabPane.getTabCount()) {
                this.tabPane.setSelectedIndex(index);
            } else {
                this.tabPane.setSelectedIndex(0);
            }
        }
        if ((conViewerName = Preferences.getString("LayoutManager.VisibleMultiTierViewer", this.viewerManager.getTranscription())) != null && conViewerName.equals(TimeLineViewer.class.getName())) {
            if (this.timeLineViewer != null) {
                this.showTimeLineViewer();
                this.getMultiTierControlPanel().setViewer(this.timeLineViewer);
            }
        } else if (conViewerName != null && conViewerName.equals(InterlinearViewer.class.getName()) && this.interlinearViewer != null) {
            this.showInterlinearViewer();
            this.getMultiTierControlPanel().setViewer(this.interlinearViewer);
        }
        if ((sigHeight = Preferences.getInt("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription())) != null && sigHeight > 70 && (this.signalViewer != null || this.timeseriesViewer != null) && this.timeLineSplitPane != null) {
            this.timeLineSplitPane.setDividerLocation(sigHeight);
        }
        if ((sigHeight = Preferences.getInt("LayoutManager.TSWavSplitPaneDividerLocation", this.viewerManager.getTranscription())) != null && this.wav_tsSplitPane != null) {
            this.wav_tsSplitPane.setDividerLocation(sigHeight);
        }
        if (this.tabPane != null) {
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                String tierName;
                SingleTierViewerPanel panel;
                JComponent comp = (JComponent)this.tabPane.getComponent(i);
                if (comp instanceof SingleTierViewerPanel) {
                    String tierName2;
                    panel = (SingleTierViewerPanel)comp;
                    if (panel.getViewer() instanceof GridViewer) {
                        Boolean multiGrid = Preferences.getBool("GridViewer.MultiTierMode", this.viewerManager.getTranscription());
                        if (multiGrid != null && multiGrid.booleanValue()) {
                            Boolean mtmSubdivision = Preferences.getBool("GridViewer.MultiTierMode.Subdivision", this.viewerManager.getTranscription());
                            if (mtmSubdivision == null || !mtmSubdivision.booleanValue()) {
                                panel.setTierMode(1);
                                ((GridViewer)panel.getViewer()).setModeFromPref(1);
                            } else {
                                panel.setTierMode(2);
                                ((GridViewer)panel.getViewer()).setModeFromPref(2);
                            }
                        } else {
                            ((GridViewer)panel.getViewer()).setModeFromPref(0);
                        }
                        tierName = Preferences.getString("GridViewer.TierName", this.viewerManager.getTranscription());
                        if (tierName == null) continue;
                        panel.selectTier(tierName);
                        continue;
                    }
                    if (!(panel.getViewer() instanceof TextViewer) || (tierName2 = Preferences.getString("TextViewer.TierName", this.viewerManager.getTranscription())) == null) continue;
                    panel.selectTier(tierName2);
                    continue;
                }
                if (comp != this.subtitlePanel) continue;
                Component[] subComps = comp.getComponents();
                int index = 0;
                for (Component subComp : subComps) {
                    if (!(subComp instanceof SingleTierViewerPanel) || !((panel = (SingleTierViewerPanel)subComp).getViewer() instanceof SubtitleViewer) || (tierName = Preferences.getString("SubTitleViewer.TierName-" + (index = ((SubtitleViewer)panel.getViewer()).getViewerIndex()), this.viewerManager.getTranscription())) == null) continue;
                    panel.selectTier(tierName);
                }
            }
        }
        if ((sameSize = Preferences.getBool("Media.VideosSameSize", null)) != null) {
            this.oneRowForVisuals = sameSize;
        }
        if ((los = Preferences.getListOfString("PreferencesDialog.Viewer.SortOrder", null)) != null) {
            this.viewerSortOrder = los;
        }
        if ((boolPref = Preferences.getBool("Media.VideosCentre", null)) != null) {
            this.mediaInCentre = boolPref;
        }
        if (this.mediaInCentre) {
            boolPref = Preferences.getBool("PreferencesDialog.Viewer.Grid.Right", null);
            if (boolPref != null) {
                boolean bl = this.gridViewerLeft = boolPref == false;
            }
            if ((boolPref = Preferences.getBool("PreferencesDialog.Viewer.Text.Right", null)) != null) {
                boolean bl = this.textViewerLeft = boolPref == false;
            }
            if ((boolPref = Preferences.getBool("PreferencesDialog.Viewer.Subtitle.Right", null)) != null) {
                boolean bl = this.subtitleViewerLeft = boolPref == false;
            }
            if ((boolPref = Preferences.getBool("PreferencesDialog.Viewer.Lexicon.Right", null)) != null) {
                boolean bl = this.lexiconViewerLeft = boolPref == false;
            }
            if ((boolPref = Preferences.getBool("PreferencesDialog.Viewer.Comment.Right", null)) != null) {
                boolean bl = this.commentViewerLeft = boolPref == false;
            }
            if ((boolPref = Preferences.getBool("PreferencesDialog.Viewer.Audio.Right", null)) != null) {
                boolean bl = this.recognizerLeft = boolPref == false;
            }
            if ((boolPref = Preferences.getBool("PreferencesDialog.Viewer.MetaData.Right", null)) != null) {
                this.metaDataLeft = boolPref == false;
            }
        }
        this.preferenceChanged = true;
    }

    @Override
    public void enableOrDisableMenus(boolean enabled) {
    }

    private void loadKSNottoBeConsumed() {
        this.ksNotToBeConsumed.clear();
        ShortcutsUtil scu = ShortcutsUtil.getInstance();
        KeyStroke ks = null;
        String modeName = "Menu.Options.AnnotationMode";
        ks = scu.getKeyStrokeForAction("Menu.Play.PlaySelection", modeName);
        if (ks != null) {
            this.ksNotToBeConsumed.add(ks);
        }
        if ((ks = scu.getKeyStrokeForAction("CommandActions.PlayAroundSelection", modeName)) != null) {
            this.ksNotToBeConsumed.add(ks);
        }
        if ((ks = scu.getKeyStrokeForAction("Menu.Play.ToggleCrosshairInSelection", modeName)) != null) {
            this.ksNotToBeConsumed.add(ks);
        }
        if ((ks = scu.getKeyStrokeForAction("Menu.Play.MoveCrosshairToCenterOfSelection", modeName)) != null) {
            this.ksNotToBeConsumed.add(ks);
        }
        if ((ks = scu.getKeyStrokeForAction("TimeLineViewer.CenterSelection", modeName)) != null) {
            this.ksNotToBeConsumed.add(ks);
        }
        if ((ks = scu.getKeyStrokeForAction("CommandActions.LoopMode", modeName)) != null) {
            this.ksNotToBeConsumed.add(ks);
        }
    }

    @Override
    public void shortcutsChanged() {
        this.loadKSNottoBeConsumed();
        if (this.timeLineViewer != null) {
            this.timeLineViewer.setKeyStrokesNotToBeConsumed(this.ksNotToBeConsumed);
        }
        if (this.viewerManager.getGridViewer() != null) {
            this.viewerManager.getGridViewer().setKeyStrokesNotToBeConsumed(this.ksNotToBeConsumed);
        }
        List<SubtitleViewer> sViewers = this.viewerManager.getSubtitleViewers();
        for (SubtitleViewer v : sViewers) {
            if (v == null) continue;
            v.setKeyStrokesNotToBeConsumed(this.ksNotToBeConsumed);
        }
        if (this.interlinearViewer != null) {
            this.interlinearViewer.setKeyStrokesNotToBeConsumed(this.ksNotToBeConsumed);
        }
    }

    @Override
    public List<Zoomable> getZoomableViewers() {
        ArrayList<Zoomable> zoomList = new ArrayList<Zoomable>(6);
        if (this.timeLineViewer != null) {
            zoomList.add(this.timeLineViewer);
        }
        if (this.signalViewer != null) {
            zoomList.add(this.signalViewer);
        }
        if (this.timeseriesViewer != null) {
            zoomList.add(this.timeseriesViewer);
        }
        if (this.interlinearViewer != null) {
            // empty if block
        }
        return zoomList;
    }
}

