/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.Zoomable;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.interlinear.edit.InterlinearEditor;
import mpi.eudico.client.annotator.interlinear.edit.PotentialTiers;
import mpi.eudico.client.annotator.interlinear.edit.TextAnalyzerHostContext;
import mpi.eudico.client.annotator.interlinear.edit.TextAnalyzerLexiconHostContext;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTAddToLexiconAction;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTCreateDependentAnnotationsAction;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTDeleteAction;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTInterlinearizeAction;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTNavigateAction;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTSplitAnnotationAction;
import mpi.eudico.client.annotator.interlinear.edit.actions.IGTStartEditAction;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerConfig;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerConfigPanel;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerSettingsPanel;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerTypeConfig;
import mpi.eudico.client.annotator.layout.ModeLayoutManager;
import mpi.eudico.client.annotator.layout.PlayerLayoutModel;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.NeedsCreateNewVisualComponent;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChangeListener;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChanger;
import nl.mpi.lexan.analyzers.helpers.Information;
import nl.mpi.lexiconcomponent.gui.ElanLexRootPanel;
import nl.mpi.lexiconcomponent.gui.LexiconGuiResources;

public class InterlinearizationManager
implements ModeLayoutManager,
ConfigurationChangeListener {
    private static final String SEPARATOR = "/,/";
    private ViewerManager2 viewerManager;
    private ElanLayoutManager layoutManager;
    private Container container;
    int origMediaAreaWidth = 352;
    int origMediaAreaHeight = 250;
    private JSplitPane leftRightSplit;
    private JSplitPane rightTopBottomSplit;
    private JSplitPane leftTopBottomSplit;
    private AnalyzerSettingsPanel topLeftPanel;
    private AnalyzerConfigPanel topRightPanel;
    private InterlinearEditor interPanel;
    private ElanLexRootPanel lexiconPanel;
    private TextAnalyzerHostContext analyzerHostContext;
    private TextAnalyzerLexiconHostContext lexiconHostContext;
    private boolean initialLoadPerformed = false;
    private List<KeyStroke> ksNotToBeConsumed;
    private List<AbstractAction> modeActions;
    private final String INTER_CONFIG_KEY = "InterlinearizationConfigurations";
    private final String INTER_CONFIG_EXCLUDED_KEY = "InterlinearizationConfigurations.ExcludedTierConfigurations";
    private final String INTER_LEXICON_PANEL_KEY = "InterlinearizationMode.LexiconPanelPrefs";
    private final String INTER_LR_SPLIT_KEY = "InterlinearizationMode.LeftRightSplit";
    private final String INTER_LTB_SPLIT_KEY = "InterlinearizationMode.LeftTopBottomSplit";
    private final String INTER_RTB_SPLIT_KEY = "InterlinearizationMode.RightTopBottomSplit";

    public InterlinearizationManager(ViewerManager2 viewerManager, ElanLayoutManager elanLayoutManager) {
        this.viewerManager = viewerManager;
        this.layoutManager = elanLayoutManager;
        this.lexiconHostContext = new TextAnalyzerLexiconHostContext(this);
        this.analyzerHostContext = new TextAnalyzerHostContext(this);
        this.container = this.layoutManager.getContainer();
        this.topLeftPanel = new AnalyzerSettingsPanel(this.analyzerHostContext);
        LexiconGuiResources.setLanguageBundle((ResourceBundle)ElanLocale.getResourceBundle());
        this.lexiconPanel = new ElanLexRootPanel(this.lexiconHostContext.getLexiconFolder().getAbsolutePath(), this.lexiconHostContext.getDefaultLexiconName(), true);
        this.topRightPanel = new AnalyzerConfigPanel(this);
        this.interPanel = new InterlinearEditor(this);
        this.interPanel.setViewerManager(viewerManager);
        viewerManager.connectViewer(this.interPanel, true);
        this.preferencesChanged();
    }

    public TextAnalyzerHostContext getTextAnalyzerContext() {
        return this.analyzerHostContext;
    }

    public TextAnalyzerLexiconHostContext getTextAnalyzerLexiconContext() {
        return this.lexiconHostContext;
    }

    public Transcription getTranscription() {
        return this.viewerManager.getTranscription();
    }

    public ViewerManager2 getViewerManager() {
        return this.viewerManager;
    }

    public InterlinearEditor getInterEditor() {
        return this.interPanel;
    }

    public AnalyzerConfigPanel getConfigPanel() {
        return this.topRightPanel;
    }

    public ElanLexRootPanel getLexiconPanel() {
        return this.lexiconPanel;
    }

    @Override
    public void add(Object object) {
    }

    @Override
    public void remove(Object object) {
    }

    @Override
    public void doLayout() {
        int containerWidth = this.container.getWidth();
        int containerHeight = this.container.getHeight();
        this.leftRightSplit.setBounds(0, 0, containerWidth, containerHeight);
        this.leftRightSplit.validate();
    }

    @Override
    public void updateLocale() {
        this.topRightPanel.updateLocale();
        LexiconGuiResources.setLanguageBundle((ResourceBundle)ElanLocale.getResourceBundle());
        this.lexiconPanel.updateLocale();
    }

    @Override
    public void clearLayout() {
        ArrayList<AnalyzerConfig> toRemove = new ArrayList<AnalyzerConfig>(this.getTextAnalyzerContext().getConfigurations());
        for (AnalyzerConfig config : toRemove) {
            this.getTextAnalyzerContext().removeConfig(config);
        }
        this.viewerManager.connectViewer(this.interPanel, false);
        this.viewerManager.getTranscription().removeACMEditListener(this.interPanel);
        this.container.remove(this.leftRightSplit);
        this.layoutManager.setMediaAreaWidth(this.origMediaAreaWidth);
        this.layoutManager.setMediaAreaHeight(this.origMediaAreaHeight);
        ElanMediaPlayer masterPlayer = this.viewerManager.getMasterMediaPlayer();
        List<PlayerLayoutModel> players = this.layoutManager.getPlayerList();
        for (PlayerLayoutModel model : players) {
            if (model.player == masterPlayer || !model.isVisual() || !model.isAttached()) continue;
            if (model.player instanceof NeedsCreateNewVisualComponent) {
                model.visualComponent.setVisible(true);
                continue;
            }
            this.container.add(model.visualComponent);
        }
        this.container.repaint();
    }

    private void storePreferences() {
        this.storeGUIPreferences();
        Transcription transcription = this.viewerManager.getTranscription();
        if (this.analyzerHostContext != null && this.analyzerHostContext.getConfigurations() != null) {
            ArrayList<Object> confList = new ArrayList<Object>();
            HashMap excludedTierMap = new HashMap();
            for (AnalyzerConfig ac : this.analyzerHostContext.getConfigurations()) {
                Object config = ac.getAnnotId().getName() + SEPARATOR + ac.getSource() + SEPARATOR;
                for (String dest : ac.getDest()) {
                    config = ((String)config).concat(dest + SEPARATOR);
                }
                config = ((String)config).concat(Boolean.toString(ac.isTypeMode()));
                confList.add(config);
                if (!ac.isTypeMode()) continue;
                ArrayList<String> excludedSourceList = new ArrayList<String>();
                List<? extends Tier> sourceTiers = transcription.getTiersWithLinguisticType(ac.getSource());
                for (Tier tier : sourceTiers) {
                    excludedSourceList.add(tier.getName());
                }
                for (AnalyzerConfig analyzerConfig : ((AnalyzerTypeConfig)ac).getTierConfigurations()) {
                    excludedSourceList.remove(analyzerConfig.getSource());
                }
                excludedTierMap.put(config, excludedSourceList);
            }
            Preferences.set("InterlinearizationConfigurations", confList, transcription, false, false);
            Preferences.set("InterlinearizationConfigurations.ExcludedTierConfigurations", excludedTierMap, transcription, false, false);
        }
        this.topLeftPanel.storePreferences();
        Map lexPanelPrefs = this.lexiconPanel.getUserPreferences();
        if (lexPanelPrefs != null) {
            Preferences.set("InterlinearizationMode.LexiconPanelPrefs", lexPanelPrefs, transcription);
        }
    }

    private void readPreferences() {
        Map<String, ?> lexPanelPrefs;
        if (this.initialLoadPerformed) {
            return;
        }
        Transcription transcription = this.viewerManager.getTranscription();
        List<String> confObj = Preferences.getListOfString("InterlinearizationConfigurations", transcription);
        Map<String, ?> excludedObj = Preferences.getMap("InterlinearizationConfigurations.ExcludedTierConfigurations", transcription);
        Map<Object, Object> excludedTiersMap = new HashMap();
        excludedTiersMap = excludedObj != null ? excludedObj : new HashMap();
        List<Information> analyzers = this.analyzerHostContext.listTextAnalyzersInfo();
        if (confObj != null && analyzers != null) {
            List<String> storedConfigs = confObj;
            for (String item : storedConfigs) {
                if (!(item instanceof String)) continue;
                String conf = item;
                List excludedTiers = (List)excludedTiersMap.get(conf);
                String[] tokens = conf.split(SEPARATOR);
                if (tokens.length < 4) continue;
                ArrayList<String> destList = new ArrayList<String>();
                Information info = null;
                String name = tokens[0];
                for (Information in : analyzers) {
                    if (!name.equals(in.getName())) continue;
                    info = in;
                    break;
                }
                if (info == null) continue;
                String source = tokens[1];
                for (int i = 2; i < tokens.length - 1; ++i) {
                    destList.add(tokens[i]);
                }
                if (tokens[tokens.length - 1].equals(Boolean.toString(true))) {
                    AnalyzerTypeConfig atc = new AnalyzerTypeConfig(info, source, destList);
                    this.fillWithTierConfigs(info, atc, excludedTiers);
                    this.analyzerHostContext.addConfig(atc);
                    continue;
                }
                if (transcription.getTierWithId(source) == null) continue;
                for (String dest : destList) {
                    if (transcription.getTierWithId(dest) != null) continue;
                }
                AnalyzerConfig ac = new AnalyzerConfig(info, source, destList);
                this.analyzerHostContext.addConfig(ac);
            }
        }
        if ((lexPanelPrefs = Preferences.getMap("InterlinearizationMode.LexiconPanelPrefs", transcription)) != null && this.lexiconPanel != null) {
            this.lexiconPanel.setUserPreferences(lexPanelPrefs);
        }
        this.initialLoadPerformed = true;
        if (this.topRightPanel != null && !this.analyzerHostContext.getConfigurations().isEmpty()) {
            this.topRightPanel.configsChanged();
        }
    }

    private void storeGUIPreferences() {
        Transcription transcription = this.viewerManager.getTranscription();
        int value = this.leftRightSplit.getDividerLocation();
        double size = this.leftRightSplit.getWidth();
        Preferences.set("InterlinearizationMode.LeftRightSplit", new Double(size > 0.0 ? (double)value / size : 0.0), transcription, false, false);
        value = this.leftTopBottomSplit.getDividerLocation();
        size = this.leftTopBottomSplit.getHeight();
        Preferences.set("InterlinearizationMode.LeftTopBottomSplit", new Double(size > 0.0 ? (double)value / size : 0.0), transcription, false, false);
        value = this.rightTopBottomSplit.getDividerLocation();
        size = this.rightTopBottomSplit.getHeight();
        Preferences.set("InterlinearizationMode.RightTopBottomSplit", new Double(size > 0.0 ? (double)value / size : 0.0), transcription, false, false);
    }

    private void readGUIPreferences() {
        Double intObj;
        Transcription transcription = this.viewerManager.getTranscription();
        Dimension d = Preferences.getDimension("FrameSize", transcription);
        Dimension curFrameSize = this.layoutManager.getElanFrame().getSize();
        double hScale = 1.0;
        double vScale = 1.0;
        if (d != null && curFrameSize != null) {
            hScale = (double)d.width / (double)curFrameSize.width;
            vScale = (double)d.height / (double)curFrameSize.height;
        }
        if ((intObj = Preferences.getDouble("InterlinearizationMode.LeftRightSplit", transcription)) != null) {
            this.leftRightSplit.setDividerLocation(intObj * hScale);
        }
        if ((intObj = Preferences.getDouble("InterlinearizationMode.LeftTopBottomSplit", transcription)) != null) {
            this.leftTopBottomSplit.setDividerLocation(intObj * vScale);
        }
        if ((intObj = Preferences.getDouble("InterlinearizationMode.RightTopBottomSplit", transcription)) != null) {
            this.rightTopBottomSplit.setDividerLocation(intObj * vScale);
        }
    }

    private Map<String, List<String>> createTierMap() {
        HashMap<String, List<String>> tiersMap = new HashMap<String, List<String>>();
        List<TierImpl> list = ((TranscriptionImpl)this.getTranscription()).getTiers();
        ArrayList<String> allTierNames = new ArrayList<String>(list.size());
        for (TierImpl tier : list) {
            allTierNames.add(tier.getName());
            List<TierImpl> childList = tier.getChildTiers();
            if (childList == null || childList.isEmpty()) continue;
            ArrayList<String> childTierNamesList = new ArrayList<String>();
            for (TierImpl child : childList) {
                childTierNamesList.add(child.getName());
            }
            tiersMap.put(tier.getName(), childTierNamesList);
        }
        tiersMap.put("", allTierNames);
        if (ClientLogger.LOG.isLoggable(Level.FINER)) {
            ClientLogger.LOG.finer(String.format("createTierMap: %s", String.valueOf(tiersMap)));
        }
        return tiersMap;
    }

    public void fillWithTierConfigs(Information parameterInformation, AnalyzerTypeConfig atc, List<String> excludedTiers) {
        String sourceType = atc.getSource();
        Transcription transcription = this.viewerManager.getTranscription();
        List<? extends Tier> sourceTiers = transcription.getTiersWithLinguisticType(sourceType);
        if (sourceTiers == null) {
            if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                ClientLogger.LOG.finer(String.format("fillWithTierConfigs: source 0: no tiers available of type %s", sourceType));
            }
            return;
        }
        List params = parameterInformation.getParameters();
        PotentialTiers potentialTiers = new PotentialTiers(params);
        potentialTiers.setChildMap(this.createTierMap(), false);
        List<String> potentialSourceTiers = potentialTiers.getPotentialSourceNames(0, null);
        if (ClientLogger.LOG.isLoggable(Level.FINE)) {
            ClientLogger.LOG.fine(String.format("fillWithTierConfigs: source 0: %s, excluded %s", String.valueOf(potentialSourceTiers), String.valueOf(excludedTiers)));
        }
        List<String> destTypeList = atc.getDest();
        for (Tier tier : sourceTiers) {
            int i;
            String sourceTierName = tier.getName();
            if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                ClientLogger.LOG.finer(String.format("fillWithTierConfigs: considering typed tier %s", sourceTierName));
            }
            if (excludedTiers != null && excludedTiers.contains(sourceTierName)) {
                if (!ClientLogger.LOG.isLoggable(Level.FINER)) continue;
                ClientLogger.LOG.finer(String.format("fillWithTierConfigs: reject tier %s: excluded", sourceTierName));
                continue;
            }
            if (!potentialSourceTiers.contains(sourceTierName)) {
                if (!ClientLogger.LOG.isLoggable(Level.FINER)) continue;
                ClientLogger.LOG.finer(String.format("fillWithTierConfigs: reject tier %s: not in potential source tiers", sourceTierName));
                continue;
            }
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine(String.format("fillWithTierConfigs: tier %s: ok so far", sourceTierName));
            }
            ArrayList<String> destTierList = new ArrayList<String>();
            int numDests = destTypeList.size();
            boolean numSources = true;
            assert (numDests == potentialTiers.getNumberOfTargetTiers());
            potentialTiers.setTierName(0, sourceTierName);
            for (i = 0; i < numDests; ++i) {
                potentialTiers.setTierName(1 + i, "");
            }
            for (i = 0; i < numDests; ++i) {
                boolean foundTier = false;
                List<String> potentialTargets = potentialTiers.getPotentialTargetNames(1 + i);
                if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                    ClientLogger.LOG.finer(String.format("fillWithTierConfigs: dest %d: getPotentialTargetNames() => %s", i, String.valueOf(potentialTargets)));
                }
                for (String tierName : potentialTargets) {
                    Tier tier2 = transcription.getTierWithId(tierName);
                    if (tier2.getLinguisticType().getLinguisticTypeName().equals(destTypeList.get(i))) {
                        if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                            ClientLogger.LOG.finer(String.format("fillWithTierConfigs: dest %d: tier %s is of correct type %s", i, tierName, destTypeList.get(i)));
                        }
                        destTierList.add(tierName);
                        potentialTiers.setTierName(1 + i, tierName);
                        foundTier = true;
                        break;
                    }
                    if (!ClientLogger.LOG.isLoggable(Level.FINER)) continue;
                    ClientLogger.LOG.finer(String.format("fillWithTierConfigs: dest %d: tier %s is of wrong type %s (required %s)", i, tierName, tier2.getLinguisticType().getLinguisticTypeName(), destTypeList.get(i)));
                }
                if (!foundTier) break;
            }
            if (ClientLogger.LOG.isLoggable(Level.FINER)) {
                ClientLogger.LOG.finer(String.format("fillWithTierConfigs: destTierList: %s)", String.valueOf(destTierList)));
                ClientLogger.LOG.finer(String.format("fillWithTierConfigs: have %d (required %d)", destTierList.size(), numDests));
            }
            if (destTierList.size() != numDests) continue;
            AnalyzerConfig ac = new AnalyzerConfig(atc.getAnnotId(), sourceTierName, destTierList);
            atc.addTierConf(ac);
        }
    }

    @Override
    public void initComponents() {
        this.origMediaAreaWidth = this.layoutManager.getMediaAreaWidth();
        this.origMediaAreaHeight = this.layoutManager.getMediaAreaHeight();
        List<PlayerLayoutModel> players = this.layoutManager.getPlayerList();
        ElanMediaPlayer masterPlayer = this.viewerManager.getMasterMediaPlayer();
        for (PlayerLayoutModel model : players) {
            if (!model.isVisual() || !model.isAttached()) continue;
            if (model.player != masterPlayer) {
                if (model.player instanceof NeedsCreateNewVisualComponent) {
                    model.visualComponent.setVisible(false);
                    continue;
                }
                this.container.remove(model.visualComponent);
                continue;
            }
            model.visualComponent.setBounds(0, 0, 1, 1);
        }
        this.leftTopBottomSplit = new JSplitPane(0);
        this.leftTopBottomSplit.setOneTouchExpandable(true);
        this.leftTopBottomSplit.setTopComponent(this.topLeftPanel);
        this.leftTopBottomSplit.setBottomComponent((Component)this.lexiconPanel);
        this.rightTopBottomSplit = new JSplitPane(0);
        this.rightTopBottomSplit.setOneTouchExpandable(true);
        this.rightTopBottomSplit.setTopComponent(this.topRightPanel);
        this.rightTopBottomSplit.setBottomComponent(this.interPanel);
        this.leftRightSplit = new JSplitPane(1);
        this.leftRightSplit.setOneTouchExpandable(true);
        this.leftRightSplit.setLeftComponent(this.leftTopBottomSplit);
        this.leftRightSplit.setRightComponent(this.rightTopBottomSplit);
        this.container.add(this.leftRightSplit);
        this.doLayout();
        this.readGUIPreferences();
    }

    @Override
    public void enableOrDisableMenus(boolean enabled) {
        ((ElanFrame2)this.layoutManager.getElanFrame()).enableOrDisableMenus(null, 200, enabled);
        ArrayList<String> viewSubMenus = new ArrayList<String>(3);
        viewSubMenus.add(ElanLocale.getString("Menu.View.MediaPlayer"));
        viewSubMenus.add(ElanLocale.getString("Menu.View.Waveform"));
        viewSubMenus.add(ElanLocale.getString("Menu.View.Viewers"));
        ((ElanFrame2)this.layoutManager.getElanFrame()).enableOrDisableMenus(viewSubMenus, 600, enabled);
        ArrayList<String> optionsSubMenus = new ArrayList<String>(3);
        optionsSubMenus.add(ElanLocale.getString("Menu.Options.PlayAroundSelectionDialog"));
        optionsSubMenus.add(ElanLocale.getString("Menu.Options.PlaybackToggleDialog"));
        optionsSubMenus.add(ElanLocale.getString("Menu.Options.FrameLength"));
        ((ElanFrame2)this.layoutManager.getElanFrame()).enableOrDisableMenus(optionsSubMenus, 700, enabled);
        ArrayList<String> seachSubMenus = new ArrayList<String>(2);
        seachSubMenus.add(ElanLocale.getString("Menu.Search.GoTo"));
        ((ElanFrame2)this.layoutManager.getElanFrame()).enableOrDisableMenus(seachSubMenus, 500, enabled);
        ArrayList<String> editSubMenus = new ArrayList<String>(2);
        editSubMenus.add(ElanLocale.getString("CommandActions.CopyCurrentTime"));
        editSubMenus.add(ElanLocale.getString("Menu.Edit.LinkedFiles"));
        ((ElanFrame2)this.layoutManager.getElanFrame()).enableOrDisableMenus(editSubMenus, 100, enabled);
        this.enableAction(ELANCommandFactory.getCommandAction(this.viewerManager.getTranscription(), "CommandActions.PreviousAnnotation"), enabled);
        this.enableAction(ELANCommandFactory.getCommandAction(this.viewerManager.getTranscription(), "CommandActions.NextAnnotation"), enabled);
        this.enableAction(ELANCommandFactory.getCommandAction(this.viewerManager.getTranscription(), "CommandActions.AnnotationUp"), enabled);
        this.enableAction(ELANCommandFactory.getCommandAction(this.viewerManager.getTranscription(), "CommandActions.AnnotationDown"), enabled);
        this.enableAction(ELANCommandFactory.getCommandAction(this.viewerManager.getTranscription(), "CommandActions.OpenInlineEditBox"), enabled);
    }

    private void enableAction(Action action, boolean enable) {
        if (action != null) {
            action.setEnabled(enable);
        }
    }

    @Override
    public void detach(Object object) {
    }

    @Override
    public void attach(Object object) {
    }

    @Override
    public void preferencesChanged() {
        this.readPreferences();
    }

    @Override
    public void cleanUpOnClose() {
        this.clearLayout();
    }

    @Override
    public void shortcutsChanged() {
        this.ksNotToBeConsumed = new ArrayList<KeyStroke>(10);
        this.addModeActions();
        JRootPane rootPane = SwingUtilities.getRootPane(this.interPanel);
        InputMap imap = rootPane.getInputMap(2);
        ShortcutsUtil su = ShortcutsUtil.getInstance();
        imap.put(su.getKeyStrokeForAction("CommandActions.PreviousAnnotation", "Menu.Options.InterlinearizationMode"), "CommandActions.PreviousAnnotation");
        imap.put(su.getKeyStrokeForAction("CommandActions.NextAnnotation", "Menu.Options.InterlinearizationMode"), "CommandActions.NextAnnotation");
        imap.put(su.getKeyStrokeForAction("CommandActions.AnnotationUp", "Menu.Options.InterlinearizationMode"), "CommandActions.AnnotationUp");
        imap.put(su.getKeyStrokeForAction("CommandActions.AnnotationDown", "Menu.Options.InterlinearizationMode"), "CommandActions.AnnotationDown");
        imap.put(su.getKeyStrokeForAction("Menu.Annotation.DeleteAnnotation", "Menu.Options.InterlinearizationMode"), "Menu.Annotation.DeleteAnnotation");
        imap.put(su.getKeyStrokeForAction("Menu.Annotation.CreateDependingAnnotations", "Menu.Options.InterlinearizationMode"), "Menu.Annotation.CreateDependingAnnotations");
        imap.put(su.getKeyStrokeForAction("Menu.Annotation.SplitAnnotation", "Menu.Options.InterlinearizationMode"), "Menu.Annotation.SplitAnnotation");
        imap.put(su.getKeyStrokeForAction("Menu.Annotation.NewAnnotationBefore", "Menu.Options.InterlinearizationMode"), "Menu.Annotation.NewAnnotationBefore");
        imap.put(su.getKeyStrokeForAction("Menu.Annotation.NewAnnotationAfter", "Menu.Options.InterlinearizationMode"), "Menu.Annotation.NewAnnotationAfter");
        imap.put(su.getKeyStrokeForAction("Menu.Annotation.Analyze", "Menu.Options.InterlinearizationMode"), "Menu.Annotation.Analyze");
        imap.put(su.getKeyStrokeForAction("Menu.Annotation.AddToLexicon", "Menu.Options.InterlinearizationMode"), "Menu.Annotation.AddToLexicon");
        imap.put(su.getKeyStrokeForAction("CommandActions.OpenInlineEditBox", "Menu.Options.InterlinearizationMode"), "CommandActions.OpenInlineEditBox");
        KeyStroke ks = null;
        ks = su.getKeyStrokeForAction("Menu.Play.PlaySelection", "Menu.Options.InterlinearizationMode");
        if (ks != null) {
            this.ksNotToBeConsumed.add(ks);
        }
        this.interPanel.setKeyStrokesNotToBeConsumed(this.ksNotToBeConsumed);
    }

    private void addModeActions() {
        if (this.modeActions == null) {
            this.modeActions = new ArrayList<AbstractAction>(20);
            this.modeActions.add(new IGTNavigateAction(this.interPanel, "CommandActions.PreviousAnnotation", IGTNavigateAction.Direction.LEFT));
            this.modeActions.add(new IGTNavigateAction(this.interPanel, "CommandActions.NextAnnotation", IGTNavigateAction.Direction.RIGHT));
            this.modeActions.add(new IGTNavigateAction(this.interPanel, "CommandActions.AnnotationUp", IGTNavigateAction.Direction.UP));
            this.modeActions.add(new IGTNavigateAction(this.interPanel, "CommandActions.AnnotationDown", IGTNavigateAction.Direction.DOWN));
            this.modeActions.add(new IGTDeleteAction(null, this.analyzerHostContext, "Menu.Annotation.DeleteAnnotation"));
            this.modeActions.add(new IGTCreateDependentAnnotationsAction(null, this.analyzerHostContext, "Menu.Annotation.CreateDependingAnnotations"));
            this.modeActions.add(new IGTSplitAnnotationAction(null, this.analyzerHostContext, 0, "Menu.Annotation.SplitAnnotation"));
            this.modeActions.add(new IGTSplitAnnotationAction(null, this.analyzerHostContext, 1, "Menu.Annotation.NewAnnotationBefore"));
            this.modeActions.add(new IGTSplitAnnotationAction(null, this.analyzerHostContext, 2, "Menu.Annotation.NewAnnotationAfter"));
            this.modeActions.add(new IGTInterlinearizeAction(null, this.analyzerHostContext, "Menu.Annotation.Analyze"));
            this.modeActions.add(new IGTAddToLexiconAction(null, this.lexiconHostContext, "Menu.Annotation.AddToLexicon"));
            this.modeActions.add(new IGTStartEditAction(this.interPanel, "CommandActions.OpenInlineEditBox"));
        }
        ActionMap amap = SwingUtilities.getRootPane(this.interPanel).getActionMap();
        for (AbstractAction aa : this.modeActions) {
            amap.put(aa.getValue("Name"), aa);
        }
    }

    @Override
    public void createAndAddViewer(String viewerName) {
    }

    @Override
    public boolean destroyAndRemoveViewer(String viewerName) {
        return false;
    }

    @Override
    public void isClosing() {
        this.storePreferences();
        this.interPanel.isClosing();
        this.lexiconPanel.isClosing();
    }

    @Override
    public List<Zoomable> getZoomableViewers() {
        ArrayList<Zoomable> zoomList = new ArrayList<Zoomable>(1);
        if (this.interPanel != null && this.interPanel.getZoomable() != null) {
            zoomList.add(this.interPanel.getZoomable());
        }
        return zoomList;
    }

    public void configurationChanged(ConfigurationChanger panel) {
    }
}

