/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.layout.PlayerLayoutModel;
import mpi.eudico.client.annotator.player.NeedsCreateNewVisualComponent;

public class VideoLayoutPanel
extends JPanel
implements ComponentListener {
    PlayerLayoutModel playerLoModel;

    public VideoLayoutPanel() {
        this.setLayout(null);
    }

    public void setPlayerLayoutModel(PlayerLayoutModel layoutModel) {
        this.playerLoModel = layoutModel;
        if (this.playerLoModel.isVisual()) {
            if (this.playerLoModel.player instanceof NeedsCreateNewVisualComponent) {
                Component visComponent;
                this.playerLoModel.visualComponent = visComponent = ((NeedsCreateNewVisualComponent)((Object)this.playerLoModel.player)).createNewVisualComponent();
            }
            this.add(this.playerLoModel.visualComponent);
            this.updateSizes();
        }
    }

    private void updateSizes() {
        if (this.playerLoModel != null) {
            float ratio = this.playerLoModel.player.getAspectRatio();
            int width = this.getWidth();
            int height = (int)((float)width / ratio);
            this.playerLoModel.visualComponent.setBounds(0, 0, width, height);
            this.setPreferredSize(new Dimension(width / 4, height));
            this.setMinimumSize(new Dimension(width / 4, height));
            this.revalidate();
        }
    }

    public void detach(PlayerLayoutModel layoutModel) {
        if (layoutModel == this.playerLoModel) {
            this.remove(this.playerLoModel.visualComponent);
            this.setPreferredSize(new Dimension(0, 0));
            this.setMinimumSize(new Dimension(0, 0));
            this.revalidate();
        }
    }

    public void attach(PlayerLayoutModel layoutModel) {
        if (layoutModel == this.playerLoModel && this.playerLoModel.isVisual()) {
            if (this.playerLoModel.player instanceof NeedsCreateNewVisualComponent) {
                Component visComponent;
                this.playerLoModel.visualComponent = visComponent = ((NeedsCreateNewVisualComponent)((Object)this.playerLoModel.player)).createNewVisualComponent();
            }
            this.add(this.playerLoModel.visualComponent);
            this.updateSizes();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateSizes();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.revalidate();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

