/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.layout;

import mpi.eudico.client.annotator.DetachedFrame;
import mpi.eudico.client.annotator.DetachedViewerFrame;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.viewer.AbstractViewer;

public class ViewerLayoutModel {
    public AbstractViewer viewer;
    private ElanLayoutManager layoutManager;
    private boolean attached;
    public DetachedFrame detachedFrame;

    public ViewerLayoutModel(AbstractViewer viewer, ElanLayoutManager layoutManager) {
        this.viewer = viewer;
        this.layoutManager = layoutManager;
        this.attached = true;
        this.detachedFrame = null;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void detach() {
        if (!this.attached) {
            return;
        }
        String title = this.viewer.getClass().getName();
        int index = title.lastIndexOf(46);
        if (index > 0) {
            title = title.substring(index + 1, title.length());
        }
        this.detachedFrame = new DetachedViewerFrame(this.layoutManager, this.viewer, title);
        this.detachedFrame.setSize(500, 300);
        this.detachedFrame.setVisible(true);
        this.viewer.preferencesChanged();
        this.attached = false;
    }

    public void attach() {
        if (this.attached || this.detachedFrame == null) {
            return;
        }
        this.detachedFrame.getContentPane().remove(this.viewer);
        this.detachedFrame.setVisible(false);
        this.detachedFrame.dispose();
        this.detachedFrame = null;
        this.attached = true;
    }
}

