/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.lexicon;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.lexicon.LexiconClientFactoryLoader;
import mpi.eudico.client.annotator.lexicon.LexiconLoginDialog;
import mpi.eudico.client.annotator.lexicon.lexcom.LexiconComponentClient;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.lexicon.LexicalEntryFieldIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClient;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientException;
import nl.mpi.lexiconcomponent.impl.LexiconContext;

public class LexiconQueryBundleDialog
extends ClosableDialog
implements ActionListener,
ListSelectionListener {
    private JLabel lexiconLinkLabel;
    private JComboBox lexiconLinkComboBox;
    private JTable lexiconEntryFieldTable;
    private JScrollPane entryFieldScroller;
    private JButton okButton;
    private JButton cancelButton;
    private TranscriptionImpl transcription;
    private LexiconQueryBundle2 oldQueryBundle;
    private boolean canceled;
    private String none;
    private HashMap<String, LexiconEntryTableModel> fieldLists;
    private JLabel titleLabel;
    private JPanel lexiconEntryFieldPanel;
    private Component parent;

    public LexiconQueryBundleDialog(Dialog dialog, boolean modal, Transcription trans) {
        block3: {
            super(dialog, modal);
            this.parent = dialog;
            this.transcription = (TranscriptionImpl)trans;
            if (!this.transcription.isLexiconServicesLoaded()) {
                try {
                    new LexiconClientFactoryLoader().loadLexiconClientFactories(this.transcription);
                }
                catch (Exception exc) {
                    if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block3;
                    ClientLogger.LOG.warning("Error while loading lexicon service clients: " + exc.getMessage());
                }
            }
        }
        this.fieldLists = new HashMap();
        this.canceled = true;
        this.initComponents();
        this.postInit();
    }

    public LexiconQueryBundleDialog(Dialog dialog, boolean modal, Transcription trans, LexiconQueryBundle2 queryBundle) {
        block3: {
            super(dialog, modal);
            this.parent = dialog;
            this.transcription = (TranscriptionImpl)trans;
            if (!this.transcription.isLexiconServicesLoaded()) {
                try {
                    new LexiconClientFactoryLoader().loadLexiconClientFactories(this.transcription);
                }
                catch (Exception exc) {
                    if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block3;
                    ClientLogger.LOG.warning("Error while loading lexicon service clients: " + exc.getMessage());
                }
            }
        }
        this.oldQueryBundle = queryBundle;
        this.fieldLists = new HashMap();
        this.canceled = true;
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LexiconQueryBundleDialog.this.closeDialog();
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                LexiconQueryBundleDialog.this.fillEntryFieldTable();
            }
        });
        this.titleLabel = new JLabel();
        this.lexiconLinkLabel = new JLabel();
        this.lexiconLinkComboBox = new JComboBox();
        this.lexiconLinkComboBox.addActionListener(this);
        this.lexiconEntryFieldPanel = new JPanel();
        this.lexiconEntryFieldPanel.setLayout(new GridBagLayout());
        this.lexiconEntryFieldPanel.setBorder(new TitledBorder(""));
        this.lexiconEntryFieldTable = new JTable();
        this.lexiconEntryFieldTable.setSelectionMode(0);
        this.lexiconEntryFieldTable.getSelectionModel().addListSelectionListener(this);
        this.entryFieldScroller = new JScrollPane(this.lexiconEntryFieldTable);
        this.okButton = new JButton();
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = new Insets(6, 6, 6, 6);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        c.fill = 2;
        c.anchor = 11;
        c.insets = insets;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.add((Component)this.titleLabel, c);
        c.fill = 0;
        c.insets = insets;
        c.anchor = 21;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        this.add((Component)this.lexiconLinkLabel, c);
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 1;
        this.add((Component)this.lexiconLinkComboBox, c);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.lexiconEntryFieldPanel.add((Component)this.entryFieldScroller, c);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        this.add((Component)this.lexiconEntryFieldPanel, c);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        c.insets = insets;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 15;
        this.add((Component)buttonPanel, c);
    }

    private void postInit() {
        this.updateLocale();
        this.fillLexiconLinkCombo();
        this.setLocationRelativeTo(this.getParent());
        this.updateButtons();
        this.pack();
        int w = 450;
        int h = 550;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.parent);
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("EditQueryBundle.Title"));
        this.titleLabel.setText(this.getTitle());
        this.lexiconLinkLabel.setText(ElanLocale.getString("EditQueryBundle.Label.Links"));
        this.lexiconEntryFieldPanel.setBorder(new TitledBorder(ElanLocale.getString("EditQueryBundle.Label.Entryfield")));
        this.okButton.setText(ElanLocale.getString("Button.OK"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        this.none = ElanLocale.getString("EditQueryBundle.None");
        if (this.lexiconLinkComboBox.getItemCount() > 0) {
            this.lexiconLinkComboBox.removeItemAt(0);
        }
        this.lexiconLinkComboBox.insertItemAt(this.none, 0);
    }

    private void updateButtons() {
        if (this.lexiconLinkComboBox.getSelectedIndex() > -1 && this.lexiconEntryFieldTable.getSelectedRow() > -1) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private void fillLexiconLinkCombo() {
        ArrayList lexiconLinks = new ArrayList(((HashMap)this.transcription.getLexiconLinks()).values());
        this.lexiconLinkComboBox.removeActionListener(this);
        this.lexiconLinkComboBox.removeAllItems();
        for (LexiconLink link : lexiconLinks) {
            this.lexiconLinkComboBox.addItem(link.getName());
        }
        this.addLexiconComponentLinks();
        if (this.oldQueryBundle != null) {
            String linkName = this.oldQueryBundle.getLinkName();
            for (int i = 0; i < this.lexiconLinkComboBox.getItemCount(); ++i) {
                if (!linkName.equals(this.lexiconLinkComboBox.getItemAt(i))) continue;
                this.lexiconLinkComboBox.setSelectedIndex(i);
                break;
            }
        } else if (this.lexiconLinkComboBox.getItemCount() > 0) {
            this.lexiconLinkComboBox.setSelectedIndex(0);
        } else {
            this.lexiconLinkComboBox.addItem(this.none);
        }
        this.lexiconLinkComboBox.addActionListener(this);
    }

    private void addLexiconComponentLinks() {
        String[] availabelLexs = LexiconContext.getInstance().getAvailableLexicons();
        if (availabelLexs.length > 0) {
            for (String lexName : availabelLexs) {
                boolean alreadyThere = false;
                for (int i = 0; i < this.lexiconLinkComboBox.getItemCount(); ++i) {
                    if (!lexName.equals(this.lexiconLinkComboBox.getItemAt(i))) continue;
                    alreadyThere = true;
                }
                if (alreadyThere) continue;
                this.lexiconLinkComboBox.addItem(lexName);
            }
        }
    }

    private void fillEntryFieldTable() {
        this.lexiconEntryFieldTable.setModel(new LexiconEntryTableModel());
        if (this.lexiconLinkComboBox.getSelectedIndex() >= 0) {
            if (this.lexiconLinkComboBox.getSelectedItem() == this.none) {
                return;
            }
            ArrayList lexiconLinks = new ArrayList(((HashMap)this.transcription.getLexiconLinks()).values());
            LexiconLink link = null;
            for (LexiconLink lnk2 : lexiconLinks) {
                if (!lnk2.getName().equals(this.lexiconLinkComboBox.getSelectedItem())) continue;
                link = lnk2;
                break;
            }
            boolean isLexiconComponentLexicon = false;
            if (link == null) {
                isLexiconComponentLexicon = this.fillEntryFieldTableLC(link, (String)this.lexiconLinkComboBox.getSelectedItem());
            } else if ("ELAN Lexicon Component".equals(link.getLexSrvcClntType())) {
                isLexiconComponentLexicon = this.fillEntryFieldTableLC(link, null);
            }
            if (isLexiconComponentLexicon) {
                return;
            }
            if (link == null || link.getSrvcClient() == null) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("LexiconLink.NoClient"), "Warning", 2);
            } else if (!this.fieldLists.containsKey(this.lexiconLinkComboBox.getSelectedItem())) {
                boolean tryGetFieldIds = true;
                while (tryGetFieldIds) {
                    try {
                        ArrayList<LexicalEntryFieldIdentification> fldIds = link.getSrvcClient().getLexicalEntryFieldIdentifications(link.getLexId());
                        Collections.sort(fldIds);
                        LexiconEntryTableModel tmpModel = new LexiconEntryTableModel();
                        for (LexicalEntryFieldIdentification fldId : fldIds) {
                            tmpModel.addRow(fldId);
                        }
                        this.lexiconEntryFieldTable.setModel(tmpModel);
                        this.fieldLists.put((String)this.lexiconLinkComboBox.getSelectedItem(), tmpModel);
                        tryGetFieldIds = false;
                    }
                    catch (LexiconServiceClientException e) {
                        if (e.getMessage().equals("No username or password") || e.getMessage().equals("Incorrect username or password")) {
                            LexiconLoginDialog loginDialog = new LexiconLoginDialog((Dialog)this, link);
                            loginDialog.setVisible(true);
                            if (!loginDialog.isCanceled()) continue;
                            tryGetFieldIds = false;
                            continue;
                        }
                        String title = ElanLocale.getString("LexiconLink.Action.Error");
                        String message = title + "\n" + ElanLocale.getString("LexiconServiceClientException.Cause") + " " + e.getMessageLocale();
                        JOptionPane.showMessageDialog(this, message, title, 0);
                        tryGetFieldIds = false;
                    }
                }
                if (this.oldQueryBundle != null) {
                    String fldIdName = this.oldQueryBundle.getFldId().getName();
                    for (int i = 0; i < this.lexiconEntryFieldTable.getModel().getRowCount(); ++i) {
                        if (!fldIdName.equals(((LexiconEntryTableModel)this.lexiconEntryFieldTable.getModel()).getFldIdAtRow(i).getName())) continue;
                        this.lexiconEntryFieldTable.setRowSelectionInterval(i, i);
                        break;
                    }
                }
            } else {
                this.lexiconEntryFieldTable.setModel(this.fieldLists.get(this.lexiconLinkComboBox.getSelectedItem()));
            }
        }
    }

    private boolean fillEntryFieldTableLC(LexiconLink lexLink, String lexiconName) {
        LexiconIdentification lexId = null;
        lexId = lexLink == null ? new LexiconIdentification(lexiconName, lexiconName) : lexLink.getLexId();
        try {
            LexiconServiceClient lcClient = null;
            lcClient = lexLink != null && lexLink.getSrvcClient() != null ? lexLink.getSrvcClient() : new LexiconComponentClient();
            ArrayList<LexicalEntryFieldIdentification> fields = lcClient.getLexicalEntryFieldIdentifications(lexId);
            if (fields != null) {
                LexiconEntryTableModel tmpModel = new LexiconEntryTableModel();
                for (LexicalEntryFieldIdentification fldId : fields) {
                    tmpModel.addRow(fldId);
                }
                this.lexiconEntryFieldTable.setModel(tmpModel);
                return true;
            }
        }
        catch (LexiconServiceClientException lsce) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning(lsce.getMessage());
            }
            return lexLink != null && "ELAN Lexicon Component".equals(lexLink.getLexSrvcClntType());
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.okButton) {
            this.setCanceled(false);
            this.closeDialog();
        } else if (ae.getSource() == this.lexiconLinkComboBox) {
            this.fillEntryFieldTable();
            this.updateButtons();
        } else if (ae.getSource() == this.cancelButton) {
            this.closeDialog();
        }
    }

    protected void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        this.updateButtons();
    }

    public LexiconQueryBundle2 getBundle() {
        if (this.lexiconLinkComboBox.getSelectedIndex() >= 0 && this.lexiconEntryFieldTable.getSelectedRow() > -1) {
            LexiconLink theLink = null;
            String linkName = (String)this.lexiconLinkComboBox.getSelectedItem();
            if (linkName.equals(this.none)) {
                return null;
            }
            ArrayList links = new ArrayList(((HashMap)this.transcription.getLexiconLinks()).values());
            for (LexiconLink link : links) {
                if (!link.getName().equals(linkName)) continue;
                theLink = link;
            }
            if (theLink == null) {
                LexiconIdentification lid = new LexiconIdentification(linkName, linkName);
                theLink = new LexiconLink(linkName, "ELAN Lexicon Component", "", new LexiconComponentClient(), lid);
                this.transcription.addLexiconLink(theLink);
            }
            LexicalEntryFieldIdentification theFldId = ((LexiconEntryTableModel)this.lexiconEntryFieldTable.getModel()).getFldIdAtRow(this.lexiconEntryFieldTable.getSelectedRow());
            return new LexiconQueryBundle2(theLink, theFldId);
        }
        return null;
    }

    private class LexiconEntryTableModel
    extends AbstractTableModel {
        ArrayList<LexicalEntryFieldIdentification> entryFields = new ArrayList();
        private String[] columnNames = new String[2];

        public LexiconEntryTableModel() {
            this.columnNames[0] = ElanLocale.getString("EditQueryBundle.Label.Name");
            this.columnNames[1] = ElanLocale.getString("EditQueryBundle.Label.Description");
        }

        public void addRow(LexicalEntryFieldIdentification entryField) {
            this.entryFields.add(entryField);
            this.fireTableRowsInserted(this.entryFields.size() - 1, this.entryFields.size() - 1);
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.entryFields.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            LexicalEntryFieldIdentification entryField = this.entryFields.get(rowIndex);
            if (columnIndex == 0) {
                return entryField.getName();
            }
            if (columnIndex == 1) {
                return entryField.getDescription();
            }
            return null;
        }

        public LexicalEntryFieldIdentification getFldIdAtRow(int rowNumber) {
            return this.entryFields.get(rowNumber);
        }
    }
}

