/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.lexicon.lexcom;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.tree.TreeModel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.lexicon.LexicalEntryFieldIdentification;
import mpi.eudico.server.corpora.lexicon.Lexicon;
import mpi.eudico.server.corpora.lexicon.LexiconIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClient;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientException;
import nl.mpi.lexiconcomponent.impl.LexiconContext;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;

public class LexiconComponentClient
implements LexiconServiceClient {
    public static final String CLIENT_TYPE = "ELAN Lexicon Component";
    private String url = "";
    private String user;

    @Override
    public String getType() {
        return CLIENT_TYPE;
    }

    @Override
    public String getDescription() {
        return "Built-in ELAN lexicon client";
    }

    @Override
    public void setUrl(String lexiconWebserviceUrl) {
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUsername(String username) {
        this.user = username;
    }

    @Override
    public String getUsername() {
        if (this.user != null) {
            return this.user;
        }
        return "";
    }

    @Override
    public void setPassword(String password) {
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public ArrayList<LexiconIdentification> getLexiconIdentifications() throws LexiconServiceClientException {
        try {
            String[] lexiconNames = LexiconContext.getInstance().getAvailableLexicons();
            if (lexiconNames != null) {
                ArrayList<LexiconIdentification> lexIds = new ArrayList<LexiconIdentification>(lexiconNames.length);
                for (String lName : lexiconNames) {
                    LexiconImpl lexImpl = LexiconContext.getInstance().getLexicon(lName);
                    if (lexImpl != null) {
                        LexiconIdentification li = new LexiconIdentification(lName, lName);
                        li.setDescription(lexImpl.getHeader().getDescription());
                        lexIds.add(li);
                        continue;
                    }
                    if (!ClientLogger.LOG.isLoggable(Level.INFO)) continue;
                    ClientLogger.LOG.info(String.format("A lexicon name exists (%s) but the lexicon could not be loaded.", lName));
                }
                return lexIds;
            }
            if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                ClientLogger.LOG.info("No lexicons found.");
            }
            return new ArrayList<LexiconIdentification>(0);
        }
        catch (Throwable t) {
            throw new LexiconServiceClientException(t);
        }
    }

    @Override
    public Lexicon getLexicon(LexiconIdentification lexId) throws LexiconServiceClientException {
        return null;
    }

    @Override
    public ArrayList<LexicalEntryFieldIdentification> getLexicalEntryFieldIdentifications(LexiconIdentification lexId) throws LexiconServiceClientException {
        if (lexId == null) {
            throw new LexiconServiceClientException("The lexicon identifier is null");
        }
        try {
            String[] lexiconNames;
            for (String lName : lexiconNames = LexiconContext.getInstance().getAvailableLexicons()) {
                if (!lexId.getName().equals(lName)) continue;
                LexiconImpl lexImpl = LexiconContext.getInstance().getLexicon(lName);
                if (lexImpl != null) {
                    List entryFieldNames = new ArrayList();
                    entryFieldNames = lexImpl.getEntryFieldNames();
                    ArrayList<LexicalEntryFieldIdentification> fieldIds = new ArrayList<LexicalEntryFieldIdentification>();
                    for (String fieldName : entryFieldNames) {
                        fieldIds.add(new LexicalEntryFieldIdentification("", fieldName));
                    }
                    return fieldIds;
                }
                throw new LexiconServiceClientException(String.format("The Lexicon named '%s' could not be found", lName));
            }
        }
        catch (Throwable t) {
            throw new LexiconServiceClientException("The entry fields could not be listed: " + t.getMessage());
        }
        return null;
    }

    @Override
    public TreeModel getLexicalEntryStructure(LexiconIdentification lexId) throws LexiconServiceClientException {
        return null;
    }

    @Override
    public ArrayList<String> getSearchConstraints() {
        return null;
    }

    @Override
    public Lexicon search(LexiconIdentification lexId, LexicalEntryFieldIdentification fldId, String constraint, String searchString) throws LexiconServiceClientException {
        return null;
    }
}

