/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.linkedmedia;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.linkedmedia.LinkedFilesTableModel;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;

public class LFDescriptorTableModel
extends LinkedFilesTableModel {
    private List<LinkedFileDescriptor> descriptors;

    public LFDescriptorTableModel() {
        this(new ArrayList<LinkedFileDescriptor>(0));
    }

    public LFDescriptorTableModel(List<LinkedFileDescriptor> descriptors) {
        this.descriptors = descriptors != null ? descriptors : new ArrayList();
        this.columnIds = new ArrayList();
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.MediaName"));
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.MediaURL"));
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.MimeType"));
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.AssociatedWith"));
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.MediaOffset"));
        this.columnIds.add(ElanLocale.getString("LinkedFilesDialog.Label.LinkStatus"));
        this.types = new ArrayList(this.columnIds.size());
        this.types.add(String.class);
        this.types.add(String.class);
        this.types.add(String.class);
        this.types.add(String.class);
        this.types.add(Integer.class);
        this.types.add(Boolean.class);
        this.initData();
    }

    private void initData() {
        this.data = new ArrayList(this.descriptors.size());
        for (int i = 0; i < this.descriptors.size(); ++i) {
            LinkedFileDescriptor desc = this.descriptors.get(i);
            ArrayList<Object> rowData = new ArrayList<Object>(this.getColumnCount());
            String url = desc.linkURL;
            String name = FileUtility.fileNameFromPath(url);
            rowData.add(name);
            rowData.add(url);
            rowData.add(desc.mimeType);
            rowData.add(desc.associatedWith != null ? desc.associatedWith : "-");
            rowData.add((int)desc.timeOrigin);
            boolean linked = FileUtility.fileExists(desc.linkURL);
            rowData.add(linked);
            this.data.add(rowData);
        }
    }

    public void removeRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.data.size()) {
            this.data.remove(rowIndex);
            this.descriptors.remove(rowIndex);
            this.fireTableDataChanged();
        }
    }

    public void addRow(LinkedFileDescriptor desc) {
        if (desc == null) {
            return;
        }
        this.descriptors.add(desc);
        ArrayList<Object> rowData = new ArrayList<Object>(this.getColumnCount());
        String url = desc.linkURL;
        String name = FileUtility.fileNameFromPath(url);
        rowData.add(name);
        rowData.add(url);
        rowData.add(desc.mimeType);
        rowData.add(desc.associatedWith != null ? desc.associatedWith : "-");
        rowData.add((int)desc.timeOrigin);
        boolean linked = FileUtility.fileExists(desc.linkURL);
        rowData.add(linked);
        this.data.add(rowData);
        this.fireTableDataChanged();
    }

    public void addLinkDescriptor(LinkedFileDescriptor md) {
        this.addRow(md);
    }

    public void rowDataChanged() {
        this.initData();
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.data.size() || columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return;
        }
        if (value == null) {
            return;
        }
        if (value instanceof Integer && (Integer)value < 0) {
            return;
        }
        if (this.getColumnClass(columnIndex).isInstance(value)) {
            ((List)this.data.get(rowIndex)).set(columnIndex, value);
            this.fireTableCellUpdated(rowIndex, columnIndex);
            String columnName = this.getColumnName(columnIndex);
            if (ElanLocale.getString("LinkedFilesDialog.Label.MediaOffset").equals(columnName) && value instanceof Integer) {
                LinkedFileDescriptor md = this.descriptors.get(rowIndex);
                md.timeOrigin = ((Integer)value).intValue();
            }
        }
    }
}

