/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.linkedmedia;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.linkedmedia.LinkedFilesDialog;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorTableModel;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class MediaFilesPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private static final String NO_SOURCE = "-";
    private JScrollPane mediaScrollPane;
    private JTable mediaTable;
    private JPanel linkInfoPanel;
    private JLabel linkInfoLabel;
    private JButton addRemoteMB;
    private JButton addMB;
    private JButton removeMB;
    private JButton updateMB;
    private JButton masterMB;
    private JButton extractMB;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JPanel moveButtonPanel;
    private JPanel mediaButtonPanel;
    private TranscriptionImpl transcription;
    private List<MediaDescriptor> currentMDCopy;
    private boolean offsetEditMode = false;
    private LinkedFilesDialog linkedFilesDialog;

    public MediaFilesPanel(Transcription transcription, LinkedFilesDialog linkedFilesDialog) {
        this.transcription = (TranscriptionImpl)transcription;
        this.linkedFilesDialog = linkedFilesDialog;
        if (transcription != null) {
            List<MediaDescriptor> orgMD = transcription.getMediaDescriptors();
            this.currentMDCopy = new ArrayList<MediaDescriptor>(orgMD.size());
            for (int i = 0; i < orgMD.size(); ++i) {
                MediaDescriptor md = orgMD.get(i);
                MediaDescriptor cloneMD = (MediaDescriptor)md.clone();
                if (cloneMD == null) continue;
                this.currentMDCopy.add(cloneMD);
            }
        }
        this.initComponents();
    }

    private void initComponents() {
        ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
        ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
        ImageIcon tickIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Tick16.gif"));
        ImageIcon untickIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Untick16.gif"));
        CheckBoxTableCellRenderer cbRenderer = new CheckBoxTableCellRenderer();
        cbRenderer.setIcon(untickIcon);
        cbRenderer.setSelectedIcon(tickIcon);
        cbRenderer.setHorizontalAlignment(0);
        this.mediaScrollPane = new JScrollPane();
        this.mediaTable = new JTable();
        this.linkInfoPanel = new JPanel();
        this.linkInfoLabel = new JLabel();
        this.mediaButtonPanel = new JPanel();
        this.addRemoteMB = new JButton();
        this.addMB = new JButton();
        this.removeMB = new JButton();
        this.updateMB = new JButton();
        this.masterMB = new JButton();
        this.extractMB = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.mediaScrollPane.setMinimumSize(new Dimension(100, 100));
        this.mediaScrollPane.setPreferredSize(new Dimension(550, 100));
        MediaDescriptorTableModel model = new MediaDescriptorTableModel(this.currentMDCopy);
        this.mediaTable.setModel(model);
        this.mediaTable.setSelectionMode(0);
        this.mediaTable.getSelectionModel().addListSelectionListener(this);
        this.mediaTable.getModel().addTableModelListener(this);
        for (int i = 0; i < this.mediaTable.getColumnCount(); ++i) {
            if (this.mediaTable.getModel().getColumnClass(i) != String.class) {
                this.mediaTable.getColumn(this.mediaTable.getModel().getColumnName(i)).setPreferredWidth(35);
            }
            if (this.mediaTable.getModel().getColumnClass(i) != Boolean.class) continue;
            this.mediaTable.getColumn(this.mediaTable.getModel().getColumnName(i)).setCellRenderer(cbRenderer);
        }
        this.mediaScrollPane.setViewportView(this.mediaTable);
        this.mediaScrollPane.getViewport().setBackground(this.mediaTable.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        this.add((Component)this.mediaScrollPane, gridBagConstraints);
        this.linkInfoPanel.setLayout(new BorderLayout());
        this.linkInfoLabel.setFont(this.linkInfoLabel.getFont().deriveFont(0, 10.0f));
        this.fillInfoPanel(-1);
        this.linkInfoPanel.add((Component)this.linkInfoLabel, "West");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.add((Component)this.linkInfoPanel, gridBagConstraints);
        this.mediaButtonPanel.setLayout(new GridLayout(2, 4, 6, 2));
        this.addRemoteMB.addActionListener(this);
        this.mediaButtonPanel.add(this.addRemoteMB);
        this.addMB.addActionListener(this);
        this.mediaButtonPanel.add(this.addMB);
        this.removeMB.setEnabled(false);
        this.removeMB.addActionListener(this);
        this.mediaButtonPanel.add(this.removeMB);
        this.updateMB.setEnabled(false);
        this.updateMB.addActionListener(this);
        this.mediaButtonPanel.add(this.updateMB);
        this.mediaButtonPanel.add(new JLabel());
        this.masterMB.setEnabled(false);
        this.masterMB.addActionListener(this);
        this.mediaButtonPanel.add(this.masterMB);
        this.extractMB.setEnabled(false);
        this.extractMB.addActionListener(this);
        this.mediaButtonPanel.add(this.extractMB);
        this.moveButtonPanel = new JPanel();
        this.moveButtonPanel.setLayout(new GridLayout(1, 2, 6, 2));
        this.moveUpButton.setIcon(upIcon);
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(this);
        this.moveButtonPanel.add(this.moveUpButton);
        this.moveDownButton.setIcon(downIcon);
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(this);
        this.moveButtonPanel.add(this.moveDownButton);
        this.mediaButtonPanel.add(this.moveButtonPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = insets;
        this.add((Component)this.mediaButtonPanel, gridBagConstraints);
        this.updateLocale();
    }

    private void updateLocale() {
        this.linkInfoPanel.setBorder(new TitledBorder(ElanLocale.getString("LinkedFilesDialog.Label.LinkInfo")));
        this.addRemoteMB.setText(ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteMedia"));
        this.addMB.setText(ElanLocale.getString("LinkedFilesDialog.Button.Add"));
        this.removeMB.setText(ElanLocale.getString("LinkedFilesDialog.Button.Remove"));
        this.updateMB.setText(ElanLocale.getString("LinkedFilesDialog.Button.Update"));
        this.masterMB.setText(ElanLocale.getString("LinkedFilesDialog.Button.MasterMedia"));
        this.extractMB.setText(ElanLocale.getString("LinkedFilesDialog.Button.Extracted"));
        this.moveUpButton.setToolTipText(ElanLocale.getString("LinkedFilesDialog.Button.Up"));
        this.moveDownButton.setToolTipText(ElanLocale.getString("LinkedFilesDialog.Button.Down"));
    }

    void applyChanges() {
        boolean anyChange = this.hasChanged();
        this.checkUnequalOffsets();
        if (anyChange) {
            Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.ChangeLinkedFiles");
            if (this.offsetEditMode) {
                c.execute(this.transcription, new Object[]{this.currentMDCopy, Boolean.TRUE, Boolean.TRUE});
            } else {
                c.execute(this.transcription, new Object[]{this.currentMDCopy, Boolean.TRUE});
            }
        }
        List<MediaDescriptor> orgMD = this.transcription.getMediaDescriptors();
        this.currentMDCopy = new ArrayList<MediaDescriptor>(orgMD.size());
        for (int i = 0; i < orgMD.size(); ++i) {
            MediaDescriptor md = orgMD.get(i);
            MediaDescriptor cloneMD = (MediaDescriptor)md.clone();
            if (cloneMD == null) continue;
            this.currentMDCopy.add(cloneMD);
        }
    }

    boolean hasChanged() {
        if (this.mediaTable.isEditing()) {
            this.mediaTable.getCellEditor().stopCellEditing();
        }
        boolean anyChange = false;
        List<MediaDescriptor> orgMD = this.transcription.getMediaDescriptors();
        if (orgMD.size() != this.currentMDCopy.size()) {
            anyChange = true;
        }
        if (!anyChange) {
            block0: for (int i = 0; i < orgMD.size(); ++i) {
                MediaDescriptor olddesc = orgMD.get(i);
                for (int j = 0; j < this.currentMDCopy.size(); ++j) {
                    MediaDescriptor newdesc = this.currentMDCopy.get(j);
                    if (olddesc != null && olddesc.equals(newdesc)) {
                        if (i == j) continue block0;
                        anyChange = true;
                        break block0;
                    }
                    if (olddesc == null || newdesc == null || !olddesc.mediaURL.equals(newdesc.mediaURL) || olddesc.timeOrigin == newdesc.timeOrigin) continue;
                    anyChange = true;
                    break block0;
                }
                anyChange = true;
                break;
            }
        }
        return anyChange;
    }

    private void addRemoteMedia() {
        String url = this.chooseRemoteFile();
        if (url == null) {
            return;
        }
        MediaDescriptor md = MediaDescriptorUtil.createMediaDescriptor(url);
        this.addMediaDescriptor(md);
    }

    private void addMediaDescriptor() {
        String file = this.chooseMediaFile(2, false);
        if (file == null) {
            return;
        }
        MediaDescriptor md = MediaDescriptorUtil.createMediaDescriptor(file);
        this.addMediaDescriptor(md);
    }

    private void addMediaDescriptor(MediaDescriptor md) {
        if (md == null) {
            return;
        }
        if (this.linkedFilesDialog.urlAlreadyLinked(md.mediaURL)) {
            this.showWarningDialog(ElanLocale.getString("LinkedFilesDialog.Message.AlreadyLinked"));
            return;
        }
        int row = this.mediaTable.getSelectedRow();
        for (int i = 0; i < this.currentMDCopy.size(); ++i) {
            MediaDescriptor otherMD = this.currentMDCopy.get(i);
            if (md.mimeType.equals("audio/x-wav") && MediaDescriptorUtil.isVideoType(otherMD) && FileUtility.sameNameIgnoreExtension(md.mediaURL, otherMD.mediaURL)) {
                md.extractedFrom = otherMD.mediaURL;
            }
            if (!otherMD.mimeType.equals("audio/x-wav") || !MediaDescriptorUtil.isVideoType(md) || !FileUtility.sameNameIgnoreExtension(md.mediaURL, otherMD.mediaURL)) continue;
            otherMD.extractedFrom = md.mediaURL;
        }
        this.currentMDCopy.add(md);
        ((MediaDescriptorTableModel)this.mediaTable.getModel()).rowDataChanged();
        if (row >= 0) {
            this.setSelectionIndex(this.currentMDCopy.size() - 1);
        }
    }

    public boolean urlAlreadyLinked(String url) {
        for (int i = 0; i < this.currentMDCopy.size(); ++i) {
            MediaDescriptor otherMD = this.currentMDCopy.get(i);
            if (!otherMD.mediaURL.equals(url)) continue;
            return true;
        }
        return false;
    }

    private void removeMediaDescriptor() {
        int row = this.mediaTable.getSelectedRow();
        if (row >= 0) {
            MediaDescriptor md = this.currentMDCopy.get(row);
            if (md.mimeType.equals("video/mpeg")) {
                for (int i = 0; i < this.currentMDCopy.size(); ++i) {
                    if (i == row) continue;
                    MediaDescriptor desc = this.currentMDCopy.get(i);
                    if (!desc.mimeType.equals("audio/x-wav") || desc.extractedFrom == null || !desc.extractedFrom.equals(md.mediaURL)) continue;
                    desc.extractedFrom = null;
                    if (md.timeOrigin == 0L || !this.showOptionDialog(ElanLocale.getString("LinkedFilesDialog.Question.AudioKeepOffset"))) break;
                    desc.timeOrigin = md.timeOrigin;
                    break;
                }
            }
            this.currentMDCopy.remove(row);
            ((MediaDescriptorTableModel)this.mediaTable.getModel()).rowDataChanged();
        }
    }

    private void setSelectionIndex(int row) {
        this.mediaTable.getSelectionModel().setSelectionInterval(row, row);
    }

    private void updateMediaDescriptor() {
        int row = this.mediaTable.getSelectedRow();
        if (row >= 0) {
            MediaDescriptor updateMD = this.currentMDCopy.get(row);
            String file = null;
            file = updateMD.mimeType.equals("video/mpeg") ? this.chooseMediaFile(0, true) : (updateMD.mimeType.equals("audio/x-wav") ? this.chooseMediaFile(1, true) : this.chooseMediaFile(2, true));
            if (file == null) {
                return;
            }
            MediaDescriptor md = MediaDescriptorUtil.createMediaDescriptor(file);
            if (md.mediaURL.equals(updateMD.mediaURL)) {
                this.showWarningDialog(ElanLocale.getString("LinkedFilesDialog.Message.SameFile"));
                return;
            }
            for (int i = 0; i < this.currentMDCopy.size(); ++i) {
                if (i == row) continue;
                MediaDescriptor otherMD = this.currentMDCopy.get(i);
                if (otherMD.mediaURL.equals(md.mediaURL)) {
                    this.showWarningDialog(ElanLocale.getString("LinkedFilesDialog.Message.AlreadyLinked"));
                    return;
                }
                if (otherMD.extractedFrom != null && otherMD.extractedFrom.equals(updateMD.mediaURL)) {
                    otherMD.extractedFrom = md.mimeType.equals("video/mpeg") ? (this.showOptionDialog(ElanLocale.getString("LinkedFilesDialog.Question.UpdateExtractedFrom")) ? md.mediaURL : null) : null;
                }
                if (md.mimeType.equals("audio/x-wav") && otherMD.mimeType.equals("video/mpeg") && FileUtility.sameNameIgnoreExtension(md.mediaURL, otherMD.mediaURL)) {
                    md.extractedFrom = otherMD.mediaURL;
                }
                if (!otherMD.mimeType.equals("audio/x-wav") || !md.mimeType.equals("video/mpeg") || !FileUtility.sameNameIgnoreExtension(md.mediaURL, otherMD.mediaURL)) continue;
                otherMD.extractedFrom = md.mediaURL;
            }
            if (updateMD.timeOrigin != 0L && this.showOptionDialog(ElanLocale.getString("LinkedFilesDialog.Question.UpdateKeepOffset"))) {
                md.timeOrigin = updateMD.timeOrigin;
            }
            this.currentMDCopy.remove(row);
            this.currentMDCopy.add(row, md);
            ((MediaDescriptorTableModel)this.mediaTable.getModel()).rowDataChanged();
            this.setSelectionIndex(row);
        }
    }

    private void setMasterMedia() {
        int row = this.mediaTable.getSelectedRow();
        if (row > 0) {
            MediaDescriptor md = this.currentMDCopy.remove(row);
            this.currentMDCopy.add(0, md);
            ((MediaDescriptorTableModel)this.mediaTable.getModel()).rowDataChanged();
            this.setSelectionIndex(0);
        }
    }

    private void setExtractedFrom() {
        int row = this.mediaTable.getSelectedRow();
        if (row >= 0) {
            MediaDescriptor md = this.currentMDCopy.get(row);
            if (md.mimeType.equals("audio/x-wav")) {
                String source = this.showVideoSelectionDialog(md);
                if (source != null) {
                    md.extractedFrom = source == NO_SOURCE ? null : source;
                }
                ((MediaDescriptorTableModel)this.mediaTable.getModel()).rowDataChanged();
                this.setSelectionIndex(row);
            }
        }
    }

    private void moveUp() {
        int row = this.mediaTable.getSelectedRow();
        if (row > 0) {
            MediaDescriptor md = this.currentMDCopy.remove(row);
            this.currentMDCopy.add(row - 1, md);
            ((MediaDescriptorTableModel)this.mediaTable.getModel()).rowDataChanged();
            this.setSelectionIndex(row - 1);
        }
    }

    private void moveDown() {
        int row = this.mediaTable.getSelectedRow();
        if (row >= 0 && row < this.currentMDCopy.size() - 1) {
            MediaDescriptor md = this.currentMDCopy.remove(row);
            this.currentMDCopy.add(row + 1, md);
            ((MediaDescriptorTableModel)this.mediaTable.getModel()).rowDataChanged();
            this.setSelectionIndex(row + 1);
        }
    }

    private void updateUIComponents() {
        int row = this.mediaTable.getSelectedRow();
        if (row >= 0 && row < this.currentMDCopy.size()) {
            this.removeMB.setEnabled(true);
            this.updateMB.setEnabled(true);
            if (row == 0) {
                this.masterMB.setEnabled(false);
                this.moveUpButton.setEnabled(false);
            } else {
                this.masterMB.setEnabled(true);
                this.moveUpButton.setEnabled(true);
            }
            if (row == this.currentMDCopy.size() - 1) {
                this.moveDownButton.setEnabled(false);
            } else {
                this.moveDownButton.setEnabled(true);
            }
            MediaDescriptor md = this.currentMDCopy.get(row);
            if (md.mimeType.equals("audio/x-wav")) {
                this.extractMB.setEnabled(true);
            } else {
                this.extractMB.setEnabled(false);
            }
        } else {
            this.removeMB.setEnabled(false);
            this.updateMB.setEnabled(false);
            this.masterMB.setEnabled(false);
            this.extractMB.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        }
        this.fillInfoPanel(row);
    }

    private void fillInfoPanel(int row) {
        TableModel model = this.mediaTable.getModel();
        Object masterObj = model.getValueAt(row, 5);
        Object linkedObj = model.getValueAt(row, 6);
        boolean isMaster = masterObj instanceof Boolean ? (Boolean)masterObj : false;
        boolean isLinked = linkedObj instanceof Boolean ? (Boolean)linkedObj : false;
        this.linkInfoLabel.setText("<html><table><tr><td>" + model.getColumnName(0) + "</td><td>" + (model.getValueAt(row, 0) != null ? model.getValueAt(row, 0) : "") + "</td></tr><tr><td>" + model.getColumnName(1) + "</td><td>" + (model.getValueAt(row, 1) != null ? model.getValueAt(row, 1) : "") + "</td></tr><tr><td>" + model.getColumnName(2) + "</td><td>" + (model.getValueAt(row, 2) != null ? model.getValueAt(row, 2) : "") + "</td></tr><tr><td>" + model.getColumnName(3) + "</td><td>" + (model.getValueAt(row, 3) != null ? model.getValueAt(row, 3) : "") + "</td></tr><tr><td>" + model.getColumnName(4) + "</td><td>" + (model.getValueAt(row, 4) != null ? model.getValueAt(row, 4) : "") + "</td></tr><tr><td>" + model.getColumnName(5) + "</td><td>" + (model.getValueAt(row, 5) != null ? (isMaster ? ElanLocale.getString("LinkedFilesDialog.Label.Yes") : ElanLocale.getString("LinkedFilesDialog.Label.No")) : "") + "</td></tr><tr><td>" + model.getColumnName(6) + "</td><td>" + (model.getValueAt(row, 6) != null ? (isLinked ? ElanLocale.getString("LinkedFilesDialog.Label.StatusLinked") : ElanLocale.getString("LinkedFilesDialog.Label.StatusMissing")) : "") + "</td></tr></table></html>");
    }

    private String chooseMediaFile(int mediaType, boolean updating) {
        FileChooser chooser = new FileChooser(this);
        String[] mainExt = null;
        ArrayList<String[]> extensions = null;
        switch (mediaType) {
            case 2: {
                mainExt = FileExtension.MEDIA_EXT;
                extensions = new ArrayList<String[]>();
                extensions.add(FileExtension.MEDIA_EXT);
                extensions.add(FileExtension.MPEG_EXT);
                extensions.add(FileExtension.WAV_EXT);
                extensions.add(FileExtension.MPEG4_EXT);
                extensions.add(FileExtension.QT_EXT);
                if (updating) break;
                mainExt = null;
                Integer val = Preferences.getInt("Media.LastUsedMediaType", null);
                if (val == null) break;
                int type = val;
                if (type == 2) {
                    mainExt = FileExtension.MEDIA_EXT;
                    break;
                }
                if (type == 16) {
                    mainExt = FileExtension.MPEG4_EXT;
                    break;
                }
                if (type != 17) break;
                mainExt = FileExtension.QT_EXT;
                break;
            }
            case 0: {
                mainExt = FileExtension.MPEG_EXT;
                break;
            }
            case 1: {
                mainExt = FileExtension.WAV_EXT;
            }
        }
        chooser.createAndShowFileDialog(ElanLocale.getString("LinkedFilesDialog.SelectMediaDialog.Title"), 0, ElanLocale.getString("LinkedFilesDialog.SelectMediaDialog.Approve"), extensions, mainExt, true, "MediaDir", 0, null);
        File selected = chooser.getSelectedFile();
        if (selected != null) {
            String ext = FileUtility.getExtension(selected);
            if (!updating) {
                int type = -1;
                List<String> extensionsList = Arrays.asList(FileExtension.MEDIA_EXT);
                if (extensionsList.contains(ext)) {
                    type = 2;
                }
                if ((extensionsList = Arrays.asList(FileExtension.MPEG4_EXT)).contains(ext)) {
                    type = 16;
                }
                if ((extensionsList = Arrays.asList(FileExtension.QT_EXT)).contains(ext)) {
                    type = 17;
                }
                Preferences.set("Media.LastUsedMediaType", (Object)type, null);
            }
            return selected.getAbsolutePath();
        }
        return null;
    }

    private String chooseRemoteFile() {
        Object url = "rtsp://";
        Object rf;
        while ((rf = JOptionPane.showInputDialog(this, ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteLabel"), ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteMedia"), -1, null, null, url)) != null) {
            url = (String)rf;
            ((String)url).replace('\\', '/');
            boolean valid = true;
            if (!((String)url).startsWith("rtsp")) {
                int ds = ((String)url).indexOf("//");
                url = ds > -1 ? "rtsp:" + ((String)url).substring(ds) : "rtsp://" + (String)url;
            }
            if (((String)url).indexOf("://") != 4) {
                valid = false;
            }
            int dot = ((String)url).lastIndexOf(46);
            int slash = ((String)url).lastIndexOf(47);
            if (dot < 0 || dot < slash) {
                valid = false;
            }
            if (valid) {
                return url;
            }
            JOptionPane.showMessageDialog(this, ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteMessage") + (String)url, ElanLocale.getString("Message.Error"), 0);
        }
        return null;
    }

    private void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private boolean showOptionDialog(String question) {
        int option = JOptionPane.showOptionDialog(this, question, ElanLocale.getString("LinkedFilesDialog.Title"), 0, 3, null, new String[]{ElanLocale.getString("Button.Yes"), ElanLocale.getString("Button.No")}, ElanLocale.getString("Button.Yes"));
        return option == 0;
    }

    private String showVideoSelectionDialog(MediaDescriptor forAudioMD) {
        if (forAudioMD == null) {
            return null;
        }
        ArrayList<String> videos = new ArrayList<String>();
        videos.add(NO_SOURCE);
        for (int i = 0; i < this.currentMDCopy.size(); ++i) {
            MediaDescriptor md = this.currentMDCopy.get(i);
            if (!md.mimeType.equals("video/mpeg")) continue;
            videos.add(md.mediaURL);
        }
        String option = (String)JOptionPane.showInputDialog(this, ElanLocale.getString("LinkedFilesDialog.Question.SelectSource"), ElanLocale.getString("LinkedFilesDialog.Title"), 3, null, videos.toArray(), NO_SOURCE);
        return option;
    }

    private void checkUnequalOffsets() {
        if (this.currentMDCopy.size() < 2) {
            return;
        }
        StringBuilder mesBuf = null;
        block0: for (int i = 0; i < this.currentMDCopy.size(); ++i) {
            MediaDescriptor amd = this.currentMDCopy.get(i);
            if (!amd.mimeType.equals("audio/x-wav")) continue;
            for (int j = 0; j < this.currentMDCopy.size(); ++j) {
                MediaDescriptor vmd = this.currentMDCopy.get(j);
                if (!MediaDescriptorUtil.isVideoType(vmd) || !vmd.mediaURL.equals(amd.extractedFrom) || j == 0 || vmd.timeOrigin == amd.timeOrigin) continue;
                if (mesBuf == null) {
                    mesBuf = new StringBuilder(ElanLocale.getString("LinkedFilesDialog.Message.OffsetNotEqual"));
                    mesBuf.append("\n\n");
                }
                mesBuf.append("- " + vmd.mediaURL + "\n");
                mesBuf.append("- " + amd.mediaURL + "\n\n");
                continue block0;
            }
        }
        if (mesBuf != null) {
            this.showWarningDialog(mesBuf.toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.addMB) {
            this.addMediaDescriptor();
        } else if (source == this.removeMB) {
            this.removeMediaDescriptor();
        } else if (source == this.updateMB) {
            this.updateMediaDescriptor();
        } else if (source == this.masterMB) {
            this.setMasterMedia();
        } else if (source == this.extractMB) {
            this.setExtractedFrom();
        } else if (source == this.moveUpButton) {
            this.moveUp();
        } else if (source == this.moveDownButton) {
            this.moveDown();
        } else if (source == this.addRemoteMB) {
            this.addRemoteMedia();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (!lse.getValueIsAdjusting()) {
            if (!this.offsetEditMode) {
                this.updateUIComponents();
            } else {
                int row = this.mediaTable.getSelectedRow();
                if (row >= 0 && row < this.currentMDCopy.size()) {
                    this.fillInfoPanel(row);
                }
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent tme) {
        if (tme.getColumn() < 0) {
            ((MediaDescriptorTableModel)this.mediaTable.getModel()).setGlobalCellEditable(false);
            this.updateUIComponents();
        } else if (tme.getColumn() == ((MediaDescriptorTableModel)this.mediaTable.getModel()).findColumn(ElanLocale.getString("LinkedFilesDialog.Label.MediaOffset"))) {
            MediaDescriptor md = this.currentMDCopy.get(tme.getFirstRow());
            Integer newValue = (Integer)((MediaDescriptorTableModel)this.mediaTable.getModel()).getValueAt(tme.getFirstRow(), tme.getColumn());
            if ((long)newValue.intValue() != md.timeOrigin) {
                this.offsetEditMode = true;
                this.addMB.setEnabled(false);
                this.addRemoteMB.setEnabled(false);
                this.removeMB.setEnabled(false);
                this.updateMB.setEnabled(false);
                this.masterMB.setEnabled(false);
                this.extractMB.setEnabled(false);
                this.moveUpButton.setEnabled(false);
                this.moveDownButton.setEnabled(false);
            }
        }
    }
}

