/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.linkedmedia;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.linkedmedia.LFDescriptorTableModel;
import mpi.eudico.client.annotator.linkedmedia.LinkedFileDescriptorUtil;
import mpi.eudico.client.annotator.linkedmedia.LinkedFilesDialog;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class SecLinkedFilesPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private TranscriptionImpl transcription;
    private final String NO_SOURCE = "-";
    private JScrollPane linkScrollPane;
    private JTable linkTable;
    private JPanel linkInfoPanel;
    private JLabel linkInfoLabel;
    private JButton addMB;
    private JButton removeMB;
    private JButton updateMB;
    private JButton associateJB;
    private JPanel linkButtonPanel;
    private List<LinkedFileDescriptor> descCopy;
    private boolean offsetEditMode = false;
    private LinkedFilesDialog linkedFilesDialog;
    private AbstractButton moveUpButton;
    private AbstractButton moveDownButton;

    public SecLinkedFilesPanel(Transcription trans, LinkedFilesDialog linkedFilesDialog) {
        this.transcription = (TranscriptionImpl)trans;
        this.linkedFilesDialog = linkedFilesDialog;
        if (this.transcription != null) {
            List<LinkedFileDescriptor> orgLFD = this.transcription.getLinkedFileDescriptors();
            this.descCopy = new ArrayList<LinkedFileDescriptor>(orgLFD.size());
            for (int i = 0; i < orgLFD.size(); ++i) {
                LinkedFileDescriptor lfd = orgLFD.get(i);
                LinkedFileDescriptor cloneLFD = (LinkedFileDescriptor)lfd.clone();
                if (cloneLFD == null) continue;
                this.descCopy.add(cloneLFD);
            }
        }
        this.initComponents();
    }

    private void initComponents() {
        ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
        ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
        ImageIcon tickIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Tick16.gif"));
        ImageIcon untickIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Untick16.gif"));
        CheckBoxTableCellRenderer cbRenderer = new CheckBoxTableCellRenderer();
        cbRenderer.setIcon(untickIcon);
        cbRenderer.setSelectedIcon(tickIcon);
        cbRenderer.setHorizontalAlignment(0);
        this.linkScrollPane = new JScrollPane();
        this.linkTable = new JTable();
        this.linkInfoPanel = new JPanel();
        this.linkInfoLabel = new JLabel();
        this.linkButtonPanel = new JPanel();
        this.addMB = new JButton();
        this.removeMB = new JButton();
        this.updateMB = new JButton();
        this.associateJB = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.linkScrollPane.setMinimumSize(new Dimension(100, 100));
        this.linkScrollPane.setPreferredSize(new Dimension(550, 100));
        LFDescriptorTableModel model = new LFDescriptorTableModel(this.descCopy);
        this.linkTable.setModel(model);
        this.linkTable.setSelectionMode(0);
        this.linkTable.getSelectionModel().addListSelectionListener(this);
        this.linkTable.getModel().addTableModelListener(this);
        for (int i = 0; i < this.linkTable.getColumnCount(); ++i) {
            if (this.linkTable.getModel().getColumnClass(i) != String.class) {
                this.linkTable.getColumn(this.linkTable.getModel().getColumnName(i)).setPreferredWidth(35);
            }
            if (this.linkTable.getModel().getColumnClass(i) != Boolean.class) continue;
            this.linkTable.getColumn(this.linkTable.getModel().getColumnName(i)).setCellRenderer(cbRenderer);
        }
        this.linkScrollPane.setViewportView(this.linkTable);
        this.linkScrollPane.getViewport().setBackground(this.linkTable.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        this.add((Component)this.linkScrollPane, gridBagConstraints);
        this.linkInfoPanel.setLayout(new BorderLayout());
        this.linkInfoLabel.setFont(this.linkInfoLabel.getFont().deriveFont(0, 10.0f));
        this.fillInfoPanel(0);
        this.linkInfoPanel.add((Component)this.linkInfoLabel, "West");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.add((Component)this.linkInfoPanel, gridBagConstraints);
        this.linkButtonPanel.setLayout(new GridLayout(2, 3, 6, 2));
        this.addMB.addActionListener(this);
        this.linkButtonPanel.add(this.addMB);
        this.removeMB.setEnabled(false);
        this.removeMB.addActionListener(this);
        this.linkButtonPanel.add(this.removeMB);
        Dimension filler = new Dimension(0, 0);
        this.linkButtonPanel.add(new Box.Filler(filler, filler, filler));
        this.associateJB.setEnabled(false);
        this.associateJB.addActionListener(this);
        this.linkButtonPanel.add(this.associateJB);
        this.updateMB.setEnabled(false);
        this.updateMB.addActionListener(this);
        this.linkButtonPanel.add(this.updateMB);
        JPanel moveButtonPanel = new JPanel();
        moveButtonPanel.setLayout(new GridLayout(1, 2, 6, 2));
        this.moveUpButton.setIcon(upIcon);
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(this);
        moveButtonPanel.add(this.moveUpButton);
        this.moveDownButton.setIcon(downIcon);
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(this);
        moveButtonPanel.add(this.moveDownButton);
        this.linkButtonPanel.add(moveButtonPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = insets;
        this.add((Component)this.linkButtonPanel, gridBagConstraints);
        this.updateLocale();
    }

    private void updateLocale() {
        this.linkInfoPanel.setBorder(new TitledBorder(ElanLocale.getString("LinkedFilesDialog.Label.LinkInfo")));
        this.addMB.setText(ElanLocale.getString("LinkedFilesDialog.Button.Add"));
        this.removeMB.setText(ElanLocale.getString("LinkedFilesDialog.Button.Remove"));
        this.updateMB.setText(ElanLocale.getString("LinkedFilesDialog.Button.Update"));
        this.associateJB.setText(ElanLocale.getString("LinkedFilesDialog.Button.AssociatedWith"));
        this.moveUpButton.setToolTipText(ElanLocale.getString("LinkedFilesDialog.Button.Up"));
        this.moveDownButton.setToolTipText(ElanLocale.getString("LinkedFilesDialog.Button.Down"));
    }

    void applyChanges() {
        if (this.hasChanged()) {
            Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.ChangeLinkedFiles");
            if (this.offsetEditMode) {
                c.execute(this.transcription, new Object[]{new ArrayList<LinkedFileDescriptor>(this.descCopy), Boolean.FALSE, Boolean.TRUE});
            } else {
                c.execute(this.transcription, new Object[]{new ArrayList<LinkedFileDescriptor>(this.descCopy), Boolean.FALSE});
            }
        }
        List<LinkedFileDescriptor> orgLFD = this.transcription.getLinkedFileDescriptors();
        block0: for (int i = 0; i < orgLFD.size(); ++i) {
            LinkedFileDescriptor lfd = orgLFD.get(i);
            for (int j = 0; j < this.descCopy.size(); ++j) {
                LinkedFileDescriptor clfd = this.descCopy.get(j);
                if (lfd.linkURL.equals(clfd.linkURL)) continue block0;
            }
            LinkedFileDescriptor cloneLFD = (LinkedFileDescriptor)lfd.clone();
            if (cloneLFD == null) continue;
            this.descCopy.add(cloneLFD);
            ((LFDescriptorTableModel)this.linkTable.getModel()).rowDataChanged();
        }
    }

    boolean hasChanged() {
        boolean anyChange = false;
        List<LinkedFileDescriptor> orgMD = this.transcription.getLinkedFileDescriptors();
        if (orgMD.size() != this.descCopy.size()) {
            anyChange = true;
        }
        if (!anyChange) {
            anyChange = !orgMD.equals(this.descCopy);
        }
        return anyChange;
    }

    private void addDescriptor() {
        String file = this.chooseFile();
        if (file == null) {
            return;
        }
        LinkedFileDescriptor lfd = LinkedFileDescriptorUtil.createLFDescriptor(file);
        if (this.linkedFilesDialog.urlAlreadyLinked(lfd.linkURL)) {
            this.showWarningDialog(ElanLocale.getString("LinkedFilesDialog.Message.AlreadyLinked"));
            return;
        }
        this.descCopy.add(lfd);
        ((LFDescriptorTableModel)this.linkTable.getModel()).rowDataChanged();
        this.setSelectionIndex(this.descCopy.size() - 1);
    }

    public boolean urlAlreadyLinked(String url) {
        for (int i = 0; i < this.descCopy.size(); ++i) {
            LinkedFileDescriptor otherLFD = this.descCopy.get(i);
            if (!otherLFD.linkURL.equals(url)) continue;
            return true;
        }
        return false;
    }

    private void removeDescriptor() {
        int row = this.linkTable.getSelectedRow();
        if (row >= 0) {
            LinkedFileDescriptor lfd = this.descCopy.get(row);
            this.descCopy.remove(row);
            for (int i = this.descCopy.size() - 1; i >= 0; --i) {
                LinkedFileDescriptor desc = this.descCopy.get(i);
                if (!lfd.linkURL.equals(desc.associatedWith)) continue;
                desc.associatedWith = null;
            }
            ((LFDescriptorTableModel)this.linkTable.getModel()).rowDataChanged();
        }
    }

    private void setAssociatedWith() {
        int row = this.linkTable.getSelectedRow();
        if (row >= 0) {
            LinkedFileDescriptor updateLFD = this.descCopy.get(row);
            String ref = this.selectAssociation(updateLFD);
            if (ref != null) {
                updateLFD.associatedWith = ref == "-" ? null : ref;
            }
            ((LFDescriptorTableModel)this.linkTable.getModel()).rowDataChanged();
            this.setSelectionIndex(row);
        }
    }

    private void setSelectionIndex(int row) {
        this.linkTable.getSelectionModel().setSelectionInterval(row, row);
    }

    private void updateDescriptor() {
        int row = this.linkTable.getSelectedRow();
        if (row >= 0) {
            LinkedFileDescriptor updateLFD = this.descCopy.get(row);
            String file = this.chooseFile();
            if (file == null) {
                return;
            }
            LinkedFileDescriptor lfd = LinkedFileDescriptorUtil.createLFDescriptor(file);
            if (lfd.linkURL.equals(updateLFD.linkURL)) {
                this.showWarningDialog(ElanLocale.getString("LinkedFilesDialog.Message.SameFile"));
                return;
            }
            for (int i = 0; i < this.descCopy.size(); ++i) {
                if (i == row) continue;
                LinkedFileDescriptor otherLFD = this.descCopy.get(i);
                if (otherLFD.linkURL.equals(lfd.linkURL)) {
                    this.showWarningDialog(ElanLocale.getString("LinkedFilesDialog.Message.AlreadyLinked"));
                    return;
                }
                if (updateLFD.linkURL.equals(otherLFD.associatedWith)) {
                    otherLFD.associatedWith = lfd.linkURL;
                }
                if (updateLFD.associatedWith == null || !updateLFD.associatedWith.equals(otherLFD.linkURL)) continue;
                lfd.associatedWith = otherLFD.linkURL;
            }
            if (updateLFD.timeOrigin != 0L && this.showOptionDialog(ElanLocale.getString("LinkedFilesDialog.Question.UpdateKeepOffset"))) {
                lfd.timeOrigin = updateLFD.timeOrigin;
            }
            this.descCopy.remove(row);
            this.descCopy.add(row, lfd);
            ((LFDescriptorTableModel)this.linkTable.getModel()).rowDataChanged();
            this.setSelectionIndex(row);
        }
    }

    private void moveUp() {
        int row = this.linkTable.getSelectedRow();
        if (row > 0) {
            LinkedFileDescriptor lfd = this.descCopy.remove(row);
            this.descCopy.add(row - 1, lfd);
            ((LFDescriptorTableModel)this.linkTable.getModel()).rowDataChanged();
            this.setSelectionIndex(row - 1);
        }
    }

    private void moveDown() {
        int row = this.linkTable.getSelectedRow();
        if (row >= 0 && row < this.descCopy.size() - 1) {
            LinkedFileDescriptor md = this.descCopy.remove(row);
            this.descCopy.add(row + 1, md);
            ((LFDescriptorTableModel)this.linkTable.getModel()).rowDataChanged();
            this.setSelectionIndex(row + 1);
        }
    }

    private void updateUIComponents() {
        int row = this.linkTable.getSelectedRow();
        if (row >= 0 && row < this.descCopy.size()) {
            this.removeMB.setEnabled(true);
            this.updateMB.setEnabled(true);
            this.associateJB.setEnabled(true);
        } else {
            this.removeMB.setEnabled(false);
            this.updateMB.setEnabled(false);
            this.associateJB.setEnabled(false);
        }
        this.moveUpButton.setEnabled(row > 0);
        this.moveDownButton.setEnabled(row >= 0 && row < this.descCopy.size() - 1);
        this.fillInfoPanel(row);
    }

    private void fillInfoPanel(int row) {
        TableModel model = this.linkTable.getModel();
        Object linkedObj = model.getValueAt(row, 5);
        boolean isLinked = linkedObj instanceof Boolean ? (Boolean)linkedObj : false;
        this.linkInfoLabel.setText("<html><table><tr><td>" + model.getColumnName(0) + "</td><td>" + (model.getValueAt(row, 0) != null ? model.getValueAt(row, 0) : "") + "</td></tr><tr><td>" + model.getColumnName(1) + "</td><td>" + (model.getValueAt(row, 1) != null ? model.getValueAt(row, 1) : "") + "</td></tr><tr><td>" + model.getColumnName(2) + "</td><td>" + (model.getValueAt(row, 2) != null ? model.getValueAt(row, 2) : "") + "</td></tr><tr><td>" + model.getColumnName(3) + "</td><td>" + (model.getValueAt(row, 3) != null ? model.getValueAt(row, 3) : "") + "</td></tr><tr><td>" + model.getColumnName(4) + "</td><td>" + (model.getValueAt(row, 4) != null ? model.getValueAt(row, 4) : "") + "</td></tr><tr><td>" + model.getColumnName(5) + "</td><td>" + (model.getValueAt(row, 5) != null ? (isLinked ? ElanLocale.getString("LinkedFilesDialog.Label.StatusLinked") : ElanLocale.getString("LinkedFilesDialog.Label.StatusMissing")) : "") + "</td></tr></table></html>");
    }

    private String chooseFile() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("Button.Select"), 0, ElanLocale.getString("LinkedFilesDialog.SelectMediaDialog.Approve"), null, null, true, "LinkedFileDir", 0, null);
        File selected = chooser.getSelectedFile();
        if (selected != null) {
            return selected.getAbsolutePath();
        }
        return null;
    }

    private void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private boolean showOptionDialog(String question) {
        int option = JOptionPane.showOptionDialog(this, question, ElanLocale.getString("LinkedFilesDialog.Title"), 0, 3, null, new String[]{ElanLocale.getString("Button.Yes"), ElanLocale.getString("Button.No")}, ElanLocale.getString("Button.Yes"));
        return option == 0;
    }

    private String selectAssociation(LinkedFileDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        String ref = null;
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("-");
        List<MediaDescriptor> mediaDesc = this.transcription.getMediaDescriptors();
        for (int i = 0; i < mediaDesc.size(); ++i) {
            MediaDescriptor md = mediaDesc.get(i);
            candidates.add(md.mediaURL);
        }
        for (int i = 0; i < this.descCopy.size(); ++i) {
            LinkedFileDescriptor lfd = this.descCopy.get(i);
            if (lfd == descriptor) continue;
            candidates.add(lfd.linkURL);
        }
        ref = (String)JOptionPane.showInputDialog(this, ElanLocale.getString("LinkedFilesDialog.Question.SelectAssocaition"), ElanLocale.getString("LinkedFilesDialog.Title"), 3, null, candidates.toArray(), "-");
        return ref;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.addMB) {
            this.addDescriptor();
        } else if (source == this.removeMB) {
            this.removeDescriptor();
        } else if (source == this.updateMB) {
            this.updateDescriptor();
        } else if (source == this.associateJB) {
            this.setAssociatedWith();
        } else if (source == this.moveUpButton) {
            this.moveUp();
        } else if (source == this.moveDownButton) {
            this.moveDown();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (!lse.getValueIsAdjusting()) {
            if (!this.offsetEditMode) {
                this.updateUIComponents();
            } else {
                int row = this.linkTable.getSelectedRow();
                if (row >= 0 && row < this.descCopy.size()) {
                    this.fillInfoPanel(row);
                }
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent tme) {
        if (tme.getColumn() < 0) {
            ((LFDescriptorTableModel)this.linkTable.getModel()).setGlobalCellEditable(false);
            this.updateUIComponents();
        } else if (tme.getColumn() == ((LFDescriptorTableModel)this.linkTable.getModel()).findColumn(ElanLocale.getString("LinkedFilesDialog.Label.MediaOffset"))) {
            LinkedFileDescriptor ld = this.descCopy.get(tme.getFirstRow());
            Integer newValue = (Integer)((LFDescriptorTableModel)this.linkTable.getModel()).getValueAt(tme.getFirstRow(), tme.getColumn());
            if ((long)newValue.intValue() != ld.timeOrigin) {
                this.offsetEditMode = true;
                this.addMB.setEnabled(false);
                this.removeMB.setEnabled(false);
                this.updateMB.setEnabled(false);
                this.associateJB.setEnabled(false);
                this.moveUpButton.setEnabled(false);
                this.moveDownButton.setEnabled(false);
            }
        }
    }
}

