/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.cmdi;

import java.io.IOException;
import java.net.URL;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.md.cmdi.CMDIKVData;
import mpi.eudico.client.annotator.md.imdi.MDKVData;
import mpi.eudico.client.annotator.util.ClientLogger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

public class CMDIDom {
    private Document cmdiDoc;

    public CMDIDom(URL cmdiUrl) throws IOException {
        if (cmdiUrl == null) {
            throw new NullPointerException("The CMDI url is null");
        }
        try {
            DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
            LSInput lsInput = domImplementation.createLSInput();
            lsInput.setEncoding("UTF-8");
            lsInput.setByteStream(cmdiUrl.openStream());
            LSParser parser = domImplementation.createLSParser((short)1, null);
            this.cmdiDoc = parser.parse(lsInput);
        }
        catch (IllegalAccessException iae) {
            throw new IOException(iae.getMessage());
        }
        catch (ClassCastException cce) {
            throw new IOException(cce.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            throw new IOException(ie.getMessage());
        }
        catch (DOMException de) {
            throw new IOException(de.getMessage());
        }
        catch (LSException lse) {
            throw new IOException(lse.getMessage());
        }
    }

    public DefaultMutableTreeNode getAsTree() {
        if (this.cmdiDoc == null) {
            return null;
        }
        NodeList compList = this.cmdiDoc.getElementsByTagName("Components");
        if (compList.getLength() > 0) {
            Element compElem = (Element)compList.item(0);
            if (compElem != null) {
                NodeList nodeList = compElem.getChildNodes();
                int length = nodeList.getLength();
                for (int i = 0; i < length; ++i) {
                    Node nextNode = nodeList.item(i);
                    if (!(nextNode instanceof Element)) continue;
                    Element rootElem = (Element)nextNode;
                    DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
                    CMDIKVData rootData = new CMDIKVData(rootElem.getTagName(), "", null);
                    rootNode.setUserObject(rootData);
                    this.addChildElements(rootNode, rootElem);
                    return rootNode;
                }
            } else {
                ClientLogger.LOG.info("The first Component is null");
            }
        } else {
            ClientLogger.LOG.info("No list of Components found in the CMDI");
        }
        return null;
    }

    private void addChildElements(DefaultMutableTreeNode treeNode, Element domElem) {
        if (domElem != null) {
            NodeList children = domElem.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node n = children.item(i);
                if (!(n instanceof Element)) continue;
                Element ne = (Element)n;
                DefaultMutableTreeNode treeChild = new DefaultMutableTreeNode();
                MDKVData userData = this.getDataObject(ne.getTagName(), this.getTextNodeContent(ne));
                treeChild.setUserObject(userData);
                treeNode.add(treeChild);
                this.addChildElements(treeChild, ne);
            }
        }
    }

    private String getTextNodeContent(Element e) {
        if (e == null) {
            return "";
        }
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 3) continue;
            return ((Text)n).getWholeText();
        }
        return "";
    }

    private MDKVData getDataObject(String key, String value) {
        if (value != null && (value = value.trim()).length() == 1 && value.charAt(0) == '\n') {
            value = null;
        }
        return new MDKVData(key, value);
    }
}

