/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.cmdi;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.dcr.DCSmall;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.dcr.ELANLocalDCRConnector;
import mpi.eudico.client.annotator.md.cmdi.CMDIDom;
import mpi.eudico.client.annotator.md.cmdi.CMDIKVData;
import mpi.eudico.client.annotator.md.cmdi.CMDIViewerPanel;
import mpi.eudico.client.annotator.md.imdi.MDKVData;
import mpi.eudico.client.annotator.md.spi.MDConfigurationPanel;
import mpi.eudico.client.annotator.md.spi.MDContentLanguageUser;
import mpi.eudico.client.annotator.md.spi.MDServiceProvider;
import mpi.eudico.client.annotator.md.spi.MDViewerComponent;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileExtension;
import nl.mpi.metadata.api.MetadataException;
import nl.mpi.metadata.api.model.MetadataDocument;
import nl.mpi.metadata.api.model.MetadataElement;
import nl.mpi.metadata.api.type.ControlledVocabularyItem;
import nl.mpi.metadata.cmdi.api.CMDIApi;
import nl.mpi.metadata.cmdi.api.model.CMDIContainerMetadataElement;
import nl.mpi.metadata.cmdi.api.model.CMDIMetadataElement;
import nl.mpi.metadata.cmdi.api.type.impl.CMDIControlledVocabularyItemImpl;
import nl.mpi.metadata.cmdi.api.type.impl.ControlledVocabularyElementTypeImpl;

public class CMDIServiceProvider
implements MDServiceProvider,
MDContentLanguageUser {
    private String sourcePath;
    private MetadataDocument cmdiDoc;
    private CMDIDom simpleDom;
    private CMDIViewerPanel viewerPanel;
    private String twoLetterLanguageCode;
    private DefaultMutableTreeNode rootTreeNode;
    private boolean isLoading = false;
    private final ReentrantLock treeLock = new ReentrantLock();
    private final String HANDLE = "hdl.handle.net";
    private final Pattern HANDLE_PAT = Pattern.compile("CCR_C-");

    @Override
    public boolean setMetadataFile(String filePath) {
        if (filePath == null) {
            return false;
        }
        File f = new File(filePath);
        if (!f.exists()) {
            ClientLogger.LOG.warning("The CMDI metadata file does not exist: " + filePath);
            return false;
        }
        if (!f.canRead()) {
            ClientLogger.LOG.warning("The CMDI metadata file cannot be read: " + filePath);
            return false;
        }
        if (f.isDirectory()) {
            ClientLogger.LOG.warning("The path is a directory not a CMDI file: " + filePath);
            return false;
        }
        if (f.length() == 0L) {
            ClientLogger.LOG.warning("The CMDI metadata file has zero length: " + filePath);
            return false;
        }
        boolean extFound = false;
        String lowerPath = filePath.toLowerCase();
        for (String ext : FileExtension.CMDI_EXT) {
            if (!lowerPath.endsWith(ext)) continue;
            extFound = true;
            break;
        }
        if (extFound) {
            this.sourcePath = filePath;
            this.rootTreeNode = null;
            return true;
        }
        return false;
    }

    @Override
    public String getMetadataFile() {
        return this.sourcePath;
    }

    @Override
    public String getMDFormatDescription() {
        return "CMDI";
    }

    @Override
    public String getValue(String key) {
        return null;
    }

    @Override
    public List<String> getValues(String key) {
        return null;
    }

    @Override
    public List<String> getKeys() {
        return null;
    }

    @Override
    public List<String> getSelectedKeys() {
        return null;
    }

    @Override
    public void setSelectedKeys(List<String> selectedKeys) {
    }

    @Override
    public Map<String, String> getSelectedKeysAndValues() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode getAsTree() {
        if (this.isLoading) {
            return new DefaultMutableTreeNode(ElanLocale.getString("MetadataViewer.Loading.CMDI"));
        }
        if (this.cmdiDoc != null) {
            if (this.rootTreeNode != null) {
                return this.rootTreeNode;
            }
            this.treeLock.lock();
            try {
                DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
                MDKVData mdkvData = this.getDataObject(this.cmdiDoc.getName(), this.cmdiDoc.getDisplayValue(), null, null);
                rootNode.setUserObject(mdkvData);
                List children = this.cmdiDoc.getChildren();
                for (CMDIMetadataElement nextElem : children) {
                    this.addChildElement(nextElem, rootNode);
                }
                this.rootTreeNode = rootNode;
            }
            finally {
                this.treeLock.unlock();
            }
            return this.rootTreeNode;
        }
        if (this.simpleDom != null) {
            if (this.rootTreeNode != null) {
                return this.rootTreeNode;
            }
            this.treeLock.lock();
            try {
                this.rootTreeNode = this.simpleDom.getAsTree();
            }
            finally {
                this.treeLock.unlock();
            }
            return this.rootTreeNode;
        }
        return null;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public MDConfigurationPanel getConfigurationPanel() {
        return null;
    }

    @Override
    public MDViewerComponent getMDViewerComponent() {
        if (this.viewerPanel == null) {
            this.viewerPanel = new CMDIViewerPanel(this);
        }
        return this.viewerPanel;
    }

    @Override
    public void initialize() {
        if (this.sourcePath == null) {
            return;
        }
        this.isLoading = true;
        Thread loadThread = new Thread(new CMDILoader());
        loadThread.setPriority(1);
        loadThread.start();
    }

    private void delayedLoadingComplete() {
        this.isLoading = false;
        if (this.viewerPanel != null) {
            EventQueue.invokeLater(new PanelUpdater());
        }
    }

    private MDKVData getDataObject(String key, String value, String datCatID, String valueDatCatID) {
        if (value != null && (value = value.trim()).length() == 1 && value.charAt(0) == '\n') {
            value = null;
        }
        datCatID = this.handleToDCId(datCatID);
        valueDatCatID = this.handleToDCId(valueDatCatID);
        return new CMDIKVData(key, value, datCatID, valueDatCatID);
    }

    private String handleToDCId(String ccrHandle) {
        String[] parts;
        if (ccrHandle != null && ccrHandle.indexOf("hdl.handle.net") > -1 && (parts = this.HANDLE_PAT.split(ccrHandle)).length >= 2 && parts[1].length() >= 5) {
            return parts[1].substring(0, 4);
        }
        return ccrHandle;
    }

    private void addChildElement(CMDIMetadataElement mdElement, DefaultMutableTreeNode parentNode) {
        CMDIContainerMetadataElement cmdElement;
        URI valueDatCatURI;
        URI datCatURI;
        block10: {
            if (mdElement == null) {
                return;
            }
            if (parentNode == null) {
                return;
            }
            datCatURI = null;
            valueDatCatURI = null;
            int numTypeExceptions = 0;
            try {
                if (mdElement.getType().getDataCategory() != null) {
                    datCatURI = mdElement.getType().getDataCategory().getIdentifier();
                }
                if (!(mdElement.getType() instanceof ControlledVocabularyElementTypeImpl) || mdElement.getDisplayValue() == null || mdElement.getDisplayValue().isEmpty()) break block10;
                ControlledVocabularyElementTypeImpl cvElemType = (ControlledVocabularyElementTypeImpl)mdElement.getType();
                List cvItems = cvElemType.getItems();
                for (ControlledVocabularyItem item : cvItems) {
                    CMDIControlledVocabularyItemImpl cmdiItem = (CMDIControlledVocabularyItemImpl)item;
                    if (!mdElement.getDisplayValue().equals(cmdiItem.getValue())) continue;
                    if (cmdiItem.getDataCategory() != null) {
                        valueDatCatURI = cmdiItem.getDataCategory().getIdentifier();
                    }
                    break;
                }
            }
            catch (Throwable t) {
                if (numTypeExceptions <= 1) {
                    ClientLogger.LOG.warning("Unable to retrieve data category information: " + t.getMessage());
                }
                ++numTypeExceptions;
            }
        }
        DefaultMutableTreeNode nextNode = new DefaultMutableTreeNode(this.getDataObject(mdElement.getName(), mdElement.getDisplayValue(), datCatURI != null ? datCatURI.toString() : null, valueDatCatURI != null ? valueDatCatURI.toString() : null));
        parentNode.add(nextNode);
        if (mdElement instanceof CMDIContainerMetadataElement && (cmdElement = (CMDIContainerMetadataElement)mdElement).getChildrenCount() > 0) {
            List children = cmdElement.getChildren();
            for (MetadataElement child : children) {
                this.addChildElement((CMDIMetadataElement)child, nextNode);
            }
        }
    }

    void updateTreeForLanguage() {
        if (this.rootTreeNode != null && this.cmdiDoc != null) {
            HashMap<String, String> loadedDatCats = new HashMap<String, String>();
            ELANLocalDCRConnector dcrConnector = ELANLocalDCRConnector.getInstance();
            Enumeration<TreeNode> breadthEnum = this.rootTreeNode.breadthFirstEnumeration();
            while (breadthEnum.hasMoreElements()) {
                CMDIKVData dataObject;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)breadthEnum.nextElement();
                if (node == this.rootTreeNode || (dataObject = (CMDIKVData)node.getUserObject()).getKeyDatCatID() == null) continue;
                String locKey = null;
                String locValue = null;
                if (this.twoLetterLanguageCode != null) {
                    DCSmall curCategory;
                    if (loadedDatCats.containsKey(dataObject.getKeyDatCatID())) {
                        locKey = (String)loadedDatCats.get(dataObject.getKeyDatCatID());
                    } else {
                        curCategory = dcrConnector.getDCSmallLoaded(dataObject.getKeyDatCatID());
                        if (curCategory != null) {
                            locKey = curCategory.getName(this.twoLetterLanguageCode);
                        }
                        loadedDatCats.put(dataObject.getKeyDatCatID(), locKey);
                    }
                    if (loadedDatCats.containsKey(dataObject.getValueDatCatID())) {
                        locValue = (String)loadedDatCats.get(dataObject.getValueDatCatID());
                    } else {
                        curCategory = dcrConnector.getDCSmallLoaded(dataObject.getValueDatCatID());
                        if (curCategory != null) {
                            locValue = curCategory.getName(this.twoLetterLanguageCode);
                        }
                        loadedDatCats.put(dataObject.getValueDatCatID(), locValue);
                    }
                }
                dataObject.setLocalizedKey(locKey);
                dataObject.setLocalizedValue(locValue);
            }
            if (this.viewerPanel != null) {
                this.viewerPanel.dataModelUpdated();
            }
        }
    }

    @Override
    public void setContentLanguage(String isoUrlId, String iso3L, String lang2L) {
        if (this.twoLetterLanguageCode != null && this.twoLetterLanguageCode.equals(lang2L)) {
            return;
        }
        String curTwoLetterCode = this.twoLetterLanguageCode;
        this.twoLetterLanguageCode = lang2L;
        if (this.twoLetterLanguageCode == null && curTwoLetterCode != null) {
            this.updateTreeForLanguage();
        } else if (this.twoLetterLanguageCode != null && !this.twoLetterLanguageCode.equals(curTwoLetterCode)) {
            this.updateTreeForLanguage();
        }
    }

    private class PanelUpdater
    implements Runnable {
        private PanelUpdater() {
        }

        @Override
        public void run() {
            if (CMDIServiceProvider.this.viewerPanel != null) {
                CMDIServiceProvider.this.viewerPanel.reinitializeTree();
            }
        }
    }

    private class CMDILoader
    implements Runnable {
        private CMDILoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            URL cmdiUrl = null;
            try {
                File f = new File(CMDIServiceProvider.this.sourcePath);
                if (f.exists()) {
                    URI fUri = f.toURI();
                    cmdiUrl = fUri.toURL();
                } else {
                    cmdiUrl = new URL(CMDIServiceProvider.this.sourcePath);
                }
            }
            catch (MalformedURLException mue) {
                ClientLogger.LOG.warning("Not a valid cmdi url: " + CMDIServiceProvider.this.sourcePath);
                CMDIServiceProvider.this.delayedLoadingComplete();
                return;
            }
            catch (Throwable th) {
                ClientLogger.LOG.warning("Could not create an url: " + CMDIServiceProvider.this.sourcePath);
                CMDIServiceProvider.this.delayedLoadingComplete();
                return;
            }
            CMDIServiceProvider.this.treeLock.lock();
            try {
                CMDIApi anAPI = new CMDIApi();
                try {
                    CMDIServiceProvider.this.cmdiDoc = (MetadataDocument)anAPI.getMetadataDocument(cmdiUrl);
                }
                catch (MetadataException me) {
                    ClientLogger.LOG.warning("Metadata exception: " + me.getMessage());
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Metadata io exception: " + ioe.getMessage());
                }
                catch (Throwable th) {
                    ClientLogger.LOG.warning("Metadata loading exception: " + th.getMessage());
                }
                if (CMDIServiceProvider.this.cmdiDoc == null) {
                    try {
                        CMDIServiceProvider.this.simpleDom = new CMDIDom(cmdiUrl);
                    }
                    catch (IOException ioe) {
                        ClientLogger.LOG.warning("CMDI DOM exception: " + ioe.getMessage());
                    }
                    catch (Throwable t) {
                        ClientLogger.LOG.warning("CMDI DOM throwable: " + t.getMessage());
                    }
                }
            }
            finally {
                CMDIServiceProvider.this.treeLock.unlock();
            }
            CMDIServiceProvider.this.delayedLoadingComplete();
        }
    }
}

